/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlsRecord
implements Comparable<GlsRecord> {
    private String label;
    private String prefix;
    private String counter;
    private String format;
    private String location;
    private long index = 0L;
    protected Bib2Gls bib2gls;
    private static long globalIndex = 0L;
    private static final Pattern DIGIT_PATTERN = Pattern.compile("(.*?)([^\\p{javaDigit}]?)(\\p{javaDigit}+)");
    private static final Pattern ROMAN_LC_PATTERN = Pattern.compile("(.*?)(.??)(m*)(c{1,3}|c?d|dc{1,3}|cm)?(x{1,3}|x?l|lx{1,3}|xc)?(i{1,3}|i?v|vi{1,3}|ix)?");
    private static final Pattern ROMAN_UC_PATTERN = Pattern.compile("(.*?)(.??)(M*)(C{1,3}|C?D|DC{1,3}|CM)?(X{1,3}|X?L|LX{1,3}|XC)?(I{1,3}|I?V|VI{1,3}|IX)?");
    private static final Pattern ALPHA_PATTERN = Pattern.compile("(.*?)(?:([^\\p{javaLowerCase}]?)(\\p{javaUpperCase}))|(?:([^\\p{javaUpperCase}]?)(\\p{javaUpperCase}))");
    private static final Pattern CS_PATTERN = Pattern.compile("(.*?)(?:\\\\protect\\s*)?(\\\\[\\p{javaAlphabetic}@]+)\\s*\\{([\\p{javaDigit}\\p{javaAlphabetic}]+)\\}");
    private static final Pattern WRGLOSSARY_PATTERN = Pattern.compile("\\\\glsxtr@wrglossarylocation\\{(\\p{javaDigit}+)\\}\\{(.*)\\}");

    public GlsRecord(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5) {
        this(bib2Gls, string, string2, string3, string4, string5, globalIndex++);
    }

    protected GlsRecord(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, long l) {
        this.label = string;
        this.prefix = string2;
        this.counter = string3;
        this.format = string4;
        this.location = string5;
        this.index = l;
        this.bib2gls = bib2Gls;
    }

    public GlsRecord copy(String string) {
        return new GlsRecord(this.bib2gls, string, this.prefix, this.counter, this.format, this.location, this.index);
    }

    public Object clone() {
        return new GlsRecord(this.bib2gls, this.label, this.prefix, this.counter, this.format, this.location, this.index);
    }

    public GlsRecord getRecord(GlsResource glsResource, String string, boolean bl) {
        String string2 = glsResource.getRecordLabelPrefix();
        String string3 = this.getLabel(string2);
        if (string3.equals(string)) {
            return this;
        }
        if (bl && string.equals(string3 = glsResource.flipLabel(string3))) {
            return this;
        }
        return null;
    }

    public GlsRecord getRecord(GlsResource glsResource, String string, String string2, String string3) {
        GlsRecord glsRecord = this.getRecord(glsResource, string, false);
        if (glsRecord == null && string2 != null) {
            glsRecord = this.getRecord(glsResource, string2, false);
        }
        if (glsRecord == null && string3 != null) {
            glsRecord = this.getRecord(glsResource, string3, false);
        }
        return glsRecord;
    }

    public Bib2GlsEntry getEntry(GlsResource glsResource, Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2) {
        String string;
        String string2 = glsResource.getLabelPrefix();
        String string3 = glsResource.getDualPrefix();
        String string4 = glsResource.getTertiaryPrefix();
        String string5 = glsResource.getRecordLabelPrefix();
        String string6 = this.getLabel(string5);
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            string = bib2GlsEntry.getId();
            if (string6.equals(string) || string2 != null && !string.startsWith(string2) && string6.equals(string2 + string)) {
                return bib2GlsEntry;
            }
            if (vector2 != null) continue;
            if (string3 != null && !string.startsWith(string3) && string6.equals(string3 + string)) {
                return bib2GlsEntry;
            }
            if (string4 == null || string.startsWith(string4) || !string6.equals(string4 + string)) continue;
            return bib2GlsEntry;
        }
        if (vector2 != null) {
            for (Bib2GlsEntry bib2GlsEntry : vector2) {
                string = bib2GlsEntry.getId();
                if (string6.equals(string) || string3 != null && !string.startsWith(string3) && string6.equals(string3 + string)) {
                    return bib2GlsEntry;
                }
                assert (bib2GlsEntry instanceof Bib2GlsDualEntry);
                Bib2GlsDualEntry bib2GlsDualEntry = (Bib2GlsDualEntry)bib2GlsEntry;
                if (!bib2GlsDualEntry.hasTertiary()) continue;
                string = bib2GlsEntry.getOriginalId();
                if (string4 != null) {
                    string = string4 + string;
                }
                if (!string6.equals(string) && (string4 == null || string.startsWith(string4) || !string6.equals(string4 + string))) continue;
                return bib2GlsEntry;
            }
        }
        return null;
    }

    public Bib2GlsEntry getEntry(GlsResource glsResource, Vector<Bib2GlsEntry> vector, boolean bl) {
        String string = glsResource.getLabelPrefix();
        String string2 = glsResource.getRecordLabelPrefix();
        String string3 = this.getLabel(string2);
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            String string4;
            String string5 = bib2GlsEntry.getId();
            if (string3.equals(string5) || string != null && !string5.startsWith(string) && string3.equals(string + string5)) {
                return bib2GlsEntry;
            }
            if (!bl || !string5.equals(string4 = glsResource.flipLabel(string3))) continue;
            return bib2GlsEntry;
        }
        return null;
    }

    @Override
    public int compareTo(GlsRecord glsRecord) {
        if (this.index == glsRecord.index) {
            return 0;
        }
        return this.index < glsRecord.index ? -1 : 1;
    }

    public long getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabel(String string) {
        String string2 = this.label;
        if (string != null && !this.label.startsWith(string)) {
            string2 = string + this.label;
        }
        return string2;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCounter() {
        return this.counter;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void merge(String string, GlsRecord glsRecord) {
        this.setFormat(string);
        this.setLocation(glsRecord.getLocation());
    }

    public String getListTeXCode() {
        return this.getFmtTeXCode();
    }

    public String getFmtTeXCode(GlsRecord glsRecord, int n) {
        int n2;
        int n3;
        int n4;
        if (n < 2 || glsRecord == null) {
            return this.getFmtTeXCode();
        }
        Matcher matcher = CS_PATTERN.matcher(this.location);
        String string = this.location;
        String string2 = "";
        String string3 = "";
        if (matcher.matches()) {
            string = matcher.group(3);
            string2 = this.location.substring(0, matcher.start(3));
            string3 = this.location.substring(matcher.end(3));
        }
        matcher = CS_PATTERN.matcher(glsRecord.location);
        String string4 = glsRecord.location;
        String string5 = "";
        String string6 = "";
        if (matcher.matches()) {
            string4 = matcher.group(3);
            string5 = glsRecord.location.substring(0, matcher.start(3));
            string6 = glsRecord.location.substring(matcher.end(3));
        }
        if (!string2.equals(string5) || !string3.equals(string6) || string.length() != string4.length() || string.length() < n) {
            return this.getFmtTeXCode();
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (n3 = 0; n3 < string.length() && (n4 = string.codePointAt(n3)) == (n2 = string4.codePointAt(n3)); n3 += Character.charCount(n4)) {
            stringBuilder.appendCodePoint(n4);
        }
        if (n3 == string4.length()) {
            return this.getFmtTeXCode();
        }
        if (DIGIT_PATTERN.matcher(string).matches()) {
            String string7 = "digit";
        } else if (ROMAN_LC_PATTERN.matcher(string).matches() && ROMAN_LC_PATTERN.matcher(string4).matches()) {
            String string8 = "roman";
        } else if (ROMAN_UC_PATTERN.matcher(string).matches() && ROMAN_UC_PATTERN.matcher(string4).matches()) {
            String string9 = "ROMAN";
        }
        String string10 = ALPHA_PATTERN.matcher(string).matches() ? "alpha" : "other";
        return this.getFmtTeXCode(String.format("%s\\bibglscompact{%s}{%s}{%s}%s", string2, string10, stringBuilder.toString(), string.substring(n3), string3));
    }

    public String getFmtTeXCode() {
        return this.getFmtTeXCode(this.getLocation());
    }

    public String getFmtTeXCode(String string) {
        String string2 = this.getFormat();
        if (string2.isEmpty()) {
            string2 = "glsnumberformat";
        } else if (string2.startsWith("(") || string2.startsWith(")")) {
            string2 = string2.length() == 1 ? "glsnumberformat" : string2.substring(1);
        }
        return String.format("\\glsnoidxdisplayloc{%s}{%s}{%s}{%s}", this.prefix, this.counter, string2, string);
    }

    public boolean locationMatch(GlsRecord glsRecord) {
        if (this.location.equals(glsRecord.location)) {
            return true;
        }
        if (this.bib2gls.mergeWrGlossaryLocations()) {
            Matcher matcher = WRGLOSSARY_PATTERN.matcher(this.location);
            Matcher matcher2 = WRGLOSSARY_PATTERN.matcher(glsRecord.location);
            if (matcher.matches() && matcher2.matches() && matcher.group(2).equals(matcher2.group(2))) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GlsRecord)) {
            return false;
        }
        GlsRecord glsRecord = (GlsRecord)object;
        return this.label.equals(glsRecord.label) && this.prefix.equals(glsRecord.prefix) && this.counter.equals(glsRecord.counter) && this.format.equals(glsRecord.format) && this.locationMatch(glsRecord);
    }

    public boolean partialMatch(GlsRecord glsRecord) {
        return this.label.equals(glsRecord.label) && this.prefix.equals(glsRecord.prefix) && this.counter.equals(glsRecord.counter) && this.locationMatch(glsRecord);
    }

    public boolean follows(GlsRecord glsRecord, int n, int[] nArray) {
        if (!(this.prefix.equals(glsRecord.prefix) && this.counter.equals(glsRecord.counter) && this.format.equals(glsRecord.format))) {
            return false;
        }
        return GlsRecord.consecutive(glsRecord.location, this.location, n, nArray);
    }

    public static boolean consecutive(String string, String string2, int n, int[] nArray) {
        if (string.isEmpty() || string2.isEmpty()) {
            return false;
        }
        Matcher matcher = WRGLOSSARY_PATTERN.matcher(string);
        Matcher matcher2 = WRGLOSSARY_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            String string3;
            String string4 = matcher.group(2);
            if (string4.equals(string3 = matcher2.group(2))) {
                return false;
            }
            return GlsRecord.consecutive(string4, string3, n, nArray);
        }
        matcher = CS_PATTERN.matcher(string);
        matcher2 = CS_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            String string5;
            String string6;
            String string7 = matcher.group(1);
            String string8 = matcher2.group(1);
            String string9 = matcher.group(2);
            if (!string9.equals(string6 = matcher2.group(2))) {
                return false;
            }
            String string10 = matcher.group(3);
            if (string10.equals(string5 = matcher2.group(3))) {
                return GlsRecord.consecutive(string7, string8, n, nArray);
            }
            return GlsRecord.consecutive(string10, string5, n, nArray);
        }
        matcher = DIGIT_PATTERN.matcher(string);
        matcher2 = DIGIT_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            String string11;
            String string12 = matcher.group(1);
            String string13 = matcher2.group(1);
            if (string12 == null) {
                string12 = "";
            }
            if (string13 == null) {
                string13 = "";
            }
            String string14 = matcher.group(2);
            String string15 = matcher2.group(2);
            String string16 = matcher.group(3);
            if (string16.equals(string11 = matcher2.group(3))) {
                if (string16.equals("0")) {
                    return string14.equals(string15) ? GlsRecord.consecutive(string12, string13, n, nArray) : GlsRecord.consecutive(string12 + string14, string13 + string15, n, nArray);
                }
                return false;
            }
            if (!string12.equals(string13) || !string14.equals(string15)) {
                return false;
            }
            try {
                int n2 = Integer.parseInt(string16);
                int n3 = Integer.parseInt(string11);
                int n4 = n3 - n2;
                if (0 < n4 && n4 <= n) {
                    if (n4 > nArray[0]) {
                        nArray[0] = n4;
                    }
                    return true;
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return false;
            }
        }
        matcher = ROMAN_LC_PATTERN.matcher(string);
        matcher2 = ROMAN_LC_PATTERN.matcher(string2);
        if (!(!matcher.matches() || !matcher2.matches() || matcher.group(3).isEmpty() && matcher.group(4) == null && matcher.group(5) == null && matcher.group(6) == null || matcher2.group(3).isEmpty() && matcher2.group(4) == null && matcher2.group(5) == null && matcher2.group(6) == null)) {
            int n5;
            String string17 = matcher.group(1);
            String string18 = matcher2.group(1);
            String string19 = matcher.group(2);
            String string20 = matcher2.group(2);
            int n6 = GlsRecord.romanToDecimal(matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6));
            if (n6 == (n5 = GlsRecord.romanToDecimal(matcher2.group(3), matcher2.group(4), matcher2.group(5), matcher2.group(6)))) {
                return string19.equals(string20) ? GlsRecord.consecutive(string17, string18, n, nArray) : GlsRecord.consecutive(string17 + string19, string18 + string20, n, nArray);
            }
            if (!string17.equals(string18) || !string19.equals(string20)) {
                return false;
            }
            int n7 = n5 - n6;
            if (0 < n7 && n7 <= n) {
                if (n7 > nArray[0]) {
                    nArray[0] = n7;
                }
                return true;
            }
            return false;
        }
        matcher = ROMAN_UC_PATTERN.matcher(string);
        matcher2 = ROMAN_UC_PATTERN.matcher(string2);
        if (!(!matcher.matches() || !matcher2.matches() || matcher.group(3).isEmpty() && matcher.group(4) == null && matcher.group(5) == null && matcher.group(6) == null || matcher2.group(3).isEmpty() && matcher2.group(4) == null && matcher2.group(5) == null && matcher2.group(6) == null)) {
            int n8;
            String string21 = matcher.group(1);
            String string22 = matcher2.group(1);
            String string23 = matcher.group(2);
            String string24 = matcher2.group(2);
            String string25 = matcher.group(4);
            String string26 = matcher.group(5);
            String string27 = matcher.group(6);
            String string28 = matcher2.group(4);
            String string29 = matcher2.group(5);
            String string30 = matcher2.group(6);
            int n9 = GlsRecord.romanToDecimal(matcher.group(3).toLowerCase(), string25 == null ? null : string25.toLowerCase(), string26 == null ? null : string26.toLowerCase(), string27 == null ? null : string27.toLowerCase());
            if (n9 == (n8 = GlsRecord.romanToDecimal(matcher2.group(3).toLowerCase(), string28 == null ? null : string28.toLowerCase(), string29 == null ? null : string29.toLowerCase(), string30 == null ? null : string30.toLowerCase()))) {
                return string23.equals(string24) ? GlsRecord.consecutive(string21, string22, n, nArray) : GlsRecord.consecutive(string21 + string23, string22 + string24, n, nArray);
            }
            if (!string21.equals(string22) || !string23.equals(string24)) {
                return false;
            }
            int n10 = n8 - n9;
            if (0 < n10 && n10 <= n) {
                if (n10 > nArray[0]) {
                    nArray[0] = n10;
                }
                return true;
            }
            return false;
        }
        matcher = ALPHA_PATTERN.matcher(string);
        matcher2 = ALPHA_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            String string31 = matcher.group(1);
            String string32 = matcher2.group(1);
            if (string31 == null) {
                string31 = "";
            }
            if (string32 == null) {
                string32 = "";
            }
            String string33 = matcher.group(2);
            String string34 = matcher2.group(2);
            String string35 = matcher.group(3);
            String string36 = matcher2.group(3);
            if (string35 == null) {
                string33 = matcher.group(4);
                string35 = matcher.group(5);
            }
            if (string36 == null) {
                string34 = matcher2.group(4);
                string36 = matcher2.group(5);
            }
            if (string35.equals(string36)) {
                return string33.equals(string34) ? GlsRecord.consecutive(string31, string32, n, nArray) : GlsRecord.consecutive(string31 + string33, string32 + string34, n, nArray);
            }
            if (!string31.equals(string32) || !string33.equals(string34)) {
                return false;
            }
            int n11 = string35.codePointAt(0);
            int n12 = string36.codePointAt(0);
            int n13 = n12 - n11;
            if (0 < n13 && n13 <= n) {
                if (n13 > nArray[0]) {
                    nArray[0] = n13;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean lessThan(String string, String string2) {
        if (string.isEmpty() || string2.isEmpty()) {
            return false;
        }
        Matcher matcher = CS_PATTERN.matcher(string);
        Matcher matcher2 = CS_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            String string3;
            String string4;
            String string5 = matcher.group(1);
            String string6 = matcher2.group(1);
            String string7 = matcher.group(2);
            if (!string7.equals(string4 = matcher2.group(2))) {
                return false;
            }
            String string8 = matcher.group(3);
            if (string8.equals(string3 = matcher2.group(3))) {
                return GlsRecord.lessThan(string5, string6);
            }
            return GlsRecord.lessThan(string8, string3);
        }
        matcher = DIGIT_PATTERN.matcher(string);
        matcher2 = DIGIT_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            String string9;
            String string10 = matcher.group(1);
            String string11 = matcher2.group(1);
            if (string10 == null) {
                string10 = "";
            }
            if (string11 == null) {
                string11 = "";
            }
            String string12 = matcher.group(2);
            String string13 = matcher2.group(2);
            String string14 = matcher.group(3);
            if (string14.equals(string9 = matcher2.group(3))) {
                if (string14.equals("0")) {
                    return string12.equals(string13) ? GlsRecord.lessThan(string10, string11) : GlsRecord.lessThan(string10 + string12, string11 + string13);
                }
                return false;
            }
            if (!string10.equals(string11) || !string12.equals(string13)) {
                return false;
            }
            try {
                int n = Integer.parseInt(string14);
                int n2 = Integer.parseInt(string9);
                return n < n2;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return false;
            }
        }
        matcher = ROMAN_LC_PATTERN.matcher(string);
        matcher2 = ROMAN_LC_PATTERN.matcher(string2);
        if (!(!matcher.matches() || !matcher2.matches() || matcher.group(3).isEmpty() && matcher.group(4) == null && matcher.group(5) == null && matcher.group(6) == null || matcher2.group(3).isEmpty() && matcher2.group(4) == null && matcher2.group(5) == null && matcher2.group(6) == null)) {
            int n;
            String string15 = matcher.group(1);
            String string16 = matcher2.group(1);
            String string17 = matcher.group(2);
            String string18 = matcher2.group(2);
            int n3 = GlsRecord.romanToDecimal(matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6));
            if (n3 == (n = GlsRecord.romanToDecimal(matcher2.group(3), matcher2.group(4), matcher2.group(5), matcher2.group(6)))) {
                return string17.equals(string18) ? GlsRecord.lessThan(string15, string16) : GlsRecord.lessThan(string15 + string17, string16 + string18);
            }
            if (!string15.equals(string16) || !string17.equals(string18)) {
                return false;
            }
            return n3 < n;
        }
        matcher = ROMAN_UC_PATTERN.matcher(string);
        matcher2 = ROMAN_UC_PATTERN.matcher(string2);
        if (!(!matcher.matches() || !matcher2.matches() || matcher.group(3).isEmpty() && matcher.group(4) == null && matcher.group(5) == null && matcher.group(6) == null || matcher2.group(3).isEmpty() && matcher2.group(4) == null && matcher2.group(5) == null && matcher2.group(6) == null)) {
            int n;
            String string19 = matcher.group(1);
            String string20 = matcher2.group(1);
            String string21 = matcher.group(2);
            String string22 = matcher2.group(2);
            String string23 = matcher.group(4);
            String string24 = matcher.group(5);
            String string25 = matcher.group(6);
            String string26 = matcher2.group(4);
            String string27 = matcher2.group(5);
            String string28 = matcher2.group(6);
            int n4 = GlsRecord.romanToDecimal(matcher.group(3).toLowerCase(), string23 == null ? null : string23.toLowerCase(), string24 == null ? null : string24.toLowerCase(), string25 == null ? null : string25.toLowerCase());
            if (n4 == (n = GlsRecord.romanToDecimal(matcher2.group(3).toLowerCase(), string26 == null ? null : string26.toLowerCase(), string27 == null ? null : string27.toLowerCase(), string28 == null ? null : string28.toLowerCase()))) {
                return string21.equals(string22) ? GlsRecord.lessThan(string19, string20) : GlsRecord.lessThan(string19 + string21, string20 + string22);
            }
            if (!string19.equals(string20) || !string21.equals(string22)) {
                return false;
            }
            return n4 < n;
        }
        matcher = ALPHA_PATTERN.matcher(string);
        matcher2 = ALPHA_PATTERN.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            int n;
            String string29 = matcher.group(1);
            String string30 = matcher2.group(1);
            if (string29 == null) {
                string29 = "";
            }
            if (string30 == null) {
                string30 = "";
            }
            String string31 = matcher.group(2);
            String string32 = matcher2.group(2);
            String string33 = matcher.group(3);
            String string34 = matcher2.group(3);
            if (string33 == null) {
                string31 = matcher.group(4);
                string33 = matcher.group(5);
            }
            if (string34 == null) {
                string32 = matcher2.group(4);
                string34 = matcher2.group(5);
            }
            if (string33.equals(string34)) {
                return string31.equals(string32) ? GlsRecord.lessThan(string29, string30) : GlsRecord.lessThan(string29 + string31, string30 + string32);
            }
            if (!string29.equals(string30) || !string31.equals(string32)) {
                return false;
            }
            int n5 = string33.codePointAt(0);
            return n5 < (n = string34.codePointAt(0));
        }
        return false;
    }

    private static int romanToDecimal(String string, String string2, String string3, String string4) {
        int n = 0;
        if (string != null && !string.isEmpty()) {
            n = 1000 * string.length();
        }
        if ("c".equals(string2)) {
            n += 100;
        } else if ("cc".equals(string2)) {
            n += 200;
        } else if ("ccc".equals(string2)) {
            n += 300;
        } else if ("cd".equals(string2)) {
            n += 400;
        } else if ("d".equals(string2)) {
            n += 500;
        } else if ("dc".equals(string2)) {
            n += 600;
        } else if ("dcc".equals(string2)) {
            n += 700;
        } else if ("dccc".equals(string2)) {
            n += 800;
        } else if ("cm".equals(string2)) {
            n += 900;
        }
        if ("x".equals(string3)) {
            n += 10;
        } else if ("xx".equals(string3)) {
            n += 20;
        } else if ("xxx".equals(string3)) {
            n += 30;
        } else if ("xl".equals(string3)) {
            n += 40;
        } else if ("l".equals(string3)) {
            n += 50;
        } else if ("lx".equals(string3)) {
            n += 60;
        } else if ("lxx".equals(string3)) {
            n += 70;
        } else if ("lxxx".equals(string3)) {
            n += 80;
        } else if ("xc".equals(string3)) {
            n += 90;
        }
        if ("i".equals(string4)) {
            ++n;
        } else if ("ii".equals(string4)) {
            n += 2;
        } else if ("iii".equals(string4)) {
            n += 3;
        } else if ("iv".equals(string4)) {
            n += 4;
        } else if ("v".equals(string4)) {
            n += 5;
        } else if ("vi".equals(string4)) {
            n += 6;
        } else if ("vii".equals(string4)) {
            n += 7;
        } else if ("viii".equals(string4)) {
            n += 8;
        } else if ("ix".equals(string4)) {
            n += 9;
        }
        return n;
    }

    public static Vector<GlsRecord> merge(Vector<GlsRecord> vector, Vector<GlsRecord> vector2) {
        int n;
        Vector<GlsRecord> vector3 = new Vector<GlsRecord>(vector.size(), vector2.size());
        int n2 = 0;
        int n3 = vector.size();
        int n4 = vector2.size();
        for (n = 0; n < n3 && n2 < n4; ++n) {
            GlsRecord glsRecord;
            GlsRecord glsRecord2 = vector.get(n);
            if (glsRecord2.equals(glsRecord = vector2.get(n2))) {
                vector3.add(glsRecord2);
                ++n2;
                continue;
            }
            if (!glsRecord2.getCounter().equals(glsRecord.getCounter()) || !glsRecord2.getPrefix().equals(glsRecord.getPrefix())) {
                vector3.add(glsRecord2);
                continue;
            }
            while (GlsRecord.lessThan(glsRecord.location, glsRecord2.location)) {
                vector3.add(glsRecord);
                if (++n2 >= n4) break;
                glsRecord = vector2.get(n2);
            }
            vector3.add(glsRecord2);
        }
        while (n < n3) {
            vector3.add(vector.get(n));
            ++n;
        }
        while (n2 < n4) {
            vector3.add(vector2.get(n2));
            ++n2;
        }
        return vector3;
    }

    public String toString() {
        return String.format("{%s}{%s}{%s}{%s}{%s}", this.label, this.prefix, this.counter, this.format, this.location);
    }
}

