/* $OpenBSD: ts.h,v 1.3 2023/07/28 09:53:55 tb Exp $ */
/*
 * Copyright (c) 2023 Bob Beck <beck@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LIBCRYPTO_TS_H
#define _LIBCRYPTO_TS_H

#ifndef _MSC_VER
#include_next <openssl/ts.h>
#else
#include "../include/openssl/ts.h"
#endif
#include "crypto_namespace.h"

LCRYPTO_USED(TS_REQ_new);
LCRYPTO_USED(TS_REQ_free);
LCRYPTO_USED(i2d_TS_REQ);
LCRYPTO_USED(d2i_TS_REQ);
LCRYPTO_USED(TS_REQ_dup);
LCRYPTO_USED(d2i_TS_REQ_fp);
LCRYPTO_USED(i2d_TS_REQ_fp);
LCRYPTO_USED(d2i_TS_REQ_bio);
LCRYPTO_USED(i2d_TS_REQ_bio);
LCRYPTO_USED(TS_MSG_IMPRINT_new);
LCRYPTO_USED(TS_MSG_IMPRINT_free);
LCRYPTO_USED(i2d_TS_MSG_IMPRINT);
LCRYPTO_USED(d2i_TS_MSG_IMPRINT);
LCRYPTO_USED(TS_MSG_IMPRINT_dup);
LCRYPTO_USED(d2i_TS_MSG_IMPRINT_fp);
LCRYPTO_USED(i2d_TS_MSG_IMPRINT_fp);
LCRYPTO_USED(d2i_TS_MSG_IMPRINT_bio);
LCRYPTO_USED(i2d_TS_MSG_IMPRINT_bio);
LCRYPTO_USED(TS_RESP_new);
LCRYPTO_USED(TS_RESP_free);
LCRYPTO_USED(i2d_TS_RESP);
LCRYPTO_USED(d2i_TS_RESP);
LCRYPTO_USED(PKCS7_to_TS_TST_INFO);
LCRYPTO_USED(TS_RESP_dup);
LCRYPTO_USED(d2i_TS_RESP_fp);
LCRYPTO_USED(i2d_TS_RESP_fp);
LCRYPTO_USED(d2i_TS_RESP_bio);
LCRYPTO_USED(i2d_TS_RESP_bio);
LCRYPTO_USED(TS_STATUS_INFO_new);
LCRYPTO_USED(TS_STATUS_INFO_free);
LCRYPTO_USED(i2d_TS_STATUS_INFO);
LCRYPTO_USED(d2i_TS_STATUS_INFO);
LCRYPTO_USED(TS_STATUS_INFO_dup);
LCRYPTO_USED(TS_TST_INFO_new);
LCRYPTO_USED(TS_TST_INFO_free);
LCRYPTO_USED(i2d_TS_TST_INFO);
LCRYPTO_USED(d2i_TS_TST_INFO);
LCRYPTO_USED(TS_TST_INFO_dup);
LCRYPTO_USED(d2i_TS_TST_INFO_fp);
LCRYPTO_USED(i2d_TS_TST_INFO_fp);
LCRYPTO_USED(d2i_TS_TST_INFO_bio);
LCRYPTO_USED(i2d_TS_TST_INFO_bio);
LCRYPTO_USED(TS_ACCURACY_new);
LCRYPTO_USED(TS_ACCURACY_free);
LCRYPTO_USED(i2d_TS_ACCURACY);
LCRYPTO_USED(d2i_TS_ACCURACY);
LCRYPTO_USED(TS_ACCURACY_dup);
LCRYPTO_USED(ESS_ISSUER_SERIAL_new);
LCRYPTO_USED(ESS_ISSUER_SERIAL_free);
LCRYPTO_USED(i2d_ESS_ISSUER_SERIAL);
LCRYPTO_USED(d2i_ESS_ISSUER_SERIAL);
LCRYPTO_USED(ESS_ISSUER_SERIAL_dup);
LCRYPTO_USED(ESS_CERT_ID_new);
LCRYPTO_USED(ESS_CERT_ID_free);
LCRYPTO_USED(i2d_ESS_CERT_ID);
LCRYPTO_USED(d2i_ESS_CERT_ID);
LCRYPTO_USED(ESS_CERT_ID_dup);
LCRYPTO_USED(ESS_SIGNING_CERT_new);
LCRYPTO_USED(ESS_SIGNING_CERT_free);
LCRYPTO_USED(i2d_ESS_SIGNING_CERT);
LCRYPTO_USED(d2i_ESS_SIGNING_CERT);
LCRYPTO_USED(ESS_SIGNING_CERT_dup);
LCRYPTO_USED(TS_REQ_set_version);
LCRYPTO_USED(TS_REQ_get_version);
LCRYPTO_USED(TS_REQ_set_msg_imprint);
LCRYPTO_USED(TS_REQ_get_msg_imprint);
LCRYPTO_USED(TS_MSG_IMPRINT_set_algo);
LCRYPTO_USED(TS_MSG_IMPRINT_get_algo);
LCRYPTO_USED(TS_MSG_IMPRINT_set_msg);
LCRYPTO_USED(TS_MSG_IMPRINT_get_msg);
LCRYPTO_USED(TS_REQ_set_policy_id);
LCRYPTO_USED(TS_REQ_get_policy_id);
LCRYPTO_USED(TS_REQ_set_nonce);
LCRYPTO_USED(TS_REQ_get_nonce);
LCRYPTO_USED(TS_REQ_set_cert_req);
LCRYPTO_USED(TS_REQ_get_cert_req);
LCRYPTO_USED(TS_REQ_get_exts);
LCRYPTO_USED(TS_REQ_ext_free);
LCRYPTO_USED(TS_REQ_get_ext_count);
LCRYPTO_USED(TS_REQ_get_ext_by_NID);
LCRYPTO_USED(TS_REQ_get_ext_by_OBJ);
LCRYPTO_USED(TS_REQ_get_ext_by_critical);
LCRYPTO_USED(TS_REQ_get_ext);
LCRYPTO_USED(TS_REQ_delete_ext);
LCRYPTO_USED(TS_REQ_add_ext);
LCRYPTO_USED(TS_REQ_get_ext_d2i);
LCRYPTO_USED(TS_REQ_print_bio);
LCRYPTO_USED(TS_RESP_set_status_info);
LCRYPTO_USED(TS_RESP_get_status_info);
LCRYPTO_USED(TS_STATUS_INFO_get0_failure_info);
LCRYPTO_USED(TS_STATUS_INFO_get0_text);
LCRYPTO_USED(TS_STATUS_INFO_get0_status);
LCRYPTO_USED(TS_STATUS_INFO_set_status);
LCRYPTO_USED(TS_RESP_set_tst_info);
LCRYPTO_USED(TS_RESP_get_token);
LCRYPTO_USED(TS_RESP_get_tst_info);
LCRYPTO_USED(TS_TST_INFO_set_version);
LCRYPTO_USED(TS_TST_INFO_get_version);
LCRYPTO_USED(TS_TST_INFO_set_policy_id);
LCRYPTO_USED(TS_TST_INFO_get_policy_id);
LCRYPTO_USED(TS_TST_INFO_set_msg_imprint);
LCRYPTO_USED(TS_TST_INFO_get_msg_imprint);
LCRYPTO_USED(TS_TST_INFO_set_serial);
LCRYPTO_USED(TS_TST_INFO_get_serial);
LCRYPTO_USED(TS_TST_INFO_set_time);
LCRYPTO_USED(TS_TST_INFO_get_time);
LCRYPTO_USED(TS_TST_INFO_set_accuracy);
LCRYPTO_USED(TS_TST_INFO_get_accuracy);
LCRYPTO_USED(TS_ACCURACY_set_seconds);
LCRYPTO_USED(TS_ACCURACY_get_seconds);
LCRYPTO_USED(TS_ACCURACY_set_millis);
LCRYPTO_USED(TS_ACCURACY_get_millis);
LCRYPTO_USED(TS_ACCURACY_set_micros);
LCRYPTO_USED(TS_ACCURACY_get_micros);
LCRYPTO_USED(TS_TST_INFO_set_ordering);
LCRYPTO_USED(TS_TST_INFO_get_ordering);
LCRYPTO_USED(TS_TST_INFO_set_nonce);
LCRYPTO_USED(TS_TST_INFO_get_nonce);
LCRYPTO_USED(TS_TST_INFO_set_tsa);
LCRYPTO_USED(TS_TST_INFO_get_tsa);
LCRYPTO_USED(TS_TST_INFO_get_exts);
LCRYPTO_USED(TS_TST_INFO_ext_free);
LCRYPTO_USED(TS_TST_INFO_get_ext_count);
LCRYPTO_USED(TS_TST_INFO_get_ext_by_NID);
LCRYPTO_USED(TS_TST_INFO_get_ext_by_OBJ);
LCRYPTO_USED(TS_TST_INFO_get_ext_by_critical);
LCRYPTO_USED(TS_TST_INFO_get_ext);
LCRYPTO_USED(TS_TST_INFO_delete_ext);
LCRYPTO_USED(TS_TST_INFO_add_ext);
LCRYPTO_USED(TS_TST_INFO_get_ext_d2i);
LCRYPTO_USED(TS_RESP_CTX_new);
LCRYPTO_USED(TS_RESP_CTX_free);
LCRYPTO_USED(TS_RESP_CTX_set_signer_cert);
LCRYPTO_USED(TS_RESP_CTX_set_signer_key);
LCRYPTO_USED(TS_RESP_CTX_set_def_policy);
LCRYPTO_USED(TS_RESP_CTX_set_certs);
LCRYPTO_USED(TS_RESP_CTX_add_policy);
LCRYPTO_USED(TS_RESP_CTX_add_md);
LCRYPTO_USED(TS_RESP_CTX_set_accuracy);
LCRYPTO_USED(TS_RESP_CTX_set_clock_precision_digits);
LCRYPTO_USED(TS_RESP_CTX_add_flags);
LCRYPTO_USED(TS_RESP_CTX_set_serial_cb);
LCRYPTO_USED(TS_RESP_CTX_set_time_cb);
LCRYPTO_USED(TS_RESP_CTX_set_extension_cb);
LCRYPTO_USED(TS_RESP_CTX_set_status_info);
LCRYPTO_USED(TS_RESP_CTX_set_status_info_cond);
LCRYPTO_USED(TS_RESP_CTX_add_failure_info);
LCRYPTO_USED(TS_RESP_CTX_get_request);
LCRYPTO_USED(TS_RESP_CTX_get_tst_info);
LCRYPTO_USED(TS_RESP_create_response);
LCRYPTO_USED(TS_RESP_verify_signature);
LCRYPTO_USED(TS_RESP_verify_response);
LCRYPTO_USED(TS_RESP_verify_token);
LCRYPTO_USED(TS_VERIFY_CTX_new);
LCRYPTO_USED(TS_VERIFY_CTX_free);
LCRYPTO_USED(TS_VERIFY_CTX_cleanup);
LCRYPTO_USED(TS_VERIFY_CTX_add_flags);
LCRYPTO_USED(TS_VERIFY_CTX_set_flags);
LCRYPTO_USED(TS_VERIFY_CTX_set_data);
LCRYPTO_USED(TS_VERIFY_CTX_set_store);
LCRYPTO_USED(TS_VERIFY_CTX_set_certs);
LCRYPTO_USED(TS_VERIFY_CTX_set_imprint);
LCRYPTO_USED(TS_REQ_to_TS_VERIFY_CTX);
LCRYPTO_USED(TS_RESP_print_bio);
LCRYPTO_USED(TS_STATUS_INFO_print_bio);
LCRYPTO_USED(TS_TST_INFO_print_bio);
LCRYPTO_USED(TS_ASN1_INTEGER_print_bio);
LCRYPTO_USED(TS_OBJ_print_bio);
LCRYPTO_USED(TS_ext_print_bio);
LCRYPTO_USED(TS_X509_ALGOR_print_bio);
LCRYPTO_USED(TS_MSG_IMPRINT_print_bio);
LCRYPTO_USED(TS_CONF_load_cert);
LCRYPTO_USED(TS_CONF_load_certs);
LCRYPTO_USED(TS_CONF_load_key);
LCRYPTO_USED(TS_CONF_get_tsa_section);
LCRYPTO_USED(TS_CONF_set_serial);
LCRYPTO_USED(TS_CONF_set_signer_cert);
LCRYPTO_USED(TS_CONF_set_certs);
LCRYPTO_USED(TS_CONF_set_signer_key);
LCRYPTO_USED(TS_CONF_set_def_policy);
LCRYPTO_USED(TS_CONF_set_policies);
LCRYPTO_USED(TS_CONF_set_digests);
LCRYPTO_USED(TS_CONF_set_accuracy);
LCRYPTO_USED(TS_CONF_set_clock_precision_digits);
LCRYPTO_USED(TS_CONF_set_ordering);
LCRYPTO_USED(TS_CONF_set_tsa_name);
LCRYPTO_USED(TS_CONF_set_ess_cert_id_chain);
LCRYPTO_USED(ERR_load_TS_strings);

#endif /* _LIBCRYPTO_TS_H */
