unit Frame;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ShellApi, Clipbrd,  
  Info, ComCtrls, IniFiles, CleanUp, Buttons, ExtCtrls, RichEdit,
  StdCtrls, ToolWin;

const MAXCOMMAND = 500;   // maximal length of a command

type
  TFrameForm = class(TForm)
    FrameMenu: TMainMenu;
    File1: TMenuItem;
    Window1: TMenuItem;
    New: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    TeX1: TMenuItem;
    Compile1: TMenuItem;
    Help1: TMenuItem;
    MainFile1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    DialogMainFile: TOpenDialog;
    Tile1: TMenuItem;
    Cascade1: TMenuItem;
    ArrangeIcons1: TMenuItem;
    OpenDialog: TOpenDialog;
    Preview1: TMenuItem;
    View1: TMenuItem;
    WordWrap1: TMenuItem;
    LogFile1: TMenuItem;
    MainFile2: TMenuItem;
    StatusBar1: TStatusBar;
    StatusBar2: TMenuItem;
    TeXShell1: TMenuItem;
    LaTeX1: TMenuItem;
    N2: TMenuItem;
    CleanUp1: TMenuItem;
    SpeedBar2: TMenuItem;
    Options1: TMenuItem;
    LineSpecials1: TMenuItem;
    CreateBackups1: TMenuItem;
    SyntaxColoring1: TMenuItem;
    N3: TMenuItem;
    UpdateSelection1: TMenuItem;
    Appearance1: TMenuItem;
    ProgramCalls1: TMenuItem;
    WindowBar1: TMenuItem;
    Recent1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    N4: TMenuItem;
    Toolboxes1: TMenuItem;
    Symbols1: TMenuItem;
    MathSymbols1: TMenuItem;
    GreekLetters1: TMenuItem;
    UserTemplates1: TMenuItem;
    UserTemplates2: TMenuItem;
    Templates1: TMenuItem;
    Section1: TMenuItem;
    Subsection1: TMenuItem;
    N7: TMenuItem;
    Enumeration1: TMenuItem;
    Items1: TMenuItem;
    Description1: TMenuItem;
    N8: TMenuItem;
    Image1: TMenuItem;
    Document1: TMenuItem;
    N5: TMenuItem;
    UserTemplates3: TMenuItem;
    Chapter1: TMenuItem;
    Edit1: TMenuItem;
    Undo1: TMenuItem;
    N6: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N9: TMenuItem;
    Find1: TMenuItem;
    Replace1: TMenuItem;
    SearchAgain1: TMenuItem;
    Find2: TMenuItem;
    N10: TMenuItem;
    GoToLine1: TMenuItem;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;
    ToolBar1: TPanel;
    WindowBar: TPanel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    ScrollBox1: TScrollBox;
    CloseAll1: TMenuItem;
    Graphics1: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    SpellCheck1: TMenuItem;
    SpellChecker1: TMenuItem;
    Save0: TMenuItem;
    Commentoutin1: TMenuItem;
    UnicodeUTF8: TMenuItem;
    procedure NewChild(Sender: TObject);
    procedure MainFileClick(Sender: TObject);
    procedure Compile(Sender: TObject);
    procedure TileClick(Sender: TObject);
    procedure CascadeClick(Sender: TObject);
    procedure ArrangeIconsClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure OpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure WordWrap1Click(Sender: TObject);
    procedure MainFile2Click(Sender: TObject);
    procedure LogFile1Click(Sender: TObject);
    procedure StatusBar2Click(Sender: TObject);
    procedure LaTeX1Click(Sender: TObject);
    procedure TeXShell1Click(Sender: TObject);
    procedure CleanUp1Click(Sender: TObject);
    procedure SpeedBar2Click(Sender: TObject);
    procedure LineSpecials1Click(Sender: TObject);
    procedure CreateBackups1Click(Sender: TObject);
    procedure SyntaxColoring1Click(Sender: TObject);
    procedure UpdateSelection1Click(Sender: TObject);
    procedure Appearance1Click(Sender: TObject);
    procedure ProgramCalls1Click(Sender: TObject);
    procedure CallExternalProgram(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure WindowBar1Click(Sender: TObject);
    procedure Buttons1Click(Sender: TObject);
    procedure OpenRecent(Sender: TObject); //*PN*
    procedure Save(Sender: TObject); //*PN* moved from EditForm
    procedure SaveAs(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure GreekLetters1Click(Sender: TObject);
    procedure MathSymbols1Click(Sender: TObject);
    procedure Symbols1Click(Sender: TObject);
    procedure UserTemplates1Click(Sender: TObject);
    procedure UserTemplates2Click(Sender: TObject);
    procedure Chapter1Click(Sender: TObject);
    procedure Section1Click(Sender: TObject);
    procedure Subsection1Click(Sender: TObject);
    procedure Enumeration1Click(Sender: TObject);
    procedure Items1Click(Sender: TObject);
    procedure Description1Click(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Document1Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure SearchAgain1Click(Sender: TObject);
    procedure Find2Click(Sender: TObject);
    procedure GoToLine1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
//    procedure Recent1Click(Sender: TObject);
    procedure View1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure CloseAll1Click(Sender: TObject);
    procedure Graphics1Click(Sender: TObject);
    procedure SpellCheck1Click(Sender: TObject);
    procedure SpellChecker1Click(Sender: TObject);
    procedure Save0Click(Sender: TObject);
    procedure Commentoutin1Click(Sender: TObject);
    procedure UnicodeUTF8Click(Sender: TObject); //*PN* moved from EditForm
  private
    defaultFormat: integer; //*DS* property defaultFileFormat
    iniFile: TIniFile;
    cUnnamed: integer; // counter for the new unnamed windows;
    procedure ReplaceStringPart ( toReplace, by: string; var source: string);
    // expands modifiers like %m, %f for command line
    function ExpandModifiers (const toExpand: string): string;

    function ExpandEnvironmentVariables (const toExpand: string): string;//*DS*

    procedure DoButton(Sender: TObject);
    function GetTag(theCommand: string):integer;
    procedure UserTemplSubClick(Sender: TObject);
    procedure UpdateTemplateSub;

    //*DS* rempove this in future versions
    procedure CompatibilityTransformTemplateFiles;

    //*PK* Message Handler (Drag & Drop)
    procedure WMDropFiles(var Message: TWMDropFiles); message WM_DropFiles;

  public
    version: integer;     //*DS* version number 50 means 0.5
    versionNetworkIni: integer; //*DS* version number in network ini
    lockIniFile: boolean; //*DS* don't write back to ini file if this is true
    network: boolean; //*DS* network configuration active?
    laTexHelpFile: string;
    helpFile: string;
    strMainFile: string;
    mainFileSelected: boolean;
    strCompileCommand: string;
    strLogFileCommand: string;
    strPreviewCommand: string;
    strSpellChecker: string;
    backgroundColor: TColor;

    standardFont: TFont;
    texCommandFont: TFont;
    parenthesisFont: TFont;
    squareBracketFont: TFont;
    roundBracketFont: TFont;
    dollarFont: TFont;
    commentFont: TFont;

    standardFormat:    TCharFormat;
    texCommandFormat:  TCharFormat;
    parenthesisFormat: TCharFormat;
    squareBracketFormat: TCharFormat;
    roundBracketFormat: TCharFormat;
    dollarFormat:       TCharFormat;
    commentFormat:      TCharFormat;
    wordWrap: boolean;
    createBackup: boolean;
    handleLineSpecials: boolean;
    syntaxColoring: boolean;
    iniFileName: string; // use this to read from ini file
    userIniFileName: string; //*DS* use this to write to ini file
    extProgramNames: TStringList; // names of external programs for the menu
    extProgramCalls: TStringList; // names and parameters of that programs
    extButtonNames   : TStringList; // names of user defined buttons
    extButtonActions : TStringList; // actions that should be performed

    //*DS* button commands as they are defined in the ini file
    // parsing results in extButtonActions;
    extButtonValues: TStringList;

    recentFiles      : TStringList; //*PN* for recent files
    linelength       : integer; //*PN* for poor mans word wrap...

    procedure Open (const fileName: string;
                    const filterIndex: integer;  
                    const line: integer);
    procedure OnCopyData (var msg: TMessage); message WM_COPYDATA;
    procedure SaveAllFilesIfChanged; //*DS*
    //*PN*
    procedure ExecProg(programm:string; dir:string);
    procedure SetFormats;
    procedure InsertText(part1, part2: string);
    procedure SetButtons;
    procedure AddToRecent(recFile: string); //*PN*
    procedure CheckWinBarScroll;
    //*DS* called by the program unit to restore old status
    procedure AfterCreate;
    procedure SetDefaultFileFormat( newFormat: integer );
    property defaultFileFormat: integer read defaultFormat write SetDefaultFileFormat; //*DS* TEX_FORMAT or UTF8_FORMAT
  end;

var
  FrameForm: TFrameForm;

implementation

uses greekDlg, mathDlg, symbolDlg, AppearanceDlg, ProgramsDlg, //CustButtons,
     UserTemplates, TemplateDlg, ImageDlg, DocumentDlg, Edit, GraphicsDlg,
  SpellCheckDlg, OptSpellCheckDlg;

{$R *.DFM}

procedure TFrameForm.CheckWinBarScroll;
begin
  if ScrollBox1.HorzScrollBar.Range > ScrollBox1.Width then
  begin
    if ScrollBox1.ClientHeight >= ToolBar1.Height - 2 then exit;  //nothing to do
    WindowBar.Height := ToolBar1.Height + (ToolBar1.Height - 2 - ScrollBox1.ClientHeight);
  end
  else
  begin
    if WindowBar.Height = Toolbar1.Height then exit;  //nothing to do
    WindowBar.Height := Toolbar1.Height;
  end;
  Scrollbox1.Refresh;
end;


procedure TFrameForm.ReplaceStringPart ( toReplace, by: string; var source: string);
var position: integer;
begin
  while true do
  begin
    position := Pos (toReplace, source);
    if position = 0 then
      exit
    else
    begin
      Delete (source, position, Length (toReplace));
      Insert (by, source, position);
    end;
  end;
end;

// expands modifiers for command line. Main file must be chosen
function TFrameForm.ExpandModifiers (const toExpand: string): string;
var expanded: string;
    strActiveFile : string;
    extendedExtension: string;
    pathMainFile : string;
    fileMainFile : string;
    extMainFile : string;
    pathActiveFile : string;
    fileActiveFile : string;
    extActiveFile : string;
    lineNumber : integer;
begin
  if handleLineSpecials then
    extendedExtension := '.txx'
  else
    extendedExtension := '.tex';

  expanded := toExpand;

  pathMainFile := ExtractFilePath (strMainFile);
  fileMainFile := ExtractFilename (strMainFile);
  fileMainFile := ChangeFileExt (fileMainFile, '');
  extMainFile  := ExtractFileExt (strMainFile);

  // obsolete placeholders
  ReplaceStringPart ('%M', strMainFile, expanded);
  ReplaceStringPart ('%m', pathMainFile + fileMainFile, expanded);
  //

  ReplaceStringPart ('%P', pathMainFile, expanded);
  ReplaceStringPart ('%F', fileMainFile, expanded);
  ReplaceStringPart ('%E', extMainFile, expanded);
  ReplaceStringPart ('%x', extendedExtension, expanded);

  if activeMDIChild is TEditForm then
  begin
    strActiveFile := (activeMDIChild as TEditForm).fileName;
    pathActiveFile := ExtractFilePath (strActiveFile);
    fileActiveFile := ExtractFilename (strActiveFile);
    fileActiveFile := ChangeFileExt (fileActiveFile, '');
    extActiveFile  := ExtractFileExt (strActiveFile);
    lineNumber := (activeMDIChild as TEditForm).GetLineNumber;

    ReplaceStringPart ('%p', pathActiveFile, expanded);
    ReplaceStringPart ('%f', fileActiveFile, expanded);
    ReplaceStringPart ('%e', extActiveFile, expanded);
    ReplaceStringPart ('%l', IntToStr(lineNumber), expanded);

    // obsolete placeholders
    //ReplaceStringPart ('%f', pathActiveFile + fileActiveFile, expanded);
    //ReplaceStringPart ('%F', strActiveFile, expanded);
    ReplaceStringPart ('%S', fileActiveFile + ExtActiveFile, expanded);
    //
  end;
  Result := expanded;
end;


// *DS*
// Expands file name with environment varibles
// like c:\%username%\texshell.ini
// returns '' if an environment variable is not set
// needed for network
function TFrameForm.ExpandEnvironmentVariables (const toExpand: string): string;
var expanded: String[255];
    envVariableName: String[255];
    envVariable: String[255];
    pCharEnvVariableName: array[0..254] of Char;
    pCharEnvVariable: array[0..254] of Char;
    pivot,
    pos1,
    pos2: integer;
    i: integer;
    success: integer;
    len: integer;
begin
  pos1 := 0;
  pivot := 1;
  envVariable := '';
  expanded := '';

  len := Length (toExpand);
  for i := 1 to len do
  begin
    if toExpand[i] = '%' then
    begin
      if pos1 = 0 then
      begin
        pos1 := i;
        expanded := expanded + Copy (toExpand, pivot, i - pivot);
      end
      else
      begin
        pos2 := i;
        pivot := i + 1;
        envVariableName := Copy (toExpand, pos1 + 1, pos2 - pos1 - 1);
        StrPCopy (pCharEnvVariableName, envVariableName);
        success := GetEnvironmentVariable(pCharEnvVariableName, pCharEnvVariable, 254 );
        if success = 0 then
        begin
          Result := '';
          Exit;
        end;
        envVariable := string (pCharEnvVariable);
        expanded := expanded + envVariable;
        pos1 := 0;
      end;
    end;
  end;

  if pivot < len then
    expanded := expanded + Copy (toExpand, pivot, len + 1 - pivot); ;

  Result := expanded;
end;


procedure TFrameForm.NewChild(Sender: TObject);
var EditForm: TEditForm;
begin
  EditForm := TEditForm.Create(self);
  EditForm.Caption := 'Unnamed' + IntToStr(cUnnamed);
  EditForm.theWinPanel.Caption := EditForm.Caption;
  EditForm.SizeWinPanel;
  Inc (cUnnamed);
end;

procedure TFrameForm.MainFileClick(Sender: TObject);
begin
  if DialogMainFile.Execute then
  begin
    strMainFile := DialogMainFile.FileName;
    mainFileSelected := true;
    MainFile2Click (Sender);
  end;
end;

//*DS*
procedure TFrameForm.SaveAllFilesIfChanged;
var i: integer;
    specialFile: string;
begin
  for i := 0 to MDIChildCount - 1 do
  begin
    with (MDIChildren[i] as TEditForm) do
    begin
      if RichEdit.Modified then Save;
    end
  end;
end;

procedure TFrameForm.Compile(Sender: TObject);
begin
  SaveAllFilesIfChanged; //*DS*

  { check for selected main file and compile }
  if mainFileSelected = false then
    MainFileClick (Sender);
  if mainFileSelected = true then
  begin
    //*PN*
    ExecProg(ExpandModifiers(strCompileCommand), ExtractFileDir(strMainFile));
  end;
end;


procedure TFrameForm.TileClick(Sender: TObject);
begin
  Tile;
end;

procedure TFrameForm.CascadeClick(Sender: TObject);
begin
  Cascade;
end;

procedure TFrameForm.ArrangeIconsClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TFrameForm.ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TFrameForm.OpenClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    Open (OpenDialog.FileName, OpenDialog.FilterIndex, -1);
  end
end;

procedure TFrameForm.Open( const fileName: string;
                           const filterIndex: integer;
                           const line: integer);
var EditForm: TEditForm;
    i: Integer;
    loaded: Integer;
    fullFileName: string;
    extension: string;
begin
  loaded := -1;
  fullFileName := ExpandFileName (fileName);

  // *DS* TeX sometimes returns file names without extension
  if not FileExists(fullFileName) then
  begin
    fullFileName := ChangeFileExt (fullFileName, '.tex');
  end;

  extension := ExtractFileExt (fullFileName);

  { map files with .txx ending to .tex ending }
  if handleLineSpecials and (extension = '.txx') then
  begin
    fullFileName := ChangeFileExt (fullFileName, '.tex');
    extension := '.tex';
  end;

  if FileExists (fullFileName) then
  begin
    { file already loaded? }
    for i := 0 to MDIChildCount-1 do
    begin
      if AnsiCompareFileName( (MDIChildren[i] as TEditForm).fileName, fullFileName ) =  0 then
        loaded := i;
    end;
    { handle log files seperatly }
    if (extension = '.log') and (loaded <> - 1) then
    begin { close old log file if already opened }
      (MDIChildren[loaded] as TEditForm).Close;
      loaded := -1;
    end;

    if loaded <> -1 then
    begin
      (MDIChildren[loaded] as TEditForm).BringToFront;
      Application.ProcessMessages;
      (ActiveMDIChild as TEditForm).GoToLine (line);
    end
    else
    begin
      EditForm := TEditForm.Create (Self);
      case filterIndex of
        TEX_FORMAT:  begin
                       EditForm.Open( fullFileName, TEX_FORMAT, true );
                     end;
        UTF8_FORMAT: begin
                       EditForm.Open( fullFileName, UTF8_FORMAT, true );
                     end;
        DOS_FORMAT:  EditForm.Open( fullFileName, DOS_FORMAT, false );  //OEM
        UNIX_FORMAT: EditForm.Open( fullFileName, UNIX_FORMAT, true );   //UNIX
        STYLE_FORMAT:EditForm.Open( fullfilename, STYLE_FORMAT, true );   //*PN* open sty, cls
                      // do LFConv, because most sty, cls are with UNIX-LF
        ALL_FORMATS: EditForm.Open( fullfilename, ALL_FORMATS, true ); //*DS* All files Unix Style
      end;
//      EditForm.Visible := true;
      EditForm.GoToLine (line);
      AddToRecent(fullFileName); //*PN*
    end;
  end
end;

procedure TFrameForm.SetFormats;

  procedure SetSingleFormat(var theFormat: TCharFormat; theFont: TFont);
  begin
    with theFormat do
    begin
      cbSize := SizeOf (TCharFormat);
      dwMask := 0;
      dwMask := CFM_SIZE or CFM_FACE or CFM_COLOR or CFM_BOLD or CFM_ITALIC or CFM_UNDERLINE or CFM_STRIKEOUT;
      dwEffects := 0;
      if fsBold in theFont.Style then dwEffects := dwEffects or CFE_BOLD;
      if fsItalic in theFont.Style then dwEffects := dwEffects or CFE_ITALIC;
      if fsUnderline in theFont.Style then dwEffects := dwEffects or CFE_UNDERLINE;
      if fsStrikeOut in theFont.Style then dwEffects := dwEffects or CFE_STRIKEOUT;
      yHeight := theFont.Size * 20;
      yOffset := 0;
      crTextColor := theFont.Color;
      bCharSet := theFont.Charset;
      case theFont.Pitch of
        fpVariable: bPitchAndFamily := VARIABLE_PITCH;
        fpFixed:    bPitchAndFamily := FIXED_PITCH;
      else
        bPitchAndFamily := DEFAULT_PITCH;
      end;
      StrPLCopy(szFaceName, theFont.Name, SizeOf(szFaceName));
    end;
  end;

begin
  SetSingleFormat(texCommandFormat, texCommandFont);
  SetSingleFormat(standardFormat, standardFont);
  SetSingleFormat(parenthesisFormat, parenthesisFont);
  SetSingleFormat(squareBracketFormat, squareBracketFont);
  SetSingleFormat(roundBracketFormat, roundBracketFont);
  SetSingleFormat(dollarFormat, dollarFont);
  SetSingleFormat(commentFormat, commentFont);
end;

procedure TFrameForm.FormCreate(Sender: TObject);
var i: integer;
    state : string;
    recRead: string; //*PN*
    testStream: TFileStream; //*DS*

  procedure CreateFont(var theFont: TFont; theFontName: string; defcolor: integer); //*PN* only better readable...
  var strStyle: string;
  begin
    with theFont do
    begin
      theFont := TFont.Create;
      Name  := iniFile.ReadString ('View', theFontName + 'fontName', 'System');
      Size  := iniFile.ReadInteger ('View', theFontName + 'fontSize', 12);
      Color := iniFile.ReadInteger ('View', theFontName + 'fontColor', defcolor);
      strStyle := iniFile.ReadString ('View', theFontName + 'fontStyle', '');;
      Charset  := iniFile.ReadInteger ('View', theFontName + 'charSet', Charset);
      Style := [];
      if Pos('fsBold',   strStyle) > 0 then Style := [fsBold];
      if Pos('fsItalic', strStyle) > 0 then Style := Style + [fsItalic];
      if Pos('fsUnderline', strStyle) > 0 then Style := Style + [fsUnderline];
      if Pos('fsStrikeout', strStyle) > 0 then Style := Style + [fsStrikeout];
    end;
  end;

begin
  DragAcceptFiles(Handle,true); //*PK* accept files via drag and drop
  lockIniFile := false; //*DS*
  cUnnamed := 1;
  mainFileSelected := false;

  helpFile := ExtractFileDir(Application.ExeName) + '\' + 'TeXShell.hlp';
  Application.HelpFile := helpFile;
  laTexHelpFile := ExtractFileDir(Application.ExeName) + '\' + 'LaTeX2e.hlp';

  iniFileName := ExtractFileDir(Application.ExeName) + '\' + 'TeXShell.ini';
  userIniFileName := iniFileName;
  iniFile := TIniFile.Create (iniFileName);

  // *DS* Network configuration
  versionNetworkIni := iniFile.ReadInteger ('General', 'version', 0);
  network := iniFile.ReadBool ('Network', 'network', false);
  if network = true then
  begin
    userIniFileName := iniFile.ReadString('Network', 'userIni', '');
    // parse userIni for environment variables
    userIniFileName := ExpandEnvironmentVariables (userIniFileName);

    // if this is not valid use alternative file
    if userIniFileName = '' then
    begin
      userIniFileName := iniFile.ReadString('Network', 'alternativeIni', '');
      userIniFileName := ExpandEnvironmentVariables (userIniFileName);
    end;

    if userIniFileName <> '' then // oo better check for valid filename
    begin
      // if there is already an ini file then use it
      if  ( FileExists (userIniFileName) )
      and ( Pos('*', userIniFileName)=0 )  // check for wildcards because FileExists doesn't
      and ( Pos('?', userIniFileName)=0 )then
      begin
        iniFileName := userIniFileName;
        iniFile.Free;
        iniFile := TIniFile.Create (userIniFileName);
      end
      else // try if it is possible to create a new one
      begin
        try
          CreateDir ( ExtractFilePath(userIniFileName) );
          testStream := TFileStream.Create(userIniFileName, fmCreate); // just try if it is possible to create a file
          testStream.Free;
        except
          MessageDlg('Could not create user ini file!', mtWarning, [mbOK], 0);
          lockIniFile := true;
        end;
      end;
    end
    else lockIniFile := true;
  end;
  // END *DS* Network configuration

  //*DS*remove this line in future versions
  CompatibilityTransformTemplateFiles;

  version := iniFile.ReadInteger ('General', 'version', 0);  //*DS*
  wordWrap := iniFile.ReadBool ('View', 'wordWrap', false);
  handleLineSpecials := iniFile.ReadBool ('Options', 'lineSpecials', false);
  createBackup := iniFile.ReadBool ('Options', 'createBackup', true);
  syntaxColoring := iniFile.ReadBool ('Options', 'syntaxColoring', true);
  defaultFileFormat := iniFile.ReadInteger ('Options', 'fileFormat', TEX_FORMAT); //*DS*
  statusBar1.Visible := iniFile.ReadBool ('View', 'statusBar', true);
  ToolBar1.Visible := iniFile.ReadBool ('View', 'speedBar', true);
  WindowBar.Visible := iniFile.ReadBool ('View', 'WindowBar', true); //*PN*

  CreateFont(standardFont, '', clBlack);
  CreateFont(texCommandFont, 'texCommand', clRed);
  CreateFont(parenthesisFont, 'parenthesis', clRed);
  CreateFont(squareBracketFont, 'squareBracket', clRed);
  CreateFont(roundBracketFont, 'roundBracket', clRed);
  CreateFont(dollarFont, 'dollar', clRed);
  CreateFont(commentFont, 'comment', clGreen);

  backgroundColor := iniFile.ReadInteger ('View', 'backgroundColor', clWindow);
  Color := backgroundColor;
  strCompileCommand := iniFile.ReadString ('TeX', 'Compile', 'latex --src-specials %F.tex');
  strLogFileCommand := iniFile.ReadString ('TeX', 'LogFile', '%P%F.log');
  strPreviewCommand := iniFile.ReadString ('TeX', 'Preview', 'yap -1 -s %l%f%e "%P%F.dvi"');
  strSpellChecker := iniFile.ReadString ('Options', 'spellChecker', '');

  // User defined programs for TeX menu
  extProgramNames := TStringList.Create;
  extProgramCalls := TStringList.Create;
  iniFile.ReadSection ('External Programs', extProgramNames);
  iniFile.ReadSectionValues ('External Programs', extProgramCalls);

  // User defined buttons
  extButtonNames := TStringList.Create;
  extButtonActions := TStringList.Create;
  extButtonValues := TStringList.Create;

  //*PN* first check for new ButtonBar Section
  iniFile.ReadSection ('Buttons', extButtonNames);
  iniFile.ReadSectionValues ('Buttons', extButtonValues);

  //*PN* recent file list
  recentFiles := TStringList.Create;
  i := 0;
  repeat
    recRead := iniFile.ReadString('Recent', IntToStr(i), '');
    if recRead <> '' then begin
      recentFiles.Add(recRead);
      Recent1.Enabled := true;
      Recent1.Add(NewItem('&'+IntToStr(i)+' '+recread, //ExtractFileName(recRead),
                          0,
                          false,
                          true,
                          OpenRecent,
                          0,
                          'recFile'+IntToStr(i)));
    end;
    INC(i);
  until (recRead='') or (i=10);  //max. 10 recent files were saved
  //*PN* end

  Height := iniFile.ReadInteger ('WindowSize', 'height', 450);
  Width :=  iniFile.ReadInteger ('WindowSize', 'width', 600);
  Left :=   iniFile.ReadInteger ('WindowSize', 'left', 10);
  Top :=    iniFile.ReadInteger ('WindowSize', 'top', 10);

  state := iniFile.ReadString ('WindowSize', 'state', 'wsNormal');
  windowState := wsNormal;
  if state = 'wsMaximized' then windowState := wsMaximized;
  if state = 'wsMinimized' then windowState := wsMinimized;

  WordWrap1.Checked := wordWrap;
  speedBar2.Checked := ToolBar1.Visible;
  statusBar2.Checked := statusBar1.Visible;
  LineSpecials1.Checked := handleLineSpecials;
  CreateBackups1.Checked := createBackup;
  WindowBar1.Checked := WindowBar.Visible; //*PN*

  SetFormats;

  { add external programs to TeX menu }
  if extProgramNames.Count > 0 then
  begin
    TeX1.Add (NewLine);
    for i := 0 to extProgramNames.Count-1 do
    begin
      TeX1.Add ( NewItem(extProgramNames.Strings[i],
                         0,
                         False,
                         True,
                         CallExternalProgram,
                         0,
                         extProgramNames.Strings[i]) );
    end;
  end;

  SetButtons;
  Font.Charset := standardFont.charset;
  linelength := inifile.ReadInteger('Options', 'linebreakat', 0);
  iniFile.Free;  //*PN* moved to end
end; // OnCreate


procedure TFrameForm.PreviewClick(Sender: TObject);
begin
  if mainFileSelected = false then
    MainFileClick (Sender);
  if mainFileSelected = true then
  begin
    //*PN*
    ExecProg(ExpandModifiers(strPreviewCommand), ExtractFileDir(strMainFile));
  end;
end;


procedure TFrameForm.About1Click(Sender: TObject);
begin
  InfoDlg.ShowModal;
end;

procedure TFrameForm.WordWrap1Click(Sender: TObject);
var i: integer;
begin
  wordWrap := not wordWrap;
  WordWrap1.Checked := wordWrap;

  for i := 0 to MDIChildCount-1 do
  begin
    (MDIChildren[i] as TEditForm).WordWrapClick(Sender);
  end;

end;

procedure TFrameForm.MainFile2Click(Sender: TObject);
begin
  if mainFileSelected = false then MainFileClick(Sender);
  if mainFileSelected then
  begin
    Open (strMainFile, DialogMainFile.FilterIndex, -1);
    StatusBar1.Panels[1].Text := 'Main file: ' + strMainFile;  //*PN*
    SetCurrentDir (ExtractFileDir (FrameForm.strMainFile)); //*PN*
  end;
end;

procedure TFrameForm.LogFile1Click(Sender: TObject);
var strLogFile: string;
begin
  if mainFileSelected = false then MainFileClick(Sender);
  if mainFileSelected then
  begin
    strLogFile := ExpandModifiers (strLogFileCommand);
    if defaultFormat = UTF8_FORMAT then
      Open (strLogFile, UTF8_FORMAT, -1)
    else
      Open (strLogFile, TEX_FORMAT, -1);
 end;
end;

procedure TFrameForm.StatusBar2Click(Sender: TObject);
begin
  StatusBar1.Visible := not StatusBar1.Visible;
  StatusBar2.Checked := StatusBar1.Visible;
end;

procedure TFrameForm.OnCopyData (var msg: TMessage);
const line: integer = 0;
const main: boolean = false;
const fileType: string = '';
var pCopyDataStruct : ^TCopyDataStruct;
    strMessage : string;
    option: integer;
    isFileName : boolean;
begin
  // OnCopyData receives only one parameter at a time
  pCopyDataStruct := Pointer(msg.LParam);
  strMessage := StrPas (pCopyDataStruct.lpData);
  isFileName := true;

  option := Pos ('/m', strMessage);
  if option <> 0 then
  begin
    main := true;
    isFileName := false;
  end;

  option := Pos ('/l=', strMessage);
  if option <> 0 then
  begin
    Delete (strMessage, 1, 3);
    line := StrToInt (strMessage);
    isFileName := false;
  end;

  option := Pos ('/f=', strMessage);
  if option <> 0 then
  begin
    Delete (strMessage, 1, 3);
    fileType := AnsiLowerCase(strMessage);
    isFileName := false;
  end;

  if isFileName then
  begin
    strMessage := ExpandModifiers(strMessage);

    if fileType = 'dos' then
      Open (strMessage, DOS_FORMAT, line)
    else if fileType = 'unix' then
      Open (strMessage, UNIX_FORMAT, line)
    else if defaultFormat = UTF8_FORMAT then
      Open (strMessage, UTF8_FORMAT, line)
    else
      Open (strMessage, TEX_FORMAT, line);

    line := 1;
    fileType := '';
    if main then
    begin
      strMainFile := ExpandFileName (strMessage);
      mainFileSelected := true;
      StatusBar1.Panels[1].Text := 'Main file ' + strMainFile;
      main := false;
    end;
  end;
end;

procedure TFrameForm.LaTeX1Click(Sender: TObject);
begin
  Application.HelpFile := laTexHelpFile;
  Application.HelpCommand(HELP_CONTENTS, 0);
  Application.HelpFile := helpFile;
end;

procedure TFrameForm.TeXShell1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TFrameForm.CleanUp1Click(Sender: TObject);
begin
  CleanUpDlg.ShowModal;
end;

procedure TFrameForm.SpeedBar2Click(Sender: TObject);
begin
  Toolbar1.Visible := not ToolBar1.Visible;
  SpeedBar2.Checked := ToolBar1.Visible;
  //*PN* the following ensures, that the order of SpeedBar and WindowBar
  //     is kept (otherwise Delphi shuffles top aligned elements if they
  //              are switched in the wrong order)
  // value must only be great enough to move windowbar below Speedbar
  if ToolBar1.Visible and WindowBar.Visible then WindowBar.Top := 200;
end;

procedure TFrameForm.LineSpecials1Click(Sender: TObject);
begin
  handleLineSpecials := not handleLineSpecials;
  LineSpecials1.Checked := handleLineSpecials;
end;

procedure TFrameForm.CreateBackups1Click(Sender: TObject);
begin
  createBackup := not createBackup;
  CreateBackups1.Checked := createBackup;
end;

procedure TFrameForm.SyntaxColoring1Click(Sender: TObject);
var i: integer;
    isModified: boolean;
begin
  syntaxColoring := not syntaxColoring;
  SyntaxColoring1.Checked := syntaxColoring;

  // update syntax coloring
  for i := 0 to MDIChildCount-1 do
  begin
    isModified := (MDIChildren[i] as TEditForm).RichEdit.Modified; //save state
    (MDIChildren[i] as TEditForm).Font := standardFont;
    if syntaxColoring then
    begin
      Screen.Cursor := crHourglass;
      (MDIChildren[i] as TEditForm).UpdateSyntaxColoring;
      Screen.Cursor := crDefault;
    end
    else
    begin
      (MDIChildren[i] as TEditForm).SetToStandard; //Format (standardFormat);
    end;
    (MDIChildren[i] as TEditForm).RichEdit.Modified := isModified;
    if not isModified then //*PN* reset bold in WinPanel
    begin
      (MDIChildren[i] as TEditForm).theWinPanel.Font.Style := [];
      (MDIChildren[i] as TEditForm).SizeWinPanel;
    end;
  end;
end;

procedure TFrameForm.UpdateSelection1Click(Sender: TObject);
begin
  (activeMDIChild as TEditForm).UpdateSelection;
end;

procedure TFrameForm.Appearance1Click(Sender: TObject);
var i: integer;
    hDec: HDC;
    isModified: boolean;
//    size: integer;
begin
  AppearanceDialog.DemoEdit.Color := backgroundColor;
  AppearanceDialog.standardFont := standardFont;
  AppearanceDialog.parenthesisFont :=  parenthesisFont;
  AppearanceDialog.texCommandFont :=   texCommandFont;
  AppearanceDialog.squareBracketFont := squareBracketFont;
  AppearanceDialog.roundBracketFont := roundBracketFont;
  AppearanceDialog.dollarFont :=    dollarFont;
  AppearanceDialog.commentFont :=   commentFont;

  AppearanceDialog.ShowModal;
  if AppearanceDialog.ModalResult = mrOk then
  begin
    // set new background color
    backgroundColor := AppearanceDialog.DemoEdit.Color;
    Color := backgroundColor;
    hDec := GetDC (ClientHandle);
    PostMessage(Handle, WM_ERASEBKGND, wparam(hDec), 0);
//    for i := 0 to MDIChildCount-1 do
//      (MDIChildren[i] as TEditForm).BackgroundColor1Click(Sender);

    // set new fonts
    standardFont := AppearanceDialog.standardFont;
    parenthesisFont := AppearanceDialog.parenthesisFont;
    texCommandFont := AppearanceDialog.texCommandFont;
    squareBracketFont := AppearanceDialog.squareBracketFont;
    roundBracketFont := AppearanceDialog.roundBracketFont;
    dollarFont := AppearanceDialog.dollarFont;
    commentFont := AppearanceDialog.commentFont;
    SetFormats;

    Screen.Cursor := crHourglass;
    for i := 0 to MDIChildCount-1 do
    begin
      with (MDIChildren[i] as TEditForm) do
      begin
        isModified := RichEdit.Modified;   //*PN* save modified state
        RichEdit.Color := backgroundColor;
        RichEdit.Font := standardFont;
        if syntaxColoring then
          UpdateSyntaxColoring
        else
          SetToStandard; //Format(standardFormat);
        RichEdit.Modified := isModified;
        if not isModified then //*PN* reset bold in WinPanel
        begin
          theWinPanel.Font.Style := [];
          SizeWinPanel;
        end;
      end;
    end;
    Screen.Cursor := crDefault;
  end;
end;

procedure TFrameForm.ProgramCalls1Click(Sender: TObject);
begin
  ProgramsDialog.TexEdit.Text       := strCompileCommand;
  ProgramsDialog.LogFileEdit.Text   := strLogFileCommand;
  ProgramsDialog.PreviewerEdit.Text := strPreviewCommand;
  ProgramsDialog.ShowModal;
  if ProgramsDialog.ModalResult = mrOk then
  begin
    strCompileCommand := ProgramsDialog.TexEdit.Text;
    strLogFileCommand := ProgramsDialog.LogFileEdit.Text;
    strPreviewCommand := ProgramsDialog.PreviewerEdit.Text;
  end;
end;


procedure TFrameForm.CallExternalProgram(Sender: TObject);
var strCommand : String;
    strMenu: String;
begin
  //*PN*
  ExecProg(ExpandModifiers(extProgramCalls.Values [(Sender as TMenuItem).Name]), ''); //this one not with path to main file
end;

procedure TFrameForm.SaveButtonClick(Sender: TObject);
begin
  if MDIChildCount > 0 then Save(Sender);
end;


procedure TFrameForm.WindowBar1Click(Sender: TObject);
begin
  WindowBar.Visible := not WindowBar.Visible;
  WindowBar1.Checked := WindowBar.Visible;
  //*PN* the following ensures, that the order of SpeedBar and WindowBar
  //     is kept (otherwise Delphi shuffles top aligned elements if they
  //              are switched in the wrong order)
  // value must only be great enough to move windowbar below Speedbar
  if ToolBar1.Visible and WindowBar.Visible then WindowBar.Top := 200;
end;

procedure TFrameForm.Buttons1Click(Sender: TObject);
begin
//  CustButtonsDialog.ShowModal;
end;

//*PN*
procedure TFrameForm.AddToRecent(recFile: string);
var i, toDelete: integer;
begin
  Recent1.Enabled := true;
  toDelete := -1;
  for i := 0 to recentFiles.Count - 1 do
    if recentFiles[i] = recFile then toDelete := i;//already in recent files list, bring to top!
  if toDelete >= 0 then
  begin
    Recent1.Delete(0);      //no matter which Element is deleted
    recentFiles.Delete(toDelete);
  end;
  if recentFiles.Count < 10 then
    Recent1.Add(NewItem('', 0, false, true, OpenRecent, 0, 'recfile'));
  recentFiles.Insert(0,recFile);
  if recentFiles.Count = 11 then
    recentFiles.Delete(10); //delete oldest if more then 10 entrys
  for i := 0 to recentFiles.Count - 1 do  //now set Captions to new values
  begin
    Recent1[i].Caption := '&'+IntToStr(i)+' '+recentFiles[i];
    Recent1[i].Name := 'recFile'+IntToStr(i)
  end;
end;

//*PN*
procedure TFrameForm.OpenRecent(Sender: TObject);
var idx: integer;
begin
  idx := StrToInt((Sender as TMenuItem).Name[8]);
  while true do
  begin
    if FileExists(recentFiles[idx]) then
    begin
      if defaultFormat = UTF8_FORMAT then
        Open(recentFiles[idx], UTF8_FORMAT, -1)
      else
        Open(recentFiles[idx], TEX_FORMAT, -1);
      exit;
    end
    else
      if MessageDlg('Recent File'#13#10#13#10
                    + recentFiles[idx] + #13#10#13#10
                    + 'not found!',mtWarning,[mbCancel,mbRetry],0)=mrCancel then
        exit;
  end;
end;

procedure TFrameForm.SaveAs(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).SaveAs;
end;

procedure TFrameForm.Save(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).Save;
end;

//*PN* moved from Destroy to Close to be able to save child window states!
//     Delphi ensures, that this is only called, if all child windows are
//     willing to close
procedure TFrameForm.FormClose(Sender: TObject; var Action: TCloseAction);
var state: string;
    i, k : integer;
    buttonNames:   TStringList; //*DS*
    buttonActions: TStringList; //*DS*

  procedure SaveFontInfo(theFont: TFont; theFontName: string);  //*PN* only better readable...
  var strStyle: string;
  begin
    with theFont do
    begin
      iniFile.WriteString ('View', theFontName + 'fontName', Name);
      iniFile.WriteInteger ('View', theFontName + 'fontSize', Size);
      iniFile.WriteInteger ('View', theFontName + 'fontColor', Color);
      iniFile.WriteInteger ('View', theFontName + 'charSet', Charset);
      strStyle := '';
      if fsBold      in Style then strStyle := 'fsBold';
      if fsItalic    in Style then strStyle := strStyle + 'fsItalic';
      if fsUnderline in Style then strStyle := strStyle + 'fsUnderline';
      if fsStrikeout in Style then strStyle := strStyle + 'fsStrikeout';
      iniFile.WriteString ('View', theFontName + 'fontStyle', strStyle);
    end;
  end;

begin
  application.HelpCommand (help_quit, 0);

  if lockIniFile = false then //*DS* ini file may be locked in network environment
  begin
    iniFile := TIniFile.Create (userIniFileName);

    iniFile.WriteBool ('View', 'wordWrap', wordWrap);
    iniFile.WriteBool ('Options', 'lineSpecials', handleLineSpecials);
    iniFile.WriteBool ('Options', 'createBackup', createBackup);
    iniFile.WriteBool ('Options', 'syntaxColoring', syntaxColoring);
    iniFile.WriteInteger ('Options', 'linebreakat', linelength);
    iniFile.WriteInteger ('Options', 'fileFormat', defaultFileFormat); //*DS*
    iniFile.WriteBool ('View', 'statusBar', statusBar1.Visible);
    iniFile.WriteBool ('View', 'speedBar', ToolBar1.Visible);
    iniFile.WriteBool ('View', 'WindowBar', WindowBar.Visible);

    SaveFontInfo(standardFont, '');
    SaveFontInfo(texCommandFont, 'texCommand');
    SaveFontInfo(parenthesisFont, 'parenthesis');
    SaveFontInfo(squareBracketFont, 'squareBracket');
    SaveFontInfo(roundBracketFont, 'roundBracket');
    SaveFontInfo(dollarFont, 'dollar');
    SaveFontInfo(commentFont, 'comment');

    iniFile.WriteInteger ('View', 'backgroundColor', backgroundColor);
    iniFile.WriteString ('TeX', 'Compile', strCompileCommand);
    iniFile.WriteString ('TeX', 'LogFile', strLogFileCommand);
    iniFile.WriteString ('TeX', 'Preview', strPreviewCommand);
    iniFile.WriteString ('Options', 'spellChecker', strSpellChecker);

    state := 'wsNormal';
    if windowState = wsMaximized then state := 'wsMaximized';
    if windowState = wsMinimized then state := 'wsMinimized';
    iniFile.WriteString ('WindowSize', 'state', state);

    if windowState <> wsMaximized then
    begin
      iniFile.WriteInteger ('WindowSize', 'height', Height);
      iniFile.WriteInteger ('WindowSize', 'width', Width);
      iniFile.WriteInteger ('WindowSize', 'left', Left);
      iniFile.WriteInteger ('WindowSize', 'top', Top);
    end;

    //*DS* write standard buttons to ini file
    // if old version or at first start
    //if iniFile.ReadInteger('General', 'version', 0) < 50 then
    if versionNetworkIni < 50 then
    begin
      buttonNames := TStringList.Create;
      buttonActions := TStringList.Create;
      // read old section
      iniFile.ReadSection ('Buttons', buttonNames);
      iniFile.ReadSectionValues ('Buttons', buttonActions);
      iniFile.EraseSection('Buttons');

      // write standard buttons
      //iniFile.WriteString('Buttons', 'Save', '<Save>$Save Active Document$');
      iniFile.WriteString('Buttons', 'Save', '<save>$Save Active Document$');
      iniFile.WriteString('Buttons', 'TeX', '<texmain>$TeX Main File$');
      iniFile.WriteString('Buttons', 'Log', '<showlog>$Show Log file$');
      iniFile.WriteString('Buttons', 'Preview', '<previewmain>$Preview Main File$');
      // rewrite old section
      for i := 0 to buttonNames.count-1 do
      begin
        iniFile.WriteString('Buttons', buttonNames[i], buttonActions.Values[buttonNames[i]]);
      end;
      buttonNames.Free;
      buttonActions.Free;
    end
    // versionNetworkIni >= 50
    // button and external programs are allready defined in
    // network ini but not in user ini.
    // So write them to the network ini.
    else if iniFile.ReadInteger('General', 'version', 0) < 50 then
    begin
      for i := 0 to extButtonNames.count-1 do
      begin
        iniFile.WriteString('Buttons', extButtonNames[i], extButtonValues.Values[extButtonNames[i]]);
      end;

      for i := 0 to extProgramNames.count-1 do
      begin
        iniFile.WriteString('External Programs', extProgramNames[i], extProgramCalls.Values[extProgramNames[i]]);
      end;
    end;

    iniFile.WriteInteger ('General', 'version', 71); //*DS*

    //*PN* save recent files
    for i := 0 to 9 do //max. 10 recent files
    begin
      if i >= recentFiles.Count then
        inifile.WriteString('Recent', IntToStr(i), '')
      else
        inifile.WriteString('Recent', IntToStr(i), recentFiles[i]);
    end;

    //now save state of open windows and name of main file
    iniFile.EraseSection('ChildWindows');
    if MDIChildCount > 0 then
    begin
      iniFile.WriteBool('ChildState', 'WasMaximized', ActiveMDIChild.WindowState = wsMaximized);
      if ActiveMDIChild.WindowState = wsMaximized then
        ActiveMDIChild.WindowState := wsNormal;   //switch off Maximized
    end
    else
      iniFile.WriteBool('ChildState', 'WasMaximized', false);
    k := 0;
    for i := 0 to MDIChildCount - 1 do
    begin
      if ExtractFileExt((MDIChildren[i] as TEditForm).fileName) <> '' then  //ignore Untitledxx
      begin
        iniFile.WriteInteger('ChildWindows', 'state' + IntToStr(k), ord(MDIChildren[i].WindowState));
        MDIChildren[i].WindowState := wsNormal; //otherwise pos and size are wrong!
        iniFile.WriteInteger('ChildWindows', 'top' + IntToStr(k), MDIChildren[i].Top);
        iniFile.WriteInteger('ChildWindows', 'left' + IntToStr(k), MDIChildren[i].Left);
        iniFile.WriteInteger('ChildWindows', 'height' + IntToStr(k), MDIChildren[i].Height);
        iniFile.WriteInteger('ChildWindows', 'width' + IntToStr(k), MDIChildren[i].Width);
        iniFile.WriteInteger('ChildWindows', 'pos' + IntToStr(k), (MDIChildren[i] as TEditForm).RichEdit.SelStart);
        iniFile.WriteString('ChildWindows', 'name' + IntToStr(k), (MDIChildren[i] as TEditForm).fileName);
        INC(k); //need seperate Counter because of Untitledxx-windows
      end;
    end;
    iniFile.EraseSection('MainFile');
    iniFile.WriteString('MainFile', 'Name', strMainFile);
    //now save Toolbox positions, (size) and visibility
    iniFile.WriteBool('Toolboxes', 'MathBoxVisible', MathDialog.Visible);
    iniFile.WriteBool('Toolboxes', 'GreekBoxVisible', GreekDialog.Visible);
    iniFile.WriteBool('Toolboxes', 'SymbolBoxVisible', SymbolDialog.Visible);
    iniFile.WriteBool('Toolboxes', 'TemplBoxVisible', UserTemplatesDialog.Visible);
    iniFile.WriteBool('Toolboxes', 'SpellCheckVisible', SpellCheckDialog.Visible);
    iniFile.WriteInteger('Toolboxes', 'SpellCheckLeft', SpellCheckDialog.Left);
    iniFile.WriteInteger('Toolboxes', 'SpellCheckTop', SpellCheckDialog.Top);
    iniFile.WriteInteger('Toolboxes', 'MathLeft', MathDialog.Left);
    iniFile.WriteInteger('Toolboxes', 'MathTop', MathDialog.Top);
    iniFile.WriteInteger('Toolboxes', 'GreekLeft', GreekDialog.Left);
    iniFile.WriteInteger('Toolboxes', 'GreekTop', GreekDialog.Top);
    iniFile.WriteInteger('Toolboxes', 'SymbolLeft', SymbolDialog.Left);
    iniFile.WriteInteger('Toolboxes', 'SymbolTop', SymbolDialog.Top);
    iniFile.WriteInteger('Toolboxes', 'TemplLeft', UserTemplatesDialog.Left);
    iniFile.WriteInteger('Toolboxes', 'TemplTop', UserTemplatesDialog.Top);
    iniFile.WriteInteger('Toolboxes', 'TemplWidth', UserTemplatesDialog.Width);
    iniFile.WriteInteger('Toolboxes', 'TemplHeight', UserTemplatesDialog.Height);
    //*PN* end

    iniFile.Free;
  end; // if lockIniFile

  extProgramNames.Free;
  extProgramCalls.Free;
  extButtonNames.Free;
  extButtonActions.Free;
  extButtonValues.Free;
  //*PN*
  recentFiles.Free;
end;


//*PN* to call programs with specified dir...
procedure TFrameForm.ExecProg(programm:string; dir:string);
var zAppName:array[0..255] of char;
    zParams:PChar;
    zCurDir:PChar;
    ParPos: integer;
    teststring: string; //*DS*
begin
  //*DS* Save window contents if parameters contain .tex or .txx
  teststring := AnsiLowerCase(programm);
  if (Pos('.txx', teststring) > 0)
  or (Pos('.tex', teststring) > 0) then
  begin
    SaveAllFilesIfChanged;
  end;

  FillChar(zAppName,Sizeof(zAppName),#0);
  StrPCopy(zAppName, Programm);
  zCurDir := nil;
  if length(dir) > 0 then
  begin
    zCurDir := StrAlloc(length(dir) + 1);
    StrPCopy(zCurDir, dir);
  end;
  zParams := nil;
  if Programm[1] = '"' then
  begin
    Delete(Programm, 1, 1);
    ParPos := Pos('"', Copy(Programm, 1, MAXINT));
    Delete(Programm, ParPos, 1);   //remove "
    if length(Programm) = ParPos then ParPos := 0; // no params given
  end
  else
    ParPos := Pos(' ', Programm);
  if ParPos > 0 then
  begin
    zParams := StrAlloc(length(programm)); //a bit too much, but...
    StrPCopy(zParams, Copy(Programm, ParPos + 1, MAXINT));
    StrPCopy(zAppName, Copy(Programm, 1, ParPos - 1));
  end;

  if ShellExecute(0, 'open', zAppName, zParams, zCurDir, SW_SHOW) <= 32 then
    MessageDlg('Unable to open'#13#10'>>'#13#10'>> ' + Programm + #13#10'>> ',
               mterror, [mbok], 0);
  StrDispose(zCurDir);
  StrDispose(zParams);
end;

procedure TFrameForm.GreekLetters1Click(Sender: TObject);
begin
  GreekDialog.Show;
end;

procedure TFrameForm.MathSymbols1Click(Sender: TObject);
begin
  MathDialog.Show;
end;

procedure TFrameForm.Symbols1Click(Sender: TObject);
begin
  SymbolDialog.Show;
end;

procedure TFrameForm.InsertText(part1, part2: string);
begin
  if MDIChildCount > 0 then
    (ActiveMDIChild as TEditForm).Template(part1, part2);
  SetFocus;
end;

procedure TFrameForm.UserTemplates1Click(Sender: TObject);
begin
  UserTemplatesDialog.Show;
end;

procedure TFrameForm.UpdateTemplateSub;
var i: integer;
    newMen : TMenuItem;
begin
    while UserTemplates3.Count > 0 do UserTemplates3.Delete(0);
    UserTemplates3.Enabled := (TemplateDialog.names.Count > 0);
    for i := 0 to TemplateDialog.names.Count - 1 do
    begin
      if i <= 11 then
        newMen := NewItem(TemplateDialog.names[i], ShortCut(VK_F1 + i,[ssShift]),
                          false, true, UserTemplSubClick, 0, 'UTempl' + IntToStr(i))
      else
        newMen := NewItem(TemplateDialog.names[i], 0, false, true,
                          UserTemplSubClick, 0, 'UTempl' + IntToStr(i));
      UserTemplates3.Add(newMen);
    end;
    if UserTemplatesDialog.Visible then UserTemplatesDialog.FormShow(self);
end;

procedure TFrameForm.UserTemplates2Click(Sender: TObject);
begin
  if TemplateDialog.ShowModal = mrOK then UpdateTemplateSub;
end;

procedure TFrameForm.DoButton(Sender: TObject);
var Command: string;
begin
  with (Sender as TSpeedButton) do
  begin
    case Tag of
      -1: begin
            Command := extButtonActions.Values[Caption];
            ExecProg(ExpandModifiers(Command), ''); //this one not with path to main file
          end;
       0: if MDIChildCount > 0 then Save(Sender);
       1: Compile(Sender);
       2: LogFile1Click(Sender);
       3: PreviewClick(Sender);
       4: NewChild(Sender);
       5: FrameForm.Close;
       6: GreekLetters1Click(Sender);
       7: MathSymbols1Click(Sender);
       8: Symbols1Click(Sender);
       9: UserTemplates1Click(Sender);
    end;
  end;
end;

function TFrameForm.GetTag(theCommand: string):integer;
begin
  result := -1;
  if theCommand = 'save' then result := 0;
  if theCommand = 'texmain' then result := 1;
  if theCommand = 'showlog' then result := 2;
  if theCommand = 'previewmain' then result := 3;
  if theCommand = 'new' then result := 4;
  if theCommand = 'quit' then result := 5;
  if theCommand = 'greekbox' then result := 6;
  if theCommand = 'mathbox' then result := 7;
  if theCommand = 'symbolbox' then result := 8;
  if theCommand = 'templatebox' then result := 9;
end;

procedure TFrameForm.SetButtons;
var i, thePos: integer;
    Action: string;
    theHint: string;
    theCommand: string;
    theCaption: string;
    BWidth: integer;

  procedure AddButton(theCaption, theHint: string; theTag: integer);
  var button: TSpeedButton;
      i,l : integer;
  begin
    l := 2; //calc pos BEFORE Create!
    for i := 0 to Toolbar1.ControlCount - 1 do
    begin
      if Toolbar1.Controls[i] is TSpeedButton then
        INC(l, Toolbar1.Controls[i].Width + 2);
    end;
    button := TSpeedButton.Create(ToolBar1);
    button.Caption := theCaption;
    button.Width := BWidth;
    button.Top := 4;
    button.Tag := theTag;
    button.Hint := theHint;
    button.ShowHint := true;
    button.height := Toolbar1.Height-5;
    button.OnClick := DoButton;
    button.Parent := Toolbar1;
    button.Left := l;
  end;

begin
  //*PN* calc ideal height of button bar
  FrameForm.Canvas.Font := Toolbar1.Font;
  Toolbar1.Height := FrameForm.Canvas.TextHeight('g') + 13; // 2*4 frame, 5 for Toolbar
  WindowBar.Height := Toolbar1.Height;
  BWidth := FrameForm.Canvas.TextWidth('Save all files') + 8;
  //first delete all Buttons
  ToolBar1.DestroyComponents;
  //first add 4 standard buttons
  if version < 50 then //*DS* newer versions read all buttons from ini file
  begin
    AddButton('Save', 'Save active document', 0);
    AddButton('TeX', 'TeX main file', 1);
    AddButton('Log', 'Show LOG file', 2);
    AddButton('Preview', 'Preview main file', 3);
  end;

  // now add user defined buttons
  for i := 0 to extButtonNames.Count-1 do
  begin
    theCaption := extButtonNames.Strings[i];
    Action := extButtonValues.Values[theCaption];
    theCommand := '';
    theHint := '';
    if Action[1] = '<' then //internal Command
    begin
      Delete(Action, 1, 1);
      thePos := Pos('>', Action);
      theCommand := Copy(Action, 1, thePos - 1);
      Delete(Action, 1, thePos);
    end;
    if Action[1] = '$' then //user defined hint
    begin
      Delete(Action, 1, 1);
      thePos := Pos('$', Action);
      theHint := Copy(Action, 1, thePos - 1);
      Delete(Action, 1, thePos);
    end
    else
      theHint := Action;
    extButtonActions.Values[theCaption] := Action; //only the exec. should be here
    AddButton(theCaption, theHint, GetTag(theCommand));
  end;
end;

procedure TFrameForm.Chapter1Click(Sender: TObject);
begin
  InsertText('\chapter{','}'#13#10);
end;

procedure TFrameForm.Section1Click(Sender: TObject);
begin
  InsertText('\section{', '}'#13#10);
end;

procedure TFrameForm.Subsection1Click(Sender: TObject);
begin
  InsertText('\subsection{', '}'#13#10);
end;

procedure TFrameForm.Enumeration1Click(Sender: TObject);
begin
  InsertText('\begin{enumerate}'#13#10'\item ', #13#10'\end{enumerate}');
end;

procedure TFrameForm.Items1Click(Sender: TObject);
begin
  InsertText('\begin{itemize}'#13#10'\item ', #13#10'\end{itemize}');
end;

procedure TFrameForm.Description1Click(Sender: TObject);
begin
  InsertText ('\begin{description}'#13#10'\item ', #13#10'\end{description}');
end;

procedure TFrameForm.Image1Click(Sender: TObject);
begin
  if ImageDialog.ShowModal = mrOk then
    InsertText (ImageDialog.strFigure, '');
end;

procedure TFrameForm.Document1Click(Sender: TObject);
begin
  if DocumentDialog.ShowModal = mrOk then
    InsertText (DocumentDialog.part1, DocumentDialog.part2);
end;

procedure TFrameForm.UserTemplSubClick(Sender: TObject);
var Idx: integer;
begin
  Idx := StrToIntDef(Copy((Sender as TMenuItem).Name,7,MAXINT), 0);
  InsertText(TemplateDialog.parts1[Idx], TemplateDialog.parts2[Idx]);
end;

procedure TFrameForm.Undo1Click(Sender: TObject);
begin
  with (ActiveMDIChild as TEditForm).RichEdit do
    if HandleAllocated then SendMessage(Handle, EM_UNDO, 0, 0);
end;

procedure TFrameForm.Cut1Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).RichEdit.CutToClipboard;
end;

procedure TFrameForm.Copy1Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).RichEdit.CopyToClipboard;
end;

procedure TFrameForm.Paste1Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).RichEdit.PasteFromClipboard;
end;

procedure TFrameForm.Find1Click(Sender: TObject);
begin
  FindDialog1.Execute;
end;

procedure TFrameForm.Replace1Click(Sender: TObject);
begin
  ReplaceDialog1.Execute;
end;

procedure TFrameForm.SearchAgain1Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).FindDialog1Find(Sender);
end;

procedure TFrameForm.Find2Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).Find2Click(Sender);
end;

procedure TFrameForm.GoToLine1Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).GoToLine1Click(Sender);
end;

procedure TFrameForm.FindDialog1Find(Sender: TObject);
begin
  if MDIChildCount > 0 then
    (ActiveMDIChild as TEditForm).FindDialog1Find(Sender);
end;

procedure TFrameForm.ReplaceDialog1Find(Sender: TObject);
begin
  if MDIChildCount > 0 then
    (ActiveMDIChild as TEditForm).ReplaceDialog1Find(Sender);
end;

procedure TFrameForm.ReplaceDialog1Replace(Sender: TObject);
begin
  if MDIChildCount > 0 then
    (ActiveMDIChild as TEditForm).ReplaceDialog1Replace(Sender);
end;


//*DS*
// transform old ini files into the new format
// delete this in future versions
procedure TFrameForm.CompatibilityTransformTemplateFiles;
var names,
    parts1,
    parts2: TStringList;
    userNames,
    userParts1,
    userParts2: TStringList;
    iniFile: TIniFile;
    tplBase: String;
    baseDir: String;
    version: integer;
    i: integer;

    procedure TransformLineBreaks (var stringList: TStringList);
    var strings: integer;
        i: integer;
        temp: string;
    begin
      for strings := 0 to stringList.Count-1 do
      begin
        for i := 1 to Length (stringList[strings]) do
        begin
          temp := stringList[strings];
          if (temp[i] = NL) or (temp[i] = CR) then
          begin
            temp[i] := '';
            stringList[strings] := temp;
          end
        end;
      end;
    end;

      procedure TransformLineBreaksBack (var stringList: TStringList);
      var strings: integer;
          i: integer;
          temp: string;
      begin
        for strings := 0 to stringList.Count-1 do
        begin
          for i := 1 to Length (stringList[strings])-1 do
          begin
            temp := stringList[strings];
            if (temp[i] = '') and (temp[i+1] = '') then
            begin
              temp[i] := CR;
              temp[i+1] := NL;
              stringList[strings] := temp;
            end
          end;
        end;
      end;

    procedure WriteString(theString: string; tplStream: TFileStream);
    var buffer: PChar;
        sz: integer;
    begin
      sz := length(theString);
      buffer := PChar(theString);
      tplStream.Write(sz, sizeof(integer));
      tplStream.Write(buffer^, sz);
    end;

    procedure WriteTemplates (names, parts1, parts2: TStringList; fileName: string);
    var i: integer;
        outStream: TFileStream;
    begin
      try
        outStream := TFileStream.Create (fileName, fmCreate);

        for i := 0 to names.Count - 1 do
        begin
          WriteString (names[i], outStream);
          WriteString (parts1[i], outStream);
          WriteString (parts2[i], outStream);
          WriteString ('', outStream);  // placeholder for shortcuts
        end;
      except
        MessageDlg('Could not transform old template file to new format!', mtWarning, [mbOK], 0);
      end;
      outStream.Free;
    end;

begin
  if lockIniFile = false then
  begin
    // read templates from application directory
    names := TStringList.Create;
    parts1 := TStringList.Create;
    parts2 := TStringList.Create;

    userNames := TStringList.Create;
    userParts1 := TStringList.Create;
    userParts2 := TStringList.Create;

    tplBase := ChangeFileExt (iniFileName, '');
    baseDir := ExtractFilePath (application.ExeName);
    tplBase := baseDir + ExtractFileName(tplBase);

    iniFile := TIniFile.Create (iniFileName);
    version := iniFile.ReadInteger ('General', 'version', 0);
    if version < 50 then
    begin
      if    FileExists (baseDir + '\names')
        and FileExists (baseDir + '\parts1')
        and FileExists (baseDir + '\parts2') then
      begin
        names.LoadFromFile (baseDir + '\names');
        parts1.LoadFromFile (baseDir + '\parts1');
        parts2.LoadFromFile (baseDir + '\parts2');
        TransformLineBreaksBack (names);
        TransformLineBreaksBack (parts1);
        TransformLineBreaksBack (parts2);

        // Write templates to new template file
        WriteTemplates (names, parts1, parts2, tplBase+'.tpl');

      end;
    end;
    iniFile.Free;

    if userIniFileName <> iniFileName then // true if there is no network ini
    begin
       // read templates from user ini file directory
      tplBase := ChangeFileExt (userIniFileName, '');
      baseDir := ExtractFilePath (userIniFileName);

      iniFile := TIniFile.Create (userIniFileName);
      version := iniFile.ReadInteger ('General', 'version', 0);
      if version < 50 then
      begin
        if    FileExists (baseDir + '\names')
          and FileExists (baseDir + '\parts1')
          and FileExists (baseDir + '\parts2') then
        begin
          userNames.LoadFromFile (baseDir + '\names');
          userParts1.LoadFromFile (baseDir + '\parts1');
          userParts2.LoadFromFile (baseDir + '\parts2');
          TransformLineBreaksBack (userNames);
          TransformLineBreaksBack (userParts1);
          TransformLineBreaksBack (userParts2);

          // Add user templates to main templates
          for i := 0 to userNames.count -1 do
          begin
            names.add (userNames[i]);
            parts1.add (userParts1[i]);
            parts2.add (userParts2[i]);
          end;

          // Write templates to new template file
          CreateDir (baseDir);
          WriteTemplates (names, parts1, parts2, tplBase+'.tpl');
        end;
      end;
      iniFile.Free;

      userNames.free;
      userParts1.free;
      userParts2.free;
    end;

    names.free;
    parts1.free;
    parts2.free;
  end;
end;

procedure TFrameForm.File1Click(Sender: TObject);
begin
  Recent1.Enabled := (Recent1.Count > 0);
  Save0.Enabled := (MDIChildCount > 0);
  Save1.Enabled := (MDIChildCount > 0);
  Saveas1.Enabled := Save1.Enabled;
end;

procedure TFrameForm.Edit1Click(Sender: TObject);
var hasSelection: boolean;
    oldSelLength: integer;
begin
  with (ActiveMDIChild as TEditForm) do
  begin
    hasSelection := RichEdit.SelLength <> 0;
    //using Prefix FrameForm because there are some Items with identical
    //names in Edit, but better than using (ActiveMDIChild as TEditForm) with
    //every Richedit...
    FrameForm.Cut1.Enabled := hasSelection;
    FrameForm.Copy1.Enabled := hasSelection;
    FrameForm.Paste1.Enabled := Clipboard.HasFormat (CF_TEXT);
    FrameForm.Undo1.Enabled := (SendMessage(RichEdit.Handle, EM_CANUNDO, 0, 0) = 1);
    FrameForm.SearchAgain1.Enabled := FindDialog1.FindText <> '';
    FrameForm.SpellCheck1.Enabled := (strSpellChecker <> '');

    oldSelLength :=  RichEdit.SelLength;
    RichEdit.SelLength := 1;
    Find2.Enabled := (RichEdit.SelText = '{') or (RichEdit.SelText = '}');
    RichEdit.SelLength := oldSelLength;
  end;
end;

//procedure TFrameForm.Recent1Click(Sender: TObject);
//var i: integer;
//begin
//    for i := 0 to Recent1.Count - 1 do
//      Recent1.Items[i].Enabled := FileExists(Copy(Recent1.Items[i].Caption,4,MAXINT));
//end;
//
procedure TFrameForm.View1Click(Sender: TObject);
begin
  UpdateSelection1.Enabled := syntaxColoring
                              and (MDIChildCount > 0)
                              and ((ActiveMDIChild as TEditForm).RichEdit.SelLength > 0);
end;

procedure TFrameForm.Options1Click(Sender: TObject);
begin
  SyntaxColoring1.Checked := syntaxColoring;
  LineSpecials1.Checked := handleLineSpecials;
  CreateBackups1.Checked := createBackup;
  WordWrap1.Checked := wordWrap;
  if defaultFileFormat = UTF8_FORMAT then
  begin
    UnicodeUTF8.Checked := true;
  end
  else
  begin
    UnicodeUTF8.Checked := false;
  end;
end;

procedure TFrameForm.FormResize(Sender: TObject);
begin
  CheckWinBarScroll;
end;

procedure TFrameForm.CloseAll1Click(Sender: TObject);
var i: integer;
begin
  for i := 0 to MDIChildCount - 1 do
  begin
    activeMDIChild.Close;
    Application.ProcessMessages;
  end;
end;

procedure TFrameForm.Graphics1Click(Sender: TObject);
begin
  if GraphicsDialog.ShowModal = mrOk then
    InsertText (GraphicsDialog.strGraphics, '');
end;

//*DS* moved code for restoring old windows to this procedure
// to make shure that it is evaluated before the command line
// parameters. Directly called by the program unit.
procedure TFrameForm.AfterCreate;
var winlist: TStringList;
    i : integer;
    idxstr: string;
    EditForm: TEditForm;
    theFile: string;
begin
    //*PN* restore last open files and child window states and main file name
    //     can not be done on create :-(
    iniFile := TIniFile.Create (iniFileName);
    strMainFile := iniFile.ReadString('MainFile', 'Name', '');
    MainFileSelected := (strMainFile <> '') and FileExists(strMainFile);
    if MainFileSelected then
      SetCurrentDir (ExtractFileDir (FrameForm.strMainFile))
    else
      strMainFile := '';
    StatusBar1.Panels[1].Text := 'Main file: ' + strMainFile;
    winlist := TStringList.Create;
    iniFile.ReadSectionValues('ChildWindows', winlist);
    if winlist.Count > 0 then
    begin
      //restore backwards to maintain z-order
      for i := (winlist.Count div 7) - 1 downto 0 do //every child has 7 entrys
      begin
        idxstr := IntToStr(i);
        theFile := winlist.Values['name' + idxstr];
        if FileExists(theFile) then
        begin
          EditForm := TEditForm.Create (Self);
          EditForm.RichEdit.Lines.BeginUpdate;
          EditForm.top := StrToIntDef(winlist.Values['top' + idxstr],0);
          EditForm.left := StrToIntDef(winlist.Values['left' + idxstr],0);
          EditForm.height := StrToIntDef(winlist.Values['height' + idxstr],100);
          EditForm.width := StrToIntDef(winlist.Values['width' + idxstr],100);
          EditForm.WindowState := TWindowState(StrToIntDef(winlist.Values['state' + idxstr], 0));
          EditForm.Open(theFile, defaultFileFormat, true); //should be no OEM or UNIX...
          EditForm.RichEdit.SelStart := StrToIntDef(winlist.Values['pos' + idxstr],0);
          EditForm.ShowLine;
          EditForm.RichEdit.Lines.EndUpdate;
          EditForm.RichEdit.Modified := false;
          EditForm.theWinPanel.Font.Style := [];
          EditForm.SizeWinPanel;
        end;
      end;
      if iniFile.ReadBool('ChildState', 'WasMaximized', false)
         and (MDIChildCount > 0) then
        ActiveMDIChild.WindowState := wsMaximized;
    end;
    winlist.Free;
    //now restore Toolbox positions, (size) and visibility
    MathDialog.Left := iniFile.ReadInteger('Toolboxes', 'MathLeft', MathDialog.Left);
    MathDialog.Top := iniFile.ReadInteger('Toolboxes', 'MathTop', MathDialog.Top);
    GreekDialog.Left := iniFile.ReadInteger('Toolboxes', 'GreekLeft', GreekDialog.Left);
    GreekDialog.Top := iniFile.ReadInteger('Toolboxes', 'GreekTop', GreekDialog.Top);
    SpellCheckDialog.Left := iniFile.ReadInteger('Toolboxes', 'SpellCheckLeft', SpellCheckDialog.Left);
    SpellCheckDialog.Top := iniFile.ReadInteger('Toolboxes', 'SpellCheckTop', SpellCheckDialog.Top);
    SymbolDialog.Left := iniFile.ReadInteger('Toolboxes', 'SymbolLeft', SymbolDialog.Left);
    SymbolDialog.Top := iniFile.ReadInteger('Toolboxes', 'SymbolTop', SymbolDialog.Top);
    UserTemplatesDialog.Left := iniFile.ReadInteger('Toolboxes', 'TemplLeft', UserTemplatesDialog.Left);
    UserTemplatesDialog.Top := iniFile.ReadInteger('Toolboxes', 'TemplTop', UserTemplatesDialog.Top);
    UserTemplatesDialog.Width := iniFile.ReadInteger('Toolboxes', 'TemplWidth', UserTemplatesDialog.Width);
    UserTemplatesDialog.Height := iniFile.ReadInteger('Toolboxes', 'TemplHeight', UserTemplatesDialog.Height);
    MathDialog.Visible := iniFile.ReadBool('Toolboxes', 'MathBoxVisible', false);
    GreekDialog.Visible := iniFile.ReadBool('Toolboxes', 'GreekBoxVisible', false);
    SymbolDialog.Visible := iniFile.ReadBool('Toolboxes', 'SymbolBoxVisible', false);
    UserTemplatesDialog.Visible := iniFile.ReadBool('Toolboxes', 'TemplBoxVisible', false);
    SpellCheckDialog.Visible := iniFile.ReadBool('Toolboxes', 'SpellCheckVisible', false);
    inifile.Free;
    UpdateTemplateSub;
    SetFocus;
end;

procedure TFrameForm.WMDropFiles(var Message: TWMDropFiles);
var
  buffer: array[0..255] of char;
  i,
  no_dropped: integer; // number of dropped files
begin
  no_dropped:=DragQueryFile(Message.Drop,$FFFFFFFF,nil,0);
  for i:=0 to no_dropped-1 do
  begin
    DragQueryFile(Message.Drop,i,@buffer,sizeof(buffer));
    //*PK* Definition einer Konstante fr ANSI wre nicht schlecht
    if FileExists(buffer) then Open(buffer,1,-1);
  end;
end;


procedure TFrameForm.SpellCheck1Click(Sender: TObject);
begin
  // save all files first, because an Ispell call with
  // wrong parameters causes the TeXShell to crash completely.
  SaveAllFilesIfChanged;

  SpellCheckDialog.Show;
end;


procedure TFrameForm.SpellChecker1Click(Sender: TObject);
begin
  OptSpellCheckDialog.ComboBox1.Text := strSpellChecker;
  OptSpellCheckDialog.ShowModal;
  if OptSpellCheckDialog.ModalResult = mrOk then
  begin
    strSpellChecker := OptSpellCheckDialog.ComboBox1.Text;
  end;
end;

// Reaction to an invisible menu
// to use the old F2 as Shortcut
procedure TFrameForm.Save0Click(Sender: TObject);
begin
  Save (Sender);
end;

procedure TFrameForm.Commentoutin1Click(Sender: TObject);
begin
  (ActiveMDIChild as TEditForm).Commentout1Click(Sender);
end;

//*DS*
// For switching between Unicode and old ANSi TeXFormat
// new Format may only be TEX_FORMAT or UTF8_FORMAT
procedure TFrameForm.SetDefaultFileFormat( newFormat: integer );
var i: integer;
begin
  defaultFormat := newFormat;

  DialogMainFile.FilterIndex := newFormat;
  OpenDialog.FilterIndex := newFormat;

  for i := 0 to MDIChildCount - 1 do
  begin
    with (MDIChildren[i] as TEditForm) do
    begin
      if (SaveDialog.FilterIndex = TEX_FORMAT)
      or (SaveDialog.FilterIndex = UTF8_FORMAT)
      then
      begin
        SaveDialog.FilterIndex := newFormat;
      end;
    end
  end;

end;

procedure TFrameForm.UnicodeUTF8Click(Sender: TObject);
begin
  if defaultFileFormat = TEX_FORMAT then
  begin
    defaultFileFormat := UTF8_FORMAT;
    UnicodeUTF8.Checked := true;
  end
  else
  begin
    defaultFileFormat := TEX_FORMAT;
    UnicodeUTF8.Checked := false;
  end;
end;

end.
