/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.Predictor;

public class LZWFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(LZWFilter.class);
    public static final long CLEAR_TABLE = 256L;
    public static final long EOD = 257L;

    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase baseObj = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary decodeParams = null;
        if (baseObj instanceof COSDictionary) {
            decodeParams = (COSDictionary)baseObj;
        } else if (baseObj instanceof COSArray) {
            COSArray paramArray = (COSArray)baseObj;
            if (filterIndex < paramArray.size()) {
                decodeParams = (COSDictionary)paramArray.getObject(filterIndex);
            }
        } else if (baseObj != null) {
            throw new IOException("Error: Expected COSArray or COSDictionary and not " + baseObj.getClass().getName());
        }
        int predictor = -1;
        int earlyChange = 1;
        if (decodeParams != null) {
            predictor = decodeParams.getInt(COSName.PREDICTOR);
            earlyChange = decodeParams.getInt(COSName.EARLY_CHANGE, 1);
            if (earlyChange != 0 && earlyChange != 1) {
                earlyChange = 1;
            }
        }
        if (predictor > 1) {
            int colors = Math.min(decodeParams.getInt(COSName.COLORS, 1), 32);
            int bitsPerPixel = decodeParams.getInt(COSName.BITS_PER_COMPONENT, 8);
            int columns = decodeParams.getInt(COSName.COLUMNS, 1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.doLZWDecode(compressedData, baos, earlyChange);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Predictor.decodePredictor(predictor, colors, bitsPerPixel, columns, bais, result);
            result.flush();
            baos.reset();
            bais.reset();
        } else {
            this.doLZWDecode(compressedData, result, earlyChange);
        }
    }

    private void doLZWDecode(InputStream compressedData, OutputStream result, int earlyChange) throws IOException {
        ArrayList<byte[]> codeTable = null;
        int chunk = 9;
        MemoryCacheImageInputStream in = new MemoryCacheImageInputStream(compressedData);
        long nextCommand = 0L;
        long prevCommand = -1L;
        try {
            while ((nextCommand = in.readBits(chunk)) != 257L) {
                byte[] data;
                if (nextCommand == 256L) {
                    chunk = 9;
                    codeTable = this.createCodeTable();
                    prevCommand = -1L;
                    continue;
                }
                if (nextCommand < (long)codeTable.size()) {
                    data = codeTable.get((int)nextCommand);
                    byte firstByte = data[0];
                    result.write(data);
                    if (prevCommand != -1L) {
                        this.checkIndexBounds(codeTable, prevCommand, in);
                        data = codeTable.get((int)prevCommand);
                        byte[] newData = new byte[data.length + 1];
                        for (int i = 0; i < data.length; ++i) {
                            newData[i] = data[i];
                        }
                        newData[data.length] = firstByte;
                        codeTable.add(newData);
                    }
                } else {
                    this.checkIndexBounds(codeTable, prevCommand, in);
                    data = codeTable.get((int)prevCommand);
                    byte[] newData = new byte[data.length + 1];
                    for (int i = 0; i < data.length; ++i) {
                        newData[i] = data[i];
                    }
                    newData[data.length] = data[0];
                    result.write(newData);
                    codeTable.add(newData);
                }
                chunk = this.calculateChunk(codeTable.size(), earlyChange);
                prevCommand = nextCommand;
            }
        }
        catch (EOFException ex) {
            LOG.warn("Premature EOF in LZW stream, EOD code missing");
        }
        result.flush();
    }

    private void checkIndexBounds(List codeTable, long index, MemoryCacheImageInputStream in) throws IOException {
        if (index < 0L) {
            throw new IOException("negative array index: " + index + " near offset " + in.getStreamPosition());
        }
        if (index >= (long)codeTable.size()) {
            throw new IOException("array index overflow: " + index + " >= " + codeTable.size() + " near offset " + in.getStreamPosition());
        }
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        int r;
        ArrayList<byte[]> codeTable = this.createCodeTable();
        int chunk = 9;
        byte[] inputPattern = null;
        MemoryCacheImageOutputStream out = new MemoryCacheImageOutputStream(result);
        out.writeBits(256L, chunk);
        int foundCode = -1;
        while ((r = rawData.read()) != -1) {
            byte by = (byte)r;
            if (inputPattern == null) {
                inputPattern = new byte[]{by};
                foundCode = by & 0xFF;
                continue;
            }
            byte[] inputPatternCopy = new byte[inputPattern.length + 1];
            for (int i = 0; i < inputPattern.length; ++i) {
                inputPatternCopy[i] = inputPattern[i];
            }
            inputPattern = inputPatternCopy;
            inputPattern[inputPattern.length - 1] = by;
            int newFoundCode = this.findPatternCode(codeTable, inputPattern);
            if (newFoundCode == -1) {
                chunk = this.calculateChunk(codeTable.size() - 1, 1);
                out.writeBits(foundCode, chunk);
                codeTable.add(inputPattern);
                if (codeTable.size() == 4096) {
                    out.writeBits(256L, chunk);
                    chunk = 9;
                    codeTable = this.createCodeTable();
                }
                inputPattern = new byte[]{by};
                foundCode = by & 0xFF;
                continue;
            }
            foundCode = newFoundCode;
        }
        if (foundCode != -1) {
            chunk = this.calculateChunk(codeTable.size() - 1, 1);
            out.writeBits(foundCode, chunk);
        }
        chunk = this.calculateChunk(codeTable.size(), 1);
        out.writeBits(257L, chunk);
        out.writeBits(0L, 7);
        out.flush();
    }

    private int findPatternCode(ArrayList<byte[]> codeTable, byte[] pattern) {
        int foundCode = -1;
        int foundLen = 0;
        for (int i = codeTable.size() - 1; i >= 0; --i) {
            if ((long)i <= 257L) {
                if (foundCode != -1) {
                    return foundCode;
                }
                if (pattern.length > 1) {
                    return -1;
                }
            }
            byte[] tryPattern = codeTable.get(i);
            if (foundCode == -1 && tryPattern.length <= foundLen || !Arrays.equals(tryPattern, pattern)) continue;
            foundCode = i;
            foundLen = tryPattern.length;
        }
        return foundCode;
    }

    private ArrayList<byte[]> createCodeTable() {
        ArrayList<byte[]> codeTable = new ArrayList<byte[]>(4096);
        for (int i = 0; i < 256; ++i) {
            codeTable.add(new byte[]{(byte)(i & 0xFF)});
        }
        codeTable.add(null);
        codeTable.add(null);
        return codeTable;
    }

    private int calculateChunk(int tabSize, int earlyChange) {
        if (tabSize >= 2048 - earlyChange) {
            return 12;
        }
        if (tabSize >= 1024 - earlyChange) {
            return 11;
        }
        if (tabSize >= 512 - earlyChange) {
            return 10;
        }
        return 9;
    }
}

