/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FieldNumberMatch;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.Relational;
import java.io.IOException;

public class FieldLengthMatch
extends FieldNumberMatch {
    public FieldLengthMatch(FieldValueElement fieldValueElement, Relational relational, Number number) {
        super(fieldValueElement, relational, number);
    }

    @Override
    public boolean booleanValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string = this.fieldValueElem.getStringValue(bib2GlsEntry);
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        int n2 = this.value.intValue();
        boolean bl = this.compare(n, n2);
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage(String.format("Entry: %s%nCondition: %s%nValue: \"%s\"%nResult: %s", bib2GlsEntry, this.toString(), string, bl));
        }
        return bl;
    }

    @Override
    public String toString() {
        return String.format("\\LEN{%s} %s %s", new Object[]{this.fieldValueElem, this.relation, this.value});
    }
}

