// SPDX-License-Identifier: BSD-3-Clause
package org.islandoftex.arara.core.localization

import org.islandoftex.arara.api.localization.MPPLocale
import org.islandoftex.arara.api.localization.Messages

@Suppress("MaxLineLength")
class DutchLanguage : Messages(
    providedLocale = MPPLocale("nl"),
    translators = listOf("Marijn Schraagen", "Taco de Marie"),
    ERROR_BASENAME_NOT_A_FILE = "De 'basename'-methode vereist een bestand, geen directory. Het lijkt erop dat '%s' geen bestand is. Als je taken wil uitvoeren met een directory kan je een aantal methodes uit de Java API gebruiken.",
    ERROR_CALCULATEHASH_IO_EXCEPTION = "Om een of andere reden kan ik de hash niet berekenen. Ik weet niet waarom het precies fout ging. Misschien is het bestand verplaatst of verwijderd voor of tijdens de hashing, of misschien heb ik niet de juiste rechten om het bestand te lezen.",
    ERROR_CHECKBOOLEAN_NOT_VALID_BOOLEAN = "Het lijkt erop dat '%s' geen boolean-waarde is. Dit zou makkelijk op te lossen moeten zijn. Gebruik een geldige representatie voor een boolean (yes en no, true en false, 1 en 0, on en off).",
    ERROR_CHECKREGEX_IO_EXCEPTION = "Ik kon de inhoud van het bestand '%s' niet lezen vanwege een IO-fout. Ik weet niet waarom het precies fout ging. Misschien is het bestand verplaatst of verwijderd voor of tijdens de leesoperatie, of misschien heb ik niet de juiste rechten om het bestand te lezen.",
    ERROR_CONFIGURATION_GENERIC_ERROR = "Ik kon het configuratiebestand niet verwerken, er is iets verkeerd gegaan. Dit probleem is ingewikkeld, omdat het te maken heeft met aspecten van de onderliggende serialisatiesyntax. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_CONFIGURATION_LOOPS_INVALID_RANGE = "De waarde gedefinieerd in de 'loops'-optie in het configuratiebestand om het maximumaantal herhalingen te specificeren heeft een ongeldig bereik. Geef alsjeblieft een positieve long integer-waarde op.",
    ERROR_DISCOVERFILE_FILE_NOT_FOUND = "Ik kon het opgegeven bestand '%s' %s niet vinden. Zorg ervoor dat het bestand bestaat en dat het een geldige extensie heeft.",
    ERROR_EVALUATE_COMPILATION_FAILED = "Om een of andere reden kon ik de expressie in de opgegeven voorwaarde niet compileren. Dit is een ingewikkeld probleem, omdat het te maken heeft met aspecten van de onderliggende expressietaal. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_EVALUATE_NOT_BOOLEAN_VALUE = "De evaluatie van de voorwaarde verwachtte een boolean als resultaat. Dit zou makkelijk op te lossen moeten zijn. Zorg ervoor dat de evaluatie uiteindelijk een boolean oplevert.",
    ERROR_EXTRACTOR_IO_ERROR = "Er was een IO-probleem bij het verwerken van de directives. Ik weet niet waarom het precies fout ging. Misschien is het bestand verplaatst of verwijderd voor of tijdens het hashen, of misschien heb ik niet de juiste rechten om het bestand te lezen.",
    ERROR_EXTRACTOR_INTERPOLATION_FAILURE = "Uw 'opties'-veld bevat een item dat de MVEL-parser niet aankan. Herzie alstublieft uw opties, zodat deze geen foutieve '@ {…}' onderdelen meer bevatten.",
    ERROR_FILETYPE_NOT_A_FILE = "De 'filetype'-methode vereist een bestand, geen directory. Het lijkt erop dat '%s' geen bestand is. Als je taken wil uitvoeren met een directory kan je een aantal methodes uit de Java API gebruiken.",
    ERROR_FILETYPE_UNKNOWN_EXTENSION = "De extensie '%s' is niet herkend als een standaardextensie. Als je een nieuw bestandstype wil definiëren zorg dan dat de extensie en het patroon zijn opgegeven. De volgende extensies zijn standaard: %s",
    ERROR_GETAPPLICATIONPATH_ENCODING_EXCEPTION = "Er was een coderingsprobleem bij het verkrijgen van het applicatiepad. Daar kan ik niet zo veel aan doen.",
    ERROR_INTERPRETER_ARGUMENT_IS_REQUIRED = "Het argument '%s' is gemarkeerd als verplicht in de regel, maar ik kon het niet vinden in de parameters van de directive. Zorg ervoor dat het als parameter voor de directive wordt toegevoegd en probeer het opnieuw.",
    ERROR_INTERPRETER_COMMAND_RUNTIME_ERROR = "Ik kon een van de opgegeven opdrachten niet evalueren. Dit is een ingewikkeld probleem, omdat het te maken heeft met aspecten van de onderliggende expressietaal. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_INTERPRETER_COMMAND_UNSUCCESSFUL_EXIT = "Het commando \"%s\" is onverwacht beëindigd met een afsluitwaarde die niet gelijk is aan nul. Bekijk het resultaat van het commando en anaylseer het om uw volgende stappen te bepalen.",
    ERROR_INTERPRETER_EXIT_RUNTIME_ERROR = "Ik kon de exitwaardemelding van een van de opgegeven opdrachten niet evalueren. Dit is een ingewikkeld probleem, omdat het te maken heeft met aspecten van de onderliggende expressietaal. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_INTERPRETER_FLAG_RUNTIME_EXCEPTION = "Ik kon de optie-expressie van een van de argumenten niet evalueren. Dit is een ingewikkeld probleem, omdat het te maken heeft met aspecten van de onderliggende expressietaal. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_INTERPRETER_RULE_NOT_FOUND = "Ik kon de regel met de naam '%s' niet vinden in de opgegeven regelpaden. Misschien een spelfout? Ik heb geprobeerd het bestand '%s.yaml' te vinden in de volgende paden in volgorde van prioriteit: %s",
    ERROR_INTERPRETER_UNKNOWN_KEYS = "Ik heb de volgende onbekende verwijzingen gevonden in de directive: %s. Dit zou makkelijk op te lossen moeten zijn: verwijder deze uit de verwijzingstabel.",
    ERROR_INTERPRETER_USER_REQUESTED_HALT = "arara word nu beëindigd op uw (of een regel) verzoek.",
    ERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN = "De 'exit'-expressie moet altijd een boolean waarde teruggeven (zelfs als er geen berekening heeft plaatsgevonden). Dit zou makkelijk op te lossen moeten zijn: pas het type van de return-regel aan en probeer het opnieuw.",
    ERROR_INTERPRETER_WRONG_RETURN_TYPE = "Een regel mag alleen een, waar of niet waar (booleaanse waarde), of een commando als uitkomst hebben. Andere enter types worden niet ondersteund.",
    ERROR_LOAD_COULD_NOT_LOAD_XML = "Ik kon de YAML-database met de naam '%s' niet laden. Ik weet niet waarom het precies fout ging. Misschien was het bestand verplaatst of verwijderd tijdens de leesoperatie. Of misschien heb ik niet de juiste rechten om het bestand te lezen. Overigens: zorg ervoor dat het YAML-bestand welgevormd is.",
    ERROR_PARSER_INVALID_PREAMBLE = "Het spijt me, maar de preamble '%s' is niet gevonden. Zorg ervoor dat deze verwijzing bestaat in het configuratiebestand.",
    ERROR_PARSERULE_GENERIC_ERROR = "Ik kon de regel niet verwerken, er is iets verkeerd gegaan. Dit probleem is ingewikkeld, omdat het te maken heeft met aspecten van de onderliggende dataserialisatiesyntax. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_REPLICATELIST_MISSING_FORMAT_ARGUMENTS_EXCEPTION = "Ik kon de lijst niet genereren vanwege een ontbrekend format-argument. Ik denk dat er minder (of meer) parameters zijn dan verwacht. Geef het juiste aantal argumenten op en probeer het opnieuw.",
    ERROR_RULE_IDENTIFIER_AND_PATH = "Ik heb een fout gevonden in regel '%s' op positie '%s'.",
    ERROR_RUN_GENERIC_EXCEPTION = "Ik kon het opgegeven systeemcommando niet uitvoeren, er is iets misgegaan. Dit is een ingewikkeld probleem, omdat het te maken heeft met aspecten van de onderliggende expressietaal. Ik zal mijn best doen om je zoveel mogelijk hiermee te helpen.",
    ERROR_RUN_INTERRUPTED_EXCEPTION = "Het uitvoeren van het opgegeven systeemcommando is onverwacht onderbroken. Misschien was er een externe onderbreking die ervoor gezorgd heeft dat het commando gestopt is.",
    ERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION = "Het opgegeven systeemcommando heeft een ongeldige exit-waarde teruggegeven.",
    ERROR_RUN_IO_EXCEPTION = "Het uitvoeren van het systeemcommando is mislukt vanwege een IO-fout. Weet je zeker dat het commando bestaat in het pad? Het is misschien een goed idee om het pad te controleren en te kijken of het commando beschikbaar is.",
    ERROR_RUN_TIMEOUT_EXCEPTION = "Het uitvoeren van het systeemcommando is onderbroken omdat de maximale uitvoeringsduur overschreden is. Als de tijd te kort was, pas dan de maximale uitvoeringsduur aan.",
    ERROR_SAVE_COULD_NOT_SAVE_XML = "Ik kon de YAML-database met de naam '%s' niet opslaan. Ik weet niet precies waarom het fout ging. Misschien heb ik niet de juiste schrijfrechten om het YAML-bestand op te slaan.",
    ERROR_SESSION_OBTAIN_UNKNOWN_KEY = "De 'get'-methode heeft een onbekende verwijzing gevonden in de sessie: '%s'. Als ik iets niet heb kan ik het ook niet gebruiken. Geef een bestaande verwijzing op en probeer het opnieuw.",
    ERROR_SESSION_REMOVE_UNKNOWN_KEY = "De 'remove'-methode heeft een onbekende verwijzing gevonden in de sessie: '%s'. Als ik iets niet heb kan ik het ook niet verwijderen. Geef een bestaande verwijzing op en probeer het opnieuw.",
    ERROR_VALIDATE_EMPTY_FILES_LIST = "Ik heb een directive %s gelezen en kwam erachter dat de opgegeven 'files'-lijst leeg is. Dit zou makkelijk op te lossen moeten zijn: zorg ervoor dat de lijst tenminste een element heeft en probeer het opnieuw.",
    ERROR_VALIDATE_FILES_IS_NOT_A_LIST = "Ik heb een directive %s gelezen en kwam erachter dat 'files' een lijst nodig heeft. Zorg dat je het type aanpast naar een lijst en probeer het opnieuw.",
    ERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT = "Ik heb een ongeldige directive %s gevonden in het opgegeven bestand. Pas de directive aan en probeer het opnieuw.",
    ERROR_VALIDATE_NO_DIRECTIVES_FOUND = "Er zijn geen directives gevonden in het opgegeven bestand. Zorg ervoor dat er tenminste een directive in het bestand staat en probeer het opnieuw.",
    ERROR_VALIDATE_ORPHAN_LINEBREAK = "Er is een ongeldig directive-regeleinde in regel %s. Ik kan niet verder. Pas de directive aan en probeer het opnieuw.",
    ERROR_VALIDATE_REFERENCE_IS_RESERVED = "Ik heb een directive %s gelezen en kwam erachter dat de verwijzing 'reference' gebruikt is. Deze verwijzing is gereserveerd, en kan dus niet gebruikt worden. Maar maak je geen zorgen, dit zou makkelijk op te lossen moeten zijn: gebruik een andere naam.",
    ERROR_VALIDATE_YAML_EXCEPTION = "Er is een probleem met de opgegeven YAML-omzetting in directive %s. Dit probleem is ingewikkeld, omdat het te maken heeft met aspecten van de onderliggende serialisatiesyntax.",
    ERROR_VALIDATEBODY_ARGUMENT_ID_IS_RESERVED = "De argumentverwijzing '%s' is gereserveerd, en kan dus niet gebruikt worden. Dit zou makkelijk op te lossen moeten zijn: gebruik een andere naam.",
    ERROR_VALIDATEBODY_DUPLICATE_ARGUMENT_IDENTIFIERS = "Blijkbaar zijn er dubbele argumentnamen in de regel. Pas dit aan en probeer het opnieuw.",
    ERROR_VALIDATEBODY_MISSING_KEYS = "Bij het definiëren van het argumentbereik van een regel moet tenminste 'flag' of 'default' worden gebruikt. Zorg ervoor dat je in ieder geval een van deze gebruikt.",
    ERROR_VALIDATEBODY_NULL_ARGUMENT_ID = "Ik kwam erachter dat een van de argumenten geen verwijsnaam heeft. Zorg ervoor dat een geldige naam aan het argument wordt toegewezen en probeer het opnieuw.",
    ERROR_VALIDATEBODY_NULL_COMMAND = "Ik heb een null-opdracht in de opgegeven regel gevonden. Dit zou makkelijk op te lossen moeten zijn: geef een geldige opdracht op voor deze regel.",
    ERROR_VALIDATEHEADER_NULL_NAME = "De opgegeven regel heeft geen naam. Dit zou makkelijk op te lossen moeten zijn: geef een geldige naam op en probeer het opnieuw.",
    ERROR_VALIDATEHEADER_WRONG_IDENTIFIER = "De regel heeft een verkeerde verwijsnaam. Ik verwachtte '%s', maar vond '%s'. Dit zou makkelijk op te lossen moeten zijn: vervang de verkeerde verwijsnaam met de correcte naam.",
    INFO_DISPLAY_EXCEPTION_MORE_DETAILS = "Er zijn meer details beschikbaar voor deze exception:",
    INFO_DISPLAY_EXECUTION_TIME = "Totaal: %s seconden",
    INFO_DISPLAY_FILE_INFORMATION = "Verwerken van '%s' (grootte: %s, laatst gewijzigd: %s), een ogenblik geduld.",
    INFO_INTERPRETER_DRYRUN_MODE_BOOLEAN_MODE = "Ondanks het uitvoeren in dry-runmodus is dit item mogelijk al verwerkt omdat het de booleaanse waarde terug heeft gegeven:  %s",
    INFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND = "Begin met uitvoeren: %s",
    INFO_LABEL_AUTHOR = "Auteur:",
    INFO_LABEL_AUTHORS = "Auteurs:",
    INFO_LABEL_CONDITIONAL = "Voorwaarde:",
    INFO_LABEL_NO_AUTHORS = "Geen auteurs opgegeven",
    INFO_LABEL_ON_DETAILS = "DETAILS",
    INFO_LABEL_ON_ERROR = "FOUT",
    INFO_LABEL_ON_FAILURE = "MISLUKT",
    INFO_LABEL_ON_SUCCESS = "SUCCESVOL",
    INFO_LABEL_UNNAMED_TASK = "Naamloze taak",
    INFO_PARSER_NOTES = "arara is uitgebracht onder de New BSD licentie.",
    LOG_INFO_BEGIN_BUFFER = "OPEN UITVOER",
    LOG_INFO_BOOLEAN_MODE = "Booleaanse waarde: %s",
    LOG_INFO_DIRECTIVES_BLOCK = "DIRECTIVES",
    LOG_INFO_END_BUFFER = "SLUIT UITVOER",
    LOG_INFO_INTERPRET_RULE = "Ik ben klaar om regel '%s' te verwerken.",
    LOG_INFO_INTERPRET_TASK = "Ik ben klaar om taak '%s' uit regel '%s' te verwerken.",
    LOG_INFO_POTENTIAL_PATTERN_FOUND = "Ik heb een mogelijk patroon gevonden in regel %s: %s",
    LOG_INFO_RULE_LOCATION = "Regellocatie: '%s'",
    LOG_INFO_SYSTEM_COMMAND = "Systeemopdracht: %s",
    LOG_INFO_TASK_RESULT = "Taakresultaat:",
    LOG_INFO_VALIDATED_DIRECTIVES = "Alle directives zijn gevalideerd, we kunnen beginnen.",
    LOG_INFO_WELCOME_MESSAGE = "Welkom bij arara %s!"
)
