/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.AddDelimiterOption;
import com.dickimawbooks.texparserlib.latex.datatool.CsvBlankOption;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.EscapeCharsOption;
import com.dickimawbooks.texparserlib.latex.datatool.FileFormatType;
import com.dickimawbooks.texparserlib.latex.datatool.FileOverwriteOption;
import com.dickimawbooks.texparserlib.latex.datatool.IOExpandOption;
import java.io.IOException;

public class IOSettings {
    DataToolSty sty;
    FileFormatType format = FileFormatType.CSV;
    String defaultName = null;
    String defaultExtension = "csv";
    String fileVersion = "3.0";
    boolean incHeader = true;
    int separator = 44;
    int delimiter = 34;
    FileOverwriteOption fileOverwriteOpt = FileOverwriteOption.ERROR;
    AddDelimiterOption addDelimOpt = AddDelimiterOption.DETECT;
    EscapeCharsOption escCharsOpt = EscapeCharsOption.DOUBLE_DELIM;
    CsvBlankOption csvBlankOpt = CsvBlankOption.IGNORE;
    boolean csvLiteral = true;
    IOExpandOption expandOpt = IOExpandOption.NONE;
    boolean appendAllowed = false;
    boolean autoKeys = false;
    int skipLines = 0;
    boolean trimElement = true;

    public IOSettings(DataToolSty dataToolSty) {
        this.sty = dataToolSty;
    }

    public static IOSettings fetchReadSettings(DataToolSty dataToolSty, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        IOSettings iOSettings = new IOSettings(dataToolSty);
        iOSettings.fetchSettings(true, teXParser, teXObjectList);
        return iOSettings;
    }

    public static IOSettings fetchWriteSettings(DataToolSty dataToolSty, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        IOSettings iOSettings = new IOSettings(dataToolSty);
        iOSettings.fetchSettings(false, teXParser, teXObjectList);
        return iOSettings;
    }

    public void fetchSettings(boolean bl, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string;
        this.defaultName = this.getControlSequenceValue("l__datatool_io_name_str", null, teXParser, teXObjectList);
        this.defaultExtension = this.getControlSequenceValue("l__datatool_default_ext_str", null, teXParser, teXObjectList);
        this.incHeader = !TeXParserUtils.isTrue("ifdtlnoheader", teXParser);
        String string2 = string = this.getControlSequenceValue("l__datatool_format_str", "csv", teXParser, teXObjectList);
        int n = string.indexOf(45);
        if (n > -1) {
            this.fileVersion = string.substring(n + 1);
            if (!this.fileVersion.equals("2") && !this.fileVersion.equals("3")) {
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "format=" + string, "datatool/io");
            }
            this.fileVersion = this.fileVersion + ".0";
            string2 = string.substring(0, n);
        }
        if (string2.equals("dbtex")) {
            this.format = FileFormatType.DBTEX;
        } else if (string2.equals("dtltex")) {
            this.format = FileFormatType.DTLTEX;
        } else if (string2.equals("csv")) {
            this.format = FileFormatType.CSV;
        } else if (string2.equals("tsv")) {
            this.format = FileFormatType.TSV;
        } else {
            throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "format=" + string, "datatool/io");
        }
        if (this.format == FileFormatType.CSV || this.format == FileFormatType.TSV) {
            this.separator = this.sty.getSeparator();
            this.delimiter = this.sty.getDelimiter();
            string = this.getControlSequenceValue("__texparser_io_csv_escape_chars_tl", "double-delim", teXParser, teXObjectList);
            if (string.equals("none")) {
                this.escCharsOpt = EscapeCharsOption.NONE;
            } else if (string.equals("double-delim")) {
                this.escCharsOpt = EscapeCharsOption.DOUBLE_DELIM;
            } else if (string.equals("delim")) {
                this.escCharsOpt = EscapeCharsOption.ESC_DELIM;
            } else if (string.equals("delim+bksl")) {
                this.escCharsOpt = EscapeCharsOption.ESC_DELIM_BKSL;
            } else {
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "csv-escape-chars=" + string, "datatool/io");
            }
        }
        if (bl) {
            if (this.format == FileFormatType.CSV || this.format == FileFormatType.TSV) {
                this.autoKeys = TeXParserUtils.isTrue("ifdtlautokeys", teXParser);
                this.skipLines = TeXParserUtils.toInt(teXParser.getListener().getControlSequence("dtl@omitlines"), teXParser, teXObjectList);
                string = this.getControlSequenceValue("__texparser_io_csv_blank_tl", "ignore", teXParser, teXObjectList);
                if (string.equals("ignore")) {
                    this.csvBlankOpt = CsvBlankOption.IGNORE;
                } else if (string.equals("empty-row")) {
                    this.csvBlankOpt = CsvBlankOption.EMPTY_ROW;
                } else if (string.equals("end")) {
                    this.csvBlankOpt = CsvBlankOption.END;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "csv-blank=" + string, "datatool/io");
                }
                this.csvLiteral = !TeXParserUtils.isFalse("l__datatool_csv_literal_content_bool", teXParser);
            }
            this.appendAllowed = !TeXParserUtils.isFalse("l__datatool_append_allowed_bool", teXParser);
            this.trimElement = !TeXParserUtils.isFalse("l__datatool_new_element_trim_bool", teXParser);
        } else {
            if (this.defaultName == null) {
                this.defaultName = this.getControlSequenceValue("l__datatool_default_dbname_str", "untitled", teXParser, teXObjectList);
            }
            if ((string = this.getControlSequenceValue("__texparser_io_overwrite_tl", "error", teXParser, teXObjectList)).equals("allow")) {
                this.fileOverwriteOpt = FileOverwriteOption.WARN;
            } else if (string.equals("warn")) {
                this.fileOverwriteOpt = FileOverwriteOption.WARN;
            } else if (string.equals("error")) {
                this.fileOverwriteOpt = FileOverwriteOption.ERROR;
            } else {
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "overwrite=" + string, "datatool/io");
            }
            if (this.format != FileFormatType.DBTEX) {
                string = this.getControlSequenceValue("__texparser_io_expand_tl", "none", teXParser, teXObjectList);
                if (string.equals("none")) {
                    this.expandOpt = IOExpandOption.NONE;
                } else if (string.equals("protected")) {
                    this.expandOpt = IOExpandOption.PROTECTED;
                } else if (string.equals("full")) {
                    this.expandOpt = IOExpandOption.FULL;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "expand=" + string, "datatool/io");
                }
            }
            if (this.format == FileFormatType.CSV || this.format == FileFormatType.TSV) {
                string = this.getControlSequenceValue("__texparser_io_add_delimiter_tl", "detect", teXParser, teXObjectList);
                if (string.equals("always")) {
                    this.addDelimOpt = AddDelimiterOption.ALWAYS;
                } else if (string.equals("never")) {
                    this.addDelimOpt = AddDelimiterOption.NEVER;
                } else if (string.equals("detect")) {
                    this.addDelimOpt = AddDelimiterOption.DETECT;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "add-delimiter=" + string, "datatool/io");
                }
            }
        }
    }

    protected String getControlSequenceValue(String string, String string2, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        ControlSequence controlSequence = teXParser.getControlSequence(string);
        if (controlSequence == null) {
            return string2;
        }
        if (controlSequence instanceof TextualContentCommand) {
            return ((TextualContentCommand)controlSequence).getText();
        }
        return teXParser.expandToString(controlSequence, teXObjectList);
    }

    public FileFormatType getFormat() {
        return this.format;
    }

    public void setFileFormat(FileFormatType fileFormatType) {
        this.format = fileFormatType;
    }

    public void setFileFormat(FileFormatType fileFormatType, String string) throws TeXSyntaxException {
        this.format = fileFormatType;
        this.setFileVersion(string);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String string) {
        this.defaultName = string;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDefaultExtension(String string) {
        this.defaultExtension = string;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String string) throws TeXSyntaxException {
        if (!(this.format != FileFormatType.DBTEX && this.format != FileFormatType.DTLTEX || string.equals("2.0") || string.equals("3.0"))) {
            throw new LaTeXSyntaxException(this.sty.getParser(), DataBase.ERROR_FILE_FORMAT_VERSION, new Object[]{string, this.format});
        }
        this.fileVersion = string;
    }

    public boolean isHeaderIncluded() {
        return this.incHeader;
    }

    public void setHeaderIncluded(boolean bl) {
        this.incHeader = bl;
    }

    public int getSeparator() {
        return this.separator;
    }

    public void setSeparator(int n) {
        this.separator = n;
    }

    public int getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(int n) {
        this.delimiter = n;
    }

    public FileOverwriteOption getOverwriteOption() {
        return this.fileOverwriteOpt;
    }

    public void setFileOverwriteOption(FileOverwriteOption fileOverwriteOption) {
        this.fileOverwriteOpt = fileOverwriteOption;
    }

    public AddDelimiterOption getAddDelimiterOption() {
        return this.addDelimOpt;
    }

    public void setAddDelimiterOption(AddDelimiterOption addDelimiterOption) {
        this.addDelimOpt = addDelimiterOption;
    }

    public EscapeCharsOption getEscapeCharsOption() {
        return this.escCharsOpt;
    }

    public void setEscapeCharsOption(EscapeCharsOption escapeCharsOption) {
        this.escCharsOpt = escapeCharsOption;
    }

    public CsvBlankOption getCsvBlankOption() {
        return this.csvBlankOpt;
    }

    public void setCsvBlankOption(CsvBlankOption csvBlankOption) {
        this.csvBlankOpt = csvBlankOption;
    }

    public boolean isCsvLiteral() {
        return this.csvLiteral;
    }

    public void setCsvLiteral(boolean bl) {
        this.csvLiteral = bl;
    }

    public IOExpandOption getExpandOption() {
        return this.expandOpt;
    }

    public void setExpandOption(IOExpandOption iOExpandOption) {
        this.expandOpt = iOExpandOption;
    }

    public boolean isAppendAllowed() {
        return this.appendAllowed;
    }

    public void setAppendAllowed(boolean bl) {
        this.appendAllowed = bl;
    }

    public boolean isAutoKeysOn() {
        return this.autoKeys;
    }

    public void setAutoKeys(boolean bl) {
        this.autoKeys = bl;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int n) {
        this.skipLines = n;
    }

    public boolean isTrimElementOn() {
        return this.trimElement;
    }

    public void setTrimElement(boolean bl) {
        this.trimElement = bl;
    }

    public DataToolSty getSty() {
        return this.sty;
    }
}

