/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.StartElement;
import java.io.IOException;
import java.nio.file.Path;

public class L2HImage
extends AbstractTeXObject
implements Expandable {
    private Path path;
    private String mimetype;
    private String name;
    private int width = 0;
    private int height = 0;
    private TeXObject alt;

    public L2HImage(Path path) {
        this(path, null, 0, 0, null, null);
    }

    public L2HImage(Path path, String string) {
        this(path, string, 0, 0, null, null);
    }

    public L2HImage(Path path, String string, int n, int n2, String string2, TeXObject teXObject) {
        this.path = path;
        this.width = n;
        this.height = n2;
        this.alt = teXObject;
        if (string == null) {
            this.updateMimeType();
        } else {
            this.mimetype = string;
        }
        if (string2 != null) {
            string2 = string2.replaceAll("[^\\w]", "");
        }
    }

    @Override
    public Object clone() {
        return new L2HImage(this.path, this.mimetype, this.width, this.height, this.name, this.alt == null ? null : (TeXObject)this.alt.clone());
    }

    protected void updateMimeType() {
        String string = this.path.getName(this.path.getNameCount() - 1).toString();
        int n = string.lastIndexOf(".");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(n).toLowerCase();
        }
        if (string2.equals("jpg") || string2.equals("jpeg")) {
            this.mimetype = "image/jpeg";
        } else if (string2.equals("png")) {
            this.mimetype = "image/png";
        } else if (string2.equals("pdf")) {
            this.mimetype = "application/pdf";
        }
    }

    public void setAlt(TeXObject teXObject) {
        this.alt = teXObject;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public String toString() {
        return String.format("%s[path=%s,width=%d,height=%d,type=%s,name=%s,alt=%s]", this.getClass().getName(), this.path, this.width, this.height, this.mimetype, this.name, this.alt);
    }

    @Override
    public boolean isPar() {
        return false;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.alt.toString(teXParser);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.alt.string(teXParser);
    }

    @Override
    public String format() {
        return this.alt == null ? "" : this.alt.format();
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        StartElement startElement = new StartElement("object");
        startElement.putAttribute("data", this.getData());
        if (this.width != 0) {
            startElement.putAttribute("width", "" + this.width);
        }
        if (this.height != 0) {
            startElement.putAttribute("height", "" + this.height);
        }
        if (this.mimetype != null) {
            startElement.putAttribute("type", this.mimetype);
        }
        if (this.name != null) {
            startElement.putAttribute("id", this.name);
        }
        teXObjectList.add(startElement);
        if (this.alt != null) {
            teXObjectList.add(this.alt);
        }
        teXObjectList.add(new EndElement("object"));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        StartElement startElement = new StartElement("object");
        startElement.putAttribute("data", this.getData());
        if (this.width != 0) {
            startElement.putAttribute("width", "" + this.width);
        }
        if (this.height != 0) {
            startElement.putAttribute("height", "" + this.height);
        }
        if (this.mimetype != null) {
            startElement.putAttribute("type", this.mimetype);
        }
        if (this.name != null) {
            startElement.putAttribute("id", this.name);
        }
        teXObjectList2.add(startElement);
        if (this.alt != null) {
            this.alt = TeXParserUtils.expandFully(this.alt, teXParser, teXObjectList);
            teXObjectList2.add(this.alt, true);
        }
        teXObjectList2.add(new EndElement("object"));
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public Path getPath() {
        return this.path;
    }

    private String getData() {
        int n = this.path.getNameCount();
        if (n == 1) {
            return this.path.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.path.getName(0).toString());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.path.getName(i).toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        Writeable writeable = teXParser.getListener().getWriteable();
        writeable.writeliteral(String.format("<object data=\"%s\"", this.getData()));
        if (this.width != 0) {
            writeable.writeliteral(String.format(" width=\"%d\"", this.width));
        }
        if (this.height != 0) {
            writeable.writeliteral(String.format(" height=\"%d\"", this.height));
        }
        if (this.mimetype != null) {
            writeable.writeliteral(String.format(" type=\"%s\"", this.mimetype));
        }
        if (this.name != null) {
            writeable.writeliteral(String.format(" id=\"%s\"", this.name));
        }
        writeable.writeliteral(">");
        if (this.alt != null) {
            if (teXParser == teXObjectList) {
                this.alt.process(teXParser);
            } else {
                this.alt.process(teXParser, teXObjectList);
            }
        }
        writeable.writeliteral("</object>");
    }
}

