/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.AccSupp;
import com.dickimawbooks.texparserlib.AccSuppObject;
import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Direction;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Paragraph;
import com.dickimawbooks.texparserlib.PercentUnit;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.Spacer;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontSize;
import com.dickimawbooks.texparserlib.TeXFontText;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXMode;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.BinarySymbol;
import com.dickimawbooks.texparserlib.generic.GreekSymbol;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.SpaceCs;
import com.dickimawbooks.texparserlib.generic.UndefinedActiveChar;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HCode;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HAbstract;
import com.dickimawbooks.texparserlib.html.L2HAlignRow;
import com.dickimawbooks.texparserlib.html.L2HAltListDesc;
import com.dickimawbooks.texparserlib.html.L2HAltListDescEnv;
import com.dickimawbooks.texparserlib.html.L2HAltListItem;
import com.dickimawbooks.texparserlib.html.L2HAmp;
import com.dickimawbooks.texparserlib.html.L2HAtMakeCaption;
import com.dickimawbooks.texparserlib.html.L2HAtStartToc;
import com.dickimawbooks.texparserlib.html.L2HBibItem;
import com.dickimawbooks.texparserlib.html.L2HBigOperator;
import com.dickimawbooks.texparserlib.html.L2HBinarySymbol;
import com.dickimawbooks.texparserlib.html.L2HCaption;
import com.dickimawbooks.texparserlib.html.L2HContentsLine;
import com.dickimawbooks.texparserlib.html.L2HDescriptionItem;
import com.dickimawbooks.texparserlib.html.L2HDescriptionLabel;
import com.dickimawbooks.texparserlib.html.L2HEqnarray;
import com.dickimawbooks.texparserlib.html.L2HFloat;
import com.dickimawbooks.texparserlib.html.L2HFontFamilyDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontShapeDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontSizeDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontWeightDeclaration;
import com.dickimawbooks.texparserlib.html.L2HGreekSymbol;
import com.dickimawbooks.texparserlib.html.L2HGroup;
import com.dickimawbooks.texparserlib.html.L2HImage;
import com.dickimawbooks.texparserlib.html.L2HItem;
import com.dickimawbooks.texparserlib.html.L2HLetter;
import com.dickimawbooks.texparserlib.html.L2HLongTable;
import com.dickimawbooks.texparserlib.html.L2HMaketitle;
import com.dickimawbooks.texparserlib.html.L2HMathAlignRow;
import com.dickimawbooks.texparserlib.html.L2HMathDeclaration;
import com.dickimawbooks.texparserlib.html.L2HMathGroup;
import com.dickimawbooks.texparserlib.html.L2HMathJaxCommand;
import com.dickimawbooks.texparserlib.html.L2HMathSymbol;
import com.dickimawbooks.texparserlib.html.L2HMultiCols;
import com.dickimawbooks.texparserlib.html.L2HNewFontFamily;
import com.dickimawbooks.texparserlib.html.L2HNoBreakSpace;
import com.dickimawbooks.texparserlib.html.L2HNormalFont;
import com.dickimawbooks.texparserlib.html.L2HNumberline;
import com.dickimawbooks.texparserlib.html.L2HOther;
import com.dickimawbooks.texparserlib.html.L2HPar;
import com.dickimawbooks.texparserlib.html.L2HParagraph;
import com.dickimawbooks.texparserlib.html.L2HQuote;
import com.dickimawbooks.texparserlib.html.L2HSection;
import com.dickimawbooks.texparserlib.html.L2HTableOfContents;
import com.dickimawbooks.texparserlib.html.L2HTabular;
import com.dickimawbooks.texparserlib.html.L2HTeXParserSection;
import com.dickimawbooks.texparserlib.html.L2HTextSubscript;
import com.dickimawbooks.texparserlib.html.L2HTextSuperscript;
import com.dickimawbooks.texparserlib.html.L2HTheBibliography;
import com.dickimawbooks.texparserlib.html.L2HToImage;
import com.dickimawbooks.texparserlib.html.L2HUndefined;
import com.dickimawbooks.texparserlib.html.L2Hhfill;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.Angle;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.BorderStyle;
import com.dickimawbooks.texparserlib.latex.DescriptionDec;
import com.dickimawbooks.texparserlib.latex.FloatBoxStyle;
import com.dickimawbooks.texparserlib.latex.FontFamilyDeclaration;
import com.dickimawbooks.texparserlib.latex.FontShapeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontSizeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontWeightDeclaration;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.IndexLocation;
import com.dickimawbooks.texparserlib.latex.Input;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.L2HSpacer;
import com.dickimawbooks.texparserlib.latex.LaTeXFile;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.TeXParserSection;
import com.dickimawbooks.texparserlib.latex.TrivListDec;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.awt.Color;
import java.awt.Dimension;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class L2HConverter
extends LaTeXParserListener
implements Writeable {
    private Vector<String> styCs;
    private int indexLoc = 0;
    private Writer writer;
    private Writer currentWriter;
    private StringWriter footnoteWriter = null;
    protected boolean inPreamble = false;
    private Charset htmlCharSet = null;
    private TeXApp texApp;
    private Path outPath;
    private Path basePath;
    private boolean useMathJax = true;
    private boolean unicodeScriptSupport = true;
    private boolean useHtmlEntities = false;
    private String suffix = "html";
    private Vector<String> extraHead = null;
    private Vector<String> extraCssStyles = new Vector();
    private HashMap<String, TeXObject> internalReferences;
    private HashMap<String, String> defaultStyles;
    private HashMap<HashMap<String, String>, String> defaultStyleMaps;
    private String currentSection = null;
    private Stack<TrivListDec> trivListStack = new Stack();
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_JPEG = "image/jpeg";

    public L2HConverter(TeXApp teXApp) {
        this(teXApp, true, null, null, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, Vector<AuxData> vector) {
        this(teXApp, true, null, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, boolean bl2) {
        this(teXApp, bl, null, null, bl2, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, Vector<AuxData> vector) {
        this(teXApp, bl, null, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, File file) {
        this(teXApp, true, file, null, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, File file, Vector<AuxData> vector) {
        this(teXApp, true, file, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file) {
        this(teXApp, bl, file, null, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector) {
        this(teXApp, bl, file, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, boolean bl2) {
        this(teXApp, bl, file, null, bl2, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2) {
        this(teXApp, bl, file, vector, bl2, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2, Charset charset) {
        this(teXApp, bl, file, vector, bl2, charset, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2, Charset charset, boolean bl3) {
        super(null, vector, bl2, bl3);
        this.texApp = teXApp;
        this.outPath = file == null ? null : file.toPath();
        this.htmlCharSet = charset;
        if (this.htmlCharSet == null) {
            this.htmlCharSet = this.texApp.getDefaultCharset();
        }
        this.styCs = new Vector();
        this.defaultStyles = new HashMap();
        this.internalReferences = new HashMap();
        this.setWriteable(this);
        this.setUseMathJax(bl);
        this.setImageExtensions("svg", "SVG", "png", "PNG", "jpg", "JPG", "jpeg", "JPEG", "gif", "GIF", "pdf", "PDF");
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.putControlSequence(new AtFirstOfTwo("IfTeXParserLib"));
        this.putControlSequence(new L2HToImage());
        this.putControlSequence(new HCode());
        this.parser.putControlSequence(new TextualContentCommand("TeX", "TeX"));
        this.parser.putControlSequence(new TextualContentCommand("LaTeX", "LaTeX"));
        this.parser.putControlSequence(new TextualContentCommand("LaTeXe", "LaTeX2e"));
        this.parser.putControlSequence(new TextualContentCommand("eTeX", "eTeX"));
        this.parser.putControlSequence(new TextualContentCommand("XeTeX", "XeTeX"));
        this.parser.putControlSequence(new TextualContentCommand("XeLaTeX", "XeLaTeX"));
        this.parser.putControlSequence(new TextualContentCommand("LuaTeX", "LuaTeX"));
        this.parser.putControlSequence(new TextualContentCommand("LuaLaTeX", "LuaLaTeX"));
        this.parser.putControlSequence(new TextualContentCommand("pdfTeX", "pdfTeX"));
        this.parser.putControlSequence(new TextualContentCommand("pdfLaTeX", "pdfLaTeX"));
        this.parser.putControlSequence(new TextualContentCommand("BibTeX", "BibTeX"));
        this.parser.putControlSequence(new GenericCommand("indexspace", null, new HtmlTag("<div class=\"indexspace\"></div>")));
        this.putControlSequence(new Relax("nonumberline"));
        this.putControlSequence(new L2HAmp());
        this.putControlSequence(new L2HNoBreakSpace());
        this.putControlSequence(new SpaceCs("newblock"));
        this.putControlSequence(new L2HTheBibliography());
        this.addToBibliographySection(new TeXCsRef("label"));
        this.addToBibliographySection(this.createGroup("bib"));
        this.addInternalReference("bib", new TeXCsRef("refname"));
        this.addInternalReference("toc", new TeXCsRef("contentsname"));
        this.putControlSequence(new AtSecondOfTwo("texparser@ifintoc"));
        this.putControlSequence(new L2HTableOfContents());
        this.putControlSequence(new L2HAtStartToc());
        this.putControlSequence(new L2HContentsLine());
        this.putControlSequence(new L2HBibItem());
        this.putControlSequence(new L2HMaketitle());
        this.putControlSequence(new L2HTextSuperscript());
        this.putControlSequence(new L2HTextSubscript());
        this.putControlSequence(new L2HSection());
        this.putControlSequence(new L2HSection("subsection"));
        this.putControlSequence(new L2HSection("subsubsection"));
        this.putControlSequence(new L2HSection("paragraph"));
        this.putControlSequence(new L2HSection("subparagraph"));
        this.putControlSequence(new L2HSection("part"));
        this.putControlSequence(new L2HNumberline());
        this.putControlSequence(new L2HCaption());
        this.putControlSequence(new L2HAtMakeCaption());
        this.putControlSequence(new L2HFloat("figure"));
        this.putControlSequence(new L2HFloat("table"));
        this.putControlSequence(new L2HAbstract());
        this.putControlSequence(new L2HMultiCols());
        this.putControlSequence(new L2HMultiCols("multicols*"));
        this.putControlSequence(new L2HItem());
        this.putControlSequence(new L2HDescriptionLabel());
        this.putControlSequence(new L2HDescriptionItem());
        this.putControlSequence(new L2HAltListItem());
        this.putControlSequence(new L2HAltListDesc());
        this.putControlSequence(new L2HAltListDescEnv());
        this.putControlSequence(new L2HQuote());
        this.putControlSequence(new L2HMathDeclaration("math"));
        L2HMathDeclaration l2HMathDeclaration = new L2HMathDeclaration("(");
        this.parser.putControlSequence(l2HMathDeclaration);
        this.parser.putControlSequence(new EndDeclaration(")", l2HMathDeclaration));
        this.parser.putControlSequence(new L2HMathDeclaration("displaymath", TeXMode.DISPLAY_MATH));
        L2HMathDeclaration l2HMathDeclaration2 = new L2HMathDeclaration("[", TeXMode.DISPLAY_MATH);
        this.parser.putControlSequence(l2HMathDeclaration2);
        this.parser.putControlSequence(new EndDeclaration("]", l2HMathDeclaration2));
        this.parser.putControlSequence(new L2HMathDeclaration("equation", TeXMode.DISPLAY_MATH, true));
        this.parser.putControlSequence(new L2HTabular());
        this.parser.putControlSequence(new L2HTabular("array"));
        this.parser.putControlSequence(new L2HLongTable());
        this.parser.putControlSequence(new L2HEqnarray());
        this.parser.putControlSequence(new L2HEqnarray("eqnarray*", false));
        this.parser.putControlSequence(new Relax("strut"));
        this.putControlSequence(new GenericCommand(true, "bigskip", null, new TeXObject[]{new HtmlTag("<div class=\"bigskip\"></div>")}));
        this.putControlSequence(new GenericCommand(true, "medskip", null, new TeXObject[]{new HtmlTag("<div class=\"medskip\"></div>")}));
        this.putControlSequence(new GenericCommand(true, "smallskip", null, new TeXObject[]{new HtmlTag("<div class=\"smallskip\"></div>")}));
        this.putControlSequence(new L2Hhfill("hfill"));
        this.putControlSequence(new L2Hhfill("hfil"));
        this.putControlSequence(new GenericCommand(true, "quad", null, new TeXObject[]{new HtmlTag("<span class=\"quad\"></span>")}));
        this.putControlSequence(new GenericCommand(true, "qquad", null, new TeXObject[]{new HtmlTag("<span class=\"qquad\"></span>")}));
        this.putControlSequence(new AtGobble("addvspace"));
        this.putControlSequence(new L2HNormalFont());
        this.putControlSequence(new GenericCommand(true, "labelitemii", null, new HtmlTag("&#x2013;")));
        this.putControlSequence(new Relax("indent"));
        this.putControlSequence(new Relax("noindent"));
        this.putControlSequence(new Relax("allowbreak"));
        this.putControlSequence(new GenericCommand(true, "newline", null, new HtmlTag("<br>")));
        this.putControlSequence(new AtGobble("pagenumbering"));
        this.putControlSequence(new Input("include"));
        this.putControlSequence(new L2HNewFontFamily());
        try {
            LaTeXSty laTeXSty = this.requirepackage("hyperref", this.getParser());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected TeXParserSection createTeXParserSection(String string) {
        return new L2HTeXParserSection("texparser@" + string, string);
    }

    public void addInternalReference(String string, TeXObject teXObject) {
        this.internalReferences.put(string, teXObject);
    }

    @Override
    public TeXObject createUnknownReference(String string) {
        TeXObject teXObject = this.internalReferences.get(string);
        if (teXObject != null) {
            return teXObject;
        }
        return super.createUnknownReference(string);
    }

    @Override
    public TeXObject createUnknownReference(TeXObject teXObject) {
        try {
            TeXObjectList teXObjectList;
            if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this.parser)) != null) {
                teXObject = teXObjectList;
            }
            return this.createUnknownReference(teXObject.toString(this.parser));
        }
        catch (IOException iOException) {
            this.getParser().error(iOException);
            return super.createUnknownReference(teXObject);
        }
    }

    public L2HImage toImage(String string, String string2, String string3, TeXObject teXObject, String string4, boolean bl) throws IOException {
        return null;
    }

    @Override
    public BigOperator createBigOperator(String string, int n, int n2) {
        return new L2HBigOperator(string, n, n2);
    }

    @Override
    public BigOperator createBigOperator(String string, int n) {
        return new L2HBigOperator(string, n);
    }

    @Override
    public MathSymbol createMathSymbol(String string, int n) {
        return new L2HMathSymbol(string, n);
    }

    @Override
    public BinarySymbol createBinarySymbol(String string, int n) {
        return new L2HBinarySymbol(string, n);
    }

    @Override
    public GreekSymbol createGreekSymbol(String string, int n) {
        return new L2HGreekSymbol(string, n);
    }

    @Override
    public Letter getLetter(int n) {
        return new L2HLetter(n);
    }

    @Override
    public Other getOther(int n) {
        return new L2HOther(n);
    }

    @Override
    public Par getPar() {
        return new L2HPar();
    }

    @Override
    public Paragraph createParagraph() {
        return new L2HParagraph();
    }

    @Override
    public Spacer getSpacer(Direction direction, TeXDimension teXDimension, boolean bl) {
        return new L2HSpacer(direction, teXDimension, bl);
    }

    @Override
    public TeXObject getDivider(String string) {
        return new HtmlTag(String.format("<div class=\"%s\"><hr></div>", string));
    }

    @Override
    public Group createGroup() {
        return new L2HGroup();
    }

    @Override
    public Group createGroup(String string) {
        return new L2HGroup(this, string);
    }

    @Override
    public MathGroup createMathGroup() {
        return new L2HMathGroup();
    }

    @Override
    public AlignRow createAlignRow(TeXObjectList teXObjectList) throws IOException {
        return new L2HAlignRow(this.getParser(), teXObjectList);
    }

    public AlignRow createMathAlignRow(TeXObjectList teXObjectList, boolean bl) throws IOException {
        return new L2HMathAlignRow(this.getParser(), teXObjectList, bl);
    }

    @Override
    public void cr(boolean bl, TeXObject teXObject) throws IOException {
        TeXSettings teXSettings = this.getParser().getSettings();
        if (teXSettings.getAlignMode() == 1) {
            teXSettings.startRow();
        } else {
            this.writeliteral(String.format("<br>%n", new Object[0]));
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.currentWriter = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getStyle() {
        String string = "";
        if (this.parser != null) {
            TeXSettings teXSettings = this.parser.getSettings();
            switch (teXSettings.getCurrentFontFamily()) {
                case RM: {
                    string = "font-family: serif; ";
                    break;
                }
                case SF: {
                    string = "font-family: sans-serif; ";
                    break;
                }
                case TT: 
                case VERB: {
                    string = "font-family: monospace; ";
                    break;
                }
                case CAL: {
                    string = "font-family: cursive; ";
                }
            }
            switch (teXSettings.getCurrentFontShape()) {
                case UP: {
                    string = string + "font-style: normal; font-variant: normal; ";
                    break;
                }
                case IT: {
                    string = string + "font-style: italic; font-variant: normal; ";
                    break;
                }
                case SL: {
                    string = string + "font-style: oblique; font-variant: normal; ";
                    break;
                }
                case EM: {
                    TeXFontShape teXFontShape;
                    TeXSettings teXSettings2 = teXSettings.getParent();
                    string = teXSettings2 != null ? ((teXFontShape = teXSettings2.getFontShape()) == TeXFontShape.UP || teXFontShape == TeXFontShape.INHERIT ? (teXSettings.getFontFamily() == TeXFontFamily.SF ? string + "font-style: oblique; " : string + "font-style: italic; ") : string + "font-style: normal; ") : (teXSettings.getFontFamily() == TeXFontFamily.SF ? string + "font-style: oblique; " : string + "font-style: italic; ");
                    string = string + "font-variant: normal; ";
                    break;
                }
                case SC: {
                    string = string + "font-style: normal; font-variant: small-caps; ";
                }
            }
            switch (teXSettings.getCurrentFontWeight()) {
                case MD: {
                    string = string + "font-weight: normal; ";
                    break;
                }
                case BF: {
                    string = string + "font-weight: bold; ";
                }
            }
        }
        return string;
    }

    @Override
    public FontWeightDeclaration getFontWeightDeclaration(String string, TeXFontWeight teXFontWeight) {
        return new L2HFontWeightDeclaration(string, teXFontWeight);
    }

    @Override
    public FontSizeDeclaration getFontSizeDeclaration(String string, TeXFontSize teXFontSize) {
        return new L2HFontSizeDeclaration(string, teXFontSize);
    }

    @Override
    public FontShapeDeclaration getFontShapeDeclaration(String string, TeXFontShape teXFontShape) {
        return new L2HFontShapeDeclaration(string, teXFontShape);
    }

    @Override
    public FontFamilyDeclaration getFontFamilyDeclaration(String string, TeXFontFamily teXFontFamily) {
        return new L2HFontFamilyDeclaration(string, teXFontFamily);
    }

    @Override
    public void writeliteralln(String string) throws IOException {
        this.writeliteral(String.format("%s%n", string));
    }

    @Override
    public void writeliteral(String string) throws IOException {
        if (this.currentWriter == null) {
            this.currentWriter = this.writer;
        }
        if (this.currentWriter == null) {
            this.parser.debugMessage(1, "No writer available. writeliteral: " + string);
        } else {
            this.currentWriter.write(string);
        }
    }

    public void setUseEntities(boolean bl) {
        this.useHtmlEntities = bl;
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
        if (this.currentWriter == null) {
            this.currentWriter = this.writer;
            if (this.currentWriter == null) {
                if (!Character.isWhitespace(n)) {
                    this.parser.debugMessage(1, "No writer available. writeCodePoint: " + n);
                }
                return;
            }
        }
        if (this.inPreamble && !Character.isWhitespace(n)) {
            throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_begin_doc", new String(Character.toChars(n)));
        }
        if (n == 60) {
            this.currentWriter.write("&lt;");
        } else if (n == 62) {
            this.currentWriter.write("&gt;");
        } else if (n == 38) {
            this.currentWriter.write("&amp;");
        } else if (n >= 128 && this.useHtmlEntities) {
            this.currentWriter.write(String.format("&#x%x;", n));
        } else if (n <= 65535) {
            this.currentWriter.write((char)n);
        } else {
            char[] cArray;
            for (char c : cArray = Character.toChars(n)) {
                this.currentWriter.write(c);
            }
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (this.currentWriter == null) {
            this.currentWriter = this.writer;
            if (this.currentWriter == null) {
                if (!string.trim().isEmpty()) {
                    this.parser.debugMessage(1, "No writer available. write: " + string);
                }
                return;
            }
        }
        if (this.inPreamble && !string.trim().isEmpty()) {
            throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_begin_doc", string);
        }
        if (this.useHtmlEntities) {
            int n;
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                if (n == 38) {
                    this.currentWriter.write("&amp;");
                    continue;
                }
                if (n == 60) {
                    this.currentWriter.write("&lt;");
                    continue;
                }
                if (n == 62) {
                    this.currentWriter.write("&gt;");
                    continue;
                }
                if (n >= 128) {
                    this.currentWriter.write(String.format("&#x%x;", n));
                    continue;
                }
                this.currentWriter.write((char)n);
            }
        } else {
            this.currentWriter.write(string);
        }
    }

    @Override
    public void write(char c) throws IOException {
        if (this.currentWriter == null) {
            this.currentWriter = this.writer;
            if (this.currentWriter == null) {
                if (!Character.isWhitespace(c)) {
                    this.parser.debugMessage(1, "No writer available. write(char): " + c);
                }
                return;
            }
        }
        if (this.inPreamble && !Character.isWhitespace(c)) {
            throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_begin_doc", Character.valueOf(c));
        }
        if (this.useHtmlEntities) {
            if (c == '&') {
                this.currentWriter.write("&amp;");
            } else if (c == '<') {
                this.currentWriter.write("&lt;");
            } else if (c == '>') {
                this.currentWriter.write("&gt;");
            } else if (c >= '\u0080') {
                this.currentWriter.write(String.format("&#x%x;", Character.valueOf(c)));
            } else {
                this.currentWriter.write(c);
            }
        } else {
            this.currentWriter.write(c);
        }
    }

    @Override
    public void writeln(String string) throws IOException {
        if (this.currentWriter == null) {
            this.currentWriter = this.writer;
            if (this.currentWriter == null) {
                if (!string.trim().isEmpty()) {
                    this.parser.debugMessage(1, "No writer available. writeln: " + string);
                }
                return;
            }
        }
        if (this.inPreamble && !string.trim().isEmpty()) {
            throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_begin_doc", string);
        }
        this.write(String.format("%s%n", string));
        this.currentWriter.flush();
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        AccSupp accSupp;
        if (this.currentWriter == null) {
            this.currentWriter = this.writer;
            if (this.currentWriter == null) {
                throw new IOException("No writer available");
            }
        }
        this.currentWriter.write("<a href=\"");
        this.write(string);
        this.currentWriter.write("\"");
        if (teXObject instanceof AccSuppObject && (accSupp = ((AccSuppObject)teXObject).getAccSupp()).isIcon()) {
            this.currentWriter.write(" class=\"icon\"");
        }
        this.currentWriter.write(">");
        teXObject.process(this.parser);
        this.currentWriter.write("</a>");
    }

    public boolean isIcon(AccSupp accSupp) {
        return accSupp.isIcon();
    }

    public boolean isIcon(TeXObject teXObject) {
        if (teXObject instanceof AccSuppObject) {
            return this.isIcon(((AccSuppObject)teXObject).getAccSupp());
        }
        return false;
    }

    @Override
    public TeXObject applyAccSupp(AccSupp accSupp, TeXObject teXObject) {
        StartElement startElement;
        TeXObjectList teXObjectList;
        String string = accSupp.getTag();
        String string2 = accSupp.getAttribute();
        String string3 = accSupp.getText();
        String string4 = accSupp.getId();
        if (string != null && teXObject instanceof TeXObjectList && !teXObject.isEmpty() && (teXObjectList = (TeXObjectList)teXObject).firstElement() instanceof StartElement && (teXObjectList.size() == 1 || teXObjectList.lastElement() instanceof EndElement)) {
            startElement = (StartElement)teXObjectList.firstElement();
            EndElement endElement = null;
            if (teXObjectList.size() > 1) {
                endElement = (EndElement)teXObjectList.lastElement();
            }
            if (startElement.getName().equals(string) && (endElement == null || endElement.getName().equals(string))) {
                String string5 = startElement.getAttribute("id");
                Object var11_11 = null;
                if (string2 != null) {
                    startElement.getAttribute(string2);
                }
                if ((string5 == null || string4 == null || string5.equals(string4)) && (string3 == null || var11_11 == null || string3.equals(var11_11))) {
                    if (string4 != null) {
                        startElement.putAttribute("id", string4);
                    }
                    if (string3 != null) {
                        startElement.putAttribute(string2, string3);
                    }
                    return teXObject;
                }
            }
        }
        teXObjectList = this.createStack();
        if (string == null) {
            string = "span";
        }
        startElement = new StartElement(string);
        if (string4 != null) {
            startElement.putAttribute("id", string4);
        }
        if (string3 != null) {
            if (string2 == null) {
                startElement.putAttribute("title", string3);
            } else {
                startElement.putAttribute(string2, string3);
            }
        }
        if (this.isIcon(accSupp)) {
            startElement.putAttribute("class", "icon");
        }
        teXObjectList.add(startElement);
        teXObjectList.add(teXObject);
        teXObjectList.add(new EndElement(string));
        return teXObjectList;
    }

    @Override
    public TeXObject createAnchor(String string, TeXObject teXObject) throws IOException {
        Object object;
        TeXObject teXObject2;
        if (teXObject instanceof TeXObjectList && !teXObject.isEmpty() && ((TeXObjectList)teXObject).firstElement() instanceof StartElement && !((StartElement)(teXObject2 = (StartElement)((TeXObjectList)teXObject).firstElement())).hasAttribute("id")) {
            ((StartElement)teXObject2).putAttribute("id", string);
            return teXObject;
        }
        teXObject2 = this.createStack();
        String string2 = "a";
        String string3 = HtmlTag.getUriFragment(string);
        String string4 = null;
        String string5 = null;
        if (teXObject instanceof AccSuppObject && (((AccSupp)(object = ((AccSuppObject)teXObject).getAccSupp())).getId() == null || ((AccSupp)object).getId().equals(string3)) && ((AccSupp)object).getTag() != null) {
            string2 = ((AccSupp)object).getTag();
            string4 = ((AccSupp)object).getAttribute();
            string5 = ((AccSupp)object).getText();
            if (string5 != null && string4 == null) {
                string4 = "title";
            }
            teXObject = ((AccSuppObject)teXObject).getObject();
        }
        object = new StartElement(string2);
        ((StartElement)object).putAttribute("id", string3);
        if (string4 != null) {
            ((StartElement)object).putAttribute(string4, string5);
        }
        ((TeXObjectList)teXObject2).add((TeXObject)object);
        ((TeXObjectList)teXObject2).add(teXObject);
        ((TeXObjectList)teXObject2).add(new EndElement(string2));
        return teXObject2;
    }

    @Override
    public TeXObject createLink(String string, TeXObject teXObject) throws IOException {
        TeXObject teXObject2;
        Vector<AuxData> vector = this.getAuxData();
        if (vector != null && (teXObject2 = AuxData.getLabelForLink(vector, this.getParser(), string)) != null) {
            string = teXObject2.toString(this.parser);
        }
        teXObject2 = this.createStack();
        StartElement startElement = new StartElement("a");
        if (teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).isStack() && ((TeXObjectList)teXObject).size() == 1 && this.isIcon(teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement())) {
            startElement.putAttribute("class", "icon");
        }
        startElement.putAttribute("href", "#" + HtmlTag.getUriFragment(string));
        ((TeXObjectList)teXObject2).add(startElement);
        ((TeXObjectList)teXObject2).add(teXObject);
        ((TeXObjectList)teXObject2).add(new EndElement("a"));
        return teXObject2;
    }

    @Override
    public void substituting(String string, String string2) {
        this.texApp.substituting(this.parser, string, string2);
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    public boolean supportUnicodeScript() {
        return this.unicodeScriptSupport;
    }

    public void setSupportUnicodeScript(boolean bl) {
        this.unicodeScriptSupport = bl;
    }

    public boolean useMathJax() {
        return this.useMathJax;
    }

    public void setUseMathJax(boolean bl) {
        this.useMathJax = bl;
    }

    public String mathJaxStartInline() {
        return "\\(";
    }

    public String mathJaxEndInline() {
        return "\\)";
    }

    public String mathJaxStartDisplay() {
        return "\\[";
    }

    public String mathJaxEndDisplay() {
        return "\\]";
    }

    public void writeMathJaxHeader() throws IOException {
        this.setUseMathJax(true);
        this.writeliteralln("<!-- MathJax -->");
        this.writeliteralln("<script type=\"text/x-mathjax-config\">");
        this.writeliteralln("MathJax.Hub.Config({tex2jax:");
        this.writeliteralln("{");
        this.writeliteralln(String.format("  inlineMath: [['%s','%s']],", this.mathJaxStartInline().replace("\\", "\\\\"), this.mathJaxEndInline().replace("\\", "\\\\")));
        this.writeliteralln(String.format("  displayMath: [ ['%s','%s'] ]", this.mathJaxStartDisplay().replace("\\", "\\\\"), this.mathJaxEndDisplay().replace("\\", "\\\\")));
        this.writeliteralln("}});");
        this.writeliteralln("</script>");
        this.writeliteral("<script type=\"text/javascript\" src=");
        this.writeliteralln("\"http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML\">");
        this.writeliteralln("</script>");
    }

    protected void writeTabularCss(String string, String string2) throws IOException {
        String string3 = "";
        if (string != null) {
            string3 = string3 + string.charAt(0);
        }
        if (string2 != null) {
            string3 = string3 + string2.charAt(0);
        }
        this.writeliteralln("table.tabular-" + string3);
        this.writeliteralln("{");
        this.writeliteralln("  display: inline-table;");
        this.writeliteralln("  border-collapse: collapse;");
        if (string != null) {
            this.writeliteralln("  align: " + string + ";");
        }
        if (string2 != null) {
            this.writeliteralln("  vertical-align: " + string2 + ";");
        }
        this.writeliteralln("}");
    }

    public void writeCssStyles() throws IOException {
        this.addDefaultTabularStyles();
        this.writeliteralln("#main {margin-left: 5%; margin-right: 15%}");
        this.writeliteralln("div.tomain {position: absolute; left: 0pt; width: 5%; text-align: right; font-size: x-small;}");
        this.writeliteralln("div.tomain a {text-decoration: none;}");
        this.writeliteralln("div.labellink {display: inline; font-size: x-small; margin-left: 1em; margin-right: 1em;}");
        this.writeliteralln("div.marginleft {position: absolute; left: 0pt; width: 5%;}");
        this.writeliteralln("div.marginright {position: absolute; right: 0pt; width: 15%;}");
        this.writeliteralln("div.displaymath { display: block; text-align: center; }");
        this.writeliteralln("span.eqno { float: right; }");
        this.writeliteralln("div.table { display: block; text-align: center; }");
        this.writeTabularCss("center", "middle");
        this.writeTabularCss("center", "bottom");
        this.writeTabularCss("center", "top");
        this.writeTabularCss("left", "middle");
        this.writeTabularCss("left", "bottom");
        this.writeTabularCss("left", "top");
        this.writeTabularCss("right", "middle");
        this.writeTabularCss("right", "bottom");
        this.writeTabularCss("right", "top");
        this.writeTabularCss(null, "middle");
        this.writeTabularCss(null, "bottom");
        this.writeTabularCss(null, "top");
        this.writeTabularCss("left", null);
        this.writeTabularCss("center", null);
        this.writeTabularCss("right", null);
        this.writeliteralln("pre { white-space: pre-wrap; }");
        this.writeliteralln("div.figure { display: block; text-align: center; }");
        this.writeliteralln("div.caption { display: block; text-align: center; }");
        this.writeliteralln("div.marginpar { float: right; }");
        this.writeliteralln("div.abstract { display: block; margin-right: 4em; margin-left: 4em;}");
        this.writeliteralln("div.title { display: block; text-align: center; font-size: x-large;}");
        this.writeliteralln("div.author { display: block; text-align: center; font-size: large;}");
        this.writeliteralln("div.date { display: block; text-align: center; font-size: medium;}");
        this.writeliteralln("div.bibliography { display: block; margin-left: 4em; }");
        this.writeliteralln("div.bibitem { display: inline; float: left; text-indent: -3em; }");
        this.writeliteralln("span.numberline { display: inline-block; width: 3em; }");
        this.writeliteralln(".toc-subsection span.numberline { display: inline-block; width: 3em; }");
        this.writeliteralln(".toc-subsubsection span.numberline { display: inline-block; width: 4em; }");
        this.writeliteralln(".toc-paragraph span.numberline { display: inline-block; width: 5em; }");
        this.writeliteralln(".toc-subparagraph span.numberline { display: inline-block; width: 6em; }");
        this.writeliteralln("nav ul { list-style-type: none; }");
        this.writeliteralln(".toc-part { padding-left: 0em; padding-bottom: 1ex; padding-top: 1ex; font-weight: bold; font-size: large;}");
        this.writeliteralln(".toc-chapter { padding-left: 0em; padding-bottom: .25ex; padding-top: .25ex; font-weight: bold; }");
        this.writeliteralln(".toc-section { padding-left: .5em; }");
        this.writeliteralln(".toc-subsection { padding-left: 1.5em; }");
        this.writeliteralln(".toc-subsubsection { padding-left: 2em; }");
        this.writeliteralln(".toc-paragraph { padding-left: 2.5em; }");
        this.writeliteralln(".toc-subparagraph { padding-left: 3em; }");
        this.writeliteralln(".part { font-size: x-large; font-weight: bold; }");
        this.writeliteralln("div.bigskip { padding-left: 0pt; padding-right: 0pt; padding-top: 0pt; padding-bottom: 2ex;}");
        this.writeliteralln("div.medskip { padding-left: 0pt; padding-right: 0pt; padding-top: 0pt; padding-bottom: 1ex;}");
        this.writeliteralln("div.smallskip { padding-left: 0pt; padding-right: 0pt; padding-top: 0pt; padding-bottom: .5ex;}");
        this.writeliteralln("span.quad { padding-left: 0pt; padding-right: 1em; padding-top: 0pt; padding-bottom: 0pt;}");
        this.writeliteralln("span.qquad { padding-left: 0pt; padding-right: 2em; padding-top: 0pt; padding-bottom: 0pt;}");
        this.writeliteralln(".displaylist { display: block; list-style-type: none; }");
        this.writeliteralln(".inlinelist { display: inline; }");
        this.writeliteralln("dl.inlinetitle dt { display: inline-block; margin-left: 0; margin-right: 1em;}");
        this.writeliteralln("dl.inlinetitle dd { display: inline; margin: 0; }");
        this.writeliteralln("dl.inlinetitle dd::after { display: block; content: ''; }");
        this.writeliteralln("dl.inlineblock dt { display: inline-block; margin-left: 0; margin-right: 1em;}");
        this.writeliteralln("dl.inlineblock dd { display: inline; margin: 0; }");
        this.writeliteralln("dl.inlineblock dd::after { display: block; content: ''; }");
        this.writeliteralln(".clearfix::after { content: \"\"; clear: both; display: table; }");
        this.writeliteralln("span.inlineitem { margin-right: .5em; margin-left: .5em; }");
        this.writeliteralln("span.numitem { float: left; margin-left: -3em; text-align: right; min-width: 2.5em; }");
        this.writeliteralln("span.bulletitem { float: left; margin-left: -1em; }");
        this.writeliteralln("span.descitem { font: normal; font-weight: bold; }");
        this.writeliteralln("div.indexspace { min-height: 2ex; }");
        for (String string : this.defaultStyles.keySet()) {
            this.writeliteralln(String.format(".%s {%s}", this.defaultStyles.get(string), string));
        }
        for (String string : this.extraCssStyles) {
            this.writeliteralln(string);
        }
    }

    public void addCssStyle(String string) {
        this.extraCssStyles.add(string);
    }

    public void addToHead(String string) {
        if (this.extraHead == null) {
            this.extraHead = new Vector();
        }
        this.extraHead.add(string);
    }

    protected void writeDocType() throws IOException {
        this.writeliteralln("<!DOCTYPE html>");
    }

    @Override
    public void documentclass(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        super.documentclass(keyValList, string, bl, teXObjectList);
        if (this.parser.getControlSequence("c@chapter") != null) {
            this.putControlSequence(new L2HSection("chapter"));
        }
        this.writeDocType();
        this.writeliteralln("<html>");
        this.writeliteralln("<head>");
        this.writeliteralln(String.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">", this.htmlCharSet.name()));
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibGeneratorName");
        String string2 = "TeX Parser Library";
        if (controlSequence != null) {
            string2 = this.parser.expandToString(controlSequence, teXObjectList);
        }
        if (!string2.isEmpty()) {
            this.writeliteralln(String.format("<meta name=\"generator\" content=\"%s\">", string2));
        }
        if (this.useMathJax()) {
            this.writeMathJaxHeader();
        }
        if (this.extraHead != null) {
            for (String string3 : this.extraHead) {
                this.writeliteralln(string3);
            }
        }
        this.inPreamble = true;
    }

    protected void addMathJaxCommands() {
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textstyle")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("displaystyle")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("text")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mbox")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textrm")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textsf")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("texttt")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textbf")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textmd")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textit")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textsl")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textup")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("textsc")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathrm")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathsf")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathtt")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathit")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathbf")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathcal")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathbb")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("mathfrak")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("boldsymbol")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("pmb")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence(" ")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("_")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence(",")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence(";")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence(":")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("!")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("{")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("}")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("&")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("#")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("%")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence(">")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("|")));
        this.putControlSequence(new L2HMathJaxCommand(this.getControlSequence("$")));
    }

    @Override
    public void beginDocument(TeXObjectList teXObjectList) throws IOException {
        Object object;
        this.inPreamble = false;
        ControlSequence controlSequence = this.getControlSequence("@title");
        if (!(controlSequence instanceof Undefined) && !controlSequence.isEmpty()) {
            object = TeXParserUtils.expandFully(controlSequence, this.parser, teXObjectList);
            this.writeliteral("<title>");
            this.write(object.purified());
            this.writeliteralln("</title>");
        } else {
            this.writeliteralln("<!-- no title found -->");
        }
        this.writeliteralln("<style type=\"text/css\">");
        this.writeCssStyles();
        this.writeliteralln("</style>");
        this.writeliteralln("</head>");
        this.writeliteral("<body");
        object = this.getParser().getSettings().getFgColor();
        Color color = this.getParser().getSettings().getBgColor();
        if (object != null && object != Color.BLACK) {
            this.writeliteral(String.format(" text=\"%s\"", this.getHtmlColor((Color)object)));
        }
        if (color != null && color != Color.WHITE) {
            this.writeliteral(String.format(" background=\"%s\"", this.getHtmlColor(color)));
        }
        this.writeliteralln(">");
        super.beginDocument(teXObjectList);
        if (this.useMathJax()) {
            this.addMathJaxCommands();
        }
        this.writeliteralln("<div id=\"main\">");
        this.getParser().getSettings().setCharMapMode(1);
    }

    @Override
    public void endDocument(TeXObjectList teXObjectList) throws IOException {
        if (!this.isInDocEnv()) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.no_begin_doc", new Object[0]);
        }
        if (this.currentSection != null) {
            this.writeliteral(String.format("%n</section><!-- end of section %s -->%n", this.currentSection));
            this.currentSection = null;
        }
        this.processFootnotes(teXObjectList);
        this.writeliteralln("</div><!-- end of main -->");
        ControlSequence controlSequence = this.parser.getControlSequence("@enddocumenthook");
        if (controlSequence != null) {
            try {
                TeXParserUtils.process(controlSequence, this.parser, teXObjectList);
            }
            catch (IOException iOException) {
                this.getParser().error(iOException);
            }
        }
        this.writeliteralln("</body>");
        this.writeliteralln("</html>");
        this.documentEnded = true;
        this.writer.close();
        throw new EOFException();
    }

    @Override
    public void addFootnote(TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (this.footnoteWriter == null) {
            this.footnoteWriter = new StringWriter();
        } else {
            this.footnoteWriter.write("<p>");
        }
        try {
            this.currentWriter = this.footnoteWriter;
            TeXParserUtils.process(teXObject, this.getParser(), teXObjectList);
        }
        finally {
            this.currentWriter = this.writer;
        }
    }

    @Override
    public void processFootnotes(TeXObjectList teXObjectList) throws IOException {
        if (this.footnoteWriter != null) {
            this.doFootnoteRule();
            this.writer.write(this.footnoteWriter.toString());
        }
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (this.useMathJax()) {
            if (teXObject != null || teXObject2 != null) {
                this.writeliteral("\\left");
                this.write(teXObject == null ? "." : teXObject.toString(this.getParser()));
            }
            this.writeliteral("\\frac{");
            teXObject3.process(this.getParser());
            this.writeliteral("}{");
            teXObject4.process(this.getParser());
            this.writeliteral("}");
            if (teXObject != null || teXObject2 != null) {
                this.writeliteral("\\right");
                this.write(teXObject2 == null ? "." : teXObject2.toString(this.getParser()));
            }
            return;
        }
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        this.writeliteral("<table style=\"display: inline;\"><tr style=\"border-bottom-style: solid;\"><td>");
        teXObject3.process(this.parser);
        this.writeliteral("</td></tr>");
        this.writeliteral("<tr><td>");
        teXObject4.process(this.parser);
        this.writeliteral("</td></tr><table>");
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (this.useMathJax()) {
            this.write(teXObject3.toString(this.getParser()));
            this.writeliteral("\\abovewithdelims ");
            this.write(teXObject == null ? "." : teXObject.toString(this.getParser()));
            this.write(teXObject2 == null ? "." : teXObject2.toString(this.getParser()));
            this.write(teXDimension.toString(this.getParser()));
            this.write(teXObject4.toString(this.getParser()));
            return;
        }
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        this.writeliteral("<table><tr><td>");
        teXObject3.process(this.parser);
        this.writeliteral("</td></tr>");
        this.writeliteral("<tr><td>");
        teXObject4.process(this.parser);
        this.writeliteral("</td></tr><table>");
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        if (this.useMathJax()) {
            this.writeliteral("_{");
            teXObject.process(this.parser);
            this.writeliteral("}");
        } else {
            this.writeliteral("<sub>");
            teXObject.process(this.parser);
            this.writeliteral("</sub>");
        }
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        if (this.useMathJax()) {
            this.writeliteral("^{");
            teXObject.process(this.parser);
            this.writeliteral("}");
        } else {
            this.writeliteral("<sup>");
            teXObject.process(this.parser);
            this.writeliteral("</sup>");
        }
    }

    public void verb(String string, boolean bl, char c, String string2) throws IOException {
        this.writeliteral("<code style=\"white-space: pre;\">");
        super.verb(string, bl, c, string2);
        this.writeliteral("</code>");
    }

    @Override
    public void beginVerbatim() throws IOException {
        this.writeliteral("<pre>");
    }

    @Override
    public void endVerbatim() throws IOException {
        this.writeliteral("</pre>");
    }

    public String getImagePreamble() throws IOException {
        Object object;
        String string = null;
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibToImagePreamble");
        if (controlSequence != null && controlSequence instanceof Expandable && (object = ((Expandable)((Object)controlSequence)).expandonce(this.parser)) != null) {
            string = ((TeXObjectList)object).toString(this.parser);
        }
        if (string == null) {
            object = this.getDocumentClass();
            StringBuilder stringBuilder = new StringBuilder();
            if (object == null) {
                stringBuilder.append("\\documentclass{article}");
            } else {
                stringBuilder.append("\\documentclass");
                KeyValList keyValList = ((LaTeXFile)object).getOptions();
                if (keyValList != null) {
                    stringBuilder.append(String.format("[%s]", keyValList.format()));
                }
                stringBuilder.append(String.format("{%s}%n", ((LaTeXFile)object).getName()));
            }
            for (LaTeXFile laTeXFile : this.getLoadedPackages()) {
                stringBuilder.append("\\usepackage");
                KeyValList keyValList = laTeXFile.getOptions();
                if (keyValList != null) {
                    stringBuilder.append(String.format("[%s]", keyValList.format()));
                }
                stringBuilder.append(String.format("{%s}%n", laTeXFile.getName()));
            }
            stringBuilder.append("\\pagestyle{empty}%n");
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String getMimeType(String string) {
        int n = string.lastIndexOf(".") + 1;
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n).toLowerCase();
        if (string2.equals("pdf")) {
            return MIME_TYPE_PDF;
        }
        if (string2.equals("png")) {
            return MIME_TYPE_PNG;
        }
        if (string2.equals("jpeg") || string2.equals("jpg")) {
            return MIME_TYPE_JPEG;
        }
        return null;
    }

    public Dimension getImageSize(File file, String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void includegraphics(TeXObjectList teXObjectList, KeyValList keyValList, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        File file = this.getImageFile(string);
        if (file == null || !file.exists()) {
            throw new TeXSyntaxException(this.parser, "tex.error.file.not.found", string);
        }
        Path path = file.toPath();
        Path path2 = path.startsWith(this.basePath) ? this.basePath.relativize(path) : (path.isAbsolute() ? path.getName(path.getNameCount() - 1) : path);
        TeXObject teXObject = null;
        String string2 = null;
        String string3 = null;
        String string4 = L2HConverter.getMimeType(file.getName());
        L2HImage l2HImage = null;
        double d = 1.0;
        int n = 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (keyValList != null) {
            object3 = keyValList.getOrderedKeyIterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = (TeXObject)keyValList.get(object2);
                if (((String)object2).equals("alt")) {
                    teXObject = object;
                    continue;
                }
                if (((String)object2).equals("class")) {
                    string2 = this.parser.expandToString((TeXObject)object, teXObjectList);
                    continue;
                }
                if (((String)object2).equals("style")) {
                    string3 = this.parser.expandToString((TeXObject)object, teXObjectList);
                    continue;
                }
                if (((String)object2).equals("scale")) {
                    if (object == null) continue;
                    d = TeXParserUtils.toDouble((TeXObject)object, this.parser, teXObjectList);
                    continue;
                }
                if (((String)object2).equals("zoom")) {
                    if (object == null) continue;
                    n = TeXParserUtils.toInt((TeXObject)object, this.parser, teXObjectList);
                    continue;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append((String)object2);
                if (object == null || object.isEmpty()) continue;
                stringBuilder.append('=');
                stringBuilder.append(object.toString(this.parser));
            }
        }
        if (stringBuilder.length() > 0) {
            object3 = new StringBuilder("\\includegraphics[");
            object2 = null;
            ((StringBuilder)object3).append((CharSequence)stringBuilder);
            ((StringBuilder)object3).append("]{");
            ((StringBuilder)object3).append(string);
            ((StringBuilder)object3).append('}');
            if (this.getParser().isDebugMode(1)) {
                this.getParser().logMessage("Creating image " + ((StringBuilder)object3).toString());
            }
            l2HImage = this.toImage(this.getImagePreamble(), ((StringBuilder)object3).toString(), string4, teXObject, null, true);
        }
        if (l2HImage != null) {
            TeXParserUtils.process(l2HImage, this.parser, teXObjectList);
        } else {
            object3 = this.outPath == null ? path2 : this.outPath.resolve(path2);
            object2 = this.getImageSize(file, string4);
            object = this.getUri(path2);
            if (MIME_TYPE_PDF.equals(string4)) {
                object = (String)object + String.format("?#zoom=%d", n);
            }
            this.writeliteral(String.format("<object data=\"%s\"", object));
            if (string4 != null) {
                this.writeliteral(String.format(" type=\"%s\"", string4));
            }
            if (string2 != null) {
                this.writeliteral(String.format(" class=\"%s\"", string2));
            }
            if (string3 != null) {
                this.writeliteral(String.format(" style=\"%s\"", string3));
            }
            if (object2 != null) {
                this.writeliteral(String.format(" width=\"%d\" height=\"%d\"", (int)Math.round(d * (double)((Dimension)object2).width), (int)Math.round(d * (double)((Dimension)object2).height)));
            }
            this.writeliteral(">");
            try {
                if (teXObject != null) {
                    TeXParserUtils.process(teXObject, this.parser, teXObjectList);
                }
            }
            finally {
                this.writeliteral("</object>");
            }
            try {
                this.getTeXApp().copyFile(file, object3.toFile());
            }
            catch (InterruptedException interruptedException) {
                this.getParser().error(interruptedException);
            }
        }
    }

    protected void writeTransform(String string, String string2) throws IOException {
        this.writeTransform(string, string2, null);
    }

    protected void writeTransform(String string, String string2, String string3) throws IOException {
        this.writeliteral(String.format("<%s style=\"display: inline-block; transform: %s; -ms-transform: %s; -webkit-transform: %s;", string, string2, string2, string2));
        if (string3 != null) {
            this.writeliteral(String.format(" transform-origin: %s; -ms-transform-origin: %s; -webkit-transform-origin: %s;", string3, string3, string3));
        }
        this.writeliteral("\">");
    }

    public void transform(String string, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.writeTransform("div", string);
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        this.writeliteral("</div>");
    }

    @Override
    public void rotate(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void rotate(double d, double d2, double d3, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (d2 == 0.0 && d3 == 0.0) {
            this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
        } else {
            this.transform(String.format("rotate(%fdeg)", -d, String.format("%d%% %d%%", d2, d3)), teXParser, teXObjectList, teXObject);
        }
    }

    @Override
    public void rotate(double d, TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXDimension == null && teXDimension == null) {
            this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
        } else {
            String string = "0%";
            String string2 = "0%";
            if (teXDimension != null) {
                string = String.format("%f%s", teXDimension.format());
            }
            if (teXDimension2 != null) {
                string2 = String.format("%f%s", teXDimension2.format());
            }
            this.transform(String.format("rotate(%fdeg)", -d, String.format("%s %s", string, string2)), teXParser, teXObjectList, teXObject);
        }
    }

    @Override
    public void scale(double d, double d2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scale(%f,%f)", d, d2), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void scaleX(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scaleX(%f)", d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void scaleY(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scaleY(%f)", d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void resize(TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.writeliteral("<div style=\"display: inline-block;");
        if (teXDimension != null) {
            this.writeliteral(String.format(" width: %s;", this.getHtmlDimension(teXDimension)));
        }
        if (teXDimension2 != null) {
            this.writeliteral(String.format(" height: %s;", this.getHtmlDimension(teXDimension2)));
        }
        this.writeliteral("\">");
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        this.writeliteral("</div>");
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        File file2;
        this.getParser().message("message.reading", file);
        if (charset != null) {
            this.getParser().message("message.charset", charset);
        }
        if ((file2 = file.getParentFile()) == null) {
            file2 = new File(".");
        }
        this.basePath = file2.toPath();
        if (this.writer == null) {
            Files.createDirectories(this.outPath, new FileAttribute[0]);
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n > -1) {
                string = string.substring(0, n);
            }
            File file3 = new File(this.outPath.toFile(), string + "." + this.getSuffix());
            this.getParser().message("message.writing", file3);
            this.getParser().message("message.charset", this.htmlCharSet);
            this.writer = new PrintWriter(Files.newBufferedWriter(file3.toPath(), this.htmlCharSet, new OpenOption[0]));
        }
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new L2HUndefined(string, this.getUndefinedAction());
    }

    @Override
    public ActiveChar getUndefinedActiveChar(int n) {
        return new UndefinedActiveChar(n, this.getUndefinedAction());
    }

    @Override
    public void marginpar(TeXObject teXObject, TeXObject teXObject2) throws IOException {
        this.writeliteral("<div class=\"margin");
        try {
            if (this.isMarginRight()) {
                this.writeliteral("right\">");
                teXObject2.process(this.parser);
            } else {
                this.writeliteral("left\">");
                teXObject.process(this.parser);
            }
        }
        finally {
            this.writeliteral("</div>");
        }
    }

    @Override
    public void doFootnoteRule() throws IOException {
        this.writeliteralln("<p><hr><p>");
    }

    @Override
    public IndexLocation createIndexLocation(String string) throws IOException {
        ++this.indexLoc;
        String string2 = String.format("idx-%s-%d", HtmlTag.getUriFragment(string), this.indexLoc);
        this.writeliteral(String.format("<a id=\"%s\"></a>", string2));
        return new IndexLocation(new HtmlTag(String.format("<a ref=\"#%s\">%d</a>", string2, this.indexLoc)));
    }

    @Override
    public void registerControlSequence(LaTeXSty laTeXSty, ControlSequence controlSequence) {
        this.styCs.add(controlSequence.getName());
        this.putControlSequence(controlSequence);
    }

    public boolean isStyControlSequence(ControlSequence controlSequence) {
        return this.styCs.contains(controlSequence.getName());
    }

    @Override
    public void startList(TrivListDec trivListDec) throws IOException {
        super.startList(trivListDec);
        if (trivListDec instanceof DescriptionDec) {
            switch (((DescriptionDec)trivListDec).getStyle()) {
                case INLINE_TITLE: {
                    this.writeliteral(String.format("%n<dl class=\"inlinetitle\">%n", new Object[0]));
                    break;
                }
                case INLINE_BLOCK_TITLE: {
                    this.writeliteral(String.format("%n<dl class=\"inlineblock\">%n", new Object[0]));
                    break;
                }
                default: {
                    this.writeliteral(String.format("%n<dl>%n", new Object[0]));
                    break;
                }
            }
        } else if (trivListDec.isInLine()) {
            this.writeliteral("<div class=\"inlinelist\">");
        } else if (this.isIfTrue(this.getControlSequence("if@nmbrlist"))) {
            this.writeliteral(String.format("%n<ol class=\"displaylist\">%n", new Object[0]));
        } else {
            this.writeliteral(String.format("%n<ul class=\"displaylist\">%n", new Object[0]));
        }
    }

    @Override
    public void endList(TrivListDec trivListDec) throws IOException {
        if (trivListDec instanceof DescriptionDec) {
            this.writeliteral(String.format("%n</dl>%n", new Object[0]));
        } else if (trivListDec.isInLine()) {
            this.writeliteral("</div>");
        } else if (this.isIfTrue(this.getControlSequence("if@nmbrlist"))) {
            this.writeliteral(String.format("%n</ol>%n", new Object[0]));
        } else {
            this.writeliteral(String.format("%n</ul>%n", new Object[0]));
        }
        super.endList(trivListDec);
    }

    public String getHtmlColor(Color color) {
        if (color == Color.BLACK) {
            return "black";
        }
        if (color == Color.BLUE) {
            return "blue";
        }
        if (color == Color.CYAN) {
            return "cyan";
        }
        if (color == Color.GRAY) {
            return "gray";
        }
        if (color == Color.GREEN) {
            return "green";
        }
        if (color == Color.MAGENTA) {
            return "magenta";
        }
        if (color == Color.ORANGE) {
            return "orange";
        }
        if (color == Color.PINK) {
            return "pink";
        }
        if (color == Color.RED) {
            return "red";
        }
        if (color == Color.WHITE) {
            return "white";
        }
        if (color == Color.YELLOW) {
            return "yellow";
        }
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    public String getHtmlDimension(TeXDimension teXDimension) throws IOException {
        float f = teXDimension.getValue();
        TeXUnit teXUnit = teXDimension.getUnit();
        if (teXUnit instanceof FixedUnit) {
            int n = ((FixedUnit)teXUnit).getId();
            switch (n) {
                case 2: 
                case 4: 
                case 5: {
                    return String.format("%f%s", Float.valueOf(f), FixedUnit.UNIT_NAMES[n]);
                }
                case 3: {
                    return String.format("%fpt", Float.valueOf(f));
                }
            }
        } else {
            if (teXUnit == TeXUnit.EM) {
                return String.format("%fem", Float.valueOf(f));
            }
            if (teXUnit == TeXUnit.EX) {
                return String.format("%fex", Float.valueOf(f));
            }
            if (teXUnit instanceof PercentUnit) {
                return String.format("%f%%", Float.valueOf(f * 100.0f));
            }
        }
        return String.format("%fpt", Float.valueOf(teXUnit.toUnit(this.getParser(), f, TeXUnit.BP)));
    }

    public String getUri(Path path) {
        String string;
        if (path.isAbsolute()) {
            return path.toUri().toString();
        }
        int n = path.getNameCount();
        if (n == 1) {
            string = path.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(path.getName(0).toString());
            for (int i = 1; i < n; ++i) {
                stringBuilder.append('/');
                stringBuilder.append(path.getName(i).toString());
            }
            string = stringBuilder.toString();
        }
        try {
            return new URI(string).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.getParser().error(uRISyntaxException);
            return string;
        }
    }

    @Override
    public void startColor(Color color, boolean bl) throws IOException {
        if (this.isInDocEnv()) {
            this.writeliteral("<span style=\"");
            if (bl) {
                this.writeliteral("color: ");
            } else {
                this.writeliteral("background-color: ");
            }
            this.writeliteral(String.format(" %s\">", this.getHtmlColor(color)));
        }
    }

    @Override
    public void endColor(boolean bl) throws IOException {
        if (this.isInDocEnv()) {
            this.writeliteral("</span>");
        }
    }

    protected String getElementTag(FrameBox frameBox) {
        TeXFontText teXFontText = frameBox.getTextFont();
        if (frameBox.isInLine() && !frameBox.isMultiLine()) {
            if (teXFontText != null && teXFontText.getFamily() == TeXFontFamily.VERB) {
                return "code";
            }
            if (teXFontText != null && teXFontText.getWeight() == TeXFontWeight.STRONG) {
                return "strong";
            }
            if (teXFontText != null && teXFontText.getShape() == TeXFontShape.EM) {
                return "em";
            }
            return "span";
        }
        if (teXFontText != null && teXFontText.getFamily() == TeXFontFamily.VERB) {
            return "pre";
        }
        return "div";
    }

    @Override
    public void declareFrameBox(FrameBox frameBox, boolean bl) {
        super.declareFrameBox(frameBox, bl);
        if (!frameBox.isStyleChangeable()) {
            try {
                String string = this.getFrameBoxSpecs(frameBox);
                String string2 = String.format("%s.%s {%s}", this.getElementTag(frameBox), frameBox.getId(), string);
                if (this.isInDocEnv()) {
                    this.writeliteral(String.format("<style>%s</style>", string2));
                } else {
                    this.addCssStyle(string2);
                }
            }
            catch (IOException iOException) {
                this.getParser().warning(iOException);
            }
        }
    }

    protected String getFrameBoxSpecs(FrameBox frameBox) throws IOException {
        Angle angle;
        TeXDimension teXDimension;
        TeXDimension teXDimension2;
        TeXDimension teXDimension3;
        TeXDimension teXDimension4;
        TeXDimension teXDimension5;
        boolean bl = frameBox.isInLine() && frameBox.isMultiLine();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getElementTag(frameBox);
        TeXFontText teXFontText = frameBox.getTextFont();
        if (teXFontText != null) {
            stringBuilder.append(teXFontText.getCss(this.getParser()));
        }
        switch (frameBox.getFloatStyle()) {
            case LEFT: {
                stringBuilder.append("float: left; ");
                break;
            }
            case RIGHT: {
                stringBuilder.append("float: right; ");
            }
        }
        switch (frameBox.getHAlign()) {
            case LEFT: {
                stringBuilder.append("text-align: left; ");
                break;
            }
            case CENTER: {
                stringBuilder.append("text-align: center; ");
                break;
            }
            case RIGHT: {
                stringBuilder.append("text-align: right; ");
            }
        }
        switch (frameBox.getVAlign()) {
            case TOP: {
                stringBuilder.append("vertical-align: top; ");
                break;
            }
            case MIDDLE: {
                stringBuilder.append("vertical-align: middle; ");
                break;
            }
            case BOTTOM: {
                stringBuilder.append("vertical-align: bottom; ");
                break;
            }
            case BASE: {
                stringBuilder.append("vertical-align: base; ");
            }
        }
        switch (frameBox.getStyle()) {
            case NONE: {
                stringBuilder.append("border-style: none; ");
                break;
            }
            case SOLID: {
                stringBuilder.append("border-style: solid; ");
                break;
            }
            case DOUBLE: {
                stringBuilder.append("border-style: double; ");
                break;
            }
            case DOTTED: {
                stringBuilder.append("border-style: dotted; ");
                break;
            }
            case DASHED: {
                stringBuilder.append("border-style: dashed; ");
                break;
            }
            case GROOVE: {
                stringBuilder.append("border-style: groove; ");
                break;
            }
            case RIDGE: {
                stringBuilder.append("border-style: ridge; ");
                break;
            }
            case INSET: {
                stringBuilder.append("border-style: inset; ");
                break;
            }
            case OUTSET: {
                stringBuilder.append("border-style: outset; ");
            }
        }
        Color color = frameBox.getBorderColor(this.getParser());
        if (color != null) {
            stringBuilder.append(String.format("border-color: %s; ", this.getHtmlColor(color)));
        }
        if (frameBox.getStyle() != BorderStyle.NONE && (teXDimension5 = frameBox.getBorderWidth(this.getParser())) != null) {
            stringBuilder.append(String.format("border-width: %s; ", this.getHtmlDimension(teXDimension5)));
        }
        if ((teXDimension5 = frameBox.getInnerMargin(this.getParser())) != null) {
            stringBuilder.append(String.format("padding: %s; ", this.getHtmlDimension(teXDimension5)));
        }
        if ((teXDimension4 = frameBox.getOuterMarginLeft(this.getParser())) != null) {
            stringBuilder.append(String.format("margin-left: %s; ", this.getHtmlDimension(teXDimension4)));
        }
        if ((teXDimension4 = frameBox.getOuterMarginRight(this.getParser())) != null) {
            stringBuilder.append(String.format("margin-right: %s; ", this.getHtmlDimension(teXDimension4)));
        }
        if ((teXDimension4 = frameBox.getOuterMarginTop(this.getParser())) != null) {
            stringBuilder.append(String.format("margin-top: %s; ", this.getHtmlDimension(teXDimension4)));
        }
        if ((teXDimension4 = frameBox.getOuterMarginBottom(this.getParser())) != null) {
            stringBuilder.append(String.format("margin-bottom: %s; ", this.getHtmlDimension(teXDimension4)));
        }
        if ((teXDimension3 = frameBox.getBorderRadius(this.getParser())) != null) {
            stringBuilder.append(String.format("border-radius: %s;", this.getHtmlDimension(teXDimension3)));
        }
        if ((color = frameBox.getForegroundColor(this.getParser())) != null) {
            stringBuilder.append(String.format("color: %s; ", this.getHtmlColor(color)));
        }
        if ((color = frameBox.getBackgroundColor(this.getParser())) != null) {
            stringBuilder.append(String.format("background-color: %s; ", this.getHtmlColor(color)));
        }
        if ((teXDimension2 = frameBox.getWidth(this.getParser())) != null) {
            if (frameBox.isInLine()) {
                bl = true;
            }
            stringBuilder.append(String.format("width: %s; ", this.getHtmlDimension(teXDimension2)));
            if (frameBox.isMultiLine()) {
                stringBuilder.append("overflow: auto; ");
            }
        }
        if ((teXDimension = frameBox.getHeight(this.getParser())) != null) {
            if (frameBox.isInLine()) {
                bl = true;
            }
            stringBuilder.append(String.format("height: %s; ", this.getHtmlDimension(teXDimension)));
        }
        if ((angle = frameBox.getAngle(this.parser)) != null) {
            String string2 = String.format("rotate(%fdeg)", angle.toDegrees());
            stringBuilder.append(String.format("transform: %s; ", string2));
            stringBuilder.append(String.format("-ms-transform: %s; ", string2));
            stringBuilder.append(String.format("-webkit-transform: %s; ", string2));
            bl = true;
        }
        if (bl) {
            stringBuilder.append("display: inline-block; ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void startFrameBox(FrameBox frameBox) throws IOException {
        String string = this.getElementTag(frameBox);
        this.writeliteral(String.format("<%s ", string));
        if (this.getDeclaredFrameBox(frameBox.getId()) == null) {
            String string2 = this.getFrameBoxSpecs(frameBox);
            String string3 = this.defaultStyles.get(string2);
            if (string3 == null) {
                this.writeliteral(String.format("style=\"%s\"", string2));
            } else if (!frameBox.isInLine() && frameBox.isMultiLine()) {
                this.writeliteral(String.format("class=\"%s clearfix\"", string3));
            } else {
                this.writeliteral(String.format("class=\"%s\"", string3));
            }
        } else {
            this.writeliteral(String.format("class=\"%s\"", frameBox.getId()));
        }
        this.writeliteral(">");
    }

    @Override
    public void endFrameBox(FrameBox frameBox) throws IOException {
        String string = this.getElementTag(frameBox);
        this.writeliteral(String.format("</%s>", string));
        if (frameBox.getFloatStyle() != FloatBoxStyle.NONE) {
            this.writeliteral("<span class=\"clearfix\"></span>");
        }
        if (string.equals("div") && !frameBox.isInLine() && !this.getParser().getSettings().inVerb()) {
            this.writeliteralln(String.format("<!-- end of %s -->", frameBox.getId()));
        }
    }

    @Override
    public void startTheorem(String string) throws IOException {
        this.writeliteral("<div class=\"");
        this.writeliteral(string);
        this.writeliteral("\">");
    }

    @Override
    public void endTheorem(String string) throws IOException {
        this.writeliteral(String.format("</div><!-- end of %s -->", string));
    }

    public HtmlTag createLinkBox(String string) {
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibLinkName");
        String string2 = "[link]";
        if (controlSequence instanceof Expandable && controlSequence.canExpand()) {
            try {
                string2 = this.parser.expandToString(controlSequence, this.parser);
            }
            catch (IOException iOException) {
                this.getParser().error(iOException);
            }
        }
        return new HtmlTag(String.format("<div class=\"labellink\"><a href=\"#%s\">%s</a></div>", string, string2));
    }

    public void startSection(boolean bl, String string, String string2, String string3, TeXObjectList teXObjectList) throws IOException {
        if (this.currentSection != null) {
            this.writeliteral(String.format("%n</section><!-- end of section %s -->%n", this.currentSection));
        }
        if (string3 == null) {
            this.currentSection = string + "-" + string2;
            this.writeliteral(String.format("%n<section><!-- start of section %s -->", this.currentSection));
        } else {
            this.currentSection = string3;
            this.writeliteral(String.format("%n<section id=\"%s\"><!-- start of section %s -->", string3, this.currentSection));
        }
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibToTopName");
        String string4 = "[top]";
        if (controlSequence != null) {
            string4 = this.parser.expandToString(controlSequence, teXObjectList);
        }
        this.writeliteral(String.format("<div class=\"tomain\"><a href=\"#main\">%s</a></div>", string4));
    }

    @Override
    public TeXObject getAnchor(String string) {
        TeXObjectList teXObjectList = this.createStack();
        StartElement startElement = new StartElement("a");
        startElement.putAttribute("id", string);
        teXObjectList.add(startElement);
        teXObjectList.add(new EndElement("a"));
        return teXObjectList;
    }

    protected void addDefaultTabularStyles() throws IOException {
        Register register = this.parser.getSettings().getRegister("tabcolsep");
        if (register == null || !(register instanceof DimenRegister)) {
            throw new TeXSyntaxException(this.parser, "tex.error.dimen_expected", String.format("%stabcolsep", new String(Character.toChars(this.parser.getEscChar()))));
        }
        TeXDimension teXDimension = ((DimenRegister)register).getDimension();
        if (teXDimension instanceof TeXGlue) {
            teXDimension = ((TeXGlue)teXDimension).getFixed();
        }
        String string = teXDimension.format();
        HashMap<String, String> hashMap = this.createCellCss("center");
        this.addDefaultStyle("cell-noborder-nosep-c", hashMap);
        hashMap = this.createCellCss("right");
        this.addDefaultStyle("cell-noborder-nosep-r", hashMap);
        hashMap = this.createCellCss("left");
        this.addDefaultStyle("cell-noborder-nosep-l", hashMap);
        hashMap = this.createCellCss("center");
        hashMap.put("padding-right", string);
        this.addDefaultStyle("cell-noborder-rightsep-c", hashMap);
        hashMap = this.createCellCss("center");
        hashMap.put("padding-left", string);
        this.addDefaultStyle("cell-noborder-rightsep-c", hashMap);
        hashMap = this.createCellCss("center");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        this.addDefaultStyle("cell-noborder-bothsep-c", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-right", string);
        this.addDefaultStyle("cell-noborder-rightsep-l", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-left", string);
        this.addDefaultStyle("cell-noborder-rightsep-l", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        this.addDefaultStyle("cell-noborder-bothsep-l", hashMap);
        hashMap = this.createCellCss("right");
        hashMap.put("padding-right", string);
        this.addDefaultStyle("cell-noborder-rightsep-r", hashMap);
        hashMap = this.createCellCss("right");
        hashMap.put("padding-left", string);
        this.addDefaultStyle("cell-noborder-leftsep-r", hashMap);
        hashMap = this.createCellCss("right");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        this.addDefaultStyle("cell-noborder-bothsep-r", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        hashMap.put("width", "50.000000%");
        this.addDefaultStyle("cell-noborder-bothsep-halfwidth", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        hashMap.put("width", "25.000000%");
        this.addDefaultStyle("cell-noborder-bothsep-quarterwidth", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        hashMap.put("width", "75.000000%");
        this.addDefaultStyle("cell-noborder-bothsep-threequarterwidth", hashMap);
        hashMap = this.createCellCss("left");
        hashMap.put("padding-left", string);
        hashMap.put("padding-right", string);
        hashMap.put("width", "80.000000%");
        this.addDefaultStyle("cell-noborder-bothsep-eightypc", hashMap);
    }

    protected HashMap<String, String> createCellCss(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("padding-left", "0px");
        hashMap.put("padding-right", "0px");
        hashMap.put("text-align", string);
        hashMap.put("border-left", "none");
        hashMap.put("border-right", "none");
        hashMap.put("border-top", "none");
        return hashMap;
    }

    public void addDefaultStyle(String string, HashMap<String, String> hashMap) throws IOException {
        if (this.defaultStyleMaps == null) {
            this.defaultStyleMaps = new HashMap();
        }
        this.defaultStyleMaps.put(hashMap, string);
        String string2 = this.cssAttributesToString(hashMap);
        this.defaultStyles.put(string2, string);
        if (this.isInDocEnv()) {
            this.writeliteral(String.format("<style>%s: {%s}</style>", string, string2));
        }
    }

    public String getCssClass(HashMap<String, String> hashMap) {
        if (hashMap == null || hashMap.isEmpty()) {
            return null;
        }
        if (this.defaultStyleMaps != null) {
            return this.defaultStyleMaps.get(hashMap);
        }
        return null;
    }

    public String getStyleOrClass(HashMap<String, String> hashMap) {
        if (hashMap == null || hashMap.isEmpty()) {
            return "";
        }
        String string = this.getCssClass(hashMap);
        if (string != null) {
            return String.format(" class=\"%s\"", string);
        }
        return String.format(" style=\"%s\"", this.cssAttributesToString(hashMap));
    }

    public String cssAttributesToString(HashMap<String, String> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : hashMap.keySet()) {
            stringBuilder.append(String.format("%s: %s; ", string, hashMap.get(string)));
        }
        return stringBuilder.toString();
    }
}

