/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import org.zeroturnaround.exec.ProcessOutput;

public class ProcessResult {
    private final int exitValue;
    private final ProcessOutput output;

    public ProcessResult(int exitCode, ProcessOutput output2) {
        this.exitValue = exitCode;
        this.output = output2;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public int exitValue() {
        return this.getExitValue();
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public ProcessOutput getOutput() {
        if (this.output == null) {
            throw new IllegalStateException("Process output was not read. To enable output reading please call ProcessExecutor.readOutput(true) before starting the process.");
        }
        return this.output;
    }

    public byte[] output() {
        return this.getOutput().getBytes();
    }

    public String outputString() {
        return this.getOutput().getString();
    }

    public String outputUTF8() {
        return this.getOutput().getUTF8();
    }

    public String outputString(String charset) {
        return this.getOutput().getString(charset);
    }
}

