#include <windows.h>
#include <ddeml.h>
#include <string.h>
#include <process.h>
#include <stdio.h>

DWORD DDEInst = 0;
HSZ hszDviout;
HSZ hszTopic;
DWORD hTransaction = 0;
HCONV hConv = NULL;

char ServiceName[] = "dviout";
char TopicName[] = "dviout";

void Connect( void );
void Disconnect( void );
void DoClientTransaction( LPSTR Data );

HDDEDATA CALLBACK DdeCallback( UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1,
			      HSZ hsz2, HDDEDATA hdata, DWORD dwData1,
			      DWORD dwData2 );	

int main(void)
{
   char Data[] ="[FileOpen(e:\\tmp\\xxx\\ipctst.dvi)]";
   DDEInst = 0;
   DdeInitialize((LPDWORD) &DDEInst, (PFNCALLBACK) DdeCallback,
		 APPCMD_CLIENTONLY, 0L);
   hszDviout = DdeCreateStringHandle( DDEInst, ServiceName, CP_WINANSI );
   Connect();
   DoClientTransaction( Data );
   Disconnect();
   return 0;
}


HDDEDATA CALLBACK DdeCallback( UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1,
			      HSZ hsz2, HDDEDATA hdata, DWORD dwData1,
			      DWORD dwData2 )
{
  return 0;
}

void DoClientTransaction( LPSTR Data )
{
  UINT DataLen = 0;

  if ( hTransaction ) DdeAbandonTransaction( DDEInst, hConv, hTransaction );

  if ( Data ) DataLen = strlen(Data) + 1;

  if (  !DdeClientTransaction( Data, DataLen, hConv, 0, 0,
		XTYP_EXECUTE, TIMEOUT_ASYNC, &hTransaction ) )
    {
      fprintf(stderr,"Transaction not accepted\n");
      hTransaction = 0;
    }
}

void Disconnect( void )
{
  if ( !hConv ) return;

  if ( hTransaction ) DdeAbandonTransaction( DDEInst, hConv, hTransaction );
  hTransaction = 0;
  DdeDisconnect( hConv );
  hConv = 0;
}

void Connect( void )
{
  if ( hConv ) return;

  Disconnect();
  hszTopic = DdeCreateStringHandle( DDEInst, TopicName, CP_WINANSI );
  if(!hszTopic) {
    fprintf(stderr, "StringHandle not created.\n");
  }
  hConv = DdeConnect( DDEInst, hszDviout, hszTopic, NULL );
  if(!hConv) {
    spawnlp(P_NOWAIT,"dviout", "dviout", NULL);
    Sleep(500);
    hConv = DdeConnect( DDEInst, hszDviout, hszTopic, NULL );
  }
  if(!hConv) {
    fprintf(stderr,"Not connected.\n");
  }
  DdeFreeStringHandle( DDEInst, hszTopic );
}
