#include <stdio.h>

# define D(N,M,I,C)
# define S(N,S) #S,

static char *special_tbl[] = {
# include "key.def"
};

# undef D
# undef S

int main(void)
{
  int i;
  static unsigned tbl[256];
  static char *names[256];

  enum { FK, CTRL_FK, SHIFT_FK, ALT_FK, SPECIAL, CTRL_SPECIAL, ALT_CH, ALT_N };
  enum { A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z };  

# define D(Name, Cat, Index, Code) \
	tbl[((unsigned)Code)>>8] = (Cat << 5) | Index; \
	names[((unsigned)Code)>>8] = #Name;
# define S(N,S)
# include "key.def"
# undef D
# undef S


  printf("static unsigned char key_feature_tbl[] = {\n  ");
  for (i = 0x10; i <= 0x84; ++i) {
    if (names[i])
      printf("0x%02x\t/*%s*/,\n  ", tbl[i], names[i]);
    else {
      printf("0,");
      if (names[i+1]) printf("\n  ");
    }
  }
  printf("};\n");

  printf("static char *special_tbl[] = {\n  ");
  for (i = 0; i < sizeof special_tbl/sizeof special_tbl[0]; ++i)
    printf("%s,", special_tbl[i]);
  printf("\n};\n");

  return 0;
}
