/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/mst.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __MST_C__

#include "common.h"

#include "global.h"
#include "prf.h"
#include "mst.h"
#include "main.h"
#include "msg.h"
#include "str.h"
#include "fn.h"



int MST_process(PPRF pPrf, PSZ szSourceFileAbs,
                PPSZ pszMasterDocAbs, PPSZ pszMasterDirAbs)
{
PSZ  szLastMasterDocAbs = NULL;
PSZ  szCurSourceFileAbs = NULL;
PSZ  szLineBuf          = NULL;
int  found = 0;

  for(;;)
    {
      if (!PRF_readln(pPrf, &szLineBuf, FAT_READMAST ))
        break;                                                      /* at eof */
      if (STR_is_bracked(szLineBuf))              /* that's a masterdocs name */
        {
          STR_unbrack_string(&szLineBuf);       /* save the absolute path+name */
          FN_MakeAbs(&szLastMasterDocAbs, szLineBuf, (*pPrf)->szAbsPath);
        }
      else
        {                                    /* get the asbsolute path+name    */
                                             /* of filename found in masterfile */
           FN_MakeAbs(&szCurSourceFileAbs, szLineBuf, (*pPrf)->szAbsPath);
           if (!strcmp(szCurSourceFileAbs, szSourceFileAbs))  /* found it ! */
             {
               found = 1;
               break;
             }
        }
     }
  if (found)
    {
      STR_copy_string(pszMasterDocAbs, szLastMasterDocAbs);
      FN_GetDrvPath(pszMasterDirAbs, szLastMasterDocAbs);
    }
  STR_delete_string(&szLineBuf);
  STR_delete_string(&szLastMasterDocAbs);
  STR_delete_string(&szCurSourceFileAbs);
  return found;
}


/*-----------------------------------------------------------------------------
  int MST_resolve(PSZ szMasterFile, PSZ szCurDir, PSZ szSourceFile,
                  PPSZ pszMasterDoc, PPSZ pszMasterDir)
  try to open a masterfile (_master.dat), resolve a masterdoc from masterfile
  and sourcefile. Sets masterdoc and masterdoc's directory if succesfull
  returns: 1 on success, 0 on any error
*/

int MST_resolve(void)
{
int  retcode;
PRF  Profile = NULL;
PSZ  szMasterFileAbs  = NULL;
PSZ  szMasterDoc      = NULL;
PSZ  szMasterDir      = NULL;

   if (!szMasterFile)  return 0;        /* no masterfile... stop */
   if (!*szMasterFile) return 0;

                              /* make Masterfile absolute from document */
   FN_MakeAbs(&szMasterFileAbs, szMasterFile, szCLFileDir);
                              /* open masterfile */
   retcode = PRF_open_file(szMasterFileAbs, &Profile, FAT_NOFATAL );
                              /* resolve */
   if (retcode) retcode = MST_process(&Profile,  szCLFileName,
                                      &szMasterDoc, &szMasterDir);
                              /* close chain of open profiles (masterfile) */
   PRF_close_allfiles(&Profile);
   if (retcode)
     {                        /* success, replace szCLFileName, szCLFileDir */
       STR_copy_string(&szCLFileName, szMasterDoc);
       STR_copy_string(&szCLFileDir, szMasterDir);
     }
   STR_delete_string(&szMasterFileAbs);
   STR_delete_string(&szMasterDoc);
   STR_delete_string(&szMasterDir);
   return retcode;
}

   
/*------------------------------------------------------------------------- */
