/*  <- declarations */
/*
 * These routines decode X Pixmap files. They can handle up to 256 colors.
 *
 * Written by Hippocrates Sendoukas, Athens, November 1994
 */
#define	FILTNAME	"xpm"
#include "common1.c"

/*  -> declarations */
/*  <- fgets */

static int PASCAL NEAR
fgets(char *buf,int bufsize,FILE *f)
{
  int i,c;

  for (i=0; i<bufsize; i++)
    {
      c = getc(f);
      if (c==EOF) break;
      buf[i] = (char) c;
      if (c=='\n')
        {
          if (i>0 && buf[i-1]=='\r') buf[i-1] = '\n';
          else i++;
          break;
        }
    }
  if (i==0) return 0;
  if (i>=bufsize) i = bufsize-1;
  buf[i] = '\0';
  return 1;
}

/*  -> fgets */
/*  <- xpm_readline */

static int PASCAL NEAR
xpm_readline(FILE *f,Uns8 *buf,unsigned nx,Uns8 code_ind[])
{
  unsigned	j;
  int		c;

  for (j=0; j<nx; j++)
    {
      if ( (c=getc(f)) == EOF ) return 0;
      if (c=='\r' || c=='\n')
        {
          if (c=='\r') getc(f);
          memset(buf+j,code_ind[' '],nx-j);
          return 1;
        }
      buf[j] = code_ind[c];
    }
  c = getc(f);
  if (c=='\r') c = getc(f);
  return (c != EOF);
}

/*  -> xpm_readline */
/*  <- get_chunk */

static int PASCAL NEAR
get_chunk(FILE *f,Uns8 *dibbits,unsigned bpl,
          unsigned nx,unsigned ny,Uns8 code_ind[])
{
  unsigned y;

  dibbits += bpl*(ny-1);
  for (y=ny;  y>0;  y--)
    {
      if (!xpm_readline(f,dibbits,nx,code_ind)) return IE_BAD_FILE_DATA;
      dibbits -= bpl;
    }
  return IE_OK;
}

/*  -> get_chunk */
/*  <- make_meta */

static int PASCAL NEAR
make_meta(FILE *f,unsigned nx,unsigned ny,BITMAPINFO *bi,HPALETTE hpal,
          HANDLE *hmf,DWORD mode,Uns8 code_ind[])
{
  HDC		hdc;
  unsigned	wpl,bpl,y1,y2,dy,maxdy,retcode;
  Uns8		*dibbits;

  bpl = (nx+3) / 4;		/* 32-bit alignment is required for DIBs */
  bpl *= 4;
  wpl = bpl / 2;

  maxdy = 16384u/wpl;                           /* 32K chunks */
  if (maxdy==0) return IE_TOO_BIG;
  if (maxdy>1) maxdy--;
  if (maxdy>ny) maxdy = ny;
  if ( (dibbits=malloc(bpl*maxdy)) == NULL )  return IE_MEM_FULL;

  if ( (hdc=CreateMetaFile(NULL)) == 0 )
    {
      free(dibbits);
      return IE_MEM_FULL;
    }
  SetWindowOrgEx(hdc,0,0,NULL);
  SetWindowExtEx(hdc,nx,ny,NULL);
  if (hpal)
    {
      SelectPalette(hdc,hpal,0);
      RealizePalette(hdc);
    }
  for (y1=0,y2=ny;  y1<y2;  )
    {
      dy = min(y2-y1,maxdy);
      bi->bmiHeader.biHeight = dy;
      bi->bmiHeader.biSizeImage = bpl*dy;
      retcode = get_chunk(f,dibbits,bpl,nx,dy,code_ind);
      if (retcode!=IE_OK) break;
      if (!StretchDIBits(hdc,0,y1,nx,dy,0,0,nx,dy,(LPSTR)dibbits,bi,
                        DIB_RGB_COLORS,mode))
        {
          retcode = IE_MEM_FULL;
          break;
        }
      y1 += dy;
    }
  free(dibbits);
  *hmf = CloseMetaFile(hdc);
  if (*hmf && retcode!=IE_OK)
    {
      DeleteMetaFile(*hmf);
      *hmf = 0;
    }
  return retcode;
}

/*  -> make_meta */
/*  <- getuns */

static int PASCAL NEAR
getuns(char **p,unsigned *x)
{
  char		*q;
  unsigned	num;

  q = *p;
  while (*q==' ' || *q=='\t') q++;
  if (*q<'0' || *q>'9') return 0;
  num = 0;
  do
    {
      num = 10*num + (int)(*q-'0');
      q++;
    }
  while (*q>='0' && *q<='9');
  *p = q;
  *x = num;
  return 1;
}

/*  -> getuns */
/*  <- xpm_header */

static int PASCAL NEAR
xpm_header(FILE *f,unsigned *nx,unsigned *ny,unsigned *palent)
{
  unsigned	nc;
  char		*p,temp[80];

  if (!fgets(temp,sizeof(temp)-1,f) || memcmp(temp,"! XPM2",6))
    return IE_UNKNOWN_TYPE;
  p = temp;
  if (!fgets(temp,sizeof(temp)-1,f) || !getuns(&p,nx) || !getuns(&p,ny) ||
      !getuns(&p,palent) || !getuns(&p,&nc) || *nx==0 || *ny==0 )
     return IE_BAD_FILE_DATA;
  if (*palent<2 || *palent>256 || nc!=1)
    return IE_UNSUPP_COLOR;
  return IE_OK;
}

/*  -> xpm_header */
/*  <- hex_to_dec */

static unsigned PASCAL NEAR
hex_to_dec(unsigned h,unsigned l)
{
  char	*p;
  static char *s1 = "0123456789ABCDEF";
  static char *s2 = "0123456789abcdef";

  if ( (p=strchr(s1,l)) != NULL )	l = (unsigned) (p-s1);
  else if ( (p=strchr(s2,l)) != NULL )	l = (unsigned) (p-s2);
  else					l = 0;
  if ( (p=strchr(s1,h)) != NULL )	h = (unsigned) (p-s1);
  else if ( (p=strchr(s2,h)) != NULL )	h = (unsigned) (p-s2);
  else					h = 0;
  return (h << 4) | l;
}

/*  -> hex_to_dec */
/*  <- xpm_palette */

static int PASCAL NEAR
xpm_palette(FILE *f,unsigned colors,RGBQUAD *p,Uns8 code_ind[])
{
  unsigned	i;
  char		temp[40];

  for (i=0; i<colors; i++)
    {
      if (!fgets(temp,sizeof(temp)-1,f) || strlen(temp)!=18 ||
          temp[1]!=' ' || temp[2]!='c' || temp[3]!=' ' || temp[4]!='#')
        return IE_BAD_FILE_DATA;
      code_ind[(Uns8)temp[0]] = (Uns8) i;
      p[i].rgbRed	= hex_to_dec(temp[7],temp[8]);
      p[i].rgbGreen	= hex_to_dec(temp[11],temp[12]);
      p[i].rgbBlue	= hex_to_dec(temp[15],temp[16]);
    }
  return IE_OK;
}

/*  -> xpm_palette */
/*  <- xpm_graph */

static int PASCAL NEAR
xpm_graph(char *fname,HANDLE *hmf,int *nx,int *ny,DWORD mode)
{
  FILE			*f;
  BITMAPINFO		*bi;
  BITMAPINFOHEADER	*bih;
  HPALETTE		hpal;
  int			retcode;
  unsigned		width,height,colors;
  Uns8			code_ind[256];

  if ( (f=fopen(fname,"r")) == NULL ) return IE_NO_FILE;
  if ( (retcode=xpm_header(f,&width,&height,&colors)) != IE_OK )
    {
      fclose(f);
      return retcode;
    }
  if ( (bi=malloc(sizeof(BITMAPINFOHEADER)+colors*sizeof(RGBQUAD))) == NULL )
    {
      fclose(f);
      return IE_MEM_FULL;
    }
  memset(code_ind,0,sizeof(code_ind));
  if ( (retcode=xpm_palette(f,colors,&(bi->bmiColors[0]),code_ind)) != IE_OK )
    {
      free(bi);
      fclose(f);
      return retcode;
    }
  hpal			= make_palette(colors,&(bi->bmiColors[0]));
  bih			= &(bi->bmiHeader);
  memset(bih,0,sizeof(BITMAPINFOHEADER));
  bih->biSize		= sizeof(BITMAPINFOHEADER);
  bih->biWidth		= width;
  bih->biHeight		= height;
  bih->biPlanes		= 1;
  bih->biBitCount	= 8;
  bih->biClrUsed	= colors;
  retcode = make_meta(f,width,height,bi,hpal,hmf,mode,code_ind);
  if (hpal)	DeleteObject(hpal);
  free(bi);
  fclose(f);
  *nx = width;
  *ny = height;
  return retcode;
}

/*  -> xpm_graph */
#define read_graphic(fname,hmf,x,y,m)	xpm_graph(fname,hmf,x,y,m)
#include "common2.c"
