#include <sys/emx.h>
#include <errno.h>
#include <sys/doscalls.h>

typedef int (*OPENFUNC) (const char *, int);

int __open (const char *name, int flags)
{
    int i, handle;
    OPENFUNC openfn;
    int attr;

    i = flags >> 16;		/* 1 = O_CREAT, 2 = O_EXCL, 4 = O_TRUNC */

    if (i & 0x01) {
	if (i & 0x02)		/* O_CREAT | O_EXCL */
	    openfn = dos_creatnew;
	else if (i & 4) 	/* O_CREAT | O_TRUNC */
	    openfn = dos_creat;
	else if (dos_access(name, 0) == -1)	/* old file there ? */
	    openfn = dos_creat;
	else
	    openfn = dos_open;
    } else			/* not O_CREAT */
	openfn = dos_open;

    if (openfn == dos_open)
	attr = flags & 0xff;		/* open mode */
    else
	attr = (flags >> 8) & 0xff;	/* creat attrib */

    if ((handle = (*openfn) (name, attr)) < 0)
	return -1;

    if ((i & 0x05) == 0x4) {	/* O_TRUNC with open */
	dos_lseek(handle, 0, 0);
	dos_write(handle, name, 0);
    }
    return handle;
}
