#define STRICT
#define NOUSER
#define NOGDI
#include <windows.h>
#include <sys/rsxw32.h>

/* -------- KERNEL SECTION ----------------------------------- */

DWORD GetVersion(void)
{
    NOSTACK;
    return WINCALL(3,KERNEL);
}

HGLOBAL GlobalAlloc (UINT par1, DWORD par2)
{
    STACKWORDS(1+2);

    PUSH_WORD(par1);
    PUSH_LONG(par2);
    return WINCALL( 15,KERNEL);
}

HGLOBAL WINAPI GlobalReAlloc (HGLOBAL par1, DWORD par2, UINT par3)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(par1);
    PUSH_LONG(par2);
    PUSH_WORD(par3);
    return WINCALL( 16,KERNEL);
}

HGLOBAL WINAPI GlobalFree (HANDLE par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL( 17,KERNEL);
}

/*
in syscall.c (kernel,18):
LPSTR GlobalLock (HGLOBAL par1)
*/

BOOL GlobalUnlock (HGLOBAL par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL( 19,KERNEL);
}

HMODULE GetModuleHandle(LPCSTR module_name)
{
    STACKWORDS(2);

    PUSH_LPSTR(module_name);
    return WINCALL(47,KERNEL);
}

/*
** in syscall.c
** MakeProcInstance()
** WINCALL(51,KERNEL)
*/

/*
** in syscall.c
** FreeProcInstance()
** WINCALL(52,KERNEL)
*/

short GetInstanceData (HINSTANCE hInst, BYTE* pData, short nCount)
{
    /* WINCALL( 54,KERNEL);*/
    return 0;
}

HFILE OpenFile(LPCSTR file, OFSTRUCT FAR *of, UINT action)
{
    STACKWORDS(2+2+1);

    PUSH_LPSTR(file);
    PUSH_LPSTR(of);
    PUSH_WORD(action);
    return WINCALL(74,KERNEL);
}

HFILE _lclose(HFILE handle)
{
    STACKWORDS(1);

    PUSH_WORD(handle);
    return WINCALL(81,KERNEL);
}

UINT _lread(HFILE handle, void _huge *buf, UINT bytes)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(handle);
    PUSH_LPSTR(buf);
    PUSH_WORD(bytes);
    return WINCALL(82,KERNEL);
}

HFILE _lcreat(LPCSTR file, short flags)
{
    STACKWORDS(2+1);

    PUSH_LPSTR(file);
    PUSH_WORD(flags);
    return WINCALL(83,KERNEL);
}

LONG _llseek(HFILE handle, LONG where, short fnct)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(handle);
    PUSH_LONG(where);
    PUSH_WORD(fnct);
    return WINCALL(84,KERNEL);
}

HFILE _lopen(LPCSTR file, short flags)
{
    STACKWORDS(2+1);

    PUSH_LPSTR(file);
    PUSH_WORD(flags);
    return WINCALL(85,KERNEL);
}

UINT _lwrite(HFILE handle, const void _huge *buf, UINT bytes)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(handle);
    PUSH_LPSTR(buf);
    PUSH_WORD(bytes);
    return WINCALL(86,KERNEL);
}

HINSTANCE LoadLibrary(LPCSTR name)
{
    STACKWORDS(2);

    PUSH_LPSTR(name);
    return WINCALL( 95,KERNEL);
}

void FreeLibrary(HINSTANCE hLib)
{
    STACKWORDS(1);

    PUSH_WORD(hLib);
    WINCALL( 96,KERNEL);
}

UINT GetNumTasks (void)
{
    NOSTACK;
    return WINCALL(152,KERNEL);
}

DWORD GetWinFlags(void)
{
    NOSTACK;
    return WINCALL(132,KERNEL);
}

UINT WINAPI WinExec (LPCSTR par1, UINT par2)
{
    STACKWORDS(2+1);

    PUSH_LPSTR(par1);
    PUSH_WORD(par2);
    return WINCALL(166,KERNEL);
}

/* -------- KEYBOARD SECTION --------------------------------- */

void AnsiToOem(const char _huge *buf1, char _huge *buf2)
{
    STACKWORDS(2+2);

    PUSH_LPSTR(buf1);
    PUSH_LPSTR(buf2);
    WINCALL( 5, KEYBOARD);
}

void OemToAnsi(const char _huge *buf1, char _huge *buf2)
{
    STACKWORDS(2+2);

    PUSH_LPSTR(buf1);
    PUSH_LPSTR(buf2);
    WINCALL( 6, KEYBOARD);
}

/* --------not tested ------------*/
/* --------not tested ------------*/
/* --------not tested ------------*/
/* --------not tested ------------*/

short GetProfileString (LPCSTR par1, LPCSTR par2, LPCSTR par3,
	LPSTR par4, short par5)
{
    STACKWORDS(2+2+2+2+1);
    PUSH_LPSTR(par1);
    PUSH_LPSTR(par2);
    PUSH_LPSTR(par3);
    PUSH_LPSTR(par4);
    PUSH_WORD(par5);
    return WINCALL( 58,KERNEL);
}

short GetModuleFileName (HINSTANCE par1, LPSTR par2, short par3)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    PUSH_WORD(par3);
    return WINCALL( 49,KERNEL);
}

FARPROC GetProcAddress(HINSTANCE par1, LPCSTR par2)
{
    STACKWORDS(1+2);

    PUSH_WORD(par1);
    PUSH_LPSTR(par2);
    return (FARPROC) WINCALL( 50,KERNEL);
}
