/* sys/ead.h (emx+gcc) */

#if !defined (_SYS_EAD_H)
#define _SYS_EAD_H

#if defined (__cplusplus)
extern "C" {
#endif

#define _EAD_MERGE       0x0001

typedef struct _ead_data *_ead;

int _ead_add (_ead ead, __const__ char *name, int flags, __const__ void *value,
    int size);
void _ead_clear (_ead ead);
int _ead_copy (_ead dst_ead, _ead src_ead, int src_index);
int _ead_count (_ead ead);
_ead _ead_create (void);
int _ead_delete (_ead ead, int index);
void _ead_destroy (_ead ead);
int _ead_fea2list_size (_ead ead);
void *_ead_fea2list_to_fealist (__const__ void *src);
void *_ead_fealist_to_fea2list (__const__ void *src);
int _ead_find (_ead ead, __const__ char *name);
__const__ void *_ead_get_fea2list (_ead ead);
int _ead_get_flags (_ead ead, int index);
__const__ char *_ead_get_name (_ead ead, int index);
__const__ void *_ead_get_value (_ead ead, int index);
int _ead_name_len (_ead ead, int index);
int _ead_read (_ead ead, __const__ char *path, int handle, int flags);
int _ead_replace (_ead ead, int index, int flags, __const__ void *value,
    int size);
void _ead_sort (_ead ead);
int _ead_use_fea2list (_ead ead, __const__ void *src);
int _ead_value_size (_ead ead, int index);
int _ead_write (_ead ead, __const__ char *path, int handle, int flags);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_SYS_EAD_H) */
