/* signal.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

void (*__signal (int signum, void (*handler)()))(int sig)
{
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    SA_HANDLER old_handler;

    if (signum < 1 || signum >= NSIG || signum == SIGKILL)
        return SIG_ERR;

    old_handler = proc->sigaction[SIGSA(signum)].sa_handler;

    if (handler == SIG_ACK) {
        proc->sig_blocked &= ~ SIGMASK(signum);
    }
    else {
      proc->sigaction[SIGSA(signum)].sa_handler = handler;
      proc->sigaction[SIGSA(signum)].sa_flags = 0;
      proc->sigaction[SIGSA(signum)].sa_mask = 0;
  
      if ((proc->uflags & 3) == 1)         /* system V */
          proc->sigaction[SIGSA(signum)].sa_flags = SA_SYSV;
      else if ((proc->uflags & 3) == 2)    /* BSD */
          proc->sigaction[SIGSA(signum)].sa_flags = 0;
      else                                /* old EMX */
        proc->sigaction[SIGSA(signum)].sa_flags = SA_ACK;
    }
#ifdef EMX_SYS_LIB
        _rsxnt_check_signals();
#endif
    return old_handler;
}
