/***************************************************************************\
*									    *
*   WINKERNE.H								    *
*									    *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINKERNE_H)
#define _WINKERNE_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(RC_INVOKED)
#define DELETE			(0x00010000L)
#define READ_CONTROL	(0x00020000L)
#define WRITE_DAC		(0x00040000L)
#define WRITE_OWNER		(0x00080000L)
#define SYNCHRONIZE		(0x00100000L)

#define STANDARD_RIGHTS_REQUIRED	(0x000F0000L)
#define STANDARD_RIGHTS_READ		(READ_CONTROL)
#define STANDARD_RIGHTS_WRITE		(READ_CONTROL)
#define STANDARD_RIGHTS_EXECUTE		(READ_CONTROL)
#define STANDARD_RIGHTS_ALL		(0x001F0000L)
#define SPECIFIC_RIGHTS_ALL			(0x0000FFFFL)

#define MUTANT_QUERY_STATE      0x0001
#define MUTANT_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|\
                          MUTANT_QUERY_STATE)
#define MUTEX_ALL_ACCESS MUTANT_ALL_ACCESS
#define EVENT_MODIFY_STATE      0x0002  
#define EVENT_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3) 

typedef struct {
    DWORD       nLength;
    LPVOID      lpSecurityDescriptor;
    BOOL        bInheritHandle;
} SECURITY_ATTRIBUTES, * PSECURITY_ATTRIBUTES, * LPSECURITY_ATTRIBUTES;


#define LoadLibrary TFUNCT(LoadLibrary)
HINSTANCE WINAPI LoadLibrary(LPCTSTR lpLibFileName);
#define LoadLibraryEx TFUNCT(LoadLibraryEx)
HINSTANCE WINAPI LoadLibraryEx(LPCTSTR lpLibFileName, HANDLE hFile,
	DWORD dwFlags);
PROC WINAPI GetProcAddress(HINSTANCE hModule, LPCSTR lpProcName);
BOOL WINAPI FreeLibrary(HINSTANCE hLibModule);
#define FreeModule(hLibModule) FreeLibrary((hLibModule))
#define MakeProcInstance(lpProc,hInstance) (lpProc)
#define FreeProcInstance(lpProc)

#define GetModuleFileName TFUNCT(GetModuleFileName)
DWORD WINAPI GetModuleFileName(HINSTANCE hModule, LPTSTR lpFilename,
	DWORD nSize);
#define GetModuleHandle TFUNCT(GetModuleHandle)
HMODULE WINAPI GetModuleHandle(LPCTSTR lpModuleName);

DWORD WINAPI GetLastError (void);
DWORD WINAPI GetTickCount();

typedef struct {
    DWORD	dwLowDateTime;
    DWORD	dwHighDateTime;
} FILETIME, *PFILETIME, *LPFILETIME;

#define VER_PLATFORM_WIN32s		0
#define VER_PLATFORM_WIN32_WINDOWS	1
#define VER_PLATFORM_WIN32_NT		2

typedef struct {
    DWORD	dwOSVersionInfoSize;
    DWORD	dwMajorVersion;
    DWORD	dwMinorVersion;
    DWORD	dwBuildNumber;
    DWORD	dwPlatformId;
    TCHAR    szCSDVersion[128];
} OSVERSIONINFO, *POSVERSIONINFO, * LPOSVERSIONINFO;

#define GetVersionEx TFUNCT(GetVersionEx)
BOOL WINAPI GetVersionEx(LPOSVERSIONINFO lpVersionInformation);


#define GlobalAddAtom TFUNCT(GlobalAddAtom)
ATOM WINAPI GlobalAddAtom(LPCTSTR lpString);
#define GlobalFindAtom TFUNCT(GlobalFindAtom)
ATOM WINAPI GlobalFindAtom(LPCTSTR lpString);
#define GlobalGetAtomName TFUNCT(GlobalGetAtomName)
UINT WINAPI GlobalGetAtomName(ATOM nAtom, LPTSTR lpBuffer, int nSize);
#define AddAtom TFUNCT(AddAtom)
ATOM WINAPI AddAtom(LPCTSTR lpString);
#define FindAtom TFUNCT(FindAtom)
ATOM WINAPI FindAtom(LPCTSTR lpString);
#define GetAtomName TFUNCT(GetAtomName)
UINT WINAPI GetAtomName(ATOM nAtom, LPTSTR lpBuffer, int nSize);

#define GetProfileInt TFUNCT(GetProfileInt)
UINT WINAPI GetProfileInt(LPCTSTR lpAppName, LPCTSTR lpKeyName, INT nDefault);
#define GetProfileString TFUNCT(GetProfileString)
DWORD WINAPI GetProfileString(LPCTSTR lpAppName, LPCTSTR lpKeyName,
	LPCTSTR lpDefault, LPTSTR lpReturnedString, DWORD nSize);
#define WriteProfileString TFUNCT(WriteProfileString)
BOOL WINAPI WriteProfileString(LPCTSTR lpAppName, LPCTSTR lpKeyName,
	LPCTSTR lpString);
#define GetProfileSection TFUNCT(GetProfileSection)
DWORD WINAPI GetProfileSection(LPCTSTR lpAppName, LPTSTR lpReturnedString,
	DWORD nSize);
#define WriteProfileSection TFUNCT(WriteProfileSection)
BOOL WINAPI WriteProfileSection(LPCTSTR lpAppName, LPCTSTR lpString);
#define GetPrivateProfileInt TFUNCT(GetPrivateProfileInt)
UINT WINAPI GetPrivateProfileInt(LPCTSTR lpAppName, LPCTSTR lpKeyName,
	INT nDefault, LPCTSTR lpFileName);
#define GetPrivateProfileString TFUNCT(GetPrivateProfileString)
DWORD WINAPI GetPrivateProfileString(LPCTSTR lpAppName, LPCTSTR lpKeyName,
	LPCTSTR lpDefault, LPTSTR lpReturnedString, DWORD nSize, LPCTSTR lpFileName);
#define WritePrivateProfileString TFUNCT(WritePrivateProfileString)
BOOL WINAPI WritePrivateProfileString(LPCTSTR lpAppName, LPCTSTR lpKeyName,
	LPCTSTR lpString, LPCTSTR lpFileName);
#define GetPrivateProfileSection TFUNCT(GetPrivateProfileSection)
DWORD WINAPI GetPrivateProfileSection(LPCTSTR lpAppName, LPTSTR lpReturnedString,
	DWORD nSize, LPCTSTR lpFileName);
#define WritePrivateProfileSection TFUNCT(WritePrivateProfileSection)
BOOL WINAPI WritePrivateProfileSection(LPCTSTR lpAppName, LPCTSTR lpString,
	LPCTSTR lpFileName);
#define GetPrivateProfileSectionNames TFUNCT(GetPrivateProfileSectionNames)
DWORD WINAPI GetPrivateProfileSectionNames(LPTSTR lpszReturnBuffer,
	DWORD nSize, LPCTSTR lpFileName);
#define GetPrivateProfileStruct TFUNCT(GetPrivateProfileStruct)
BOOL WINAPI GetPrivateProfileStruct(LPCTSTR lpszSection, LPCTSTR lpszKey,
	PVOID lpStruct, UINT uSizeStruct, LPCTSTR szFile);
#define WritePrivateProfileStruct TFUNCT(WritePrivateProfileStruct)
BOOL WINAPI WritePrivateProfileStruct(LPCTSTR lpszSection, LPCTSTR lpszKey,
	PVOID lpStruct, UINT uSizeStruct, LPCTSTR szFile);

typedef struct {
    WORD	wYear;
    WORD	wMonth;
    WORD	wDayOfWeek;
    WORD	wDay;
    WORD	wHour;
    WORD	wMinute;
    WORD	wSecond;
    WORD	wMilliseconds;
} SYSTEMTIME,
* PSYSTEMTIME,
* LPSYSTEMTIME;

typedef struct _TIME_ZONE_INFORMATION {
    LONG        Bias;
    WCHAR       StandardName[32];
    SYSTEMTIME  StandardDate;
    LONG        StandardBias;
    WCHAR       DaylightName[32];
    SYSTEMTIME  DaylightDate;
    LONG        DaylightBias;
} TIME_ZONE_INFORMATION, *PTIME_ZONE_INFORMATION,
*LPTIME_ZONE_INFORMATION;

#define TIME_ZONE_ID_INVALID	((DWORD) 0xFFFFFFFFL)
#define TIME_ZONE_ID_UNKNOWN  0
#define TIME_ZONE_ID_STANDARD 1
#define TIME_ZONE_ID_DAYLIGHT 2

DWORD WINAPI GetTimeZoneInformation(LPTIME_ZONE_INFORMATION);

void WINAPI GetSystemTime (LPSYSTEMTIME lpSysTime);
BOOL WINAPI SetSystemTime(CONST SYSTEMTIME *lpSystemTime);
void WINAPI GetLocalTime (LPSYSTEMTIME lpSysTime);

DWORD WINAPI GetVersion(VOID);

#define GetEnvironmentVariable TFUNCT(GetEnvironmentVariable)
DWORD WINAPI GetEnvironmentVariable(LPCTSTR lpName, LPTSTR lpBuffer, DWORD nSize);
#define SetEnvironmentVariable TFUNCT(SetEnvironmentVariable)
BOOL WINAPI SetEnvironmentVariable(LPCTSTR lpName, LPCTSTR lpValue);
/* Somebody screwed up the function definition */
#ifdef UNICODE
#define GetEnvironmentStrings GetEnvironmentStringsW
#else
#define GetEnvironmentStringsA GetEnvironmentStrings
#endif
LPTSTR WINAPI GetEnvironmentStrings(VOID);
#define FreeEnvironmentStrings TFUNCT(FreeEnvironmentStrings)
BOOL WINAPI FreeEnvironmentStrings(LPTSTR lpEnv);

#define FORMAT_MESSAGE_ALLOCATE_BUFFER 0x00000100
#define FORMAT_MESSAGE_IGNORE_INSERTS  0x00000200
#define FORMAT_MESSAGE_FROM_STRING     0x00000400
#define FORMAT_MESSAGE_FROM_HMODULE    0x00000800
#define FORMAT_MESSAGE_FROM_SYSTEM     0x00001000
#define FORMAT_MESSAGE_ARGUMENT_ARRAY  0x00002000
#define FORMAT_MESSAGE_MAX_WIDTH_MASK  0x000000FF

#define FormatMessage  TFUNCT(FormatMessage)
DWORD WINAPI FormatMessage(DWORD dwFlags, LPCVOID lpSource,
	DWORD dwMessageId, DWORD dwLanguageId, LPTSTR lpBuffer,
	DWORD nSize, va_list *Arguments);

#define OutputDebugString TFUNCT(OutputDebugString)
VOID WINAPI OutputDebugString(LPCTSTR lpOutputString);

#define INFINITE	    0xFFFFFFFF

VOID WINAPI Sleep(DWORD dwMillisecs);
DWORD WINAPI WaitForSingleObject(HANDLE hObject, DWORD dwMillisecs);
DWORD WINAPI WaitForMultipleObjects (DWORD nCount, HANDLE *lpHandles, BOOL fWaitAll, DWORD dwMillisecs);

#define CP_ACP		0
#define CP_OEMCP	1
#define CP_MACCP	2


int WINAPI WideCharToMultiByte(UINT page, DWORD flags, WCHAR *src, int srclen,
			       char *dst, int dstlen, char *def, BOOL usedef);

#define lstrcmp TFUNCT(lstrcmp)
int WINAPI lstrcmp(LPCTSTR lpString1, LPCTSTR lpString2);
#define lstrcmpi TFUNCT(lstrcmpi)
int WINAPI lstrcmpi(LPCTSTR lpString1, LPCTSTR lpString2);
#define lstrcpy TFUNCT(lstrcpy)
LPTSTR WINAPI lstrcpy(LPTSTR lpString1, LPCTSTR lpString2);
#define lstrcpyn TFUNCT(lstrcpyn)
LPTSTR WINAPI lstrcpyn(LPTSTR lpString1, LPCTSTR lpString2, INT nSize);
#define lstrcat TFUNCT(lstrcat)
LPTSTR WINAPI lstrcat (LPTSTR lpString1, LPCTSTR lpString2);
#define lstrlen TFUNCT(lstrlen)
int WINAPI lstrlen(LPCTSTR lpString);


#define SEM_FAILCRITICALERRORS	    0x0001
#define SEM_NOGPFAULTERRORBOX	    0x0002
#define SEM_NOALIGNMENTFAULTEXCEPT  0x0004
#define SEM_NOOPENFILEERRORBOX	    0x8000
UINT WINAPI SetErrorMode(UINT uMode);

#define GetComputerName TFUNCT(GetComputerName)
BOOL WINAPI GetComputerName(LPTSTR lpBuffer, DWORD *lpnSize);
UINT WINAPI WinExec(LPCSTR lpCmdLine, UINT uCmdShow);
#endif /* RC_INVOKED */

#define LANG_NEUTRAL                     0x00
#define LANG_ARABIC                      0x01
#define LANG_AFRIKAANS                   0x36
#define LANG_ALBANIAN                    0x1c
#define LANG_BASQUE                      0x2d
#define LANG_BULGARIAN                   0x02
#define LANG_BYELORUSSIAN                0x23
#define LANG_CATALAN                     0x03
#define LANG_CHINESE                     0x04
#define LANG_CROATIAN                    0x1a
#define LANG_CZECH                       0x05
#define LANG_DANISH                      0x06
#define LANG_DUTCH                       0x13
#define LANG_ENGLISH                     0x09
#define LANG_ESTONIAN                    0x25
#define LANG_FAEROESE                    0x38
#define LANG_FARSI                       0x29
#define LANG_FINNISH                     0x0b
#define LANG_FRENCH                      0x0c
#define LANG_GERMAN                      0x07
#define LANG_GREEK                       0x08
#define LANG_HEBREW                      0x0D
#define LANG_HUNGARIAN                   0x0e
#define LANG_ICELANDIC                   0x0f
#define LANG_INDONESIAN                  0x21
#define LANG_ITALIAN                     0x10
#define LANG_JAPANESE                    0x11
#define LANG_KOREAN                      0x12
#define LANG_LATVIAN                     0x26
#define LANG_LITHUANIAN                  0x27
#define LANG_NORWEGIAN                   0x14
#define LANG_POLISH                      0x15
#define LANG_PORTUGUESE                  0x16
#define LANG_ROMANIAN                    0x18
#define LANG_RUSSIAN                     0x19
#define LANG_SLOVAK                      0x1b
#define LANG_SLOVENIAN                   0x24
#define LANG_SORBIAN                     0x2e
#define LANG_SPANISH                     0x0a
#define LANG_SWEDISH                     0x1d
#define LANG_THAI                        0x1e
#define LANG_TURKISH                     0x1f
#define LANG_UKRAINIAN                   0x22

#define SUBLANG_NEUTRAL                  0x00    /* language neutral */
#define SUBLANG_DEFAULT                  0x01    /* user default */
#define SUBLANG_SYS_DEFAULT              0x02    /* system default */

#define SUBLANG_ARABIC                   		0x01
#define SUBLANG_ARABIC_IRAQ              	0x02
#define SUBLANG_ARABIC_EGYPT             	0x03
#define SUBLANG_ARABIC_LIBYA             	0x04
#define SUBLANG_ARABIC_ALGERIA           	0x05
#define SUBLANG_ARABIC_MOROCCO           	0x06
#define SUBLANG_ARABIC_TUNISIA           	0x07
#define SUBLANG_ARABIC_OMAN              	0x08
#define SUBLANG_ARABIC_YEMEN             	0x09
#define SUBLANG_ARABIC_SYRIA             	0x10
#define SUBLANG_ARABIC_JORDAN            	0x11
#define SUBLANG_ARABIC_LEBANON           	0x12
#define SUBLANG_ARABIC_KUWAIT            	0x13
#define SUBLANG_ARABIC_UAE               	0x14
#define SUBLANG_ARABIC_BAHRAIN           	0x15
#define SUBLANG_ARABIC_QATAR             	0x16
#define SUBLANG_CHINESE_TRADITIONAL      	0x01
#define SUBLANG_CHINESE_SIMPLIFIED       	0x02
#define SUBLANG_CHINESE_HONGKONG         	0x03
#define SUBLANG_CHINESE_SINGAPORE        	0x04
#define SUBLANG_DUTCH                    		0x01
#define SUBLANG_DUTCH_BELGIAN            	0x02
#define SUBLANG_ENGLISH_US               	0x01
#define SUBLANG_ENGLISH_UK               	0x02
#define SUBLANG_ENGLISH_AUS              	0x03
#define SUBLANG_ENGLISH_CAN              	0x04
#define SUBLANG_ENGLISH_NZ               	0x05
#define SUBLANG_ENGLISH_EIRE             	0x06
#define SUBLANG_ENGLISH_SAFRICA          	0x07
#define SUBLANG_ENGLISH_JAMAICA          	0x08
#define SUBLANG_ENGLISH_CARRIBEAN        	0x09
#define SUBLANG_FRENCH                   		0x01
#define SUBLANG_FRENCH_BELGIAN           	0x02
#define SUBLANG_FRENCH_CANADIAN          	0x03
#define SUBLANG_FRENCH_SWISS             	0x04
#define SUBLANG_FRENCH_LUXEMBOURG       0x05
#define SUBLANG_GERMAN                   		0x01
#define SUBLANG_GERMAN_SWISS             	0x02
#define SUBLANG_GERMAN_AUSTRIAN	0x03
#define SUBLANG_GERMAN_LUXEMBOURG	0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN	0x05
#define SUBLANG_ITALIAN                  		0x01
#define SUBLANG_ITALIAN_SWISS            	0x02
#define SUBLANG_KOREAN                   		0x01
#define SUBLANG_KOREAN_JOHAB             	0x02
#define SUBLANG_NORWEGIAN_BOKMAL         0x01
#define SUBLANG_NORWEGIAN_NYNORSK       0x02
#define SUBLANG_PORTUGUESE               	0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN	0x01
#define SUBLANG_SPANISH                  		0x01
#define SUBLANG_SPANISH_MEXICAN          	0x02
#define SUBLANG_SPANISH_MODERN           	0x03
#define SUBLANG_SPANISH_GUATEMALA        	0x04
#define SUBLANG_SPANISH_COSTARICA        	0x05
#define SUBLANG_SPANISH_PANAMA           	0x06
#define SUBLANG_SPANISH_DOMINICAN        	0x07
#define SUBLANG_SPANISH_VENEZUELA        	0x08
#define SUBLANG_SPANISH_COLOMBIA         	0x09
#define SUBLANG_SPANISH_PERU             	0x10
#define SUBLANG_SPANISH_ARGENTINA        	0x11
#define SUBLANG_SPANISH_ECUADOR          	0x12
#define SUBLANG_SPANISH_CHILE		0x13
#define SUBLANG_SPANISH_URUGUAY	0x14
#define SUBLANG_SPANISH_PARAGUAY	0x15
#define SUBLANG_SPANISH_BOLIVIA		0x16

#if !defined(RC_INVOKED)
typedef BOOL CALLBACK (*ENUMRESTYPEPROC)(HMODULE hModule, 
	LPTSTR lpType, LONG lParam);
typedef BOOL CALLBACK (*ENUMRESNAMEPROC)(HMODULE hModule, 
	LPCTSTR lpType, LPTSTR lpName, LONG lParam);
typedef BOOL CALLBACK (*ENUMRESLANGPROC)(HMODULE hModule, 
	LPCTSTR lpType, LPCTSTR lpName, WORD wLanguage, LONG lParam);

#define EnumResourceTypes TFUNCT(EnumResourceTypes)
BOOL WINAPI EnumResourceTypes(HMODULE hModule,
	ENUMRESTYPEPROC lpEnumFunc, LONG lParam);
#define EnumResourceNames TFUNCT(EnumResourceNames)
BOOL WINAPI EnumResourceNames(HMODULE hModule,
	LPCTSTR lpType, ENUMRESNAMEPROC lpEnumFunc, LONG lParam);
#define EnumResourceLanguages TFUNCT(EnumResourceLanguages)
BOOL WINAPI EnumResourceLanguages(HMODULE hModule, LPCTSTR lpType, 
	LPCTSTR lpName, ENUMRESLANGPROC lpEnumFunc, LONG lParam);
#define FindResource TFUNCT(FindResource)
HRSRC WINAPI FindResource(HMODULE hModule, LPCTSTR lpName,
	LPCTSTR lpType);
#define FindResourceEx TFUNCT(FindResourceEx)
HRSRC WINAPI FindResourceEx(HMODULE hModule, LPCTSTR lpType,
	LPCTSTR lpName, WORD wLanguage);
HGLOBAL WINAPI LoadResource(HMODULE hModule, HRSRC hResInfo);
DWORD WINAPI SizeofResource(HMODULE hModule, HRSRC hResInfo);
#define BeginUpdateResource TFUNCT(BeginUpdateResource)
HANDLE WINAPI BeginUpdateResource(LPCTSTR pFileName, BOOL bDelete);
#define UpdateResource TFUNCT(UpdateResource)
BOOL WINAPI UpdateResource(HANDLE hUpdate, LPCTSTR lpType, 
	LPCTSTR lpName, WORD wLanguage, LPVOID lpData, DWORD cbData);
#define EndUpdateResource TFUNCT(EndUpdateResource)
BOOL WINAPI EndUpdateResource(HANDLE hUpdate, BOOL fDiscard);
BOOL WINAPI FreeResource(HGLOBAL hResData);
LPVOID WINAPI LockResource(HGLOBAL hResData);
#define UnlockResource(hResData) ((hResData), 0)

#include <winmem.h>
#include <winfiles.h>
#include <wincon.h>
#include <wincomm.h>
#include <winproc.h>

#ifdef NT
#include <winnt.h>
#endif

#endif /* RC_INVOKED */

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINKERNE_H) */
