/* goto.c
 * v0.91
 * 
 * Holger Danielsson
 * (dani@lara.prima.ruhr.de)
 * 6.9.1996
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "token.h"
#include "execute.h"


/* GOTO in einer Batchdatei ausfhren:
 * Aus der Batchdatei werden solange weitere Kommandozeilen gelesen,
 * bis das entsprechende Label gefunden wurde.
 *
 * Syntax:  GOTO label
 * argv[]:         0
 *
 */
int execute_goto(char *argv[], FILE *fd)
{
   char cline[512];
   char *argvec[64];

   if ( !fd ) {
      puts("use GOTO only in batchfiles");
      return 1;
   }

   if ( !argv[0] ) {
      puts("GOTO without address");
      return 1;
   }

   fseek(fd,0,SEEK_SET);         /* ab Dateibeginn suchen */
   while (readline(fd, cline) >= 0) {
      if (!make_tokens(cline, argvec)) continue;
      if ( (*argvec[0]==':') && (!strcmp(argvec[0]+1,argv[0])) ) {
         return 0;
         }
   }
   puts("label for GOTO not found");
   return 1;
}


