/*
** running bound DJGPP exe-files
** go32.exe without DPMI
** rsxdj.exe with DPMI
*/

#include <process.h>
#include <dos.h>

unsigned _heaplen = 4096;
unsigned _stklen = 2048;
extern unsigned _psp;

int	dpmi_host(void);    /* ret = 0 DPMI, else not */
int	get_ds(void);
void	print_string_stdout(char *s);

static void x2s(int v, char *s)
{
    static char hex[] = "0123456789abcdef";
    int i;

    for (i = 0; i < 4; i++) {
	s[3 - i] = hex[v & 15];
	v >>= 4;
    }
    s[4] = 0;
}

#ifdef __WATCOMC__
#pragma aux dpmi_host = \
    "mov ax , 1687H"    \
    "int 2FH"           \
    modify [ax bx cx dx si di es] \
    value [ax];

#pragma aux get_ds =	\
    "mov ax, ds"        \
    value [ax];

#pragma aux print_string_stdout parm [dx] = \
    "mov ah , 9"        \
    "int 21H"           \
    modify [ax dx];
#endif

#ifdef __TURBOC__
int dpmi_host(void)
{
    _AX = 0x1687;
    geninterrupt(0x2F);
    return _AX;
}
int get_ds(void)
{
    return _DS;
}
void print_string_stdout(char *s)
{
    _asm mov ah,9;
    _asm mov dx, s;
    _asm int 0x21;
}
#endif

char rsx_name[] = "RSX.EXE";
char go32_name[] = "GO32.EXE";

main(int argc, char **argv)
{
    char s_argc[5], s_seg[5], s_argv[5];
    char *exe_name;
    int r=-1;

    if (dpmi_host() == 0)
	exe_name = rsx_name;
    else
	exe_name = go32_name;

    x2s(argc, s_argc);
    x2s( get_ds(), s_seg);
    x2s((int) argv, s_argv);
    r = spawnlp(P_WAIT, exe_name, exe_name, "!proxy", s_argc, s_seg, s_argv, 0);
    if (r == -1) {
	print_string_stdout(exe_name);
	print_string_stdout(":file not found\r\n$");
    }
    return r;
}
