#!/bin/sh
# mkinstalldirs --- make directory hierarchy (now mktexdir).
# Author: Noah Friedman <friedman@prep.ai.mit.edu>, created: 1993-05-16.
# Public domain.
# 
# Modified for sticky directory creation, --help, --version.
# te@informatik.uni-hannover.de and kb@mail.tug.org.

version='$Id: mktexdir,v 1.10 1998/03/16 23:15:36 olaf Exp $'
usage="Usage: $0 DIRS...
  Create each DIR, including any missing leading directories."

# Common code for all scripts.
: ${MT_TEXMFMAIN=`kpsewhich --expand-path='$TEXMFMAIN'`}
: ${MT_MKTEX_OPT=`kpsewhich --format='web2c files' mktex.opt`}
test -n "$MT_MKTEX_OPT" || MT_MKTEX_OPT="$MT_TEXMFMAIN/web2c/mktex.opt"
if test ! -f "$MT_MKTEX_OPT"; then
  echo "$0: Cannot find mktex.opt; check your installation." >&2
  exit 1
fi

. "$MT_MKTEX_OPT"

test -n "$MT_MKTEXDIR_OPT" && . "$MT_MKTEXDIR_OPT"

errstatus=0

for file
do
   set fnord `echo ":$file" | sed -ne 's/^:\//#/;s/^://;s/\// /g;s/^#/\//;p'`
   shift

   pathcomp=
   for d in ${1+"$@"} ; do
     pathcomp="$pathcomp$d"
     case "$pathcomp" in
       -* ) pathcomp="./$pathcomp" ;;
     esac

     if test ! -d "$pathcomp"; then
        mkdir "$pathcomp" || errstatus=$?
        chmod `kpsestat ${MT_APPEND_MASK:-=} "$pathcomp"/..` "$pathcomp"
     fi

     pathcomp="$pathcomp/"
   done
done

exit $errstatus
