/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "sockets_events.cc"
 *                                    created: 30/10/97 {8:44:04 pm} 
 *                                last update: 30/10/97 {9:57:52 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "sockets_events.h"

void cpp_trigger::add_socket(cpp_socket_t* e) {
	//archive() << get_tcl_command() << " connect " << e->get_tcl_command() << endl;
	register_socket(e);
	e->register_event(this);
}

void cpp_trigger::remove_socket(cpp_socket_t* e) {
	//archive() << get_tcl_command() << " disconnect " << e->get_tcl_command() << endl;
	deregister_socket(e);
	e->deregister_event(this);
}

void cpp_trigger::trigger(void) {
    // loop over my list of requests and call them
    for(list_pos<cpp_socket_t*> scanner(requests);scanner;++scanner) {
		cpp_socket_t* call = scanner.item();
		call->call(call->container,call->container);
    }
}

void cpp_trigger::trigger(tcl_object* substitute) {
    // loop over my list of requests and call them
    for(list_pos<cpp_socket_t*> scanner(requests);scanner;++scanner) {
		cpp_socket_t* call = scanner.item();
		call->call(call->container,substitute);
    }
}

cpp_trigger::cpp_trigger(tcl_object* _container)
:container(_container){
}

cpp_event::cpp_event(tcl_object* _container)
:cpp_trigger(_container) {

}

cpp_socket_t::cpp_socket_t(tcl_object* _container)
	:cpp_trigger(_container) {
}

void cpp_socket_t::deregister_myself(void) {
    // loop over my list of requestees and call them
    // note my remove_object function above will be called each time
    list_pos<cpp_trigger*> scanner = requestees.head();
    
    while((scanner = requestees.head()).onlist()) {
		scanner.item()->remove_socket(this);
    }
}

