/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "member_file_io.h"
 *                                    created: 29/10/97 {9:25:59 am} 
 *                                last update: 17/12/97 {7:45:42 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that the copyright notice and warranty disclaimer appear in
 * supporting documentation.
 * 
 * Vince Darley disclaims all warranties with regard to this software,
 * including all implied warranties of merchantability and fitness.  In
 * no event shall Vince Darley be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortuous action, arising out of or in connection with the use or
 * performance of this software.
 * ========================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  29/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_member_file_io_
#define _Cpptcl_member_file_io_

#include "cpptcl.h"
#include "cpptcl_config_mem.h"

#include "fstream.h"
/*
class ifstream;
class ofstream;
class fstream;
*/

DLL_IMPORT_EXPORT
class wrapped_stream {
  public:
	union {
		fstream (tcl_object::*fptr);
		fstream* (tcl_object::*fpptr);
		ofstream (tcl_object::*ofptr);
		ofstream* (tcl_object::*ofpptr);
		ifstream (tcl_object::*ifptr);
		ifstream* (tcl_object::*ifpptr);
	} p;
	const bool ptr;
	fstream& fs(tcl_object *o) { return (ptr ? *(o->*p.fpptr) : o->*p.fptr);}
	ofstream& ofs(tcl_object *o) { return (ptr ? *(o->*p.ofpptr) : o->*p.ofptr);}
	ifstream& ifs(tcl_object *o) { return (ptr ? *(o->*p.ifpptr) : o->*p.ifptr);}
	wrapped_stream(fstream (tcl_object::*f)):ptr(false) {p.fptr= f;}
	wrapped_stream(fstream* (tcl_object::*f)):ptr(true) {p.fpptr= f;}
	wrapped_stream(ofstream (tcl_object::*f)):ptr(false) {p.ofptr= f;}
	wrapped_stream(ofstream* (tcl_object::*f)):ptr(true) {p.ofpptr= f;}
	wrapped_stream(ifstream (tcl_object::*f)):ptr(false) {p.ifptr= f;}
	wrapped_stream(ifstream* (tcl_object::*f)):ptr(true) {p.ifpptr = f;}
	~wrapped_stream(void) {}
};

DLL_IMPORT_EXPORT
class member_file : public cpp_config_mem {
  protected:
	member_file(const char* n,fstream (tcl_object::*fptr))
	:cpp_config_mem(n),strm(fptr) {}	
	member_file(const char* n,fstream* (tcl_object::*fptr))
	:cpp_config_mem(n),strm(fptr) {}	
	member_file(const char* n,ofstream (tcl_object::*fptr))
	:cpp_config_mem(n),strm(fptr) {}	
	member_file(const char* n,ofstream* (tcl_object::*fptr))
	:cpp_config_mem(n),strm(fptr) {}	
	member_file(const char* n,ifstream (tcl_object::*fptr))
	:cpp_config_mem(n),strm(fptr) {}	
	member_file(const char* n,ifstream* (tcl_object::*fptr))
	:cpp_config_mem(n),strm(fptr) {}	
	member_file(const member_file& m):cpp_config_mem(m),strm(m.strm) {}	
  public:
	Cpptcl_BaseClass(member_file);
	~member_file(void) {}
	///
	virtual bool have_file(tcl_object*) const=0;
    ///
	void tcl_get(tcl_object* o, tcl_obj& tcl_) const {
		if(have_file(o)) {
			if(is_open(o)) 
				tcl_ << "open";
			else
				tcl_ << "closed";
		} else {
			tcl_ << "no-file";
		}
	}
	///
	mutable wrapped_stream strm;
    ///
	void tcl_set(tcl_object* o, tcl_args_reader& t) const;
	/// opens the file in the correct read/write mode
	virtual bool open(tcl_object* o, const char* n) const=0;
	///
	virtual bool is_open(tcl_object* o) const=0;
	///
	virtual void close(tcl_object* o) const=0;
};

DLL_IMPORT_EXPORT
class member_file_io : public member_file {	
  protected:
    ///
	cpp_mem* copy(void) const {return new member_file_io(*this);}
	
  public:
	Cpptcl_BaseClass(member_file_io);
	member_file_io(const char* n,fstream (tcl_object::*fptr))
	:member_file(n,fptr) {}	
	member_file_io(const char* n,fstream* (tcl_object::*fptr))
	:member_file(n,fptr) {}	
	member_file_io(const member_file_io& m):member_file(m) {}	
	~member_file_io(void) {}
	
	bool have_file(tcl_object* o) const {
		return (strm.ptr ? (o->*strm.p.fpptr != NULL) : true);
	}
    ///
	const char* data_type(void) const {return "iofile";}
	///
	bool open(tcl_object* o, const char* n) const;
	///
	bool is_open(tcl_object* o) const { return strm.fs(o).is_open();}
	///
	void close(tcl_object* o) const {strm.fs(o).close();}
	
	bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)strm.p.fptr);
	}
};

DLL_IMPORT_EXPORT
class member_file_o : public member_file {
  protected:
    ///
	cpp_mem* copy(void) const {return new member_file_o(*this);}
	
  public:
	Cpptcl_BaseClass(member_file_o);
	member_file_o(const char* n,ofstream (tcl_object::*fptr))
	:member_file(n,fptr) {}	
	member_file_o(const char* n,ofstream* (tcl_object::*fptr))
	:member_file(n,fptr) {}	
	member_file_o(const member_file_o& m):member_file(m) {}	
	~member_file_o(void) {}
	
	bool have_file(tcl_object* o) const {
		return (strm.ptr ? (o->*strm.p.ofpptr != NULL) : true);
	}
    ///
	const char* data_type(void) const {return "outputfile";}
	///
	bool open(tcl_object* o, const char* n) const;
	///
	bool is_open(tcl_object* o) const { return strm.ofs(o).is_open();}
	///
	void close(tcl_object* o) const {strm.ofs(o).close();}
	bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)strm.p.fptr);
	}
};

DLL_IMPORT_EXPORT
class member_file_i : public member_file {
  protected:
    ///
	cpp_mem* copy(void) const {return new member_file_i(*this);}
	
  public:
	Cpptcl_BaseClass(member_file_i);
	member_file_i(const char* n,ifstream (tcl_object::*fptr))
	:member_file(n,fptr) {}	
	member_file_i(const char* n,ifstream* (tcl_object::*fptr))
	:member_file(n,fptr) {}	
	member_file_i(const member_file_i& m):member_file(m) {}	
	~member_file_i(void) {}
	
	bool have_file(tcl_object* o) const {
		return (strm.ptr ? (o->*strm.p.ifpptr != NULL) : true);
	}
    ///
	const char* data_type(void) const {return "inputfile";}
	///
	bool open(tcl_object* o, const char* n) const;
	///
	bool is_open(tcl_object* o) const { return strm.ifs(o).is_open();}
	///
	void close(tcl_object* o) const {
		if(strm.ptr && have_file(o)) {
			strm.ifs(o).close();
			delete &strm.ifs(o);
		} else {
			strm.ifs(o).close();
		}
	}			
	bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)strm.p.fptr);
	}
};

#endif
