/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "tcl_object.cc"
 *									  created: 29/5/96 {12:28:43 am}	
 *								  last update: 05/08/98 {09:25:29 AM}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "tcl_object.h"
#include "cpptcl_init.h"
#include "cpptcl_metaobject.h"
#include "meta_object.h"
#include "cpptcl_members.h"
#include "cpptcl_data_members.h"
#include "cpptcl_fn_members.h"
#include "cpptcl_member_object.h"
#include "cpptcl_subcommands.h"

//virtual
int tcl_object::parse_tcl_command(tcl_args& arg){
	if (has_members() && 
		(arg("-option value ?-option value? ?...?",
		 "set a configuration option","config")=="configure")) {
		return parse_configuration_args(arg);
  	} else if (has_members() && 
		(arg("-option","return value of a configuration option")=="cget")) {
		config_opt m(this);
		arg >> m >> done;
        NO_EXCEPTIONS(arg);
		// return the last one as the result
		m.obj->tcl_get(this,tcl_);
		tcl_ << result;
  		return TCL_OK;
	} else if (has_members() && arg("item name1 name2 op",
				"Set value of enclosed member using syntax of 'trace' call.")
				=="traceset") {
		member<cpp_config_mem> i(this);
		Tcl_Obj* name1;
		Tcl_Obj* name2;
		const char* op;
		arg >> i >> name1 >> name2 >> op >> done;
        NO_EXCEPTIONS(arg);
		if(name2->length == 0) { name2 = 0;}
		// read variable value into the data member value
		Tcl_ObjGetVar2(tcl_, name1, name2, TCL_GLOBAL_ONLY) >> i;
		return tcl_;
  	} else if (arg("","initialise object for use")=="initialise") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		initialise();
		return tcl_;
  	} else {
		return parse_subcommands(arg);
  	}
}

int tcl_object::contains(tcl_args& arg, tcl_object** &where) const {
	member<cpp_object_mem> i((tcl_object*)this);
	arg >> i >> done;
	NO_EXCEPTIONS(arg);
	cpp_object_mem* mem = i;
	where = &(mem->where_is_it((tcl_object*)this));
	return TCL_OK; 
}

int tcl_object::parse_subcommands(tcl_args& arg) {
	// First check for embedded operators
	cpp_mem* inf = (cpp_mem*) configuration_option(arg,meta_info(),0);
	if(inf) {
		NO_EXCEPTIONS(arg);
		arg.container = this;
		// read member commands parameters POSTPONE
		return inf->parse_tcl_command(arg);
	} else {
		// Now check for embedded subcommands
		const cpptcl_subcommand* sub = subcommand(arg,meta_info());
		if(!sub) {
			return arg.no_match_yet();
		}
		NO_EXCEPTIONS(arg);
		// got one, so build the command
		tcl_obj t;
		t << list_mode_on << sub->associated_proc << this;
		Tcl_Obj* o;
		while(arg.args_left()) {
			arg >> o;
			t << o;
		}
		t << list_mode_off;
		arg >> done;
		NO_EXCEPTIONS(arg);
		// evaluate
		tcl_ << t << eval;
		return tcl_;
	}
}

cpptcl_subcommand* tcl_object::subcommand(tcl_args& arg, 
  					  const meta_object& o) {
    //list<cpptcl_subcommand*>& l = o.sub_commands;
	for (list_pos<cpptcl_subcommand*> s = o.sub_commands.headConst(); s; ++s) {
		if(arg(s.item()->syntax,s.item()->help) == s.item()->subcommand) {
			return s.item();
		}
	}
	// look through parents
	for (list_pos<meta_object*> p = o.parent_list.headConst(); p; ++p) {
		cpptcl_subcommand* r = subcommand(arg,*(p.item()));
		if(r != 0) {
			return r;
		}
	}
	return (cpptcl_subcommand*) NULL;
}

int tcl_object::parse_configuration_values(tcl_args& arg) {
	if(arg.empty()) {
		arg >> done;
		if(arg.haveErr) {
			delete this;
			return TCL_ERROR;
		}
		return TCL_OK;
	} else {
		return parse_configuration_args(arg);
	}
}


// This will give an error if there are no args at all
int tcl_object::parse_configuration_args(tcl_args& arg) {
	// We have this outside the loop's scope, so we can return the
	// value of the last one
	config_opt inf(this);
	do {
		inf.clear();
		arg >> inf;
		NO_EXCEPTIONS(arg);
		inf.obj->get_syntax(arg);
		arg >> inf;
		if(!arg.haveErr) {
			/*archive() << ib->char_tcl_command() << " = " 
					  << arg[-1] << endl;
			*/
		}
		// found one, so continue (the above line set the value too!)
	} while(arg.args_left());
	arg >> done;
	NO_EXCEPTIONS(arg);
	// Return the last one as the result.  Be careful in case 'arg' was empty
	if(inf) {
		inf.obj->tcl_get(this,tcl_);
		tcl_ << result;
	}
	return TCL_OK;
}

