/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_config_mem.cc"
 *                                    created: 29/10/97 {1:17:29 pm} 
 *                                last update: 3/11/97 {10:22:54 am} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "cpptcl_config_mem.h"

Cpptcl_IBaseClass(cpp_config_mem,"configurablemember",cpp_mem);

void cpp_config_mem::conversion_error(tcl_args& arg) const {
	tcl_obj obuf;
	if(read_only()) {
		obuf << " - item is read-only";
	} else {
		obuf << " to type '" << data_type();
	}
	arg.set_conversion_type(obuf);
	arg.syntax("value");
}

int cpp_config_mem::parse_meta_commands(tcl_obj& tcl_, tcl_args& arg) {
	if(arg("","is this item read-only")=="readonly") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_ << read_only() << result;
		return tcl_;
	} else {
		return cpp_mem::parse_meta_commands(tcl_,arg);
	}
}
 
