## -*-Tcl-*-
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "alphaDefinitions.tcl"
 #                                    created: 98-04-05 21.31.20 
 #                                last update: 20/4/1999 {11:16:09 pm} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom 
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.  
 # Alpha is shareware; please register with the author using the register 
 # button in the about box.
 #  
 # ###################################################################
 ##

proc alpha::getDefinitions {} {}

namespace eval flag {}
namespace eval global {}

ensureset tclvars {}
ensureset allFlags {}
ensureset allVars {}
set invisibleModeVars(wordWrap) 1

proc flag::options {v} {
    global flag::list
    set thelist [set flag::list($v)]
    set litems [lindex $thelist 1]
    switch -- [lindex $thelist 0] {
	"varitem" {
	    return [uplevel \#0 "set $litems"]
	}
	"varindex" {
	    return [uplevel \#0 "set $litems"]
	}
	"array" {
	    global $litems
	    return [lsort [array names $litems]]
	}
    }
    return $litems
}

# To fix the position of the status bar, click this box.||To allow dragging
# of the status bar (usually at the bottom of the screen), click this box.
newPref linkflag lockStatus 1
# To scroll the horizontal scrollbar automatically to follow your typing, 
# click this box||To enforce manual use of the horizontal scroll bar,
# click this box.
newPref linkflag autoHScroll 1
# To save files automatically (except untitled buffers) every 'changesLim' 
# changes, click this box||To disable the automatic saving of files, click
# this box.
newPref linkflag autoSave 0
# To make the cursor blink, click this box||To stop the cursor blinking, 
# click this box
newPref linkflag blinkingCursor 1
# To use a solid rectangular cursor, click this box||To use a thin vertical 
# cursor, click this box.
newPref linkflag blockCursor 0
# To color words according to mode and context, click this box||To display all 
# text more quickly, but in plain black and white, click this box.
newPref linkflag coloring 1
# To enable drag and drop editing using the mouse, click this box||To disable 
# drag and drop editing using the mouse, click this box.
newPref linkflag dragAndDrop 1
# To display a horizontal scrollbar in new windows, click this box||To make 
# maximum use of window space and not use a horizontal scrollbar, click this box.
newPref linkflag horScrollBar 1
# To enable clicking on hypertext items, click this box||To disable clicking
# on hypertext items, click this box
newPref linkflag hyperText 1
# To force the insertion point to move with 'pageBack' and 'pageForward' 
# commands, click this box||To leave the insertion point in place (usually 
# offscreen) after 'pageBack' and 'pageForward' commands, click this box
newPref linkflag moveInsertion 1
# To list all file types (as opposed to just 'TEXT') in open/save dialog 
# boxes, click this box||To display only 'TEXT' files in open/save dialog 
# boxes, click this box.
newPref linkflag openAllFiles 0
# To make the window scroll dynamically while using vertical scrollbars, 
# click this box||To make the window scroll only after releasing the button 
# in a vertical scrollbar, click this box
newPref linkflag powerThumb 1
# Respect projector resources
newPref linkflag projectorAware 1
# To show all tabs, carriage returns, spaces etc with distinct symbols, 
# click this box||To display whitespace characters normally, click this box.
newPref linkflag showInvisibles 0
# To use a small font for the various pop-up menus (e.g. marks menu), click this 
# box||To use the standard system font for the popup menus, click this box.
newPref linkflag smallMenuFont 1
# if set, sorted is the default for function and section menus
newPref linkflag sortedIsDefault
# To allow tearing off of menus, click this box||To disable tearing-off of
# menus, click this box
newPref linkflag tearoffMenus 1
# To enable Alpha's use of system temporary memory, click this box||To disallow
# Alpha from using system temporary memory, click this box.
newPref linkflag tempMem 1
# To retain editing information to allow undo/redo operations, click this box||
# To edit destructively (saving memory, and operating a little faster in, for 
# example global replaces), click this box.
newPref linkflag undoOn 1
# To automatically insert a carriage-return when you exceed a line
# length of 'fillColumn' characters, click this box||To disable automatic
# text wrapping, click this box.
newPref linkflag wordWrap 1
# To add a description of each preference to the standard dialogs, click this 
# box||To use standard preference dialogs, with a 'Help' button to display
# descriptions, click this box
newPref flag includeDescriptionsInDialogs 0
# Used by completion routines: if there is a selection and you and
# trying to complete something, and this item is set, Alpha will ask before 
# deleting the selection.|| Used by completion routines: if there is a 
# selection and you and trying to complete something, and this item is set, 
# Alpha will ask before deleting the selection.
newPref flag askDeleteSelection 0
# To make a backup every time a file is saved, click this box||To save disk
# space and not make backup copies when saving files, click this box.
newPref flag backup 0
# To force newly opened windows onto the main screen, click this box||To allow
# new windows to be opened anywhere, including off screen, click this box.
newPref flag forceMainScreen 1
# To iconify windows when you switch to another application, click this box||
# To leave windows alone when switching to other applications, click this box.
newPref flag iconifyOnSwitch 0
# To sort the items in the popup function menu '{}', click this box||To leave
# the items in the popup function menu '{}' in the order in which they appear,
# click this box.
newPref flag sortFuncsMenu 1
# To place two spaces after the '.' at the end of each sentence when
# filling blocks of text, click this box|| To place only a single space
# after the '.' at the end of each sentence when
# filling blocks of text, click this box
newPref flag doubleSpaces 1
# To print a header at the top of each printed page, click this box||
# To print only the contents of the window, without any identifying header,
# click this box.
newPref flag printHeader 1
# To include a file's full path in the printed header, click this box
# ||To place just a file's name in the printed header, click this box
newPref flag printHeaderFullPath 0
# To include the current time in printed headers, click this box
# ||To remove the current time from printed headers, click this box
newPref flag printHeaderTime 1
# To choose from a listbox of possible completions if you try to 
# complete a command for which no unique
# suffix exists, click this box.||To abort the completion if no
# unique suffix exists, click this box.
newPref flag listPickIfMultCmps 1
# if we have a choice between, say \left, \leftRight, \leftMore,
# then we don't get stuck on '\left' with this option.
newPref flag listPickIfNonUniqueStuckCmp 1
# To clear old marks automatically when you select 'Mark File', 
# click this box.||To check before clearing old marks, click this box.
newPref flag quietlyClearMarks 1
# To make Alpha beep when it asks you for something in the status bar, 
# click this box.||To turn off the alert beep when using the status
# bar, click this box.
newPref flag promptNoisily 0
# To prompt in the status bar if possible (rather than use a dialog),
# click this box.||To use dialogs in preference to the status bar for
# user input, click this box.
newPref flag useStatusBar 1
# Folder in which to store backups.  A null value tells Alpha to use
# the file's current directory.
newPref var backupFolder ""
# Extension to add to files when backing them up
newPref var backupExtension "~"
# If the previous backup is more recent than this number of hours,
# then don't make a new backup.  If greater than zero, this means the 
# backups Alpha has tend to be significantly different to the current file.
newPref var backupAgeRequirementInHours 0.0
# When creating files for uploading through the Ftp menu, save them
# with this eol format.  Note that some ftp clients may translate
# eols for you as they up/download.
newPref var createFtpType unix global "" "mac unix ibm"
# Number of pixels from left edge of window to start of text
newPref var horMargin 4
# Alpha will visually indent code by this many characters to 
# indicate its structure
newPref var indentationAmount 4
# If we have fewer than this many items in the opt-titlebar-menu,
# add the contents of the current directory
newPref var minItemsInTitlePopup 5
# The tiling items in the 'Arrange' menu will relocate this many
# windows, starting with the front window and moving back.
newPref var numWinsToTile 2
newPref var tileHeight [expr {$screenHeight - 60}]
newPref var tileLeft 2
newPref var tileMargin 22
newPref var tileProportion .60
newPref var tileTop 40
newPref var tileWidth [expr {$screenWidth - 10}]
newPref linkvariable defLeft 2
newPref linkvariable defTop 40
newPref linkvariable defHeight $tileHeight
newPref linkvariable defWidth [expr {$tileWidth > 510 ? 510 : $tileWidth}]
# The fraction of the screen the small batch-search, or diff-style 
# windows use up.
newPref var batchListWindowFraction 0.25 global win::SetProportions
# The type of keyboard you have.  This influences some of the keyboard
# shortcuts Alpha places in the menus, and is used for better setting
# of user-defined key-bindings.
newPref variable keyboard US global keys::keyboardChanged keyboards array
# This dictates the spelling Alpha uses for words like 'Colour/Color'
newPref var spelling 0 global "" "American British" index
# Useful for debugging some complex startup problems; you can choose
# between logging all errors for later viewing, or displaying them
# immediately
newPref var reportErrors 1 global "" \
  [list "Log startup errors" "Report errors immediately"] index
# re-read internet preferences from IC each startup
newPref flag synchroniseWithInternetConfig 0
# The font to use for printing documents
newPref linkvariable printerFont "" global "" "system monaco courier geneva helvetica profont times {new york}"
# The font-size to use for printing documents.
newPref linkvariable printerFontSize "" global "" "7 9 10 12 14 18"
# Default font to use for new windows
newPref linkvariable defaultFont "monaco" global "" "system monaco courier geneva helvetica profont times {new york} programmer"
# Default font size to use for new windows
newPref linkvariable fontSize 9 global "" "7 9 10 12 14 18"
# The amount of information to store in the resource fork of saved text
# files.  This can include font, tab, selection,... information.  Here, 'think' 
# implies font, tab information, and 'mpw' adds window position and window
# selection.
newPref linkvariable savedState "" global "" "none think mpw"
# The default size for a tab character for new windows (not the same as 
# the amount of space used for visual indentation of code).
# Alpha can be configured to remember tab sizes for previously edited documents
# -- see 'savedState' for details.
newPref linkvariable tabSize 8
# Regexp used for automatic word wrapping
newPref linkvariable wrapBreak {[\w_]+}
# Regexp used for automatic word wrapping
newPref linkvariable wrapBreakPreface {([^\w_])}
# Auto-wrap if the user types further than this column
newPref linkvariable wrapHigh ""
# Auto-un-wrap if the user deletes chars so a line is shorter than this
newPref linkvariable wrapLow ""
# The maximum number of changes before auto-saving occurs (if set via the 
# autoSave preference)
newPref linkvariable changesLim ""
# When wrapping text (see 'Word Wrap' preference), wrapping occurs
# for any text beyond this column position.  Used by all 'Fill' routines
newPref linkvariable fillColumn 75
# Set to the regular expression that ALPHA uses to find function declarations.
newPref linkvariable funcExpr {^[^ \t\(#\r/@].*\(.*\)$}
# The parenthesised regexp block to use for the func name
newPref linkvariable funcPar 1
# Number of blanks left at beginning of lines by 'fill' routines.
newPref linkvariable leftFillColumn 0
# Alpha asks the user if wrapping should be done whenever the user opens 
# files that have lines longer than 'paraColumn' characters
newPref linkvariable paraColumn 180
# Text column to use as the sort key when executing 'Sort Lines'.
newPref linkvariable sortColumn 0
# File to use for Tag searches.
newPref linkio-file tagFile [file join $HOME cTAGS]
# Margin size for printing
newPref linkvariable leftMargin ""
# Margin size for printing
newPref linkvariable bottomMargin ""
# Margin size for printing
newPref linkvariable topMargin ""
# Regular expression used to defines words for all internal operations.  Most
# modes have their own definition of this variable.
newPref linkvariable wordBreak {\w+}
# Prepended to 'wordBreak' when looking backwards for a word.  Most
# modes have their own definition of this variable.
newPref linkvariable wordBreakPreface {(\W)}
# Flags that won't appear in the menu.
linkVar numLock
# Usual place you use for downloading updates to Alpha and its packages.
newPref var defaultAlphaDownloadSite "" global "" remote::site array
# bug in alpha-IC interaction
if {![catch "icGetPref DownloadFolder" res] && [file exists $res]} {
    # Default download location for files from the internet
    newPref var downloadFolder $res
} else {
    newPref var downloadFolder $HOME
}
# if first item = code, then indent relative to code by given value of second arg
# if first item = fixed, then force indentation to given level
set indentationTypes [list "code 0" "code 4" "fixed 0"]

lunion flagPrefs(Backups)	backup undoOn autoSave
lunion varPrefs(Backups)	backupFolder backupExtension changesLim \
  backupAgeRequirementInHours
lunion flagPrefs(Text)		hyperText doubleSpaces dragAndDrop	
lunion varPrefs(Text)		fillColumn leftFillColumn paraColumn wrapLow \
  wrapHigh sortColumn
lunion flagPrefs(Appearance)	blinkingCursor blockCursor coloring \
  showInvisibles smallMenuFont sortFuncsMenu tearoffMenus   \
  promptNoisily includeDescriptionsInDialogs
lunion varPrefs(Appearance)	defaultFont fontSize tabSize 
lunion flagPrefs(Printer)	printHeader printHeaderFullPath printHeaderTime
lunion varPrefs(Printer)	bottomMargin printerFont printerFontSize \
  topMargin leftMargin
lunion flagPrefs(Tags)		
lunion varPrefs(Tags)		funcPar tagFile
lunion flagPrefs(Window)	autoHScroll forceMainScreen horScrollBar \
  moveInsertion powerThumb sortedIsDefault iconifyOnSwitch lockStatus \
  useStatusBar
lunion varPrefs(Window)		defHeight defLeft defTop defWidth \
  minItemsInTitlePopup savedState
lunion flagPrefs(Tiling)		
lunion varPrefs(Tiling)		numWinsToTile batchListWindowFraction horMargin \
  tileHeight tileProportion tileLeft tileMargin tileTop tileWidth 
lunion flagPrefs(Electrics)	listPickIfMultCmps listPickIfNonUniqueStuckCmp \
  askDeleteSelection
lunion varPrefs(Electrics)	indentationAmount elecStopMarker
lunion flagPrefs(Files) tempMem projectorAware openAllFiles
lunion varPrefs(Files) 
lunion "flagPrefs(Helper Applications)"
lunion "varPrefs(Helper Applications)"
lunion flagPrefs(WWW) synchroniseWithInternetConfig
lunion varPrefs(WWW) defaultAlphaDownloadSite createFtpType downloadFolder \
  browserSig ftpSig httpDownloadSig
lunion flagPrefs(International)
lunion varPrefs(International) keyboard spelling 
lunion flagPrefs(Packages)
lunion varPrefs(Packages) 
lunion flagPrefs(Errors)
lunion varPrefs(Errors) reportErrors

proc alpha::addToPreferencePage {page args} {
    global varPrefs flagPrefs allFlags
    set vars [lremove -l $args $allFlags]
    set flags [lremove -l $args $vars]
    eval lunion varPrefs($page) $vars
    eval lunion flagPrefs($page) $flags
}

namespace eval indent {}

set indent::amounts [list "nothing" "half-tab" "tab"]

proc indent::setup {args} {
    global indent_amounts indentationAmount
    set indent_amounts(0) 0
    set indent_amounts(1) [expr {$indentationAmount/2}]
    set indent_amounts(2) $indentationAmount
    set indent_amounts(-1) [expr {-$indentationAmount/2}]
    set indent_amounts(-2) [expr {-$indentationAmount}]
}
indent::setup
trace variable indentationAmount w indent::setup

proc getFileSig {f} {
    getFileInfo $f arr
    if {[info exists arr(creator)]} {
	return $arr(creator)
    } else {
	return ""
    }
}

proc getFileType {f} {
    getFileInfo $f arr
    if {[info exists arr(type)]} {
	return $arr(type)
    } else {
	return "TEXT"
    }
}

# get defaults from internet config
if {$synchroniseWithInternetConfig} {
    catch {set browserSig [getFileSig [icGetPref -t 1 Helperhttp]]}
    catch {set ftpSig [getFileSig [icGetPref -t 1 Helperftp]]}
} else {
    catch {ensureset browserSig [getFileSig [icGetPref -t 1 Helperhttp]]}
    catch {ensureset ftpSig [getFileSig [icGetPref -t 1 Helperftp]]}
}

# The application signature of your internet browser
newPref v browserSig MOSS
# The application signature of your ftp client
newPref v ftpSig Arch
# The application signature of your internet browser to use for downloading
# only (rather than viewing)
newPref v httpDownloadSig $browserSig

# The application signature of your stuffit expander
newPref v unstuffSig SITx

namespace eval win {}

proc win::SetProportions {} {
    global tileHeight tileWidth tileTop tileLeft tileHeight \
      errorHeight errorDisp tileMargin batchListWindowFraction
    set errorHeight [expr {int ($batchListWindowFraction * ($tileHeight - $tileMargin))}]
    set errorDisp [expr {int ((1- $batchListWindowFraction) * ($tileHeight - $tileMargin))}]
}

proc wordWrapProc {val} { 
    global mode wordWrap modifiedArrayElements 
    global ${mode}modeVars
    set wordWrap $val
    set ${mode}modeVars(wordWrap) $val
    lappend modifiedArrayElements [list wordWrap ${mode}modeVars]
}


proc toggleNumLock {} {
    global numLock modifiedVars
    
    set numLock [expr {1 - $numLock}]
    lappend modifiedVars numLock
}

#============================================================================
# declare these as modeVars in advance.  I'm not sure it is necessary (Vince)
lunion modeVars funcExpr wrapBreakPreface wrapBreak wordBreakPreface wordBreak

# 'mode' is nothing when we start up.
set mode		{}
set lastMode		0
set reverting		{}

# For quithook
set modifiedVars	{}
set modifiedArrVars     {}
set modifiedModeVars    {}
set modifiedArrayElements {}

namespace eval win {}
ensureset win::Active ""

# Default settings of some global parameters (not preferences settings)
# These will all be over-written by user-defs if set.
set resumeRevert 0
set prefixString ">\ "
set suffixString "\ <--"
# mapping of windows to current modes.
set win::Modes("") ""
# keep count of number of dirty windows.
set win::NumDirty 0
set win::Current ""
# For mark stack.
set markName 0
set markStack ""
set winMenu "263"
set keyboard "U.S."
set oldkeyboard ""

win::SetProportions

lunion ftpSigs Arch FTCh Woof
lunion texSigs OTEX *TEX *XeT MPS*
lunion browserSigs MOSS MSIE dogz OlG1 HTVW
lunion httpDownloadSigs MOSS MSIE dogz OlG1 Geni Arch
lunion tclshSigs WIsH TclL Geni
lunion unstuffSigs SITx MV50

namespace eval keys {}

array set keys::specialProcs { 
    "Next Stop" "ring::+"
    "Next Stop Or Indent" "bind::IndentOrNextstop"
    "Complete" "bind::Completion"
    "Complete Or Tab" "bind::TabOrComplete"
    "Prev Stop" "ring::-"
    "Real Tab" "insertActualTab"
    "nth Stop" "ring::nth"
    "Clear All Stops" "ring::clear"
}

array set keys::specialBindings {
    "Complete" "<O/c"
    "Prev Stop" "<U/c"
    "Real Tab" "<I/c"
    "nth Stop" "<B/c"
    "Clear All Stops" "<U<B/c"
    "Next Stop" ""
    "Complete Or Tab" ""
    "Next Stop Or Indent" "/c"
}

# Note: the Mercutio MDEF can only handle icon-suite resources
# with id's from 208 to 208+255 = 463.  Hence many of the little
# icons which Alpha contains cannot appear in menus.  You could
# of course do a little hacking....
set alpha::_icons {
    {DanR "Think Reference" 265}
    {OTEX "OzTeX" 266}
    {*TEX "TeXtures" 267}
    {XXXX "LaTeX" 270}
    {*XeT "CMacTeX" 272}
    {TeX+ "DirectTeX Pro" 299}
    {CWIE "Codewarrior" 268}
    {dogz "Cyberdog" 281}
    {Vbib "BibTeX" 282}
    {SLab "Scilab" 283}
    {IGR0 "Igor Pro" 284}
    {JAVC "Apple Applet Viewer" 285}
    {MOSS "Netscape Navigator" 293}
    {MOSS "Netscape Communicator" 294}
    {MSIE "Microsoft Internet Explorer" 295}
    {OlG1 "MacLynx" 296}
    {DanR "Think Ref Viewer" 310}
    {gsVR "Ghostview" 311}
    {PnLF "Finger" 313}
    {RZMI "MakeIndex" 314}
    {FTCh "Fetch" 315}
    {TGE+ "Tarmac" 316}
    {Gzip "Gzip" 317}
    {DStf "DropStuff" 318}
    {SITx "StuffIt Expander" 319}
    {ALTV "Programmer's Assistant" 400}
    {MPAD "Mupad" 411}
    {GPSE "Gnuplot" 415}
    {Vodo "VOODOO" 500}
}

namespace eval remote {}

ensureset "remote::site(Alpha's Home)" \
  "ftp://alpha.olm.net/pub/packages/"
ensureset "remote::site(Alpha's Upload site)" \
  "ftp://alpha.olm.net/incoming/"
ensureset "remote::site(Vince's Alpha-D site)" \
  "ftp://ftp.ucsd.edu/pub/alpha/"

ensureset remote::listing {}

namespace eval keyboard {}

# array set keyboard::localized {
#     Svensk Swedish
#     U.S. U.S.
# }
# 
# # Works with MacOS 8.5, but possibly not earlier releases.
# if {![catch {aebuild::result 'MACS' kybd ckyl} __keyboard] && \
#   [info exist keyboard::localized($__keyboard)]} {
#     set keyboard [set keyboard::localized($__keyboard)]
# }
# 
# catch {unset keyboard::localized __keyboard}

set "keyboards(Australian)" {
 {1234567890-=[];'\`,./}
 {!@#$%^&*()_+{}:"|~<>?}
 <U/[
 <U/]
 {'' 0x0a '' 0x0a}
}
set "keyboards(Brasil)" {
 {1234567890'+~\<,.-}
 {!"#$%&/()=?*`^|>;:_}
 <I<U/8
 <I<U/9
 {'' 0x0a '' 0x0a '' 0x21 '' 0x21 '' 0x29 '' 0x29 '' 0x1e '`' 0x1e '~' 0x27 '^' 0x27}
}
set "keyboards(British)" {
 {1234567890-=[];'\`,./}
 {!@$%^&*()_+{}:"|~<>?}
 <U/[
 <U/]
 {'' 0x0a '' 0x0a '' 0x14}
}
set "keyboards(Canadian - CSA)" {
 {/1234567890-=^;,.}
 {\!@#$%?&*()_+:'"}
 <I/7
 <I/8
 {'' 0x1e '' 0x1e '' 0x27 '' 0x27 '' 0x2a '' 0x2a '' 0x2c '' 0x2c '' 0x32 '' 0x32 '^' 0x21 '' 0x21 '7' 0x1a '8' 0x1c}
}
set "keyboards(Canadian - ISO)" {
 {1234567890-=^;,.}
 {!"#$%?&*()_+:'.}
 <I/7
 <I/0
 {'' 0x0a '' 0x0a '' 0x1e '' 0x1e '' 0x27 '' 0x27 '' 0x2a '' 0x2a '' 0x2c '' 0x2c '' 0x32 '' 0x32 '^' 0x21 '' 0x21 '7' 0x1a '0' 0x1d}
}
set "keyboards(Canadian - French)" {
 {<1234567890-='[;`/,.}
 {>!@#$%?&*()_+"]:^|<>}
 <I/[
 <I<U/[
 {'' 0x2c '' 0x2c '' 0x06 '' 0x06 '`' 0x27 '^' 0x27}
}
set "keyboards(Danish)" {
 {$1234567890+'<,.-}
 {!"#%&/()=?`^*>;:_}
 <I<U/8
 <I<U/9
 {'' 0x0a '' 0x15 '' 0x21 '' 0x21 '' 0x29 '' 0x29 '' 0x27 '' 0x27 '' 0x1e '^' 0x1e '' 0x18 '`' 0x18}
}
set "keyboards(Dutch)" {
 {1234567890-=[];'\`,./}
 {!@#$%^&*()_+{}:"|~<>?}
 <U/[
 <U/]
 {'' 0x0a '' 0x0a}
}
set "keyboards(Espaol - ISO)" {
 {1234567890'`+<,.-}
 {!"$%&/()=?^*>;:_}
 <I/
 <I/
 {'' 0x2a '' 0x29 '' 0x2a '' 0x29 '' 0x18 '' 0x18 '' 0x0a '' 0x0a '' 0x14 '`' 0x21 '^' 0x21 '' 0x27 '' 0x27}
}
set "keyboards(Finnish)" {
 {1234567890+'<,.-}
 {!"#%&/()=?`^*>;:_}
 <I<U/8
 <I<U/9
 {'' 0x0a '' 0x0a '' 0x15 '' 0x21 '' 0x27 '' 0x29 '' 0x21 '' 0x27 '' 0x29 '' 0x1e '^' 0x1e '' 0x18 '`' 0x18}
}
set "keyboards(Flemish)" {
 {@&"'(!)-^$`<,;:=}
 {#1234567890_*%>?./+}
 <I/(
 <I/)
 {'' 0x13 '(' 0x17 '' 0x16 '' 0x1a '' 0x19 '' 0x1d ')' 0x1b '' 0x1b '' 0x27 '^' 0x21 '' 0x21 '`' 0x2a '' 0x2a}
}
set "keyboards(French)" {
 {@&"'(!)-^$`<,;:=}
 {#1234567890_*%>?./+}
 <I/(
 <I/)
 {'' 0x13 '(' 0x17 '' 0x16 '' 0x1a '' 0x19 '' 0x1d ')' 0x1b '' 0x1b '' 0x27 '^' 0x21 '' 0x21 '`' 0x2a '' 0x2a}
}
set "keyboards(French - numerical)" {
 {@&"'(!)-^$`<,;:=}
 {#1234567890_*%>?./+}
 <I/(
 <I/)
 {'' 0x13 '(' 0x17 '' 0x16 '' 0x1a '' 0x19 '' 0x1d ')' 0x1b '' 0x1b '' 0x27 '^' 0x21 '' 0x21 '`' 0x2a '' 0x2a}
}
set "keyboards(German)" {
 {^1234567890+#<,.-}
 {!"$%&/()=?`*^>;:_}
 <I/8
 <I/9
 {'^' 0x0a '' 0x0a '' 0x14 '' 0x21 '' 0x29 '' 0x27 '' 0x21 '' 0x29 '' 0x27 '' 0x1b '' 0x18 '`' 0x18 '8' 0x1c '9' 0x19}
}
set "keyboards(Italian)" {
 {@&"'()-=$<,;:}
 {#1234567890_+^*%>?./!}
 <I/(
 <I/)
 {'(' 0x15 ')' 0x1a '' 0x17 '' 0x16 '' 0x1c '' 0x19 '' 0x1d '' 0x21 '' 0x27 '' 0x2c '' 0x2a '' 0x2a}
}
set "keyboards(Norwegian)" {
 {'1234567890+@<,.-}
 {!"#$%&/()=?`^*>;:_}
 <I<U/8
 <I<U/9
 {'' 0x0a '' 0x21 '' 0x27 '' 0x29 '' 0x21 '' 0x27 '' 0x29 '' 0x1e '^' 0x1e '' 0x18 '`' 0x18}
}
set "keyboards(Spanish)" {
 {[1234567890-=`;'<,.}
 {]!#$%/&*()_+:">?}
 <I<U/<
 <U/[
 {'' 0x12 '' 0x21 '' 0x21 '' 0x29 '' 0x29 '' 0x2b '' 0x2c '' 0x2c '`' 0x1e '' 0x1e}
}
set "keyboards(Swedish)" {
 {1234567890+'<,.-}
 {!"#%&/()=?`^*>;:_}
 <I<U/8
 <I<U/9
 {'' 0x0a '' 0x0a '' 0x15 '' 0x21 '' 0x21 '' 0x27 '' 0x27 '' 0x29 '' 0x29 '' 0x1e '^' 0x1e '' 0x18 '`' 0x18}
}
set "keyboards(Swiss French)" {
 {1234567890'^$<,.-}
 {+"*%&/()=?`!>;:_}
 <I/8
 <I/9
 {'' 0x0a '' 0x0a '' 0x21 '' 0x21 '' 0x29 '' 0x29 '' 0x27 '' 0x27 '' 0x15 '' 0x2a '' 0x1e '!' 0x1e '^' 0x18 '`' 0x18 '8' 0x1c '9' 0x19}
}
set "keyboards(Swiss German)" {
 {1234567890'^$<,.-}
 {+"*%&/()=?`!>;:_}
 <I/8
 <I/9
 {'' 0x0a '' 0x0a '' 0x21 '' 0x21 '' 0x29 '' 0x29 '' 0x27 '' 0x27 '' 0x15 '' 0x2a '' 0x1e '!' 0x1e '^' 0x18 '`' 0x18 '8' 0x1c '9' 0x19}
}
set "keyboards(U.S.)" {
 {1234567890-=[];'\`,./}
 {!@#$%^&*()_+{}:"|~<>?}
 <U/[
 <U/]
 {'' 0x0a '' 0x0a}
}

set "keyboards(Slovenian)" {
  {1234567890/+<,.-}
  {!"#$%&'()=?*Ʈ>;:_}
  <U<I/
  <U<I/
  {'' 0x0a '' 0x0a '' 0x21 '' 0x21 '' 0x1e '' 0x1e '' 0x29 '' 0x29 '' 0x27 '' 0x27 '' 0x2a '' 0x2a}
}

set "keyboards(Croatian)" {
  {1234567890/+䶋<,.-}
  {!"#$%&'()=?*ᭉ>;:_}
  <U<I/
  <U<I/
  {'' 0x0a '' 0x0a '' 0x21 '' 0x21 '' 0x1e '' 0x1e '' 0x29 '' 0x29 '' 0x27 '' 0x27 '' 0x2a '' 0x2a}
}

set "keyboards(Roman - JIS)" {
  {1234567890-^@[;:]`,./}
  {!"#$%&'()0=~`{+*}~<>?}
 <U/[
 <U/]
 {'' 0x0a '' 0x0a}
}

