# -*-Make-*-
# 
# Makefile.in --
#
#	This file is a Makefile for the tcllib standard tcl library. If this
#	is "Makefile.in" then it is a template for a Makefile;  to generate 
#	the actual Makefile, run "./configure", which is a configuration script
#	generated by the "autoconf" program (constructs like "@foo@" will get
#	replaced in the actual Makefile.
#
# Copyright (c) 1999-2000 Ajuba Solutions
# Copyright (c) 2001-2002      ActiveState Tool Corp.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: Makefile-Example.m4,v 1.3 2003/03/31 23:01:01 vincentdarley Exp $

# Base64 encoder/decoder
BASE64=base64

# Option processing package (like opt)
CMDLINE=cmdline

# Socket based 'send'.
COMM=comm

# Control flow commands and other language structures
CONTROL=control

# CSV processing
CSV=csv

# File utilities (grep, find, etc.)
FILEUTIL=fileutil

# FTP library
FTP=ftp

# FTPD library
FTPD=ftpd

# Code to generate javascript code (for dynamically generated web pages)
JAVASCRIPT=javascript

# Math functions
MATH=math

# MD5 hash digest
MD5=md5

# SHA1 hash digest
SHA1=sha1

# Data structures (stack, queue, tree)
STRUCT=struct

# CGI input processing, "ncgi" to avoid conflict with Libes cgi.tcl
NCGI=ncgi

# Simple function level profiler
PROFILER=profiler

# POP3 email client API
POP3=pop3

# HTML generation API
HTML=html

# MIME encoder/decoder and SMTP package. These are modified/hacked to
# have a soft requirement for Trf: They will encode/decode MIME
# messages faster if Trf is available.  Another speciality here: One
# directory contains two packages! This requires a little hackery
# when creating the full package index for tcllib.
MIME=mime

# URI parsing module
URI=uri

# NNTP client module
NNTP=nntp

# Text utilities
TEXTUTIL=textutil

# Counters and statistics
COUNTER=counter

# Logging facility
LOGGER=log

# HTML parsing facilities
HTMLPARSE=htmlparse

# Tabular reporting (depends upon matrix)
REPORT=report

# Object oriented extension: stooop
# (Simple Tcl Only Object Oriented Programming)
STOOOP=stooop

# SMTP daemon
SMTPD=smtpd

# Cyclic Redundancy Check
CRC=crc

# Calendar facilities
CALENDAR=calendar

MODULES= \
	$(BASE64)	\
	$(CALENDAR)	\
	$(CMDLINE)	\
	$(COMM)		\
	$(CONTROL)	\
	$(CRC)		\
	$(CSV)		\
	$(COUNTER)	\
	$(STRUCT)	\
	$(FILEUTIL)	\
	$(FTP)		\
	$(FTPD)         \
	$(JAVASCRIPT)   \
	$(HTML)         \
	$(MATH)		\
	$(MD5)		\
	$(MIME)		\
	$(NCGI)		\
	$(NNTP)         \
	$(POP3)		\
	$(PROFILER)	\
	$(SMTPD)	\
	$(TEXTUTIL)	\
	$(URI)		\
	$(LOGGER)	\
	$(HTMLPARSE)	\
	$(REPORT)	\
	$(SHA1) \
	$(STOOOP)

#========================================================================
# Nothing of the variables below this line need to be changed.  Please
# check the TARGETS section below to make sure the make targets are
# correct.
#========================================================================

SHELL = @SHELL@

INSTALL_ROOT =

srcdir = @srcdir@
top_srcdir = @top_srcdir@
prefix = $(INSTALL_ROOT)@prefix@
exec_prefix = $(INSTALL_ROOT)@exec_prefix@

libdir = $(INSTALL_ROOT)@libdir@
mandir = $(INSTALL_ROOT)@mandir@

DESTDIR =

pkglibdir = $(prefix)/lib/@PACKAGE@@VERSION@

top_builddir = .

INSTALL = @INSTALL@
INSTALL_PROGRAM = @INSTALL_PROGRAM@
INSTALL_DATA = @INSTALL_DATA@
INSTALL_SCRIPT = @INSTALL_SCRIPT@
INSTALL_STRIP_FLAG =
transform = @program_transform_name@

NORMAL_INSTALL = :
PRE_INSTALL = :
POST_INSTALL = :
NORMAL_UNINSTALL = :
PRE_UNINSTALL = :
POST_UNINSTALL = :

PACKAGE = @PACKAGE@
VERSION = @VERSION@
CYGPATH = @CYGPATH@
TCLSH_PROG = @TCLSH_PROG@

AUTOCONF = autoconf

ACLOCAL_M4 = $(top_srcdir)/aclocal.m4
CONFIGDIR = @CONFIGDIR@
mkinstalldirs = $(SHELL) $(CONFIGDIR)/mkinstalldirs
CONFIG_CLEAN_FILES =

#========================================================================
# Start of user-definable TARGETS section
#========================================================================

#========================================================================
# TEA TARGETS.  Please note that the "libraries:" target refers to platform
# independent files, and the "binaries:" target inclues executable programs and
# platform-dependent libraries.  Modify these targets so that they install
# the various pieces of your package.  The make and install rules
# for the BINARIES that you specified above have already been done.
#========================================================================

all: libraries doc

#========================================================================
# The binaries target builds executable programs, Windows .dll's, unix
# shared/static libraries, and any other platform-dependent files.
# The list of targets to build for "binaries:" is specified at the top
# of the Makefile, in the "BINARIES" variable.
#========================================================================

binaries:

libraries:

doc:

install: all install-libraries install-doc

install-binaries: 

#========================================================================
# This rule installs platform-independent files, such as header files.
#========================================================================

install-libraries: libraries
	$(mkinstalldirs) $(pkglibdir)
	@echo "Installing modules in $(pkglibdir)"
	@for i in $(MODULES) ; do \
	    if test -d $(srcdir)/modules/$$i; then  \
		echo "Installing $$i in $(pkglibdir)/$$i" ; \
		$(mkinstalldirs) $(pkglibdir)/$$i ; \
		for j in $(srcdir)/modules/$$i/*.tcl ; do \
		    $(INSTALL_DATA) $$j $(pkglibdir)/$$i ; \
		done; \
		if test -f $(srcdir)/modules/$$i/tclIndex ; then \
		    $(INSTALL_DATA) $(srcdir)/modules/$$i/tclIndex $(pkglibdir)/$$i ; \
		fi \
	    fi; \
	done;
	$(TCLSH_PROG) `$(CYGPATH) $(srcdir)/mkIndex.tcl` `$(CYGPATH) $(pkglibdir)` tcllib $(VERSION) $(MODULES) smtp

# AK: Mar 26, 2001: Added 'smtp' explicitly to the list of modules (is part of 'mime').

#========================================================================
# Install documentation.  Unix manpages should go in the $(mandir)
# directory.
#========================================================================

install-doc: doc
	$(mkinstalldirs) $(mandir)/mann
	-for j in $(MODULES) ; do \
	    echo "Installing documentation for $$j" ; \
	    for i in $(srcdir)/modules/$$j/*.n ; do \
		sed -e '/man\.macros/r $(srcdir)/man.macros' -e '/man\.macros/d' $$i > $$$$ ; \
	        $(INSTALL_DATA) $$$$ $(mandir)/mann/`basename $$i` ; \
		rm $$$$ ; \
	    done; \
	done
	-chmod 444 $(mandir)/mann/*
	$(INSTALL_DATA) $(srcdir)/man.macros $(mandir)

test:
	$(TCLSH_PROG) `$(CYGPATH) $(srcdir)/all.tcl` -modules "$(MODULES)"

depend:

# Make a distribution.  This includes:
#   Code, doc's, and tests for all modules
#   Generated installer for Windows (INSTALL.BAT) and UNIX (install.sh)
# This all gets archived together (tcllib$(VERSION).zip or 
# tcllib$(VERSION).tar.gz).

# Changes:
# - Generate the distributions in the current directory, not the source directory.
# - Make the structure of the source distribution equal to the
#   structure of the raw distribution out of CVS, with some files
#   removed. This makes generation easier.
#
# Actions
# - Remove possible old temp dir and archives
# - Copy examples and modules into temp dir
# - Remove meta-data of CVS
# - Copy a selected number of files into the src distribution
# - Recopy the manpages and insert man.macros (the big loop)
# - Generate pkgIndex and installation scripts
# - Generate the archives and release the temp dir

dist:
	rm -rf tcllib-$(VERSION) tcllib-$(VERSION).tar.gz tcllib-$(VERSION).zip
	@mkdir tcllib-$(VERSION)
	cp -r $(srcdir)/* tcllib-$(VERSION) ;
	find tcllib-$(VERSION) -name CVS -prune -exec rm -rf {} \;
	for j in $(MODULES) ; do \
	    doc=`ls $(srcdir)/modules/$$j/*.n 2>/dev/null` ; \
	    if test -n "$$doc" ; then \
		for i in $$doc ; do \
		    sed -e '/man\.macros/r $(srcdir)/man.macros' -e '/man\.macros/d' \
			< $$i > tcllib-$(VERSION)/modules/$$j/`basename $$i` ; \
		done; \
	    fi ; \
	done ;
	$(TCLSH_PROG) $(srcdir)/mkIndex.tcl          tcllib-$(VERSION) tcllib $(VERSION) $(MODULES)
	$(TCLSH_PROG) $(srcdir)/mkInstallScripts.tcl tcllib-$(VERSION) tcllib $(VERSION) $(MODULES)
	tar cf - tcllib-$(VERSION) | gzip --best > tcllib-$(VERSION).tar.gz
	zip -r tcllib-$(VERSION).zip tcllib-$(VERSION)
	rm -rf tcllib-$(VERSION)


# Check tcllib and report all modules without documentation and/or testsuite.
check:
	for mod in `ls $(srcdir)/modules | grep -v CVS`; do \
	   if [ `ls $(srcdir)/modules/$$mod/*.test  2>/dev/null | wc -l` -lt 1 ]; then	\
		echo '  ' $$mod has no testsuite; \
	   fi; \
	   if [ `ls $(srcdir)/modules/$$mod/*.[13n] 2>/dev/null | wc -l` -lt 1 ]; then \
		echo '  ' $$mod has no manpages; \
	   fi; \
	done

#========================================================================
# End of user-definable section
#========================================================================

#========================================================================
# Don't modify the file to clean here.  Instead, set the "CLEANFILES"
# variable in configure.in
#========================================================================

clean:  

distclean: clean
	-rm -f Makefile $(CONFIG_CLEAN_FILES)
	-rm -f config.cache config.log stamp-h stamp-h[0-9]*
	-rm -f config.status

#========================================================================
# Install binary object libraries.  On Windows this includes both .dll and
# .lib files.  Because the .lib files are not explicitly listed anywhere,
# we need to deduce their existence from the .dll file of the same name.
# Additionally, the .dll files go into the bin directory, but the .lib
# files go into the lib directory.  On Unix platforms, all library files
# go into the lib directory.  In addition, this will generate the pkgIndex.tcl
# file in the install location (assuming it can find a usable tclsh8.2 shell)
#
# You should not have to modify this target.
#========================================================================

install-lib-binaries: installdirs

#========================================================================
# Install binary executables (e.g. .exe files)
#
# You should not have to modify this target.
#========================================================================

install-bin-binaries: installdirs

.SUFFIXES: .c .o .obj

Makefile: $(srcdir)/Makefile.in  $(top_builddir)/config.status
	cd $(top_builddir) \
	  && CONFIG_FILES=$@ CONFIG_HEADERS= $(SHELL) ./config.status

uninstall-binaries:

installdirs:
	$(mkinstalldirs)  $(DESTDIR)$(pkglibdir)

.PHONY: all binaries clean depend distclean doc install installdirs \
libraries test

# Tell versions [3.59,3.63) of GNU make to not export all variables.
# Otherwise a system limit (for SysV at least) may be exceeded.
.NOEXPORT:
