# printer pre-selection
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc ds  {} {

proc dsWdsae {} {
  global Wds Wdv drseln dvlf
  destros $Wds; $Wdv.a.b.s configure -state normal; update idletasks
  if {$drseln==1} {prt_select "$dvlf" ""}
  dvfocus ""
}


global vv Wdv Wds prtpresel prtselmaxl prtselmaxc
global drselmax drsel drseltit drseln drselanz dvsep drselli drselnm

for {set n 0} {$n<$drselmax} {incr n} {
proc dssel$n {s} {
  global vv Wdv drsel prtpresel drseltit drselmax drseltit lastclick
  set n [lindex [split $lastclick "."] 3]
  if {$s=="* $vv(dsa)"} {set drsel($n) *} else {set drsel($n) $s}
  if {[lindex [split $lastclick "."] 6]=="li"} {
    set w [join [lrange [split $lastclick "."] 0 3] .]
    if [winfo exists $w.f.selected] {$w.f.selected configure -text $drsel($n)}
    selection clear $w.f.f.li
    global dssel${n}_v;  set dssel${n}_v "$s"
  }
  for {set j 0; set p ""} {$j<$drselmax} {incr j} {set p "$p $drsel($j)"};set prtpresel $p
  writescr0 $Wdv.d.tt "\n$vv(dsb4) \"$drseltit($n)\" $vv(dsb1) $drsel($n)\n\n$prtpresel\n"
  drlistfill 0
  dvfocus ""
}
}

toplevel_init $Wds "$vv(dsvor)" 0 0;  set tyh 21


for {set n 0} {$n<$drselmax} {incr n} {
  set drselli($n) "* ";  set drselanz($n) 1;  set dsw($n) [string length $drseltit($n)]
  set l [expr 2+[string length $vv(dsa)]]; if {$dsw($n)<$l} {set dsw($n) $l}
}
set foid [open_vst printing.vst]
getscl $foid ein
set drselnm 0
while {[getscl $foid ein]>0} {
  set z [split $ein $dvsep]
  if {[string trim [lindex $z 0]]==""} continue;# skip pre-selection setting
  set sn [string trim [lindex $z 1]]
  if {[string first "$sn " "$drselli(0)"]<0} {
     set drselli(0) "$drselli(0) $sn ";  incr drselanz(0)
     set l [string length $sn];  if {$l>$dsw(0)} {set dsw(0) $l}
  }
  set sn "[string trim [lindex $z 2]]:[string trim [lindex $z 3]]"
  if {[string first "$sn " "$drselli(1)"]<0} {
     set drselli(1) "$drselli(1) $sn "; incr drselanz(1)
     set l [string length $sn];  if {$l>$dsw(1)} {set dsw(1) $l}
  }
  set zmult 1
  for {set n 2} {$n<$drselmax} {incr n} {
    set sn [split [string trim [lindex $z [expr $n+9]]] ","]
    set asn [llength $sn]; # number of elements in a criterium
    set zmult [expr "$zmult*$asn"]
    foreach i $sn {
      regsub -all "\{" $i " \{" lien
      set crit [lindex $lien 0]
      if {[string first "$crit " "$drselli($n)"]<0} {
        set drselli($n) "$drselli($n) $crit ";  incr drselanz($n)
        set l [string length $crit];  if {$l>$dsw($n)} {set dsw($n) $l}
      }
    }
  }
  incr drselnm $zmult
}
close $foid

for {set n 0} {$n<$drselmax} {incr n} {set drselli($n) [lsort $drselli($n)]}


# top buttons

frame $Wds.a -relief raised -borderwidth 1
pack configure $Wds.a -side top -anchor nw -pady 5

button $Wds.a.e -text "$vv(ae)" -command {dsWdsae}
Bind3HF $Wds.a.e ds_vstquit $Wdv.d.tt
button $Wds.a.h -text "$vv(ah)" -command {HTxtFile "" ds_h $Wdv.d.tt}
Bind2HF $Wds.a.h ds_h $Wdv.d.tt
Bind3HF $Wds.a.h ds_h $Wdv.d.tt
button $Wds.a.g -text "$vv(ag)" -command {
  set f [open_vst printing.vst]; getscl $f e; set s [string index [string trim $e] 0]
  set drselmax 2; while {[getvalue $e [expr $drselmax+9] $s] != ""} {incr drselmax}
  getscl $f e; set z [split $e $s]
  if {[string trim [lindex $z 0]]==""} {# first argument is empty: pre-selection settings
    set prtpresel [string trim [lindex $z 1]]
    if {([string trim [lindex $z 2]]=="*")||([string trim [lindex $z 2]]=="")|| \
        ([string trim [lindex $z 3]]=="*")||([string trim [lindex $z 3]]=="")} {
      set prtpresel "$prtpresel *"
    } else {
      set prtpresel "$prtpresel [string trim [lindex $z 2]]:[string trim [lindex $z 3]]"
    }
    for {set i 2} {$i<=$drselmax} {incr i} {
      set prtpresel "$prtpresel [string trim [lindex $z [expr $i+9]]]"
    }
    getscl $f e; set z [split $e $s]
  } else {# 1 argument not empty: printer setting line
    for {set i 1; set prtpresel "*"} {$i<=$drselmax} {incr i} {set prtpresel "$prtpresel *"}
  }
  close $f
  writescr0 $Wdv.d.tt "$vv(ausg1)\n\n $vv(dv5)  $prtpresel\n\n"
  for {set n 0} {$n<$drselmax} {incr n} {
    global dssel${n}_v
    set drsel($n) [lindex $prtpresel $n]
    set f "$drsel($n)"; if {$f=="*"} {set f "* $vv(dsa)"}; set dssel${n}_v "$f"
    for {set c 0} {$c<=2} {incr c} \
	{if [winfo exists $Wds.c$c.$n.d] {$Wds.c$c.$n.d configure -text $drsel($n)}}
  }
  drlistfill 0
}
Bind3HF $Wds.a.g ds_grund $Wdv.d.tt
pack configure $Wds.a.e $Wds.a.h $Wds.a.g -side left -padx 3 -pady 3


frame $Wds.b; pack configure $Wds.b -anchor nw -pady 10

label $Wds.b.n -text "$vv(dsb1)  $drseln  $vv(dsb2)  $drselnm  $vv(dsb3)" -width 70 -anchor w
Bind3HF $Wds.b.n ds_selnums $Wdv.d.tt
pack configure $Wds.b.n -anchor w


# drselmax frames

frame $Wds.c0; pack configure $Wds.c0 -anchor nw -side left -ipadx 10
frame $Wds.c1; pack configure $Wds.c1 -anchor nw -side top
frame $Wds.c2; pack configure $Wds.c2 -anchor nw -side top

# look for arrangement of the frames (according to number and with of the frames)
for {set n 1; set mw 0} {$n<$drselmax} {incr n} {if {$dsw($n)>$mw} {set mw $dsw($n)}}
for {set n 1; set gz 0} {$n<$drselmax} {incr n} {incr gz [expr $dsw($n)+5]}
for {set n 1; set s 0; set d1 [expr $gz-[expr 2*($dsw(0)+5)]]} {$n<$drselmax} {incr n} {
  incr s [expr 2*($dsw($n)+5)]
  if {$s<$gz} {set d1 [expr $gz-$s]} else {set d2 [expr $s-$gz]; set z $n; break}
}
if ![info exists prtselmaxl] {set prtselmaxl [expr (([winfo screenheight .]*46)/1024)-7]}
if [info exists prtselmaxc] {set mx $prtselmaxc} \
	else {set mx [expr (([winfo screenwidth .]*142)/1280)-10-$dsw(0)]}
if {$gz<=$mx} {set case 1; set dsmaxcol $drselmax} \
elseif {[expr ($mw+5)*($drselmax/2)]<=$mx} {set case 2; set dsmaxcol [expr ($drselmax/2)]} \
else {set case 3; if {$d1<$d2} {set dsmaxcol [expr $z-1]} else {set dsmaxcol $z}}
set m1 0; set m2 0
for {set n 1} {$n<$drselmax} {incr n} {
  set i 0; foreach it $drselli($n) {incr i}
  if {($n<=$dsmaxcol)&&($i>$m1)} {set m1 $i} elseif {($n>$dsmaxcol)&&($i>$m2)} {set m2 $i}
}
if {$case>=2} {
  if {[expr $m1+$m2+4]<=$prtselmaxl} {set nl1 $m1; set nl2 $m2} \
  elseif {[expr ($m1+2)*2]<$prtselmaxl} {set nl1 $m1; set nl2 [expr $prtselmaxl-$m1-4]} \
  elseif {[expr ($m2+2)*2]<$prtselmaxl} {set nl2 $m2; set nl1 [expr $prtselmaxl-$m2-4]} \
  else {set nl1 [expr ($prtselmaxl/2)-2]; set nl2 [expr $prtselmaxl-$nl1-4]} 
}

#create the frames
for {set n 0} {$n<$drselmax} {incr n} {
  if {$n==0} {set c c0} else {if {$n<=$dsmaxcol} {set c c1} else {set c c2}}
  frame $Wds.$c.$n -relief raised -borderwidth 1
  pack configure $Wds.$c.$n -anchor nw -side left -padx 5 -fill y

  if {$case==2} {set wi $mw} else {set wi $dsw($n)}
  if {$n==0} {if {$prtselmaxl<$drselanz($n)} {set m $prtselmaxl} else {set m $drselanz($n)}} \
  elseif {$case==1} {if {$prtselmaxl<$m1} {set m $prtselmaxl} else {set m $m1}} \
  else {if {$c=="c1"} {set m $nl1} else {set m $nl2}}
  set l ""; foreach i $drselli($n) {if {$i=="*"} {lappend l "* $vv(dsa)"} {lappend l "$i"}}
  global dssel${n}_v;set t "$drsel($n)";if {$t=="*"} {set t "* $vv(dsa)"}; set dssel${n}_v $t
  CreateLSBox $Wds.$c.$n "$drseltit($n)" top $wi $m 0 ds_sellist $Wdv.d.tt \
	"" "$l" dssel$n "" dsWdsae
  if [winfo exists $Wds.$c.$n.f.f.li] {set t "$drsel($n)"} else {set t " "}
  label $Wds.$c.$n.f.selected -text "$t" -width $wi -anchor c

  pack configure $Wds.$c.$n.f.l $Wds.$c.$n.f.selected $Wds.$c.$n.f.f -anchor c
  
}

$Wdv.a.b.s configure -state disabled; update idletasks
}
