# Call of the bibliography program for the file $main_file$bsuff
#
# Copyright (C) 1999  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc bibliogr {f austext} {

  upvar 1 $austext a

  global  vv bibtex bioptions main_file bsuff dirprefix

  set a ""
  # don't clear screen by writescr0 (bibliogr may be called automatically after TeX run!)

  if {$dirprefix==""} {set mfile $main_file} else {set mfile [fileName $main_file]} 

   if {"$mfile"==""} {# text output: "no file selected --> go to TeX settings!"
    set a "${a}***** $vv(ea1)\n"
    mybell 2
    return
  }

  writescr $f "[datime] $vv(bib1)\n$bibtex $bioptions $mfile &\n"


  if {[file exists $mfile$bsuff]} { 

    if {$bibtex=="bibview"} {SigChldB; exec $bibtex $bioptions $mfile &; SigChldU} \
    else {eval mkCmd_wait $f $bibtex [list "$bioptions $mfile"]}

  } else {# output text: "file $mfile.aux not found!\none more LaTeX run with:\n"
    mybell 2
    set a "${a}\n***** $vv(aus5)   $mfile.aux   $vv(ea4)\n      $vv(bib2)\n"
    set a "${a}        \\documentstyle\[...\]\{...\}\n"
    set a "${a}        ...\n"
    set a "${a}        \\begin\{document\}\n"
    set a "${a}          \\bibliographystyle\{plain\}\n"
    set a "${a}        ... \\cite\{...\} ...\n"
    set a "${a}        \\bibliography\{...\}\n"
    set a "${a}        \\end\{document\}\n"
  }

}
