/*
    implementation of two stacks used in xetal,	
    Copyright (C) 1991 Raphael Cerf (e-mail: cerf@ens.ens.fr)

    This file is part of xetal.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "proto.h"
#include "stack.h"

/*
 * file stack
 */

char *fich_name(e)
fich_t *e;
{
	return(e->name);
}

FILE *fich_fd(e)
fich_t *e;
{
	return(e->fd);
}

long fich_line(e)
fich_t *e;
{
	return(e->line);
}

fich_t f_stack[F_MAX];
int f_top=0;

int is_f_stack_empty() {
	return(f_top==0);
}

int is_f_stack_full() {
	return(f_top==F_MAX-1);
}

fich_t *f_pop() {
	return( &(f_stack[--f_top]) );
}

void f_push(e)
fich_t *e;
{
	f_stack[f_top++]=*e;
}

fich_t *f_read()
{
	if (f_top==0) return((fich_t *)0);
	else return(f_stack+f_top-1);
	
}

void f_display() {
	int i;
	printf("%d elements\n", f_top);
	for (i=0; i<f_top; i++)
		printf("%s : %d", fich_name(f_stack+i), fich_line(f_stack+i));
	printf("\n");
}

/*
 * LEX states stack
 */

int S_stack[S_MAX];
int S_top=0;

int empty_S_stack() {
	while(S_top>0) S_pop();
}

int is_S_stack_empty() {
	return(S_top==0);
}

int is_S_stack_full() {
	return(S_top==S_MAX-1);
}

int is_S_in_stack(e)
int e;
{
	int i;
	for (i=0; i<S_top; i++) {
		if (S_stack[i]==e) break;
	}
	if (i<S_top) return 1;
	else return 0;
}

int S_pop() {
	return( S_stack[--S_top] );
}

void S_push(e)
int e;
{
	S_stack[S_top++]=e;
}

int S_read()
{
	if (S_top==0) return(0);
	else return(*(S_stack+S_top-1));
}

void S_display() {
	int i;
	printf("%d elements\n", S_top);
	for (i=0; i<S_top; i++)
		printf("%d", *(S_stack+i));
	printf("\n");
}
