/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

public enum FileSortType {
    FILE_SORT_DEFAULT("default"),
    FILE_SORT_DATE_ASCENDING("date-ascending", "date", "date-asc"),
    FILE_SORT_DATE_DESCENDING("date-descending", "date-des"),
    FILE_SORT_SIZE_ASCENDING("size-ascending", "size", "size-asc"),
    FILE_SORT_SIZE_DESCENDING("size-descending", "size-des"),
    FILE_SORT_NAME_ASCENDING("name-ascending", "name", "name-asc"),
    FILE_SORT_NAME_DESCENDING("name-descending", "name-des"),
    FILE_SORT_NAME_NOCASE_ASCENDING("iname-ascending", "iname", "iname-asc"),
    FILE_SORT_NAME_NOCASE_DESCENDING("iname-descending", "iname-des"),
    FILE_SORT_EXT_ASCENDING("ext-ascending", "ext", "ext-asc"),
    FILE_SORT_EXT_DESCENDING("ext-descending", "ext-des");

    private final String name;
    private final String altName1;
    private final String altName2;

    private FileSortType(String string2) {
        this(string2, null, null);
    }

    private FileSortType(String string2, String string3) {
        this(string2, string3, null);
    }

    private FileSortType(String string2, String string3, String string4) {
        this.name = string2;
        this.altName1 = string3;
        this.altName2 = string4;
    }

    private String options() {
        if (this.altName1 == null && this.altName2 == null) {
            return this.name;
        }
        if (this.altName2 == null) {
            return String.format("%s (or %s)", this.name, this.altName1);
        }
        return String.format("%s (or %s or %s)", this.name, this.altName1, this.altName2);
    }

    private boolean isOption(String string) {
        return string.equals(this.name) || string.equals(this.altName1) || string.equals(this.altName2);
    }

    public static String getFileSortOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FileSortType fileSortType : FileSortType.values()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(fileSortType.options());
        }
        return stringBuilder.toString();
    }

    public static FileSortType getFileSortType(String string) {
        if (string == null) {
            return FILE_SORT_DEFAULT;
        }
        for (FileSortType fileSortType : FileSortType.values()) {
            if (!fileSortType.isOption(string)) continue;
            return fileSortType;
        }
        throw new IllegalArgumentException("Invalid sort type: " + string);
    }

    public String toString() {
        return this.name;
    }
}

