/* This file was generated by SableCC (http://www.sablecc.org/). */

package net.sourceforge.texlipse.bibparser.parser;

import net.sourceforge.texlipse.bibparser.lexer.*;
import net.sourceforge.texlipse.bibparser.node.*;
import net.sourceforge.texlipse.bibparser.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings("nls")
public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    public Parser(@SuppressWarnings("hiding") Lexer lexer)
    {
        this.lexer = lexer;
    }

    @SuppressWarnings({"unchecked","unused"})
    private void push(int numstate, ArrayList listNode) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
        return ((State) this.stack.previous()).nodes;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

    @SuppressWarnings("unchecked")
    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce AAbibtex1Bibtex */
		    {
			ArrayList list = new0();
			push(goTo(0), list);
		    }
		    break;
                    case 1: /* reduce AAbibtex2Bibtex */
		    {
			ArrayList list = new1();
			push(goTo(0), list);
		    }
		    break;
                    case 2: /* reduce ABibstreBibEntry */
		    {
			ArrayList list = new2();
			push(goTo(1), list);
		    }
		    break;
                    case 3: /* reduce ABibeBibEntry */
		    {
			ArrayList list = new3();
			push(goTo(1), list);
		    }
		    break;
                    case 4: /* reduce ABibtaskBibEntry */
		    {
			ArrayList list = new4();
			push(goTo(1), list);
		    }
		    break;
                    case 5: /* reduce AAstrbracestringentry1StringEntry */
		    {
			ArrayList list = new5();
			push(goTo(2), list);
		    }
		    break;
                    case 6: /* reduce AAstrbracestringentry2StringEntry */
		    {
			ArrayList list = new6();
			push(goTo(2), list);
		    }
		    break;
                    case 7: /* reduce AAstrbracestringentry3StringEntry */
		    {
			ArrayList list = new7();
			push(goTo(2), list);
		    }
		    break;
                    case 8: /* reduce AAstrbracestringentry4StringEntry */
		    {
			ArrayList list = new8();
			push(goTo(2), list);
		    }
		    break;
                    case 9: /* reduce AAstrparenstringentry1StringEntry */
		    {
			ArrayList list = new9();
			push(goTo(2), list);
		    }
		    break;
                    case 10: /* reduce AAstrparenstringentry2StringEntry */
		    {
			ArrayList list = new10();
			push(goTo(2), list);
		    }
		    break;
                    case 11: /* reduce AAstrparenstringentry3StringEntry */
		    {
			ArrayList list = new11();
			push(goTo(2), list);
		    }
		    break;
                    case 12: /* reduce AAstrparenstringentry4StringEntry */
		    {
			ArrayList list = new12();
			push(goTo(2), list);
		    }
		    break;
                    case 13: /* reduce AAentrybraceentry1Entry */
		    {
			ArrayList list = new13();
			push(goTo(3), list);
		    }
		    break;
                    case 14: /* reduce AAentrybraceentry2Entry */
		    {
			ArrayList list = new14();
			push(goTo(3), list);
		    }
		    break;
                    case 15: /* reduce AAentryparenentry1Entry */
		    {
			ArrayList list = new15();
			push(goTo(3), list);
		    }
		    break;
                    case 16: /* reduce AAentryparenentry2Entry */
		    {
			ArrayList list = new16();
			push(goTo(3), list);
		    }
		    break;
                    case 17: /* reduce AEntryDef */
		    {
			ArrayList list = new17();
			push(goTo(4), list);
		    }
		    break;
                    case 18: /* reduce AAkeyvaldecl1KeyvalDecl */
		    {
			ArrayList list = new18();
			push(goTo(5), list);
		    }
		    break;
                    case 19: /* reduce AAkeyvaldecl2KeyvalDecl */
		    {
			ArrayList list = new19();
			push(goTo(5), list);
		    }
		    break;
                    case 20: /* reduce AValueBValOrSid */
		    {
			ArrayList list = new20();
			push(goTo(6), list);
		    }
		    break;
                    case 21: /* reduce AAvalueqvalorsid1ValOrSid */
		    {
			ArrayList list = new21();
			push(goTo(6), list);
		    }
		    break;
                    case 22: /* reduce AAvalueqvalorsid2ValOrSid */
		    {
			ArrayList list = new22();
			push(goTo(6), list);
		    }
		    break;
                    case 23: /* reduce ANumValOrSid */
		    {
			ArrayList list = new23();
			push(goTo(6), list);
		    }
		    break;
                    case 24: /* reduce AIdValOrSid */
		    {
			ArrayList list = new24();
			push(goTo(6), list);
		    }
		    break;
                    case 25: /* reduce AConcat */
		    {
			ArrayList list = new25();
			push(goTo(7), list);
		    }
		    break;
                    case 26: /* reduce ATerminal$BibEntry */
		    {
			ArrayList list = new26();
			push(goTo(8), list);
		    }
		    break;
                    case 27: /* reduce ANonTerminal$BibEntry */
		    {
			ArrayList list = new27();
			push(goTo(8), list);
		    }
		    break;
                    case 28: /* reduce ATerminal$KeyvalDecl */
		    {
			ArrayList list = new28();
			push(goTo(9), list);
		    }
		    break;
                    case 29: /* reduce ANonTerminal$KeyvalDecl */
		    {
			ArrayList list = new29();
			push(goTo(9), list);
		    }
		    break;
                    case 30: /* reduce ATerminal$Concat */
		    {
			ArrayList list = new30();
			push(goTo(10), list);
		    }
		    break;
                    case 31: /* reduce ANonTerminal$Concat */
		    {
			ArrayList list = new31();
			push(goTo(10), list);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PBibtex node1 = (PBibtex) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " +
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



    @SuppressWarnings("unchecked")
    ArrayList new0() /* reduce AAbibtex1Bibtex */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        PBibtex pbibtexNode1;
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        }

        pbibtexNode1 = new ABibtex(listNode2);
        }
	nodeList.add(pbibtexNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new1() /* reduce AAbibtex2Bibtex */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PBibtex pbibtexNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList1.get(0);
	if(listNode2 != null)
	{
	  listNode3.addAll(listNode2);
	}
        }

        pbibtexNode1 = new ABibtex(listNode3);
        }
	nodeList.add(pbibtexNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new2() /* reduce ABibstreBibEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PBibEntry pbibentryNode1;
        {
            // Block
        PStringEntry pstringentryNode2;
        pstringentryNode2 = (PStringEntry)nodeArrayList1.get(0);

        pbibentryNode1 = new ABibstreBibEntry(pstringentryNode2);
        }
	nodeList.add(pbibentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new3() /* reduce ABibeBibEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PBibEntry pbibentryNode1;
        {
            // Block
        PEntry pentryNode2;
        pentryNode2 = (PEntry)nodeArrayList1.get(0);

        pbibentryNode1 = new ABibeBibEntry(pentryNode2);
        }
	nodeList.add(pbibentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new4() /* reduce ABibtaskBibEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PBibEntry pbibentryNode1;
        {
            // Block
        TTaskcomment ttaskcommentNode2;
        ttaskcommentNode2 = (TTaskcomment)nodeArrayList1.get(0);

        pbibentryNode1 = new ABibtaskBibEntry(ttaskcommentNode2);
        }
	nodeList.add(pbibentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new5() /* reduce AAstrbracestringentry1StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList5.get(0);

        pstringentryNode1 = new AStrbraceStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new6() /* reduce AAstrbracestringentry2StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList7 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList6.get(0);

        pstringentryNode1 = new AStrbraceStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new7() /* reduce AAstrbracestringentry3StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList7 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList5.get(0);

        pstringentryNode1 = new AStrbraceStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new8() /* reduce AAstrbracestringentry4StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList8 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList7 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList6.get(0);

        pstringentryNode1 = new AStrbraceStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new9() /* reduce AAstrparenstringentry1StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList5.get(0);

        pstringentryNode1 = new AStrparenStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new10() /* reduce AAstrparenstringentry2StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList7 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList6.get(0);

        pstringentryNode1 = new AStrparenStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new11() /* reduce AAstrparenstringentry3StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList7 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList5.get(0);

        pstringentryNode1 = new AStrparenStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new12() /* reduce AAstrparenstringentry4StringEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList8 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList7 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStringEntry pstringentryNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        TStringLiteral tstringliteralNode3;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);
        tstringliteralNode3 = (TStringLiteral)nodeArrayList6.get(0);

        pstringentryNode1 = new AStrparenStringEntry(tidentifierNode2, tstringliteralNode3);
        }
	nodeList.add(pstringentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new13() /* reduce AAentrybraceentry1Entry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PEntry pentryNode1;
        {
            // Block
        PEntryDef pentrydefNode2;
        TIdentifier tidentifierNode3;
        LinkedList listNode5 = new LinkedList();
        TRBrace trbraceNode6;
        pentrydefNode2 = (PEntryDef)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList4.get(0);
	if(listNode4 != null)
	{
	  listNode5.addAll(listNode4);
	}
        }
        trbraceNode6 = (TRBrace)nodeArrayList5.get(0);

        pentryNode1 = new AEntrybraceEntry(pentrydefNode2, tidentifierNode3, listNode5, trbraceNode6);
        }
	nodeList.add(pentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new14() /* reduce AAentrybraceentry2Entry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PEntry pentryNode1;
        {
            // Block
        PEntryDef pentrydefNode2;
        TIdentifier tidentifierNode3;
        LinkedList listNode5 = new LinkedList();
        TRBrace trbraceNode6;
        pentrydefNode2 = (PEntryDef)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList4.get(0);
	if(listNode4 != null)
	{
	  listNode5.addAll(listNode4);
	}
        }
        trbraceNode6 = (TRBrace)nodeArrayList6.get(0);

        pentryNode1 = new AEntrybraceEntry(pentrydefNode2, tidentifierNode3, listNode5, trbraceNode6);
        }
	nodeList.add(pentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new15() /* reduce AAentryparenentry1Entry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PEntry pentryNode1;
        {
            // Block
        PEntryDef pentrydefNode2;
        TIdentifier tidentifierNode3;
        LinkedList listNode5 = new LinkedList();
        TRParen trparenNode6;
        pentrydefNode2 = (PEntryDef)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList4.get(0);
	if(listNode4 != null)
	{
	  listNode5.addAll(listNode4);
	}
        }
        trparenNode6 = (TRParen)nodeArrayList5.get(0);

        pentryNode1 = new AEntryparenEntry(pentrydefNode2, tidentifierNode3, listNode5, trparenNode6);
        }
	nodeList.add(pentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new16() /* reduce AAentryparenentry2Entry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList6 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PEntry pentryNode1;
        {
            // Block
        PEntryDef pentrydefNode2;
        TIdentifier tidentifierNode3;
        LinkedList listNode5 = new LinkedList();
        TRParen trparenNode6;
        pentrydefNode2 = (PEntryDef)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList4.get(0);
	if(listNode4 != null)
	{
	  listNode5.addAll(listNode4);
	}
        }
        trparenNode6 = (TRParen)nodeArrayList6.get(0);

        pentryNode1 = new AEntryparenEntry(pentrydefNode2, tidentifierNode3, listNode5, trparenNode6);
        }
	nodeList.add(pentryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new17() /* reduce AEntryDef */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PEntryDef pentrydefNode1;
        {
            // Block
        TEntryName tentrynameNode2;
        tentrynameNode2 = (TEntryName)nodeArrayList1.get(0);

        pentrydefNode1 = new AEntryDef(tentrynameNode2);
        }
	nodeList.add(pentrydefNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new18() /* reduce AAkeyvaldecl1KeyvalDecl */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PKeyvalDecl pkeyvaldeclNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        PValOrSid pvalorsidNode3;
        LinkedList listNode4 = new LinkedList();
        tidentifierNode2 = (TIdentifier)nodeArrayList2.get(0);
        pvalorsidNode3 = (PValOrSid)nodeArrayList4.get(0);
        {
            // Block
        }

        pkeyvaldeclNode1 = new AKeyvalDecl(tidentifierNode2, pvalorsidNode3, listNode4);
        }
	nodeList.add(pkeyvaldeclNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new19() /* reduce AAkeyvaldecl2KeyvalDecl */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList5 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PKeyvalDecl pkeyvaldeclNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        PValOrSid pvalorsidNode3;
        LinkedList listNode5 = new LinkedList();
        tidentifierNode2 = (TIdentifier)nodeArrayList2.get(0);
        pvalorsidNode3 = (PValOrSid)nodeArrayList4.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList5.get(0);
	if(listNode4 != null)
	{
	  listNode5.addAll(listNode4);
	}
        }

        pkeyvaldeclNode1 = new AKeyvalDecl(tidentifierNode2, pvalorsidNode3, listNode5);
        }
	nodeList.add(pkeyvaldeclNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new20() /* reduce AValueBValOrSid */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValOrSid pvalorsidNode1;
        {
            // Block
        TStringLiteral tstringliteralNode2;
        tstringliteralNode2 = (TStringLiteral)nodeArrayList1.get(0);

        pvalorsidNode1 = new AValueBValOrSid(tstringliteralNode2);
        }
	nodeList.add(pvalorsidNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new21() /* reduce AAvalueqvalorsid1ValOrSid */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValOrSid pvalorsidNode1;
        {
            // Block
        @SuppressWarnings("unused") Object nullNode2 = null;

        pvalorsidNode1 = new AValueQValOrSid(null);
        }
	nodeList.add(pvalorsidNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new22() /* reduce AAvalueqvalorsid2ValOrSid */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValOrSid pvalorsidNode1;
        {
            // Block
        TStringLiteral tstringliteralNode2;
        tstringliteralNode2 = (TStringLiteral)nodeArrayList2.get(0);

        pvalorsidNode1 = new AValueQValOrSid(tstringliteralNode2);
        }
	nodeList.add(pvalorsidNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new23() /* reduce ANumValOrSid */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValOrSid pvalorsidNode1;
        {
            // Block
        TNumber tnumberNode2;
        tnumberNode2 = (TNumber)nodeArrayList1.get(0);

        pvalorsidNode1 = new ANumValOrSid(tnumberNode2);
        }
	nodeList.add(pvalorsidNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new24() /* reduce AIdValOrSid */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValOrSid pvalorsidNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        tidentifierNode2 = (TIdentifier)nodeArrayList1.get(0);

        pvalorsidNode1 = new AIdValOrSid(tidentifierNode2);
        }
	nodeList.add(pvalorsidNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new25() /* reduce AConcat */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PConcat pconcatNode1;
        {
            // Block
        PValOrSid pvalorsidNode2;
        pvalorsidNode2 = (PValOrSid)nodeArrayList2.get(0);

        pconcatNode1 = new AConcat(pvalorsidNode2);
        }
	nodeList.add(pconcatNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new26() /* reduce ATerminal$BibEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PBibEntry pbibentryNode1;
        pbibentryNode1 = (PBibEntry)nodeArrayList1.get(0);
	if(pbibentryNode1 != null)
	{
	  listNode2.add(pbibentryNode1);
	}
        }
	nodeList.add(listNode2);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new27() /* reduce ANonTerminal$BibEntry */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PBibEntry pbibentryNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pbibentryNode2 = (PBibEntry)nodeArrayList2.get(0);
	if(listNode1 != null)
	{
	  listNode3.addAll(listNode1);
	}
	if(pbibentryNode2 != null)
	{
	  listNode3.add(pbibentryNode2);
	}
        }
	nodeList.add(listNode3);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new28() /* reduce ATerminal$KeyvalDecl */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PKeyvalDecl pkeyvaldeclNode1;
        pkeyvaldeclNode1 = (PKeyvalDecl)nodeArrayList1.get(0);
	if(pkeyvaldeclNode1 != null)
	{
	  listNode2.add(pkeyvaldeclNode1);
	}
        }
	nodeList.add(listNode2);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new29() /* reduce ANonTerminal$KeyvalDecl */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PKeyvalDecl pkeyvaldeclNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pkeyvaldeclNode2 = (PKeyvalDecl)nodeArrayList2.get(0);
	if(listNode1 != null)
	{
	  listNode3.addAll(listNode1);
	}
	if(pkeyvaldeclNode2 != null)
	{
	  listNode3.add(pkeyvaldeclNode2);
	}
        }
	nodeList.add(listNode3);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new30() /* reduce ATerminal$Concat */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PConcat pconcatNode1;
        pconcatNode1 = (PConcat)nodeArrayList1.get(0);
	if(pconcatNode1 != null)
	{
	  listNode2.add(pconcatNode1);
	}
        }
	nodeList.add(listNode2);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new31() /* reduce ANonTerminal$Concat */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PConcat pconcatNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pconcatNode2 = (PConcat)nodeArrayList2.get(0);
	if(listNode1 != null)
	{
	  listNode3.addAll(listNode1);
	}
	if(pconcatNode2 != null)
	{
	  listNode3.add(pconcatNode2);
	}
        }
	nodeList.add(listNode3);
        return nodeList;
    }



    private static int[][][] actionTable;
/*      {
			{{-1, REDUCE, 0}, {0, SHIFT, 1}, {1, SHIFT, 2}, {4, SHIFT, 3}, },
			{{-1, REDUCE, 4}, },
			{{-1, ERROR, 2}, {5, SHIFT, 10}, {8, SHIFT, 11}, },
			{{-1, REDUCE, 17}, },
			{{-1, ERROR, 4}, {17, ACCEPT, -1}, },
			{{-1, REDUCE, 26}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 3}, },
			{{-1, ERROR, 8}, {5, SHIFT, 12}, {8, SHIFT, 13}, },
			{{-1, REDUCE, 1}, {0, SHIFT, 1}, {1, SHIFT, 2}, {4, SHIFT, 3}, },
			{{-1, ERROR, 10}, {14, SHIFT, 15}, },
			{{-1, ERROR, 11}, {14, SHIFT, 16}, },
			{{-1, ERROR, 12}, {14, SHIFT, 17}, },
			{{-1, ERROR, 13}, {14, SHIFT, 18}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 15}, {11, SHIFT, 19}, },
			{{-1, ERROR, 16}, {11, SHIFT, 20}, },
			{{-1, ERROR, 17}, {10, SHIFT, 21}, },
			{{-1, ERROR, 18}, {10, SHIFT, 21}, },
			{{-1, ERROR, 19}, {15, SHIFT, 25}, {16, SHIFT, 26}, },
			{{-1, ERROR, 20}, {15, SHIFT, 27}, {16, SHIFT, 28}, },
			{{-1, ERROR, 21}, {14, SHIFT, 29}, },
			{{-1, REDUCE, 28}, },
			{{-1, ERROR, 23}, {6, SHIFT, 30}, {10, SHIFT, 31}, },
			{{-1, ERROR, 24}, {9, SHIFT, 33}, {10, SHIFT, 34}, },
			{{-1, ERROR, 25}, {16, SHIFT, 35}, },
			{{-1, ERROR, 26}, {6, SHIFT, 36}, {15, SHIFT, 37}, },
			{{-1, ERROR, 27}, {16, SHIFT, 38}, },
			{{-1, ERROR, 28}, {9, SHIFT, 39}, {15, SHIFT, 40}, },
			{{-1, ERROR, 29}, {11, SHIFT, 41}, },
			{{-1, REDUCE, 13}, },
			{{-1, ERROR, 31}, {6, SHIFT, 42}, {14, SHIFT, 29}, },
			{{-1, REDUCE, 29}, },
			{{-1, REDUCE, 15}, },
			{{-1, ERROR, 34}, {9, SHIFT, 43}, {14, SHIFT, 29}, },
			{{-1, ERROR, 35}, {6, SHIFT, 44}, {15, SHIFT, 45}, },
			{{-1, REDUCE, 5}, },
			{{-1, ERROR, 37}, {6, SHIFT, 46}, },
			{{-1, ERROR, 38}, {9, SHIFT, 47}, {15, SHIFT, 48}, },
			{{-1, REDUCE, 9}, },
			{{-1, ERROR, 40}, {9, SHIFT, 49}, },
			{{-1, ERROR, 41}, {13, SHIFT, 50}, {14, SHIFT, 51}, {15, SHIFT, 52}, {16, SHIFT, 53}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 6}, },
			{{-1, ERROR, 45}, {6, SHIFT, 55}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 10}, },
			{{-1, ERROR, 48}, {9, SHIFT, 56}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 23}, },
			{{-1, REDUCE, 24}, },
			{{-1, ERROR, 52}, {15, SHIFT, 57}, {16, SHIFT, 58}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 18}, {12, SHIFT, 59}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 21}, },
			{{-1, ERROR, 58}, {15, SHIFT, 62}, },
			{{-1, ERROR, 59}, {13, SHIFT, 50}, {14, SHIFT, 51}, {15, SHIFT, 52}, {16, SHIFT, 53}, },
			{{-1, REDUCE, 30}, },
			{{-1, REDUCE, 19}, {12, SHIFT, 59}, },
			{{-1, REDUCE, 22}, },
			{{-1, REDUCE, 25}, },
			{{-1, REDUCE, 31}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 4}, },
			{{-1, 5}, {9, 14}, },
			{{-1, 6}, },
			{{-1, 7}, },
			{{-1, 8}, },
			{{-1, 22}, {23, 32}, {24, 32}, },
			{{-1, 54}, {59, 63}, },
			{{-1, 60}, {61, 64}, },
			{{-1, 9}, },
			{{-1, 23}, {18, 24}, },
			{{-1, 61}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: taskcomment, estring, entry name, EOF",
			"expecting: '{', '('",
			"expecting: EOF",
			"expecting: identifier",
			"expecting: '='",
			"expecting: ','",
			"expecting: '"', string literal",
			"expecting: '}', ')', ','",
			"expecting: '}', ','",
			"expecting: ')', ','",
			"expecting: string literal",
			"expecting: '}', '"'",
			"expecting: ')', '"'",
			"expecting: '}', identifier",
			"expecting: ')', identifier",
			"expecting: '}'",
			"expecting: ')'",
			"expecting: number, identifier, '"', string literal",
			"expecting: '}', ')', ',', '#'",
			"expecting: '"'",
        };*/
    private static int[] errors;
/*      {
			0, 0, 1, 1, 2, 0, 0, 0, 1, 0, 3, 3, 3, 3, 0, 4, 4, 5, 5, 6, 6, 3, 7, 8, 9, 10, 11, 10, 12, 4, 0, 13, 7, 0, 14, 11, 0, 15, 12, 0, 16, 17, 0, 0, 0, 15, 0, 0, 16, 0, 18, 18, 6, 18, 18, 0, 0, 18, 19, 17, 18, 18, 18, 18, 18, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
