/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.wizards;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.wizards.TexlipseProjectAttributes;
import net.sourceforge.texlipse.wizards.TexlipseProjectCreationOperation;
import net.sourceforge.texlipse.wizards.TexlipseProjectCreationWizardPage;
import net.sourceforge.texlipse.wizards.TexlipseProjectFilesWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class TexlipseProjectCreationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private TexlipseProjectAttributes attributes = new TexlipseProjectAttributes();
    private IConfigurationElement configElement;

    public TexlipseProjectCreationWizard() {
        this.setDialogSettings(TexlipsePlugin.getDefault().getDialogSettings());
        this.setWindowTitle(TexlipsePlugin.getResourceString("projectWizardTitle"));
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new TexlipseProjectCreationWizardPage(this.attributes));
        this.addPage((IWizardPage)new TexlipseProjectFilesWizardPage(this.attributes));
    }

    public boolean performFinish() {
        TexlipseProjectCreationOperation runnable = new TexlipseProjectCreationOperation(this.attributes);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        boolean result = true;
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            result = false;
        }
        catch (InvocationTargetException e) {
            this.handleTargetException(e.getTargetException());
            result = false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return result;
    }

    private void handleTargetException(Throwable target) {
        if (target instanceof CoreException) {
            IStatus status = ((CoreException)target).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)TexlipsePlugin.getResourceString("projectWizardErrorTitle"), (String)TexlipsePlugin.getResourceString("projectWizardErrorMessage"), (IStatus)status);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)TexlipsePlugin.getResourceString("projectWizardErrorTitle"), (String)target.getMessage());
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }
}

