/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.templates;

import java.util.ArrayList;
import java.util.Collections;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.templates.CompletionProposalComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class TexTemplateCompletion
extends TemplateCompletionProcessor {
    TemplateContextType context;

    public TexTemplateCompletion(String contextName) {
        this.context = TexlipsePlugin.getDefault().getTexContextTypeRegistry().getContextType(contextName);
    }

    protected Template[] getTemplates(String contextTypeId) {
        return TexlipsePlugin.getDefault().getTexTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return this.context;
    }

    protected Image getImage(Template template) {
        return TexlipsePlugin.getImage("template");
    }

    public ArrayList addTemplateProposals(ITextViewer viewer, int documentOffset, String prefix) {
        ArrayList<ICompletionProposal> propList = new ArrayList<ICompletionProposal>();
        ICompletionProposal[] templateProposals = this.computeCompletionProposals(viewer, documentOffset);
        int j = 0;
        while (j < templateProposals.length) {
            ICompletionProposal proposal = templateProposals[j];
            if (proposal.getDisplayString().startsWith(prefix)) {
                propList.add(templateProposals[j]);
            }
            ++j;
        }
        Collections.sort(propList, new CompletionProposalComparator());
        return propList;
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        int i = offset - 1;
        if (i == -1) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        try {
            char c = viewer.getDocument().getChar(i);
            while (!Character.isWhitespace(c)) {
                sb.append(c);
                if (--i >= 0) {
                    c = viewer.getDocument().getChar(i);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexTemplateCompletion, extractPrefix.", e);
        }
        return sb.reverse().toString();
    }
}

