/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.tableview.views;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.TexSelections;
import net.sourceforge.texlipse.tableview.views.ITexRowListViewer;
import net.sourceforge.texlipse.tableview.views.TexCellListener;
import net.sourceforge.texlipse.tableview.views.TexCellModifier;
import net.sourceforge.texlipse.tableview.views.TexRow;
import net.sourceforge.texlipse.tableview.views.TexRowList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexTableView
extends ViewPart {
    private TableViewer viewer;
    private Menu menu;
    private TexRowList rowList = new TexRowList();
    private String[] columnNames = new String[32];

    public TexTableView() {
        int i = 0;
        while (i < 32) {
            this.columnNames[i] = "" + (32 - i);
            ++i;
        }
    }

    public Table createTable(Composite parent) {
        int style = 101124;
        Table table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setToolTipText(TexlipsePlugin.getResourceString("tableviewTableTooltip"));
        int i = 0;
        while (i < 32) {
            TableColumn column = new TableColumn(table, 16384, 0);
            column.setText(this.columnNames[i]);
            column.setWidth(50);
            ++i;
        }
        this.menu = new Menu((Control)parent);
        MenuItem mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewInsertRow"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexRow row = (TexRow)((IStructuredSelection)TexTableView.this.viewer.getSelection()).getFirstElement();
                int index = -1;
                if (row != null) {
                    index = TexTableView.this.rowList.indexOf(row);
                }
                if (index != -1) {
                    TexTableView.this.rowList.insertRow(index);
                } else {
                    TexTableView.this.rowList.addRow();
                }
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewDeleteRow"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexRow row = (TexRow)((IStructuredSelection)TexTableView.this.viewer.getSelection()).getFirstElement();
                if (row != null) {
                    TexTableView.this.rowList.removeRow(row);
                }
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewClearAll"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexTableView.this.rowList.clearAll();
            }
        });
        new MenuItem(this.menu, 2);
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewRowUp"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexRow row = (TexRow)((IStructuredSelection)TexTableView.this.viewer.getSelection()).getFirstElement();
                if (row != null) {
                    TexTableView.this.rowList.move(row, TexTableView.this.rowList.indexOf(row) - 1);
                }
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewRowDown"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexRow row = (TexRow)((IStructuredSelection)TexTableView.this.viewer.getSelection()).getFirstElement();
                if (row != null) {
                    TexTableView.this.rowList.move(row, TexTableView.this.rowList.indexOf(row) + 2);
                }
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewDuplicateRow"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexRow row = (TexRow)((IStructuredSelection)TexTableView.this.viewer.getSelection()).getFirstElement();
                if (row != null) {
                    TexTableView.this.rowList.copy(row, TexTableView.this.rowList.indexOf(row));
                }
            }
        });
        new MenuItem(this.menu, 2);
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewEditorImport"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEditorPart targetEditor = TexlipsePlugin.getCurrentWorkbenchPage().getActiveEditor();
                if (!(targetEditor instanceof ITextEditor)) {
                    return;
                }
                TexSelections selection = new TexSelections((ITextEditor)targetEditor);
                TexRow row = (TexRow)((IStructuredSelection)TexTableView.this.viewer.getSelection()).getFirstElement();
                int index = 0;
                if (row != null) {
                    index = TexTableView.this.rowList.indexOf(row);
                }
                TexTableView.this.rowList.importSelection(selection, index);
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewEditorExport"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = TexTableView.this.rowList.export();
                Clipboard cb = new Clipboard(null);
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{value}, new Transfer[]{textTransfer});
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewRawExport"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = TexTableView.this.rowList.exportRaw();
                Clipboard cb = new Clipboard(null);
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{value}, new Transfer[]{textTransfer});
            }
        });
        new MenuItem(this.menu, 2);
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewFlipRows"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexTableView.this.rowList.flipRowsAndColumns();
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewMirrorColumns"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexTableView.this.rowList.mirrorColumns();
            }
        });
        mi = new MenuItem(this.menu, 4);
        mi.setText(TexlipsePlugin.getResourceString("tableviewMirrorRows"));
        mi.setEnabled(true);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexTableView.this.rowList.mirrorRows();
            }
        });
        table.setMenu(this.menu);
        return table;
    }

    public void createPartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 4;
        parent.setLayout((Layout)layout);
        Table table = this.createTable(parent);
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(this.columnNames);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.rowList);
        CellEditor[] editors = new CellEditor[32];
        int i = 0;
        while (i < 32) {
            editors[i] = new TextCellEditor((Composite)table);
            ((Text)editors[i].getControl()).setTextLimit(256);
            editors[i].getControl().addKeyListener((KeyListener)new TexCellListener(this.viewer, this.rowList, i));
            ++i;
        }
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new TexCellModifier(this.viewer, this.rowList));
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)TexlipsePlugin.getResourceString("tableviewTableTitle"), (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITexRowListViewer {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((TexRowList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((TexRowList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            TexTableView.this.rowList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return TexTableView.this.rowList.getRows().toArray();
        }

        public void addRow(TexRow row) {
            TexTableView.this.viewer.add((Object)row);
        }

        public void insertRow(TexRow row) {
            TexTableView.this.viewer.insert((Object)row, TexTableView.this.rowList.indexOf(row));
        }

        public void removeRow(TexRow row) {
            TexTableView.this.viewer.remove((Object)row);
        }

        public void updateRow(TexRow row) {
            TexTableView.this.viewer.update((Object)row, null);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((TexRow)obj).getCol(index);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

