/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.tableview.views;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.texlipse.tableview.views.TexRow;
import net.sourceforge.texlipse.tableview.views.TexRowList;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class TexCellModifier
implements ICellModifier {
    private String[] columnNames;
    private TexRowList rowList;

    public TexCellModifier(TableViewer viewer, TexRowList rowList) {
        this.rowList = rowList;
        this.columnNames = new String[32];
        int i = 0;
        while (i < 32) {
            this.columnNames[i] = "" + (32 - i);
            ++i;
        }
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        List<String> cn = Arrays.asList(this.columnNames);
        int columnIndex = cn.indexOf(property);
        String result = null;
        TexRow row = (TexRow)element;
        result = row.getCol(columnIndex);
        return result;
    }

    public void modify(Object element, String property, Object value) {
        List<String> cn = Arrays.asList(this.columnNames);
        int columnIndex = cn.indexOf(property);
        TableItem item = (TableItem)element;
        TexRow row = (TexRow)item.getData();
        String valueString = ((String)value).trim();
        row.setCol(columnIndex, valueString);
        this.rowList.rowChanged(row);
    }
}

