/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.TexlipseHelpIds;
import net.sourceforge.texlipse.properties.TexlipsePreferencePage;
import net.sourceforge.texlipse.properties.ViewerListFieldEditor;
import net.sourceforge.texlipse.viewer.util.FileLocationServer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ViewerSettingsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_PORT = 65536;
    private static final int MIN_PORT = 1;

    public ViewerSettingsPreferencePage() {
        super(1);
        this.setPreferenceStore(TexlipsePlugin.getDefault().getPreferenceStore());
        this.setDescription(TexlipsePlugin.getResourceString("preferenceViewerPageDescription"));
    }

    protected void createFieldEditors() {
        TexlipsePreferencePage.addSpacer(2, this.getFieldEditorParent());
        ViewerListFieldEditor vfe = new ViewerListFieldEditor(TexlipsePlugin.getResourceString("preferenceViewerConfigsLabel"), this.getFieldEditorParent());
        this.addField((FieldEditor)vfe);
        WorkbenchHelp.setHelp((Control)vfe.getListControl(this.getFieldEditorParent()), (String)TexlipseHelpIds.VIEWER_LIST);
        TexlipsePreferencePage.addSpacer(2, this.getFieldEditorParent());
        TexlipsePreferencePage.addSeparator(2, this.getFieldEditorParent());
        TexlipsePreferencePage.addSpacer(2, this.getFieldEditorParent());
        TexlipsePreferencePage.addLabelField(2, TexlipsePlugin.getResourceString("preferenceViewerPortLabel"), this.getFieldEditorParent());
        String message = TexlipsePlugin.getResourceString("preferenceViewerConfigsPort").replaceFirst("%1", "1").replaceFirst("%2", "65536");
        IntegerFieldEditor port = new IntegerFieldEditor("fileLocPort", message, this.getFieldEditorParent());
        port.setValidateStrategy(0);
        port.setValidRange(1, 65536);
        this.addField((FieldEditor)port);
        this.addField((FieldEditor)new BooleanFieldEditor("forceReturnFocusOnInverseSearch", TexlipsePlugin.getResourceString("forceReturnFocusOnInverseSearch"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("returnFocusOnPreivew", TexlipsePlugin.getResourceString("preferenceViewerReturnFocusLabel"), this.getFieldEditorParent()));
        WorkbenchHelp.setHelp((Control)port.getTextControl(this.getFieldEditorParent()), (String)TexlipseHelpIds.VIEWER_PORT);
    }

    public boolean performOk() {
        int oldPort = this.getPreferenceStore().getInt("fileLocPort");
        boolean ok = super.performOk();
        int newPort = this.getPreferenceStore().getInt("fileLocPort");
        if (newPort != oldPort) {
            FileLocationServer.getInstance().stop();
        }
        return ok;
    }

    public void init(IWorkbench workbench) {
    }
}

