/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineNode {
    public static final int TYPE_DOCUMENT = -1;
    public static final int TYPE_PART = 0;
    public static final int TYPE_CHAPTER = 1;
    public static final int TYPE_SECTION = 2;
    public static final int TYPE_SUBSECTION = 3;
    public static final int TYPE_SUBSUBSECTION = 4;
    public static final int TYPE_PARAGRAPH = 5;
    public static final int TYPE_ENVIRONMENT = 13;
    public static final int TYPE_PREAMBLE = 14;
    public static final int TYPE_LABEL = 20;
    public static final int TYPE_INPUT = 45;
    private String name;
    private int type;
    private int beginLine;
    private int endLine;
    private int offsetOnLine;
    private int declarationLength;
    private OutlineNode parent;
    private ArrayList<OutlineNode> children;
    private Position position;
    private IFile file;

    public OutlineNode(String name, int type, int beginLine, OutlineNode parent) {
        this.name = name;
        this.type = type;
        this.beginLine = beginLine;
        this.parent = parent;
    }

    public OutlineNode(String name, int type, int beginLine, int offset, int length) {
        this.name = name;
        this.type = type;
        this.beginLine = beginLine;
        this.offsetOnLine = offset;
        this.declarationLength = length;
    }

    public OutlineNode copy(IFile texFile) {
        OutlineNode on = new OutlineNode(this.name, this.type, this.beginLine, this.offsetOnLine, this.declarationLength);
        on.endLine = this.endLine;
        on.position = this.position;
        on.file = texFile;
        return on;
    }

    public void addChild(OutlineNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void addChild(OutlineNode child, int index) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(index, child);
    }

    public boolean deleteChild(OutlineNode child) {
        return this.children.remove(child);
    }

    public ArrayList<OutlineNode> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<OutlineNode> children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OutlineNode getParent() {
        return this.parent;
    }

    public void setParent(OutlineNode parent) {
        this.parent = parent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public IFile getIFile() {
        return this.file;
    }

    public void setIFile(IFile file) {
        this.file = file;
    }

    public int getDeclarationLength() {
        return this.declarationLength;
    }

    public int getOffsetOnLine() {
        return this.offsetOnLine;
    }

    public String toString() {
        if (this.position == null) {
            return String.valueOf(this.type) + " " + this.name + " (null position) " + super.toString();
        }
        return String.valueOf(this.type) + " " + this.name + " " + this.position.getOffset() + " " + this.position.getLength() + super.toString();
    }

    public static int getSmallerType(int type) {
        if (type <= 5) {
            return type - 1;
        }
        switch (type) {
            case 13: {
                return 5;
            }
            case 14: {
                return 13;
            }
            case 45: {
                return 14;
            }
        }
        return -1;
    }
}

