/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import net.sourceforge.texlipse.builder.TexlipseBuilder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class TexlipseNature
implements IProjectNature {
    public static final String NATURE_ID = TexlipseNature.class.getName();
    private IProject project;

    public void configure() throws CoreException {
        this.addBuilder(TexlipseBuilder.BUILDER_ID);
    }

    public void deconfigure() throws CoreException {
        this.removeBuilder(TexlipseBuilder.BUILDER_ID);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private void addBuilder(String id) throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        if (!this.hasBuilder(commands, id)) {
            ICommand command = desc.newCommand();
            command.setBuilderName(id);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
        }
    }

    private void removeBuilder(String id) throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        if (this.hasBuilder(commands, id)) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length - 1);
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
        }
    }

    private boolean hasBuilder(ICommand[] commands, String id) {
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

