/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.File;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.ExternalProgram;
import net.sourceforge.texlipse.builder.Kpath;
import net.sourceforge.texlipse.builder.ProgramRunner;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;

public class KpsewhichRunner
implements ProgramRunner {
    private ExternalProgram extrun = new ExternalProgram();

    public String getDescription() {
        return "Kpsewhich program";
    }

    public String getInputFormat() {
        return null;
    }

    public String getOutputFormat() {
        return null;
    }

    public String getProgramArguments() {
        return "(Not applicable)";
    }

    public String getProgramName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") >= 0) {
            return this.getWindowsProgramName();
        }
        return this.getUnixProgramName();
    }

    public String getProgramPath() {
        return TexlipsePlugin.getPreference(this.getCommandPreferenceName());
    }

    public void initializeDefaults(IPreferenceStore pref, String path) {
        pref.setDefault(this.getCommandPreferenceName(), path);
    }

    public boolean isValid() {
        if (this.getProgramPath() == null) {
            return false;
        }
        File f = new File(this.getProgramPath());
        return f.exists() && f.isFile();
    }

    public void run(IResource resource) throws CoreException {
    }

    public void setProgramArguments(String args) {
    }

    public void setProgramPath(String path) {
        TexlipsePlugin.getDefault().getPreferenceStore().setValue(this.getCommandPreferenceName(), path);
    }

    public void stop() {
        if (this.extrun != null) {
            this.extrun.stop();
        }
    }

    private String getCommandPreferenceName() {
        return this.getClass() + "_prog";
    }

    protected String getWindowsProgramName() {
        return "kpsewhich.exe";
    }

    protected String getUnixProgramName() {
        return "kpsewhich";
    }

    protected String run(String[] command, IResource resource) throws CoreException {
        String console = null;
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("builderConsole")) {
            console = this.getProgramName();
        }
        this.extrun.setup(command, resource.getLocation().toFile().getParentFile(), console);
        String output = null;
        try {
            try {
                output = this.extrun.run();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, TexlipsePlugin.getPluginId(), 4, "Building the project: ", (Throwable)e));
            }
        }
        finally {
            this.extrun.stop();
        }
        return output;
    }

    public String getFile(IResource resource, String filename, String progname) throws CoreException {
        String[] command = new String[]{this.getProgramPath(), "-progname=" + progname, filename};
        String output = this.run(command, resource);
        String[] outList = output.split("\r\n|\r|\n");
        return outList[0];
    }

    public Kpath[] getSearchPaths(IResource resource, String ext) throws CoreException {
        String[] command = new String[]{this.getProgramPath(), "-show-path", ext};
        String output = this.run(command, resource);
        if (output.startsWith("warning: kpsewhich: Ignoring unknown file type")) {
            return null;
        }
        String[] outList = output.split(String.valueOf(File.pathSeparator) + "|\r\n|\r|\n");
        Kpath[] kpaths = new Kpath[outList.length];
        int i = 0;
        while (i < outList.length) {
            String unpack = outList[i];
            kpaths[i] = new Kpath(unpack);
            ++i;
        }
        return kpaths;
    }
}

