/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexSelections {
    private ITextEditor editor;
    private IDocument document;
    private int startLineIndex;
    private int endLineIndex;
    private int selLength;
    private String selection = "";
    private String endLineDelim = "";
    private IRegion startLine;
    private IRegion endLine;
    private ITextSelection textSelection;

    public TexSelections(ITextEditor textEditor) {
        this.document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        this.editor = textEditor;
        this.textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        this.startLineIndex = this.textSelection.getStartLine();
        this.endLineIndex = this.textSelection.getEndLine();
        this.selLength = this.textSelection.getLength();
        this.select();
    }

    private void select() {
        if (this.endLineIndex < this.startLineIndex) {
            this.endLineIndex = this.startLineIndex;
        }
        try {
            if (this.selLength > 0) {
                this.startLine = this.document.getLineInformation(this.startLineIndex);
                this.endLine = this.document.getLineInformation(this.endLineIndex);
                this.endLineDelim = this.document.getLineDelimiter(this.startLineIndex);
                this.selection = this.document.get(this.textSelection.getOffset(), this.textSelection.getLength());
            } else {
                int initialPos = 0;
                this.startLine = this.document.getLineInformation(this.startLineIndex);
                this.endLine = this.document.getLineInformation(this.endLineIndex);
                this.selLength = this.startLine.getLength();
                initialPos = this.startLine.getOffset();
                this.endLineDelim = this.document.getLineDelimiter(this.startLineIndex);
                this.selection = this.document.get(initialPos, this.selLength);
            }
        }
        catch (Exception e) {
            TexlipsePlugin.log("TexSelections.select(): ", e);
        }
    }

    public void selectCompleteLines() {
        this.selLength = this.endLine.getOffset() + this.endLine.getLength() - this.startLine.getOffset();
    }

    public void selectParagraph() {
        if (this.textSelection.getLength() == 0) {
            try {
                int offset = this.textSelection.getOffset();
                String doc = this.document.get();
                Pattern p = Pattern.compile("(?m)" + Pattern.quote(this.endLineDelim) + "\\p{Blank}*" + Pattern.quote(this.endLineDelim));
                Matcher m = p.matcher(doc);
                m.region(0, offset);
                int paraBegin = 0;
                while (m.find()) {
                    paraBegin = m.end();
                }
                this.startLineIndex = this.document.getLineOfOffset(paraBegin);
                m.region(offset, doc.length());
                int paraEnd = m.find() ? m.start() : doc.length();
                this.endLineIndex = this.document.getLineOfOffset(paraEnd);
                this.selLength = paraEnd - paraBegin;
            }
            catch (BadLocationException ble) {
                throw new RuntimeException(ble);
            }
        } else {
            this.selectCompleteLines();
        }
    }

    public String getLine(int i) {
        try {
            return this.document.get(this.document.getLineInformation(i).getOffset(), this.document.getLineInformation(i).getLength());
        }
        catch (Exception e) {
            TexlipsePlugin.log("TexSelections.getLine: ", e);
            return "";
        }
    }

    public String getCompleteLines() {
        try {
            return this.document.get(this.startLine.getOffset(), this.endLine.getOffset() + this.endLine.getLength() - this.startLine.getOffset());
        }
        catch (Exception e) {
            TexlipsePlugin.log("TexSelections.getCompleteLines: ", e);
            return "";
        }
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public ITextEditor getEditor() {
        return this.editor;
    }

    public void setEditor(ITextEditor editor) {
        this.editor = editor;
    }

    public IRegion getEndLine() {
        return this.endLine;
    }

    public void setEndLine(IRegion endLine) {
        this.endLine = endLine;
    }

    public IRegion getStartLine() {
        return this.startLine;
    }

    public void setStartLine(IRegion startLine) {
        this.startLine = startLine;
    }

    public String getEndLineDelim() {
        return this.endLineDelim;
    }

    public void setEndLineDelim(String endLineDelim) {
        this.endLineDelim = endLineDelim;
    }

    public int getEndLineIndex() {
        return this.endLineIndex;
    }

    public void setEndLineIndex(int endLineIndex) {
        this.endLineIndex = endLineIndex;
    }

    public String getCompleteSelection() {
        return this.selection;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public int getSelLength() {
        return this.selLength;
    }

    public int getRawSelLength() {
        return this.textSelection.getLength();
    }

    public int getStartLineIndex() {
        return this.startLineIndex;
    }

    public void setStartLineIndex(int startLineIndex) {
        this.startLineIndex = startLineIndex;
    }

    public ITextSelection getTextSelection() {
        return this.textSelection;
    }

    public void setTextSelection(ITextSelection textSelection) {
        this.textSelection = textSelection;
    }
}

