/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SetMainFileAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private IWorkbenchWindow window;
    private IEditorPart editor;

    public void run(IAction action) {
        String oldTmp;
        String builderNum;
        String format;
        IFile file = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        IProject project = file.getProject();
        if (TexlipseProperties.isProjectPropertiesFileChanged(project)) {
            TexlipseProperties.loadProjectProperties(project);
        }
        if ((format = TexlipseProperties.getProjectProperty((IResource)project, "outputFormat")) == null || format.length() == 0) {
            TexlipseProperties.setProjectProperty((IResource)project, "outputFormat", TexlipsePlugin.getPreference("outputFormat"));
        }
        if ((builderNum = TexlipseProperties.getProjectProperty((IResource)project, "builderNum")) == null || builderNum.length() == 0) {
            TexlipseProperties.setProjectProperty((IResource)project, "builderNum", TexlipsePlugin.getPreference("builderNum"));
        }
        String name = file.getName();
        IPath path = file.getFullPath();
        IFile currentMainFile = TexlipseProperties.getProjectSourceFile(project);
        if (currentMainFile != null && path.equals((Object)currentMainFile.getFullPath())) {
            return;
        }
        TexlipseProperties.setProjectProperty((IResource)project, "mainTexFile", name);
        String output = String.valueOf(name.substring(0, name.lastIndexOf(46) + 1)) + format;
        TexlipseProperties.setProjectProperty((IResource)project, "outputFile", output);
        String dir = path.removeFirstSegments(1).removeLastSegments(1).toString();
        TexlipseProperties.setProjectProperty((IResource)project, "srcDir", dir);
        String oldOut = TexlipseProperties.getProjectProperty((IResource)project, "outputDir");
        if (oldOut == null) {
            TexlipseProperties.setProjectProperty((IResource)project, "outputDir", dir);
        }
        if ((oldTmp = TexlipseProperties.getProjectProperty((IResource)project, "tempDir")) == null) {
            TexlipseProperties.setProjectProperty((IResource)project, "tempDir", dir);
        }
        TexlipseProperties.saveProjectProperties(project);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
        action.setEnabled(this.editor instanceof ITextEditor);
    }
}

