# Copyright (C) 1999 - Martin Strauss - under terms of GPL
 ##############################################################################
 # Umdefinition des Defaultverhaltens fuer Text-variablen
 bind Text <Control-k> {}
 bind Text <Control-b> {}
 # Block Anfang
 bind Text <Control-k><b> {
  set BlockBeginFlag 1
  %W mark set BlockBegin insert
  if {[string compare %W $BlockEditor] == 0} then {
   if $BlockEndFlag then {
    %W tag remove BlockTag 1.0 end
    %W tag add BlockTag BlockBegin BlockEnd
  }} else {
   if {$BlockBeginFlag && $BlockEndFlag} then {
    $BlockEditor tag remove BlockTag 1.0 end
   }
   set BlockEndFlag 0
   set BlockEditor %W
  }
 }
 # Block Ende
 bind Text <Control-k><k> {
  set BlockEndFlag 1
  %W mark set BlockEnd insert
  %W mark gravity BlockEnd left
  if {[string compare %W $BlockEditor] == 0} then {
   if $BlockBeginFlag then {
    %W tag remove BlockTag 1.0 end
    %W tag add BlockTag BlockBegin BlockEnd
  }} else {
   if {$BlockBeginFlag && $BlockEndFlag} then {
    $Blockeditor tag remove BlockTag 1.0 end
   }
   set BlockBeginFlag 0
   set BlockEditor %W
  }
 }
 # Block kopieren
 bind Text <Control-k><c> {
  if {$BlockBeginFlag && $BlockEndFlag} then {
   set ksp [%W index {insert linestart}]
   undo_switch %W {Save UndoBegin}
   %W insert insert [$BlockEditor get BlockBegin BlockEnd]
   undo_switch %W {UndoEnd Save UndoMax}
   Syntax %W $ksp "insert lineend"
  }
 }
 # Block verschieben
 bind Text <Control-k><v> {
  if {$BlockBeginFlag && $BlockEndFlag} then {
   set ksp [%W index "insert linestart"]
   undo_switch %W {Save UndoBegin}
   %W insert insert [$BlockEditor get BlockBegin BlockEnd]
   undo_switch %W {UndoEnd Save}
   undo_switch $BlockEditor {{BlockBegin BlockEnd} Delete UndoMax}
   if {[string compare %W $BlockEditor] == 0} then {
    undo_switch %W UndoMul
   }
   Syntax %W $ksp "insert lineend"
   Syntax $BlockEditor "BlockBegin linestart" "BlockEnd lineend"
  }
 }
 bind Text <Control-k><m> {
  event generate %W <Control-k> 
  event generate %W <v> 
 }
 # Block loeschen
 bind Text <Control-k><y> {
  if {$BlockBeginFlag && $BlockEndFlag} then {
   undo_switch $BlockEditor {Save {BlockBegin BlockEnd} Delete UndoMax}
  }
 }
 # Block auskommentieren
proc AusKomm {E A B} {
 set i [lindex "[split [$E index $A] .]" 0]
 set i_max [lindex "[split [$E index $B] .]" 0]
 incr i_max
 set ksp $i.0
 while {$i < $i_max} {
  if [expr [string compare [$E get "$i.0 linestart" "$i.0 linestart+1c"] "%"] != 0] {
   $E insert "$i.0 linestart" "%"
  }
  incr i
 }
 Syntax $E $ksp $i_max.0
 event generate $E <<Modified>>
}
 # Block auskommentieren rueckgaengig
proc AusKommRueck {E A B} {
 set i [lindex "[split [$E index $A] .]" 0]
 set i_max [lindex "[split [$E index $B] .]" 0]
 incr i_max
 set ksp $i.0
 while {$i < $i_max} {
  if [expr [string compare [$E get "$i.0 linestart" "$i.0 linestart+1c"] "%"] == 0] {
   $E delete "$i.0 linestart" "$i.0 linestart+1c"
  }
  incr i
 }
 Syntax $E $ksp $i_max.0
 event generate $E <<Modified>>
}

switch $tcl_platform(platform) windows {
# Auf jedenfall fuer Windows !!!
 bind Text <Control-k><%> {
  if { $BlockBeginFlag && $BlockEndFlag} then {
   AusKomm %W BlockBegin BlockEnd
  }
 }
} unix {
# fuer linux ???
 bind Text <Control-k><Shift-5> {
  if { $BlockBeginFlag && $BlockEndFlag} then {
   AusKomm %W BlockBegin BlockEnd
  }
 }
}
 bind Text <Control-k><space> {
  if { $BlockBeginFlag && $BlockEndFlag} then {
   AusKommRueck %W BlockBegin BlockEnd
  }
 }
 # Block in Clipboard kopieren
 bind Text <Control-k><g> {
  if { $BlockBeginFlag && $BlockEndFlag} then {
   clipboard clear -displayof %W
   catch {clipboard append -displayof %W [$BlockEditor get BlockBegin BlockEnd]}
  }
 }
 # aus Clipboard kopieren
 bind Text <Control-k><p> {
  set ksp [%W index {insert linestart}]
  undo_switch %W {Save UndoBegin}
  tk_textPaste %W
  undo_switch %W {UndoEnd Save UndoMax}
  Syntax %W $ksp "insert lineend"
 }
 bind Text <Control-k><h> {break}

 bind Text <Insert> {
  undo_switch %W {Save UndoBegin}
  catch {tkTextInsert %W [selection get -displayof %W]}
  undo_switch %W {UndoEnd Save}
 }

 # Block eliminieren
 bind Text <Destroy> {
  set BlockBeginFlag 0
  set BlockEndFlag 0
  if {[lsearch [array names ModifiedArray] %W] != -1} {
   unset ModifiedArray(%W)
  }
  if {[lsearch [array names UndoArray] %W] != -1} {
   unset UndoArray(%W)
  }
  if {[lsearch [array names FilenameArray] %W] != -1} {
   unset FilenameArray(%W)
  }
 }

 # Zeile aus Text loeschen
 bind Text <Control-y> {
  undo_switch %W {{"insert linestart" "insert lineend+1c"} Delete}
 }
 bind Text <Control-d> {
  if $FocusEditorFlag {
   focus $FocusEditor.te.edit1
   set ksp [$FocusEditor.te.edit1 get {insert wordstart-1c} {insert wordstart}]
   if ![string compare "\\" $ksp] then {
    set Text [$FocusEditor.te.edit1 get {insert wordstart} {insert wordend}]
    if {[llength [array names I_befehl $Text]] != 1} {set Text "\\section"} else {set Text "\\$Text"}
   } {set Text "\\section"}
   set ksp [$FocusEditor.te.edit1 search -- $Text {insert wordend} end]
   if {$ksp != ""} then {
    $FocusEditor.te.edit1 mark set insert "$ksp + 1 chars"
    $FocusEditor.te.edit1 see insert
    event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
 }}}
 bind Text <Control-u> {
  if $FocusEditorFlag {
   focus $FocusEditor.te.edit1
   set ksp [$FocusEditor.te.edit1 get {insert wordstart-1c} {insert wordstart}]
   if ![string compare "\\" $ksp] then {
    set Text [$FocusEditor.te.edit1 get {insert wordstart} {insert wordend}]
    if {[llength [array names I_befehl $Text]] != 1} {set Text "\\section"} else {set Text "\\$Text"}
   } {set Text "\\section"}
   set ksp [$FocusEditor.te.edit1 search -backwards -- $Text {insert wordstart-1c} 1.0]
   if {$ksp != ""} then {
    $FocusEditor.te.edit1 mark set insert "$ksp + 1 chars"
    $FocusEditor.te.edit1 see insert
    event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
 }}}
 bind Text <Control-b> {
  if $FocusEditorFlag {
   Line_breaking_switch $FocusEditor.te.edit1 section
  }
 }
 bind Text <Control-B> {
  if $FocusEditorFlag {
   Line_breaking_switch $FocusEditor.te.edit1 unsection
  }
 }
 bind Text <Alt-b> {
  if $FocusEditorFlag {
   Line_breaking_switch $FocusEditor.te.edit1 line
  }
 }
 bind Text <Alt-B> {
  if $FocusEditorFlag {
   Line_breaking_switch $FocusEditor.te.edit1 unline
  }
 }

 # Was passiert wenn man ein Fenster vernichtet
 bind Toplevel <Destroy> {
  # Fenster war Master dann Master loeschen
  if $MasterFlag then {if {[string compare $Master %W] == 0} then {set MasterFlag 0}}
  if $FocusEditorFlag then {if {[string compare $FocusEditor %W] == 0} then {set FocusEditorFlag 0}}
 }


bind Text <KeyPress> {
 if $erg_flag(%W) then {
  if {[%W get insert insert+1c] == "%A"} then {
   %W mark set insert insert+1c
   continue
  } else {
   erg_proc %W
  }
 }
 if {"%A" != "{}"} then { 
 undo_switch %W {SelSave UndoBegin}
 tkTextInsert %W %A
 undo_switch %W {UndoEnd SelMul}

  if $BeginFlag(%W) then {
   %W insert BeginMark %A
   undo_switch %W BeginMark
  }
  event generate %W <<ERG>> 
  event generate %W <<Modified>>
  if $KlammerFlag then {
     switch -- "%A" "(" {
      tkTextInsert %W ")"
      undo_switch %W UndoEnd
      tkTextSetCursor %W insert-1c
     } "\{" {
      if {[string compare [%W get insert-2c] "\\"] == 0} {
       tkTextInsert %W "\\\}"
       undo_switch %W UndoEnd
       tkTextSetCursor %W insert-2c
      } {
       tkTextInsert %W "\}"
       undo_switch %W UndoEnd
       tkTextSetCursor %W insert-1c
      }
     } "\[" {
      if {[string compare [%W get insert-2c] "\\"] == 0} {
       tkTextInsert %W "\\\]"
       undo_switch %W UndoEnd
       tkTextSetCursor %W insert-2c
      } {
       tkTextInsert %W "\]"
       undo_switch %W UndoEnd
       tkTextSetCursor %W insert-1c
      }
     } "$" {
      tkTextInsert %W "$"
      undo_switch %W UndoEnd
      tkTextSetCursor %W insert-1c
}}}}
