/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.image.CCITTFactory;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.SampledImageReader;

public final class PDImageXObject
extends PDXObject
implements PDImage {
    private static final Log LOG = LogFactory.getLog(PDImageXObject.class);
    private SoftReference<BufferedImage> cachedImage;
    private PDColorSpace colorSpace;
    private final PDResources resources;

    public static PDImageXObject createThumbnail(COSStream cosStream) throws IOException {
        PDStream pdStream = new PDStream(cosStream);
        return new PDImageXObject(pdStream, null);
    }

    public PDImageXObject(PDDocument document) throws IOException {
        this(new PDStream(document), (PDResources)null);
    }

    public PDImageXObject(PDDocument document, InputStream encodedStream, COSBase cosFilter, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        super(PDImageXObject.createRawStream(document, encodedStream), COSName.IMAGE);
        this.getCOSStream().setItem(COSName.FILTER, cosFilter);
        this.resources = null;
        this.colorSpace = null;
        this.setBitsPerComponent(bitsPerComponent);
        this.setWidth(width);
        this.setHeight(height);
        this.setColorSpace(initColorSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static COSStream createRawStream(PDDocument document, InputStream rawInput) throws IOException {
        COSStream stream = document.getDocument().createCOSStream();
        OutputStream output = null;
        try {
            output = stream.createRawOutputStream();
            IOUtils.copy(rawInput, output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return stream;
    }

    public PDImageXObject(PDStream stream, PDResources resources) throws IOException {
        this(stream, resources, stream.createInputStream());
    }

    public static PDImageXObject createFromFile(String imagePath, PDDocument doc) throws IOException {
        return PDImageXObject.createFromFile(new File(imagePath), doc);
    }

    public static PDImageXObject createFromFile(File file, PDDocument doc) throws IOException {
        String name = file.getName();
        int dot = file.getName().lastIndexOf(46);
        if (dot == -1) {
            throw new IOException("Image type not supported: " + name);
        }
        String ext = name.substring(dot + 1).toLowerCase();
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            return JPEGFactory.createFromStream(doc, new FileInputStream(file));
        }
        if ("tif".equals(ext) || "tiff".equals(ext)) {
            return CCITTFactory.createFromFile(doc, file);
        }
        if ("gif".equals(ext) || "bmp".equals(ext) || "png".equals(ext)) {
            BufferedImage bim = ImageIO.read(file);
            return LosslessFactory.createFromImage(doc, bim);
        }
        throw new IOException("Image type not supported: " + name);
    }

    private PDImageXObject(PDStream stream, PDResources resources, COSInputStream input) {
        super(PDImageXObject.repair(stream, input), COSName.IMAGE);
        this.resources = resources;
        this.colorSpace = input.getDecodeResult().getJPXColorSpace();
    }

    private static PDStream repair(PDStream stream, COSInputStream input) {
        stream.getStream().addAll(input.getDecodeResult().getParameters());
        return stream;
    }

    public PDMetadata getMetadata() {
        COSStream cosStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.METADATA);
        if (cosStream != null) {
            return new PDMetadata(cosStream);
        }
        return null;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSStream().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSStream().getInt(COSName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int key) {
        this.getCOSStream().setInt(COSName.STRUCT_PARENT, key);
    }

    @Override
    public BufferedImage getImage() throws IOException {
        BufferedImage cached;
        if (this.cachedImage != null && (cached = this.cachedImage.get()) != null) {
            return cached;
        }
        BufferedImage image = SampledImageReader.getRGBImage(this, this.getColorKeyMask());
        PDImageXObject softMask = this.getSoftMask();
        if (softMask != null) {
            image = this.applyMask(image, softMask.getOpaqueImage(), true);
        } else {
            PDImageXObject mask = this.getMask();
            if (mask != null) {
                image = this.applyMask(image, mask.getOpaqueImage(), false);
            }
        }
        this.cachedImage = new SoftReference<BufferedImage>(image);
        return image;
    }

    @Override
    public BufferedImage getStencilImage(Paint paint) throws IOException {
        if (!this.isStencil()) {
            throw new IllegalStateException("Image is not a stencil");
        }
        return SampledImageReader.getStencilImage(this, paint);
    }

    public BufferedImage getOpaqueImage() throws IOException {
        return SampledImageReader.getRGBImage(this, null);
    }

    private BufferedImage applyMask(BufferedImage image, BufferedImage mask, boolean isSoft) throws IOException {
        if (mask == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (mask.getWidth() < width || mask.getHeight() < height) {
            mask = this.scaleImage(mask, width, height);
        } else if (mask.getWidth() > width || mask.getHeight() > height) {
            width = mask.getWidth();
            height = mask.getHeight();
            image = this.scaleImage(image, width, height);
        }
        BufferedImage masked = new BufferedImage(width, height, 2);
        WritableRaster src = image.getRaster();
        WritableRaster dest = masked.getRaster();
        WritableRaster alpha = mask.getRaster();
        float[] rgb = new float[4];
        float[] rgba = new float[4];
        float[] alphaPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                src.getPixel(x, y, rgb);
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                alphaPixel = alpha.getPixel(x, y, alphaPixel);
                rgba[3] = isSoft ? alphaPixel[0] : 255.0f - alphaPixel[0];
                dest.setPixel(x, y, rgba);
            }
        }
        return masked;
    }

    private BufferedImage scaleImage(BufferedImage image, int width, int height) {
        BufferedImage image2 = new BufferedImage(width, height, 1);
        Graphics2D g = image2.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawImage(image, 0, 0, width, height, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return image2;
    }

    public PDImageXObject getMask() throws IOException {
        COSBase mask = this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return null;
        }
        COSStream cosStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    public COSArray getColorKeyMask() {
        COSBase mask = this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return (COSArray)mask;
        }
        return null;
    }

    public PDImageXObject getSoftMask() throws IOException {
        COSStream cosStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.SMASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        return this.getCOSStream().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC);
    }

    @Override
    public void setBitsPerComponent(int bpc) {
        this.getCOSStream().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSStream().getDictionaryObject(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.getStream().createInputStream();
    }

    @Override
    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        return this.createInputStream();
    }

    @Override
    public boolean isEmpty() {
        return this.getStream().getStream().getLength() == 0L;
    }

    @Override
    public void setColorSpace(PDColorSpace cs) {
        this.getCOSStream().setItem(COSName.COLORSPACE, cs != null ? cs.getCOSObject() : null);
    }

    @Override
    public int getHeight() {
        return this.getCOSStream().getInt(COSName.HEIGHT);
    }

    @Override
    public void setHeight(int h) {
        this.getCOSStream().setInt(COSName.HEIGHT, h);
    }

    @Override
    public int getWidth() {
        return this.getCOSStream().getInt(COSName.WIDTH);
    }

    @Override
    public void setWidth(int w) {
        this.getCOSStream().setInt(COSName.WIDTH, w);
    }

    @Override
    public boolean getInterpolate() {
        return this.getCOSStream().getBoolean(COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.getCOSStream().setBoolean(COSName.INTERPOLATE, value);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.getCOSStream().setItem(COSName.DECODE, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        COSBase decode = this.getCOSStream().getDictionaryObject(COSName.DECODE);
        if (decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    @Override
    public boolean isStencil() {
        return this.getCOSStream().getBoolean(COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.getCOSStream().setBoolean(COSName.IMAGE_MASK, isStencil);
    }

    @Override
    public String getSuffix() {
        List<COSName> filters = this.getStream().getFilters();
        if (filters == null) {
            return "png";
        }
        if (filters.contains(COSName.DCT_DECODE)) {
            return "jpg";
        }
        if (filters.contains(COSName.JPX_DECODE)) {
            return "jpx";
        }
        if (filters.contains(COSName.CCITTFAX_DECODE)) {
            return "tiff";
        }
        if (filters.contains(COSName.FLATE_DECODE) || filters.contains(COSName.LZW_DECODE) || filters.contains(COSName.RUN_LENGTH_DECODE)) {
            return "png";
        }
        LOG.warn("getSuffix() returns null, filters: " + filters);
        return null;
    }
}

