/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
** Permission to use, copy, modify and distribute this software
** and its documentation for any purpose is hereby granted
** without fee, provided that the above copyright notice appear
** in all copies and that both that copyright notice and this
** permission notice appear in supporting documentation, and
** that the name of EUT not be used in advertising or publicity
** pertaining to distribution of the software without specific,
** written prior permission.  EUT makes no representations about
** the suitability of this software for any purpose. It is provided
** "as is" without express or implied warranty.
** 
** EUT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
** SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL EUT
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
** DAMAGES OR ANY DAMAGE WHATSOEVER RESULTING FROM
** LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
** OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
** OF THIS SOFTWARE.
** 
** 
** Roland Backhouse & Richard Verhoeven.
** Department of Mathematics and Computing Science.
** Eindhoven University of Technology.
**
********************************************************************/
/*
** file  system.c
** doel  directories, filenamen en  variabelen initiele waarden geven
*/

#include <stdlib.h>
#include <string.h>
#include "mathpad.h"
#include "system.h"
#include "funcs.h"
#include "sources.h"
#include "config.h"

#define USERDIR "mathspad/"
#define LATEXDIR "latex/"
#define NOTATIONDIR "stencils/"
#define FONTFILENAME "MPFonts"
#define KEYPATH "emacs"

#ifndef MATHPADHOME
 #error Set the -DMATHPADHOME='"..."' option the makefile.
#endif

/*
**  Deze directories worden gebruikt bij het zoeken naar een file. Zo wordt het
**  mogelijk dat gebruikers eigen files gebruiken, die zijn aangepast
**  aan de eisen van die gebruiker.
*/


char **arguments;
int  number_of_arguments;
char *progname = NULL,
     *homedir = NULL,
     *userdir = NULL,
     *latexdir = NULL,
     *notationdir = NULL,
     *fontfile[NR_SIZE] = { NULL },
     *keypath = NULL,
     *program_dir = NULL,
     *program_latexdir = NULL,
     *program_notationdir = NULL,
     *program_fontfilename = NULL,
     *program_keypath = NULL;
char **help_dirs = NULL;
int nr_help_dirs = 0;

char *latex_line_unit,
     *latex_tab_unit,
     *latex_space_unit;

int latex_side = 3,
    line_space = 1,
    screen_tab = 20,
    screen_space = 1,
    notation_precedence = 0,
    wait_time = 250,
    textdots = 1,
    autowordwrap=1,
    singlemode=0,
    autodouble=0,
    saveonexit=0;

int symbol_is_open = 0,
    notation_is_open = 0,
    edit_is_open = 0,
    buffer_is_open =0,
    notadef_is_open = 0,
    default_is_open = 0,
    remark_is_open = 0,
    find_is_open = 0,
    menu_is_open = 0,
    symbol_iconized = 0,
    edit_iconized = 0,
    notation_iconized = 0,
    notadef_iconized = 0,
    buffer_iconized = 0,
    default_iconized = 0,
    menu_iconized = 0,
    find_iconized = 0,
    remark_iconized = 0;

void system_init(int argc, char *argv[])
{
    char *temp, *c, *h;
    int i,n=0,dhda=0;

    temp = getenv("HOME");
    homedir              = concat(temp, "/");
    i=strlen(homedir);
    if (homedir[i-2]=='/') homedir[i-1]='\0';
    userdir              = concat(homedir, USERDIR);
    latexdir             = concat(userdir, LATEXDIR);
    notationdir          = concat(userdir, NOTATIONDIR);
    latex_line_unit      = concat("2", "mm");
    latex_tab_unit       = concat("8.5", "mm");
    latex_space_unit     = concat("0.3", "em");

    if ((temp = getenv("MATHPADHOME")))
	if (temp[strlen(temp)-1]=='/')
	    program_dir = concat(temp, "");
	else
	    program_dir = concat(temp, "/");
    else
	program_dir = concat(MATHPADHOME,"/");
    /* make MATHPADFONTPATH equal to program_dir/fonts (if not set) */
    if (!getenv("MATHPADFONTPATH")) {
	char *d;
	d=concat(program_dir,"/fonts");
	temp = concat("MATHPADFONTPATH=", d);
	if (d) free(d);
	if (temp) putenv(temp);
    }
    /* make program_dir accessible with ~mathpad or $mathpad */
    if (!getenv("mathpad") && (temp = concat("mathpad=",program_dir)))
	putenv(temp);
    /* make program_dir accessible with ~mathspad or $mathspad */
    if (!getenv("mathspad") && (temp = concat("mathspad=",program_dir)))
	putenv(temp);
    /* add program_dir/bin to PATH variable */
    if ((temp = getenv("PATH"))) {
	i=strlen(temp)+strlen(program_dir)+15;
	h= (char*) malloc(i*sizeof(char));
	concat_in(h,"PATH=", temp);
	i=strlen(h);
	h[i++]=':';
	concat_in(h+i,program_dir, "bin");
	putenv(h);
    }
    if ((temp = getenv("MATHPADLATEX")))
	if (temp[strlen(temp)-1]=='/')
	    program_latexdir = concat(temp, "");
	else
	    program_latexdir = concat(temp, "/");
    else
	program_latexdir = concat(program_dir, LATEXDIR);

    if ((temp = getenv("MATHPADSTENCIL")))
	if (temp[strlen(temp)-1]=='/')
	    program_notationdir = concat(temp, "");
	else
	    program_notationdir = concat(temp, "/");
    else
	program_notationdir = concat(program_dir, NOTATIONDIR);

    if ((temp = getenv("MATHPADFONTS"))) {
	program_fontfilename = concat(temp, "");
	fontfile[EDITFONT] = concat(temp, "");
    } else {
	fontfile[EDITFONT]   = concat(FONTFILENAME, "");
	program_fontfilename = concat(FONTFILENAME, "");
    }
    temp = getenv("MATHPADHELPPATH");
    if (!temp) temp=":";
    c=temp;
    i=0;
    while (*c) { n+=(*c==':'); c++; i++; }
    help_dirs = (char **) malloc(sizeof(char*) * (n*2+7));
    c = (char*) malloc(sizeof(char)*(n*10+i*2+2));
    h = temp;
    while (i>0 || (!i && !*h)) {
	int cp=0;
	help_dirs[nr_help_dirs]=c;
	while ((*c=*h++) && *c != ':') {
	    cp+=(*c == '%');
	    c++;i--;
	}
	i--;
	if (*c==':') *c='\0';
	if (help_dirs[nr_help_dirs]!=c) {
	    if (*(c-1)!='/' && !cp) {
		*c++='/';
		*c='\0';
	    }
	    if (!cp) {
		nr_help_dirs++;
		c++;
		help_dirs[nr_help_dirs]=c;
		concat_in(c,help_dirs[nr_help_dirs-1], "%.mpd");
		while (*c) c++;
	    }
	} else if (!dhda) {
	    dhda=1;
	    help_dirs[nr_help_dirs++] = concat(homedir,
					       "mathspad/help/%.mpd");
	    help_dirs[nr_help_dirs++] = concat(homedir, "mathspad/help/");
	    help_dirs[nr_help_dirs++] = concat(program_dir, "help/%.mpd");
	    help_dirs[nr_help_dirs++] = concat(program_dir, "help/");
	    help_dirs[nr_help_dirs++] = "%.mpd";
	    help_dirs[nr_help_dirs] = "";
	}
	nr_help_dirs++;
	c++;
    }
    for (i=1; i<NR_SIZE; i++)
	fontfile[i]= concat("","");
    if ((temp = getenv("MATHPADKEYS")))
	program_keypath = concat(temp, "");
    else
	program_keypath = concat(KEYPATH,"");
    keypath = concat("","");
    make_defaults(argc, argv);
}

