/*
 *  Eukleides version 1.5.3
 *  Copyright (c) Christian Obrecht 2004-2010
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include "winutils.h"

int main(int argc, char** argv)
{
    FILE* out_file;
    char* base;
    char* stem;
    char* source;
    char* include;
    char* output;
    char* command;
    int l, s, n, p, m;
    unsigned short i;

    if (argc < 2) print_error("Missing filename.");

    base = argv[1];
    l = base_length(base);
    s = l + 10;
    n = s + 4;
    p = l + 12;
    m = 4*s + 35;
    i = 1;
    stem = malloc(s);
    source = malloc(n);
    include = malloc(p);
    output = malloc(n);
    command = malloc(m);

    snprintf(include, p, "\\input %.*s.pac", l, base);
    if (!exists(include + 7)) include = "";

    while (i < USHRT_MAX) {
	snprintf(stem, s, "%.*s-fig%u", l, base, i);
	snprintf(source, n, "%s.euk", stem);
	if (!exists(source)) break;
	snprintf(output, n, "%s.tex", stem);
	out_file = fopen(output, "w");
	fprintf(out_file,
  		"\\documentclass{article}\n%s\n"
  		"\\usepackage{pstricks,pst-eps}\n"
  		"\\nofiles\n"
  		"\\pagestyle{empty}\n"
  		"\\begin{document}\n"
  		"\\TeXtoEPS\n", include);
	fclose(out_file);
	snprintf(command, m, "euktopst -b -o %s >> %s", source, output);
	if (system(command)) exit(EXIT_FAILURE);
	out_file = fopen(output, "a");
	fprintf(out_file,
  		"\\endTeXtoEPS\n"
  		"\\end{document}\n");
	fclose(out_file);
	snprintf(command, m, "latex -interaction=nonstopmode %s", output);
	if (system(command)) print_error("LaTeX error: please check log file.");
	/*
	   For some unknown reason the '%1$s' format specification doesn't
	   work with the MinGW compiler.
	 */
	snprintf(command, m, "dvips -q -E -o%s.eps %s.dvi", stem, stem);
	if (system(command)) exit(EXIT_FAILURE);
	snprintf(command, m, "epstopdf %s.eps", stem);
	if (system(command)) exit(EXIT_FAILURE);
	snprintf(command, m, "del %s.tex %s.log %s.dvi %s.eps",
	       	 stem, stem, stem, stem);
	if (system(command)) exit(EXIT_FAILURE);
	i++;
    }

    if (i == USHRT_MAX) print_error("Too many files to process.");

    return EXIT_SUCCESS;
}
