{$W-,R+,S+,G+}

unit wbibGif;
{ GifUtl.pas - (c)Copyright 1993 Sean Wenzel
  Users are given the right to use/modify and distribute this source code as
  long as credit is given where due.  I would also ask that anyone who makes
  use of this source/program drop me a line at my CompuServe address of
  71736,1245.  Just curious...

  The unit was written using Borland Pascal v7.0 but I think it should work
  with Turbo Pascal down to 5.5 at the most (or least?).
  This unit has only been tested on my system - an Everex Tempo 386DX
  with its built in SVGA adapter.  If anyone finds/fixes any bugs please
  let me know. (Feel free to send a copy of any code too)
  I have also only tested 3 or 4 256,16, and 2 color interlaced and non-
  interlaced images. (was enough for my needs)

  Some of the code is very loosely based on DECODER.C (availble online)
  so credit should be given to Steven A. Bennett and Steve Wilhite

  A sample program (GIF.PAS) is provided to demostrate the use of this unit.
  Basically declare a pointer to the TGIF object then initialize it using a
  line such as TheGif := New(PGif, Init('agif'));  You can then check
  TheGif^.Status for any errors and/or view the GIF headers and ColorTables.
  To switch to Graphics mode and show the GIF image use TheGif^.Decode.

  If anyone cares to speed up the image decoding I'd suggest writing
  TGIF.NextCode in assembler.  The routine is the most heavily called in the
  unit while decoding and on my sytem took up about 5 seconds out of 12 when
  I profiled it. (send me a copy if you can)

  I have practically commented every line so that the source should be very
  readable and easy to follow.  Great for learning about GIF's and LZW 
  decompression.

  Any problems or suggestions drop me a line

  Good luck...
                                                  -Sean

  (almost forgot)
  "The Graphics Interchange Format(c) is the Copyright property of
   CompuServe Incorporated. GIF(sm) is a Service Mark property of
   CompuServe Incorporated."
}


interface

uses
  WObjects,WinProcs,WinTypes,strings,win31,bibstrg,wbibdisp,bibfile,
  streams,wbibbmp;

const
{ error constants }
  geNoError         = 0;  { no errors found }
  geNoFile          = 1;  { gif file not found }
  geNotGIF          = 2;  { file is not a gif file }
  geNoGlobalColor   = 3;  { no Global Color table found }
  geImagePreceded   = 4;  { image descriptor preceeded by other unknown data }
  geEmptyBlock      = 5;  { Block has no data }
  geUnexpectedEOF   = 6;  { unexpected EOF }
  geBadCodeSize     = 7;  { bad code size }
  geBadCode         = 8;  { Bad code was found }
  geBitSizeOverflow = 9;  { bit size went beyond 12 bits }

function LoadGifDIB(Fname: PChar; var Width,Height: longint): HBitmap;


implementation

type
  TDataSubBlock = record
    Size: byte;                  { size of the block -- 0 to 255 }
    Data: array[1..255] of byte; { the data }
  end;

const
  BlockTerminator     = $00; { Terminates stream of data blocks              }
  ImageSeparator      = $2C; { Marks the start if an ImageProperties block   }
  ExtensionIntroducer = $21; { Marks the start of Extension control blocks   }
  Trailer             = $3B; { Indicates the end of the GIF data stream      }
  GrContExtLabel      = $F9; { Label of the Graphics Control extension block }
  CommentLabel        = $FE; { Label of the Comment extension block          }
  PlainTextLabel      = $01; { Label of the Plain Text extension block       }

  CodeMask: array[0..12] of longint = (   { bit masks for use with Next code }
    0,
    $0001, $0003,
    $0007, $000F,
    $001F, $003F,
    $007F, $00FF,
    $01FF, $03FF,
    $07FF, $0FFF);

{ logical screen descriptor packed field masks }
  lsdGlobalColorTable = $80;  { set if global color table follows L.S.D. }
  lsdColorResolution  = $70;  { Color resolution - 3 bits }
  lsdSort             = $08;  { set if global color table is sorted - 1 bit }
  lsdColorTableSize   = $07;  { size of global color table - 3 bits }
                              { Actual size = 2^value+1    - value is 3 bits }
{ image descriptor bit masks }
  idLocalColorTable   = $80; { set if a local color table follows }
  idInterlaced        = $40; { set if image is interlaced }
  idSort              = $20; { set if color table is sorted }
  idReserved          = $0C; { reserved - must be set to $00 }
  idColorTableSize    = $07; { size of color table as above }

  MAXCODES = 4095;  { the maximum number of different codes 0 inclusive }

type
  THeader = record
    Signature: array[0..2] of char; { contains 'GIF' }
    Version:   array[0..2] of char; { '87a' or '89a' }
  end;

  TLogicalScreenDescriptor = record
    ScreenWidth : word;          { logical screen width }
    ScreenHeight: word;          { logical screen height }
    PackedFields: byte;          { packed fields - see below }
    BackGroundColorIndex: byte;  { index to global color table }
    AspectRatio: byte;           { actual ratio = (AspectRatio + 15) / 64 }
  end;

  TColorItem = record     { one item in a color table }
    Red,Green,Blue: byte;
  end;

  TColorTable = array[0..255] of TColorItem;      { the color table }
  PColorTable = ^TColorTable;

  TImageDescriptor = record
    {Seperator: byte;}        { fixed value of ImageSeperator - read it separately}
    ImageLeftPos: word;     { Column in pixels in respect to left edge of logical screen }
    ImageTopPos: word;      { row in pixels in respect to top of logical screen }
    ImageWidth: word;       { width of image in pixels }
    ImageHeight: word;      { height of image in pixels }
    PackedFields: byte;     { see below }
  end;

  TGraphicsControl = record
    {Seperator: byte;}        { fixed value - read it separately}
    {ControlLabel: byte;}
    BlockSize   : byte;
    PackedFields: byte;
    DelayTime   : word;
    Transparent : byte;
    Terminator  : byte; 
  end;

  TPlainText = record
    BlockSize: byte;
    Left,Top,Width,Height: word;
    CellWidth,CellHeight : byte;
    Foreground,background: byte;
  end;

  TExtensionBlock = record
    Introducer: byte;             { fixed value of ExtensionIntroducer }
    ExtensionLabel: byte;
    BlockSize: byte;
  end;

  PCodeItem = ^TCodeItem;
  TCodeItem = record
    Code1, Code2: byte;
  end;

function Power(A, N: real): real;       { returns A raised to the power of N }
begin
  Power := exp(N * ln(A));
end;

function LoadGifDIB(Fname: PChar; var Width,Height: longint): THandle;
type
  TParamBlock = record
    BitmapInfo: PBitmapInfo;
    BitmapInfoSize: word;
    Stream: PBufStream;                 { the file stream for the gif file }
    Header: THeader;                    { gif file header }
    LogicalScreen: TLogicalScreenDescriptor;  { gif screen descriptor }
    GlobalColorTable: TColorTable;      { global color table }
    LocalColorTable: TColorTable;       { local color table }
    ImageDescriptor: TImageDescriptor;  { image descriptor }
    Interlaced: boolean;                { true if image is interlaced }
    LZWCodeSize: byte;                  { minimum size of the LZW codes in bits }
    ImageData: TDataSubBlock;           { variable to store incoming gif data }
    TableSize: word;                    { number of entrys in the color table }
    BitsLeft, BytesLeft: integer;       { bits left in byte - bytes left in block }
    BadCodeCount: word;                 { bad code counter }
    CurrCodeSize: integer;              { Current size of code in bits }
    ClearCode: integer;                 { Clear code value }
    EndingCode: integer;                { ending code value }
    Slot: word;             { position that the next new code is to be added }
    TopSlot: word;          { highest slot position for the current code size }
    HighCode: word;         { highest code that does not require decoding }
    NextByte: integer;      { the index to the next byte in the datablock array }
    CurrByte: byte;         { the current byte }
    DecodeStack: array[0..MAXCODES] of byte;      { stack for the decoded codes }
    Prefix: array[0..MAXCODES] of word;           { array for code prefixes }
    Suffix: array[0..MAXCODES] of byte;           { array for code suffixes }
    InterlacePass: byte;                          { interlace pass number }
  end;

var
  Params: ^TParamBlock;
  Status: word;                                 { status of the decode }

procedure Error(id: integer);
begin Status:=id; end;

procedure Init(AGIFName: String);
var
  P: array[0..255] of char;
  CT: PColorTable;
  i: integer;
  UseLocalColors: boolean;
  Desc: byte;

procedure SkipExtensionBlocks(var desc: byte);
var
  Null: TNulStream;
  BlockLabel: byte;

procedure SkipDataBlocks;
var
  BlockSize: byte;
begin
  with Params^ do
  begin
    Stream^.Read(BlockSize,1);
    while BlockSize<>BlockTerminator do
    begin
      Null.CopyFrom(Stream^,BlockSize);
      Stream^.Read(BlockSize,1);
    end;
  end;
end;          { SkipDataBlocks }

begin                { SkipExtensionBlocks }
  with Params^ do
  begin
    Null.init(0);
    while Desc=ExtensionIntroducer do
    begin
      Stream^.Read(BlockLabel,1);
      case BlockLabel of
        GrContExtLabel:
          Null.CopyFrom(Stream^,sizeof(TGraphicsControl));
        CommentLabel:
          SkipDataBlocks;
        PlainTextLabel:
          begin
            Null.CopyFrom(Stream^,sizeof(TPlainText));
            SkipDataBlocks;
          end;
      end;
      Stream^.read(Desc,1);
    end;
    if Stream^.Status<>stOK then Error(geUnexpectedEOF);
  end;
end;                         { SkipExtensionBlocks }

begin
  with Params^ do
  begin
  Status:=geNoError; Stream:=Nil; 
  BitmapInfo:=Nil; TableSize:=0;
  Interlaced:=false; InterlacePass:=0; UseLocalColors:=false;
  if Pos('.',AGifName) = 0 then     { if the filename has no extension add one }
    AGifName := AGifName + '.gif';
  StrPCopy(P,AGifName);
  Stream := New(PBufStream, Init(P, stOpen, 2048));
  if (Stream=Nil) or (Stream^.Status<>stOK) then
  begin
    Error(geNoFile); Exit;
  end;
  FillChar(Header,sizeof(Header),0);
  FillChar(LogicalScreen,sizeof(LogicalScreen),0);

  Stream^.Read(Header, sizeof(Header));               { read the header }
  if Stream^.Status<>stOK then begin Error(geUnexpectedEOF); Exit; end;
  Move(Header.signature,P,3); P[3]:=#0;
  if StrPas(P) <> 'GIF' then begin Error(geNotGIF); Exit; end;  { is valid signature }

  Stream^.Read(LogicalScreen, sizeof(LogicalScreen));
  if Stream^.Status<>stOK then begin Error(geUnexpectedEOF); Exit; end;
  if LogicalScreen.PackedFields and lsdGlobalColorTable = lsdGlobalColorTable then
  begin
    TableSize := 1 shl ((LogicalScreen.PackedFields
                 and lsdColorTableSize)+1);
{    trunc(Power(2,(LogicalScreen.PackedFields
                 and lsdColorTableSize)+1)); }
    Stream^.Read(GlobalColorTable, TableSize*sizeof(TColorItem)); { read Global Color Table }
  end else
  begin
    Error(geNoGlobalColor); Exit;
  end;

  Stream^.Read(Desc,1);
  SkipExtensionBlocks(Desc);
  Stream^.Read(ImageDescriptor, sizeof(ImageDescriptor)); { read image descriptor }
  if Stream^.Status<>stOK then begin Error(geUnexpectedEOF); Exit; end;

  if Desc <> ImageSeparator then     { verify that it is the descriptor }
  begin
    Error(geImagePreceded); Exit;
  end;
  if ImageDescriptor.PackedFields and idLocalColorTable = idLocalColorTable then
  begin                     { if local color table }
    TableSize := trunc(Power(2,(ImageDescriptor.PackedFields and
                             idColorTableSize)+1));
    Stream^.Read(LocalColorTable, TableSize*sizeof(TColorItem)); { read Local Color Table }
    UseLocalColors := True;
  end else
    UseLocalColors := false;

  if ImageDescriptor.PackedFields and idInterlaced = idInterlaced then
  begin
    Interlaced := true;
    InterlacePass := 0;
  end;

  with ImageDescriptor do
    if (ImageWidth<=0) or (ImageHeight<=0) or
       (ImageWidth>=MAXCODES) or (ImageHeight>=MAXCODES) then
    begin
      Error(geBadCode); Exit;
    end;
{    message('Width = '+num2str(imageWidth)+', height = '+num2str(imageHeight));}

  BitmapInfoSize:=sizeof(TBitmapInfoHeader)+TableSize*sizeof(TRGBQuad);
  GetMem(BitmapInfo,BitmapInfoSize);
  FillChar(BitmapInfo^,BitmapInfoSize,0);

  if UseLocalColors then CT:=@LocalColorTable
  else CT:=@GlobalColorTable;
  with BitmapInfo^ do
  begin
    with bmiHeader do
    begin
      biSize         :=sizeof(TBitmapInfoHeader);
      biWidth        :=ImageDescriptor.imageWidth;
      biHeight       :=ImageDescriptor.imageHeight;
      biPlanes       :=1;
      biBitCount     :=8;
      biCompression  :=BI_RGB;
      biSizeImage    :=0;
      biXPelsPerMeter:=2000;
      biYPelsPerMeter:=2000;
      biClrUsed      :=TableSize;
      biClrImportant :=0;
    end;
{$UNDEF RPLUS}
{$IFDEF R+}
  {$DEFINE RPLUS}
{$ENDIF}
    {$R-}
    for i:=0 to TableSize-1 do
    with bmiColors[i] do
    begin
      rgbBlue    :=CT^[i].Blue;
      rgbGreen   :=CT^[i].Green;
      rgbRed     :=CT^[i].Red;
      rgbReserved:=0;
    end;
{$IFDEF RPLUS}
    {$R+}
    {$UNDEF RPLUS}
{$ENDIF}
  end;
  end;
end;                  { Init }

procedure ReadSubBlock;
begin
  with Params^ do
  begin
    Stream^.Read(ImageData.Size, sizeof(ImageData.Size)); { get the data block size }
    if ImageData.Size = 0 then Error(geEmptyBlock);       { check for empty block }
    Stream^.Read(ImageData.Data, ImageData.Size);         { read in the block }
    NextByte := 1;                                        { reset next byte }
    BytesLeft := ImageData.Size;                          { reset bytes left }
  end;
end;                   { ReadSubBlock }

function NextCode: word; { returns a code of the proper bit size }
var
  Ret: longint;        { temporary return value }
begin
  with Params^ do
  begin
  if BitsLeft = 0 then                    { any bits left in byte ? }
  begin                                   { any bytes left }
    if BytesLeft <= 0 then                { if not get another block }
      ReadSubBlock;
    CurrByte := ImageData.Data[NextByte]; { get a byte }
    inc(NextByte);                        { set the next byte index }
    BitsLeft := 8;                        { set bits left in the byte }
    dec(BytesLeft);                       { decrement the bytes left counter }
  end;
  ret := CurrByte shr (8 - BitsLeft);     { shift off any previosly used bits}
  while CurrCodeSize > BitsLeft do        { need more bits ? }
  begin
    if BytesLeft <= 0 then                { any bytes left in block ? }
      ReadSubBlock;                       { if not read in another block }
    CurrByte := ImageData.Data[NextByte]; { get another byte }
    inc(NextByte);                        { increment NextByte counter }
    ret := ret or (CurrByte shl BitsLeft);{ add the remaining bits to the return value }
    BitsLeft := BitsLeft + 8;             { set bit counter }
    dec(BytesLeft);                       { decrement bytesleft counter }
  end;
  BitsLeft := BitsLeft - CurrCodeSize;    { subtract the code size from bitsleft }
  ret := ret and CodeMask[CurrCodeSize];  { mask off the right number of bits }
  NextCode := ret;
  end;
end;                         { NextCode }

{ this procedure actually decodes the GIF image }
function GetDIB(var Width,Height: longint): THandle;
var
  SP: integer; { index to the decode stack }
  TempOldCode, OldCode: word;
  BufCnt: word;     { line buffer counter }
  Code, C: word;
  CurrBuf: word;    { line buffer index }
  CurrentY: word;

  Buf: LongType;
  DIB: THandle;
  i: integer;
  LineBuffer: PChar;
  LineBufSize,LineSize: word;

{ local procedure that decodes a code and puts it on the decode stack }
procedure DecodeCode(var Code: word);
begin
  with Params^ do
  begin
    while Code > HighCode do            { rip thru the prefix list placing suffixes }
    begin                               { onto the decode stack }
      if sp<=MAXCODES then
      begin
        DecodeStack[SP] := Suffix[Code];  { put the suffix on the decode stack }
        inc(SP);                          { increment decode stack index }
      end;
      Code := Prefix[Code];             { get the new prefix }
    end;
    if sp<=MAXCODES then
    begin
      DecodeStack[SP] := Code;            { put the last code onto the decode stack }
      inc(SP);                            { increment the decode stack index }
    end;
  end;
end;                   {  DecodeCode}

procedure InitCompressionStream;
begin
  with Params^ do
  begin
    Stream^.Read(LZWCodeSize, sizeof(byte));{ get minimum code size }
    if not (LZWCodeSize in [2..9]) then     { valid code sizes 2-9 bits }
      Error(geBadCodeSize);

    CurrCodeSize := succ(LZWCodeSize); { set the initial code size }
    ClearCode  := 1 shl LZWCodeSize;   { set the clear code }
    EndingCode := succ(ClearCode);     { set the ending code }
    HighCode   := pred(ClearCode);     { set the highest code not needing decoding }
    BytesLeft  := 0;                   { clear other variables }
    BitsLeft   := 0;
  end;
end;                       { InitCompressionStream }

procedure DrawLine;
begin
  with Params^ do
  begin
    DrawBitLine(Buf,LineBuffer,LineSize,LineBufSize,
                        BitmapInfo^.bmiHeader.biHeight-CurrentY-1);
    inc(CurrentY);

    if InterLaced then     { Interlace support }
    begin
      case InterlacePass of
        0: CurrentY := CurrentY + 7;
        1: CurrentY := CurrentY + 7;
        2: CurrentY := CurrentY + 3;
        3: CurrentY := CurrentY + 1;
      end;
      if CurrentY >= ImageDescriptor.ImageHeight then
      begin
        inc(InterLacePass);
        case InterLacePass of
          1: CurrentY := 4;
          2: CurrentY := 2;
          3: CurrentY := 1;
        end;
      end;
    end;
  end;
end;            { DrawLine }

procedure TidyUp(i: integer);
begin
  with Params^ do
  begin
    FreeMem(LineBuffer,LineSize);
    if DIB<>0 then GlobalUnlock(DIB);
    if I=geNoError then GetDIB:=DIB
    else begin
      GlobalFree(DIB); DIB:=0; GetDIB:=0;
      Width:=0; Height:=0;
      Error(i);
    end;
  end;
end;                { TidyUp }

var
  j,count: integer;
  BufSize: longint;
  P: PChar;
begin                  { GetDIB }
  with Params^ do
  begin
  GetDIB:=0; DIB:=0; Width:=0; Height:=0;
  InitCompressionStream;    { Initialize decoding parameters }
  if Status<>geNoError then Exit;
  { Init buffers }

  LineBufSize:=BitmapInfo^.bmiHeader.biWidth;
  LineSize:=LineBufSize;
  if LineSize mod 4<>0 then LineSize:=4*((lineSize div 4)+1);
  GetMem(LineBuffer,LineSize);

  with BitmapInfo^.bmiHeader do
  begin
    DIB:=GlobalAlloc(GHND,BitmapInfoSize+biHeight*LineSize+1024);    { !!!!!!! }
    Width:=biWidth; Height:=biHeight;
  end;

  P:=GlobalLock(DIB);
  Move(BitmapInfo^,P^,BitmapInfoSize);
  Buf.Ptr:=P+BitmapInfoSize;

  OldCode  := 0;
  SP       := 0;
  BufCnt   := LineBufSize; { set the Image Width }
  CurrBuf  := 0;
  CurrentY := 0;

  CurrCodeSize := LZWCodeSize + 1;    { reset the code size }
  Slot         := EndingCode + 1;     { set slot for next new code }
  TopSlot      := 1 shl CurrCodeSize; { set max slot number }

  C := NextCode;            { get the initial code - should be a clear code }
  if C<>ClearCode then
  begin
    TidyUp(geBadCode); Exit;       {!!!!!!!!!!!!!!!!!!}
  end else
  while C <> EndingCode do  { main loop until ending code is found }
  begin
    if Stream^.Status<>stOK then
    begin
      TidyUp(geUnexpectedEOF); Exit;
    end;
    if C = ClearCode then   { code is a clear code - so clear }
    begin
      CurrCodeSize := LZWCodeSize + 1;{ reset the code size }
      Slot := EndingCode + 1;         { set slot for next new code }
      TopSlot := 1 shl CurrCodeSize;  { set max slot number }
      while C = ClearCode do
        C := NextCode;      { read until all clear codes gone - shouldn't happen }
      if C = EndingCode then
      begin
        TidyUp(geBadCode);   { ending code after a clear code }
        Exit;                { this also should never happen }
      end;
      if C >= Slot { if the code is beyond preset codes then set to zero }
        then c := 0;
      OldCode := C;
      DecodeStack[sp] := C;   { output code to decoded stack }
      inc(SP);                { increment decode stack index }
    end  else   { the code is not a clear code or an ending code so it must }
    begin      { be a code code - so decode the code }
      Code := C;
      if Code < Slot then           { is the code in the table? }
      begin
        DecodeCode(Code);           { decode the code }
        if Slot <= TopSlot then
        begin             { add the new code to the table }
          Suffix[Slot] := Code;     { make the suffix }
          PreFix[slot] := OldCode;  { the previous code - a link to the data }
          inc(Slot);                { increment slot number }
          OldCode := C;             { set oldcode }
        end;
        if Slot >= TopSlot then     { have reached the top slot for bit size }
        begin                       { increment code bit size }
          if CurrCodeSize < 12 then { new bit size not too big? }
          begin
            TopSlot := TopSlot shl 1;        { new top slot }
            inc(CurrCodeSize)                { new code size }
          end else
          begin
            TidyUp(geBitSizeOverflow); Exit; { encoder made a boo boo }
          end;
        end;
      end else
      begin                   { the code is not in the table }
        if Code <> Slot then  { code is not the next available slot }
        begin
          TidyUp(geBadCode); Exit;  { so error out }
        end;

        { the code does not exist so make a new entry in the code table
          and then translate the new code }
        TempOldCode := OldCode;     { make a copy of the old code }
        while OldCode > HighCode do { translate the old code and place it }
        begin                       { on the decode stack }
          DecodeStack[SP] := Suffix[OldCode]; { do the suffix }
          OldCode := Prefix[OldCode];         { get next prefix }
        end;
        DecodeStack[SP] := OldCode; { put the code onto the decode stack }
                                    { but DO NOT increment stack index }
        { the decode stack is not incremented because because we are only
          translating the oldcode to get the first character }
        if Slot <= TopSlot then
        begin                           { make new code entry }
          Suffix[Slot] := OldCode;      { first char of old code }
          Prefix[Slot] := TempOldCode;  { link to the old code prefix }
          inc(Slot);                    { increment slot }
        end;
        if Slot >= TopSlot then { slot is too big }
        begin                   { increment code size }
          if CurrCodeSize < 12 then
          begin
            TopSlot := TopSlot shl 1;       { new top slot }
            inc(CurrCodeSize)               { new code size }
          end else
          begin
            TidyUp(geBitSizeOverFlow); Exit;
          end;
        end;
        DecodeCode(Code); { now that the table entry exists decode it }
        OldCode := C;     { set the new old code }
      end;
    end;
    { the decoded string is on the decode stack so pop it off and put it
      into the line buffer }
    while SP > 0 do
    begin
      dec(SP);
      LineBuffer[CurrBuf] := Char(DecodeStack[SP]);
      inc(CurrBuf);
      dec(BufCnt);
      if BufCnt = 0 then  { is the line full ? }
      begin
        DrawLine;
        CurrBuf := 0;
        BufCnt := LineBufSize;
      end;
    end;
    C := NextCode;  { get the next code and go at it some more }
  end;              { now that wasn't all that bad was it? }

  TidyUp(geNoError);
  GetDIB:=DIB;
  end;
end;                { GetDIB }

begin
  Width:=0; Height:=0; LoadGifDIB:=0;
  New(Params); FillChar(Params^,sizeof(Params^),0); Params^.BitmapInfo:=Nil;
  init(StrPas(FName));
  if Status=geNoError then LoadGifDIB:=GetDIB(Width,Height);
  with Params^ do
  begin
    if Stream <> nil then
    begin
      Stream^.Reset; Dispose(Stream, Done);
    end;
    if BitmapInfo<>Nil then FreeMem(BitmapInfo,BitmapInfoSize);
  end;
  dispose(Params);
end;             { LoadGifDIB }



end.