Unit graphio;

interface

Uses
  WinTypes,WinProcs,strings,WObjects,WinDos,lfnunit;

const
  pwmf_sig: array[1..4] of byte = ($D7,$CD,$C6,$9A); { Signature for placeable metafiles }
  GRFilt_IniSection: PChar = 'MS Graphic Import Filters';

  { Return codes for Import_Graphic }
 	GRIMP_OK     = 0;	   { Success                            }
  GRIMP_NOMEM  = 1;		 { Out of memory                      }
  GRIMP_NOFILE = 2;		 { Cannot find the specified file     }
  GRIMP_NOTYPE = 3;		 { The input file had no extension    }
                       {   and there was no matching file   }
	                     {   among the extensions listed in   }
	                     {   WIN.INI                          }
 	GRIMP_NOFILTER  = 4; { Cannot find the appropriate filter }
 	GRIMP_NOCONV    = 5; { The filter cannot import the file  }
 	GRIMP_BADPARMS  = 6; { Invalid parameters                 }
 	GRIMP_NOSPACE   = 7; { Out of disc space                  }
 	GRIMP_NOINIFILT = 8; { The filter cannot be initialized   }

  { Return codes for save_meta }
 	GREXP_OK       = 0;  { Success            }
 	GREXP_BADPARMS = 1;  { Invalid parameters }
 	GREXP_NOMEM    = 2;  { Out of memory      }
 	GREXP_NODISC   = 3;  { Out of disc space  }
 	GREXP_BADFNAME = 4;  { Invalid filename   }

type
  LPictInfo = record
    hmf: THandle;     { Handle to the metafile           }
    bbox: TRect;      { Bounding box (in metafile units) }
    inch: integer;    { How many metafile units in one   }
                      {   inch (can be unreliable if the }
	  			            {   graphic is non-scalable        }
    Ext: array[0..70] of char; { file extension used     }
  end;

  LPPictInfo = ^LPictInfo;

  PMF_Header = record
    Key: array[1..4] of byte;
    hmf: THandle;
    bbox: array[1..4] of integer;
    inch: word;
    Reserved: longint;
    Checksum: integer;
  end;

function Import_Graphic(DC: hdc; Wnd: HWND; fname: PChar; PI: LPPictInfo;
                        dopref: integer; IniSection: PChar): integer;
function Get_OpenMask(Desc: PChar;  DescSz: integer;
                      ExtList: PChar; ExtListSz: integer;
                      IniSection: PChar): PChar;




implementation

const
{ Import Error Codes }
 	IE_OK                = 0;
  IE_BASE              = 5300;		     { base value for IE_ error codes }
  IE_NOT_MY_FILE       = (IE_BASE+1);	 { generic "not my file" error }
  IE_TOO_BIG           = (IE_BASE+2);	 { bitmap or pict too big error }
  IE_DUMB_BITMAP       = (IE_BASE+3);	 { bitmap all white }
  IE_UNKNOWN_TYPE      = (IE_BASE+7);	 { unknown file type }
  IE_BAD_FILE_DATA     = (IE_BASE+9);  { current file data is bad }
  IE_IMPORT_ABORT      = (IE_BASE+10); { import abort alert }
  IE_MEM_FULL          = (IE_BASE+11); { ran out of memory during import }
  IE_METAFILE_TOO_BIG  = (IE_BASE+13); { metafile too big }
  IE_INVALID_LOTUS_PIC = (IE_BASE+14); { bad lotus .pic }
  IE_MEM_FAIL          = (IE_BASE+15); { couldn't lock memory during import }
  IE_PAINT_BASE        = (IE_BASE+40);
  IE_UNSUPP_COMPR      = (IE_PAINT_BASE+1); { unsupp'd compress. style }
  IE_UNSUPP_VERSION    = (IE_PAINT_BASE+2); { unsupp'd file version }
  IE_UNSUPP_COLOR      = (IE_PAINT_BASE+3); { can't handle this color style }
 	IE_NO_FILE           = (-1);		          { cannot open file }

  MaxSize = 4096;

type

  LongType = record
    case Word of
      0: (Ptr: Pointer);
      1: (Long: Longint);
      2: (Lo: Word;
	  Hi: Word);
  end;

  LFILESPEC = record
    flags: WORD;
    ftype: longint;
    handle: THandle;
    fullname: array[0..123] of char;
    filepos: longint;
  end;
  LPFileSpec = ^LFileSpec;

  LPHandle = ^THandle;

{ Version 1.0 filter functions }
  PFN_INFO   = function (W: WORD; LPSTR: PChar; LP1,LP2: LPHandle): word;
  PFN_PREF   = procedure(HANDLE1: THandle; WND: HWnd; HANDLE2: THandle; W: WORD);
  PFN_IMPORT = function(DC: HDC; LP1: LPFILESPEC; LP2: LPPICTINFO;
                        HANDLE: THandle): word;
{ Version 2.0 filter functions }
  PFN_VER = function(DWORD: longint; BOOL: PBool; LPW1,LPW2: PWord): word;
  PFN_ISMY = function(P: LPFILESPEC): word;
  PFN_PREF2 = function(H1,H2: THANDLE; LPH: LPHANDLE; DWORD: longint;
                       FARPROC: TFarProc; LPF: LPFILESPEC): word;
  PFN_OUTPUT = function(DC1,DC2:HDC; LPF: LPFILESPEC; LPSTR: PChar;
                        LPP: LPPICTINFO; HANDLE: THandle;
                        FARPROC: TFarProc; B: bool): word;

var
  LochInst: THandle;

procedure AHIncr; far; external 'KERNEL' index 114;

function Exists(F: PChar): boolean;
var
  Attr: word;
begin
  LGetAttr(F,Attr);
  Exists:=(DosError=0);
end;

function ImpAux(dc: hDC; wnd: HWnd; fname,libname: PChar;
                PI: LPPICTINFO; dopref: integer; filtopt: PChar): integer;
var
  hlib,hpref: THandle;
  result: Word;
  pfninfo,             {PFN_INFO;  }
  pfnimport,           {PFN_IMPORT;}
  pfnpref,             {PFN_PREF;  }
  pfnpref2,            {PFN_PREF2; }
  pfnoutput: TFarProc; {PFN_OUTPUT;}
  fs: LFileSpec;

procedure TidyUp(i: integer);
begin
  ImpAux:=i;
end;

begin
  fillchar(pi^,sizeof(LPICTINFO),0);
  hlib := LoadLibrary(libname);
  if (hlib<22) then
  begin
    TidyUp(GRIMP_NOFILTER); Exit;
  end;

  hpref := 0;
  result := WORD(-1);
  fillchar(fs,sizeof(fs),0);
  strcopy(fs.fullname,fname);
  if (GetProcAddress(hlib,'GetFilterVersion')=Nil) then		{ Version 1.0 }
  begin
    pfninfo   := GetProcAddress(hlib,'GetFilterInfo');
    pfnpref   := GetProcAddress(hlib,'GetFilterPref');
    pfnimport := GetProcAddress(hlib,'ImportGR');
    if (pfnimport<>Nil) then
    begin
      if ( (pfninfo<>Nil) and
           (PFN_INFO(pfninfo)(0,filtopt,@hpref,Nil)<>2 )) then
      begin
        FreeLibrary(hlib);
        TidyUp(GRIMP_NOINIFILT); Exit;
      end;
      if ((dopref<>0) and (pfnpref<>Nil)) then
            PFN_PREF(pfnpref)(lochinst,wnd,hpref,1);
      result := PFN_IMPORT(pfnimport)(dc,@fs,pi,hpref);
    end;
  end else							{ Version 2.0 }
  begin
      pfnpref2  := GetProcAddress(hlib,'GetFilterPref');
      pfnoutput := GetProcAddress(hlib,'OutputGR');

      if (pfnoutput<>Nil) then
      begin
          if (pfnpref2<>Nil) then
             PFN_PREF2(pfnpref2)(lochinst,wnd,@hpref,fs.ftype,Nil,@fs);
          result := PFN_OUTPUT(pfnoutput)(0,dc,@fs,NIL,pi,hpref,NIL,FALSE);
      end;
  end;
  FreeLibrary(hlib);
  if (hpref<>0) then GlobalFree(hpref);
  if result=IE_OK then TidyUp(GRIMP_OK)
  else if Result=IE_MEM_FULL then TidyUp(GRIMP_NOMEM)
  else TidyUp(GRIMP_NOCONV);
end; {  -> impaux }

{ Read a standard or placeable metafile from disc }

function MyReadMetafile(TheFile: PChar; PI: LPPICTINFO): integer;
var
  fl: TDosStream;
  Count: Longint;
  Start, ToAddr, Bits: LongType;
  BitsHandle,BitsByteSize: THandle;
  Header: PMF_Header;

procedure TidyUp(i: integer);
begin
  MyReadMetafile:=i;
  fl.reset; fl.Done;
end;

begin
  FillChar(PI^,sizeof(LPictInfo),0);
  fl.init(TheFile,stOpenRead); fl.seek(0);
  if fl.Status<>stOK then
  begin
    TidyUp(GRIMP_NOFILE); Exit;
  end;
  fl.Read(Header,sizeof(Header));
  if fl.Status<>stOK then
  begin
    TidyUp(GRIMP_NOCONV); Exit;
  end;
  if (longint(Header.key)<>longint(pwmf_sig)) then   { Standard metafile }
  begin
    fl.reset; fl.done;
    PI^.hmf:=GetMetafile(TheFile);
    if PI^.hmf=0 then
    begin
      MyReadMetaFile:=GRIMP_NOCONV;
      FillChar(PI^,sizeof(LPictInfo),0);
    end else
    begin
      MyReadMetafile:=GRIMP_OK;
      SetRect(PI^.bbox,0,100,0,100);
      PI^.Inch:=100;
    end;
    Exit;
  end;
  { Placeable metafile } 
  with PI^.bbox do
  begin
    left:=Header.bbox[1];
    top:=Header.bbox[2];
    right:=Header.bbox[3];
    bottom:=Header.bbox[4];
  end;
  PI^.Inch:=Header.Inch;

  BitsByteSize:=fl.GetSize-fl.GetPos;
  BitsHandle:=GlobalAlloc(GHND,BitsByteSize);

{  message(num2str(Header.bbox.right)+'x'+num2str(Header.bbox.bottom));
  message(num2str(MulDiv(Header.bbox.Right-Header.bbox.left,Header.inch,XRes))+'x'+
          num2str(MulDiv(Header.bbox.bottom-Header.bbox.top,Header.inch,YRes)));   }

  Start.Long := 0;
  Bits.Ptr := GlobalLock(BitsHandle);

  Count := BitsByteSize - Start.Long;
  while Count > 0 do
  begin
    ToAddr.Hi := Bits.Hi + (Start.Hi * Ofs(AHIncr));
    ToAddr.Lo := Start.Lo;
    if Count > $4000 then Count := $4000;
    fl.Read(ToAddr.Ptr^, Count);
    Start.Long := Start.Long + Count;
    Count := BitsByteSize - Start.Long;
  end;
  
  GlobalUnlock(BitsHandle);
  PI^.hmf:=SetMetafileBits(BitsHandle);
  if PI^.hmf=0 then
  begin
    TidyUp(GRIMP_NOCONV);
    GlobalFree(BitsHandle);
  end else TidyUp(GRIMP_OK);
end;


{
 * Import a graphics file; this DLL can read both kinds of metafiles
 * without external support; other types of files are imported through
 * filters.
}

function Import_Graphic(DC:hdc; Wnd: HWND; fname: PChar; PI: LPPICTINFO;
                        dopref: integer; inisection: PChar): integer;
label
  CONT, BRK;
var
  wildcard,n,i: integer;
  p,namext,filtext,buf,buf2,filtopt: PChar;

procedure TidyUp(i: integer);
begin
  if Buf<>Nil then FreeMem(Buf,MaxSize);
  if NamExt<>Nil then FreeMem(NamExt,270);
  Import_Graphic:=i;
end;

begin
  Buf:=Nil; NamExt:=Nil;
  if ((fname=Nil) or (pi=Nil) or (inisection=Nil)) then
  begin
    Import_Graphic:=GRIMP_BADPARMS; Exit;
  end;

  CanonicalFilename(fname);
  GetMem(NamExt,270);
  P:=StrRScan(fname,'.'); if P=Nil then P:=fname;
  StrCopy(NamExt,P);
  if NamExt[0]=#0 then
  begin
    StrCopy(NamExt,Fname);
    StrCat(NamExt,'.');
    wildcard := 1;
  end else
  begin
    for i:=1 to StrLen(NamExt) do NamExt[i-1]:=NamExt[i];
      if (not exists(fname)) then
      begin
        TidyUp(GRIMP_NOFILE); Exit;
      end;
      wildcard := 0;
  end;
  if ((wildcard<>0) or (strcomp(namext,'wmf')=0)) then  { Metafile }
  begin
    n:=MyReadMetafile(fname,pi);
    StrCopy(PI^.Ext,NamExt);
    if ( n <> GRIMP_NOFILE )  then
    begin
      TidyUp(n); Exit;
    end;
  end;
  Buf:=MemAlloc(MaxSize);
  if ( Buf=Nil ) then
  begin
    TidyUp(GRIMP_NOMEM); Exit;
  end;
  buf2 := buf + (MAXSIZE div 2);
  GetProfileString(inisection,Nil,'',buf,MAXSIZE div 2);
  n := GRIMP_NOTYPE;

  P:=Buf;
  while (P^<>#0) do
  begin
    GetProfileString(inisection,p,'',buf2,MAXSIZE div 2);
    FiltExt:=StrScan(Buf2,',');
    if FiltExt=Nil then goto CONT;
    FiltExt^:=#0; inc(FiltExt);
    while (filtext^=' ') or (filtext^=#9) do inc(filtext);
    FiltOpt:=StrScan(FiltExt,',');
    if ( filtopt <> NIL ) then
    begin
      filtopt^:=#0; inc(FiltOpt);
    end;
    if not LFNAble then strlower(filtext);
    if (wildcard<>0) then
    begin
      if (strlen(filtext)>3) then goto CONT;
      strcopy(namext,filtext);
      if (not exists(fname)) then goto CONT;
      n := impaux(dc,wnd,fname,buf2,pi,dopref,filtopt);
      if (n=GRIMP_OK) then goto BRK;
    end else if (strcomp(namext,filtext)=0) then
    begin
      n := impaux(dc,wnd,fname,buf2,pi,dopref,filtopt);
      if (n=GRIMP_OK) then goto BRK;
    end;
Cont: ;
    P:=P+StrLen(P)+1;
  end;
BRK:;
  if (n=GRIMP_NOTYPE) and (wildcard<>0) then
  begin
    dec(NamExt); NamExt^:=#0;
  end;
  PI^.Ext[0]:=#0; StrLCat(PI^.Ext,NamExt,70);
  if not LFNAble then StrLower(PI^.Ext);
  TidyUp(n);
end;          { Import_Graphic }

{ Construct a mask suitable for the "List Files of Type" listbox of
  the "Open" common dialog. }

function Get_OpenMask(Desc: PChar;  DescSz: integer;
                      ExtList: PChar; ExtListSz: integer;
                      IniSection: PChar): PChar;
label
  CONT,BRK;
const
  BufSz = 2047;
var
  n1,n2,retcode: integer;
  ip,names,entry,q,q2: Pchar;

function FoundIn(Ext: PChar): boolean;
var
  P0,P,P1: PChar;
  Found: boolean;
begin
  FoundIn:=false;
  P0:=StrNew(ExtList); P:=P0; Found:=false;
  while (not Found) and (P<>Nil) do
  begin
    if P^='*' then inc(P);
    if P^='.' then inc(P);
    P1:=StrScan(P,';'); if P1<>Nil then P1^:=#0;
    Found:=StrIComp(Ext,P)=0;
    if P1<>Nil then P:=P1+1 else P:=Nil;
  end;
  StrDispose(P0);
  FoundIn:=Found;
end;

procedure TidyUp(i: integer);
begin
  if names<>Nil then freemem(names,MAXSIZE);
end;

begin                   { Get_OpenMask }
  Get_OpenMask:=Nil;
  if ((IniSection=Nil) or (Desc=Nil) or (ExtList=Nil)) then Exit;

  names:=MemAlloc(MAXSIZE);
  if names=Nil then
  begin
    TidyUp(GRIMP_NOMEM); Exit;
  end;
  entry := names + MAXSIZE div 2;
  GetProfileString(IniSection,Nil,'',names,MAXSIZE div 2);
  retcode := GRIMP_OK;
  ip:=names;
  while (ip^<>#0) do
  begin
    GetProfileString(IniSection,ip,'',entry,MAXSIZE div 2);
    q:=StrScan(entry,',');
    if q=Nil then goto CONT;
    inc(q);
    while (q^ in [' ',#9]) do inc(q);
    q2:=StrScan(q,','); if Q2<>Nil then q2^:=#0;
    if FoundIn(q) then goto CONT;   { Already present }
    StrLower(q);
    StrLCat(ExtList,';*.',ExtListSz); StrLCat(ExtList,q,ExtListSz);

    q2:=StrScan(ip,'(');
    if (q2<>Nil) and (q2[1]='.') then q2^:=#0;

    StrCopy(Desc,ip); StrCat(Desc,'(*.');
    StrCat(Desc,q);  StrCat(Desc,')');
    Desc:=Desc+StrLen(Desc)+1;
    StrCopy(Desc,'*.'); StrCat(Desc,q);
    Desc:=Desc+StrLen(Desc)+1;
CONT:;
    ip:=ip+StrLen(ip)+1;
  end;
BRK:;
  TidyUp(retcode);
  Get_OpenMask:=Desc;
end;                    { Get_OpenMask }

end.
