/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.Resolvable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class AssignedControlSequence
extends Command
implements AssignedMacro {
    private TeXObject underlying;
    protected boolean isRobust = false;

    public AssignedControlSequence(String string, TeXObject teXObject) {
        this(string, teXObject, false);
    }

    public AssignedControlSequence(String string, TeXObject teXObject, boolean bl) {
        super(string);
        this.underlying = teXObject;
        this.isRobust = bl;
        if (teXObject instanceof Macro) {
            Macro macro = (Macro)teXObject;
            this.setAllowsPrefix(macro.getAllowsPrefix());
            this.setShort(macro.isShort());
            this.setSyntax(macro.getSyntax());
        }
    }

    @Override
    public Object clone() {
        return new AssignedControlSequence(this.getName(), (TeXObject)this.underlying.clone(), this.isRobust);
    }

    @Override
    public boolean isPar() {
        return this.underlying.isPar();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public void setPrefix(byte by) {
        if (this.underlying instanceof Macro) {
            ((Macro)this.underlying).setPrefix(by);
            super.setPrefix(by);
        }
    }

    @Override
    public void clearPrefix() {
        if (this.underlying instanceof Macro) {
            ((Macro)this.underlying).clearPrefix();
            super.clearPrefix();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof TeXObject)) {
            return false;
        }
        if (object instanceof AssignedMacro) {
            return this.underlying.equals(((AssignedMacro)object).getUnderlying());
        }
        return this.underlying.equals(object);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (teXParser.isDebugMode(64)) {
            teXParser.logMessage("PROCESSING " + this.toString());
        }
        this.underlying.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser.isDebugMode(64)) {
            teXParser.logMessage("PROCESSING " + this.toString());
        }
        this.underlying.process(teXParser, teXObjectList);
    }

    @Override
    public boolean canExpand() {
        return !this.isRobust && this.underlying.canExpand();
    }

    @Override
    public boolean isExpansionBlocker() {
        return this.underlying.isExpansionBlocker();
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        if (this.isRobust) {
            return null;
        }
        TeXObject teXObject = this.getBaseUnderlying();
        if (!(teXObject instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)teXObject)).expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.isRobust) {
            return null;
        }
        TeXObject teXObject = this.getBaseUnderlying();
        if (!(teXObject instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        if (this.isRobust) {
            return null;
        }
        TeXObject teXObject = this.getBaseUnderlying();
        if (!(teXObject instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)teXObject)).expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.isRobust) {
            return null;
        }
        TeXObject teXObject = this.getBaseUnderlying();
        if (!(teXObject instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObject getUnderlying() {
        return this.underlying;
    }

    @Override
    public TeXObject getBaseUnderlying() {
        if (this.underlying instanceof AssignedMacro) {
            return ((AssignedMacro)this.underlying).getBaseUnderlying();
        }
        return this.underlying;
    }

    @Override
    public TeXObject resolve(TeXParser teXParser) {
        TeXObject teXObject = this.getBaseUnderlying();
        if (teXObject instanceof Resolvable) {
            return ((Resolvable)((Object)teXObject)).resolve(teXParser);
        }
        return teXObject;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,robust=%s,underlying=%s]", this.getClass().getSimpleName(), this.getName(), this.isRobust, this.underlying);
    }
}

